/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 198048144863L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(479585130 + (char)-11624, -479716200 - -((char)-7252), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(479585130 + (char)-11623, 479585130 + (char)-22377, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 83943446071340L;
                thread = Thread.currentThread();
                String[] stringArray = SshAgentIpcService.y();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (stringArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1689754440 - -16187, 1689754440 - 7392, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1689754440 - -16186, 1689754440 - 9985, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1689754440 - -16189, 1689754440 - 19939, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 64034943353622L;
                Object object = this.lock;
                String[] stringArray = SshAgentIpcService.y();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1275966450 - (char)-29916, -1275966450 - -29963, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1275966450 - (char)-29915, -1275966450 - -((char)-26648), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1275966450 - (char)-29914, -1275966450 - -31627, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (stringArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1275966450 - (char)-29905, 1275966450 - 29015, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1275966450 - (char)-29904, 1275966450 - (char)-29539, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1275966450 - (char)-29903, 1275966450 - 14222, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1275966450 - (char)-29905, 1275966450 - 29015, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1275966450 - (char)-29902, -1275966450 - -((char)-31302), (int)l2));
            if (ActionTimestamp.y() != null) {
                SshAgentIpcService.y(new String[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    long l2 = 44536142705316L;
                    stringArray = SshAgentIpcService.y();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (stringArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (stringArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String[] stringArray;
        long l2;
        block27: {
            block28: {
                l2 = 47395447533320L;
                String[] stringArray2 = SshAgentIpcService.y();
                this.assertConnectionThread();
                Object object3 = this.lock;
                stringArray = stringArray2;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (stringArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(483386160 + 8617, -483386160 + -19770, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(483386160 + 8621, 483386160 + (char)-29867, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(483386160 + 8616, -483386160 + -28125, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(483386160 + 8621, 483386160 + (char)-29867, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(483386160 + 8619, -483386160 + -((char)-29269), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(483386160 + 8617, -483386160 + -19770, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(483386160 + 8621, 483386160 + (char)-29867, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(483386160 + 8618, -483386160 + -8192, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (stringArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(483386160 + 8617, -483386160 + -19770, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(483386160 + 8621, 483386160 + (char)-29867, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(483386160 + 8597, -483386160 + -22262, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(483386160 + 8621, 483386160 + (char)-29867, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(483386160 + 8596, 483386160 + 17630, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (stringArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(483386160 + 8621, 483386160 + (char)-29867, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(483386160 + 8619, -483386160 + -((char)-29269), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(483386160 + 8617, -483386160 + -19770, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(483386160 + 8621, 483386160 + (char)-29867, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(483386160 + 8599, -483386160 + -((char)-29706), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 15088532385479L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(312208740 + (char)-21213, 312208740 + (char)-22009, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 13076000903027L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(2120450460 + 31126, -2120450460 + -12682, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00c6\u0081\u00b9\u00bcD\u008e\u00fd\u00e9\u0092\u0006\u0015\u00db\u00f6|\u0089\u00c4\u0087Q\u00b6\u0014z\u0010.\u0088\u00ad\u00ca\u00bd\u00e4\u0018\u00a1\u0081\u00fb\u00a6\u0081B\u00f0\u0013\u0011#\u00e9";
                        var4_3 = "\u00c6\u0081\u00b9\u00bcD\u008e\u00fd\u00e9\u0092\u0006\u0015\u00db\u00f6|\u0089\u00c4\u0087Q\u00b6\u0014z\u0010.\u0088\u00ad\u00ca\u00bd\u00e4\u0018\u00a1\u0081\u00fb\u00a6\u0081B\u00f0\u0013\u0011#\u00e9".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 107;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 124;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 3;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 60;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 106;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 5;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 66;
                                        break;
                                    }
                                    default: {
                                        v11 = 5;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x7440) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 37;
                            case 1 -> 89;
                            case 2 -> 226;
                            case 3 -> 56;
                            case 4 -> 229;
                            case 5 -> 176;
                            case 6 -> 90;
                            case 7 -> 98;
                            case 8 -> 131;
                            case 9 -> 106;
                            case 10 -> 173;
                            case 11 -> 238;
                            case 12 -> 0;
                            case 13 -> 109;
                            case 14 -> 99;
                            case 15 -> 180;
                            case 16 -> 42;
                            case 17 -> 221;
                            case 18 -> 119;
                            case 19 -> 63;
                            case 20 -> 44;
                            case 21 -> 211;
                            case 22 -> 178;
                            case 23 -> 53;
                            case 24 -> 157;
                            case 25 -> 100;
                            case 26 -> 130;
                            case 27 -> 103;
                            case 28 -> 51;
                            case 29 -> 97;
                            case 30 -> 40;
                            case 31 -> 174;
                            case 32 -> 17;
                            case 33 -> 153;
                            case 34 -> 152;
                            case 35 -> 29;
                            case 36 -> 118;
                            case 37 -> 4;
                            case 38 -> 33;
                            case 39 -> 175;
                            case 40 -> 66;
                            case 41 -> 113;
                            case 42 -> 67;
                            case 43 -> 12;
                            case 44 -> 231;
                            case 45 -> 14;
                            case 46 -> 70;
                            case 47 -> 121;
                            case 48 -> 3;
                            case 49 -> 120;
                            case 50 -> 68;
                            case 51 -> 187;
                            case 52 -> 245;
                            case 53 -> 127;
                            case 54 -> 161;
                            case 55 -> 86;
                            case 56 -> 171;
                            case 57 -> 203;
                            case 58 -> 156;
                            case 59 -> 7;
                            case 60 -> 212;
                            case 61 -> 179;
                            case 62 -> 250;
                            case 63 -> 154;
                            case 64 -> 155;
                            case 65 -> 72;
                            case 66 -> 75;
                            case 67 -> 209;
                            case 68 -> 36;
                            case 69 -> 107;
                            case 70 -> 215;
                            case 71 -> 184;
                            case 72 -> 163;
                            case 73 -> 201;
                            case 74 -> 83;
                            case 75 -> 30;
                            case 76 -> 210;
                            case 77 -> 2;
                            case 78 -> 8;
                            case 79 -> 213;
                            case 80 -> 198;
                            case 81 -> 128;
                            case 82 -> 169;
                            case 83 -> 223;
                            case 84 -> 1;
                            case 85 -> 79;
                            case 86 -> 195;
                            case 87 -> 205;
                            case 88 -> 248;
                            case 89 -> 140;
                            case 90 -> 95;
                            case 91 -> 54;
                            case 92 -> 19;
                            case 93 -> 149;
                            case 94 -> 137;
                            case 95 -> 76;
                            case 96 -> 253;
                            case 97 -> 43;
                            case 98 -> 228;
                            case 99 -> 160;
                            case 100 -> 91;
                            case 101 -> 110;
                            case 102 -> 135;
                            case 103 -> 183;
                            case 104 -> 234;
                            case 105 -> 117;
                            case 106 -> 240;
                            case 107 -> 189;
                            case 108 -> 9;
                            case 109 -> 166;
                            case 110 -> 217;
                            case 111 -> 77;
                            case 112 -> 5;
                            case 113 -> 168;
                            case 114 -> 207;
                            case 115 -> 162;
                            case 116 -> 26;
                            case 117 -> 227;
                            case 118 -> 141;
                            case 119 -> 125;
                            case 120 -> 58;
                            case 121 -> 60;
                            case 122 -> 129;
                            case 123 -> 185;
                            case 124 -> 218;
                            case 125 -> 181;
                            case 126 -> 32;
                            case 127 -> 55;
                            case 128 -> 143;
                            case 129 -> 246;
                            case 130 -> 151;
                            case 131 -> 244;
                            case 132 -> 112;
                            case 133 -> 25;
                            case 134 -> 31;
                            case 135 -> 52;
                            case 136 -> 164;
                            case 137 -> 18;
                            case 138 -> 6;
                            case 139 -> 11;
                            case 140 -> 216;
                            case 141 -> 236;
                            case 142 -> 255;
                            case 143 -> 133;
                            case 144 -> 20;
                            case 145 -> 172;
                            case 146 -> 241;
                            case 147 -> 10;
                            case 148 -> 194;
                            case 149 -> 220;
                            case 150 -> 105;
                            case 151 -> 64;
                            case 152 -> 225;
                            case 153 -> 196;
                            case 154 -> 48;
                            case 155 -> 134;
                            case 156 -> 188;
                            case 157 -> 16;
                            case 158 -> 146;
                            case 159 -> 104;
                            case 160 -> 82;
                            case 161 -> 123;
                            case 162 -> 71;
                            case 163 -> 182;
                            case 164 -> 27;
                            case 165 -> 61;
                            case 166 -> 62;
                            case 167 -> 142;
                            case 168 -> 41;
                            case 169 -> 192;
                            case 170 -> 114;
                            case 171 -> 219;
                            case 172 -> 249;
                            case 173 -> 251;
                            case 174 -> 206;
                            case 175 -> 139;
                            case 176 -> 73;
                            case 177 -> 222;
                            case 178 -> 115;
                            case 179 -> 254;
                            case 180 -> 186;
                            case 181 -> 92;
                            case 182 -> 148;
                            case 183 -> 28;
                            case 184 -> 199;
                            case 185 -> 59;
                            case 186 -> 69;
                            case 187 -> 46;
                            case 188 -> 65;
                            case 189 -> 235;
                            case 190 -> 243;
                            case 191 -> 85;
                            case 192 -> 101;
                            case 193 -> 158;
                            case 194 -> 102;
                            case 195 -> 38;
                            case 196 -> 233;
                            case 197 -> 132;
                            case 198 -> 202;
                            case 199 -> 167;
                            case 200 -> 84;
                            case 201 -> 126;
                            case 202 -> 144;
                            case 203 -> 39;
                            case 204 -> 150;
                            case 205 -> 214;
                            case 206 -> 122;
                            case 207 -> 74;
                            case 208 -> 193;
                            case 209 -> 237;
                            case 210 -> 239;
                            case 211 -> 93;
                            case 212 -> 197;
                            case 213 -> 138;
                            case 214 -> 252;
                            case 215 -> 232;
                            case 216 -> 204;
                            case 217 -> 50;
                            case 218 -> 96;
                            case 219 -> 13;
                            case 220 -> 242;
                            case 221 -> 247;
                            case 222 -> 191;
                            case 223 -> 145;
                            case 224 -> 24;
                            case 225 -> 108;
                            case 226 -> 57;
                            case 227 -> 177;
                            case 228 -> 22;
                            case 229 -> 78;
                            case 230 -> 34;
                            case 231 -> 170;
                            case 232 -> 124;
                            case 233 -> 80;
                            case 234 -> 208;
                            case 235 -> 81;
                            case 236 -> 94;
                            case 237 -> 35;
                            case 238 -> 230;
                            case 239 -> 47;
                            case 240 -> 111;
                            case 241 -> 87;
                            case 242 -> 49;
                            case 243 -> 21;
                            case 244 -> 23;
                            case 245 -> 88;
                            case 246 -> 224;
                            case 247 -> 45;
                            case 248 -> 159;
                            case 249 -> 15;
                            case 250 -> 200;
                            case 251 -> 165;
                            case 252 -> 190;
                            case 253 -> 116;
                            case 254 -> 136;
                            default -> 147;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (stringArray == null) {
                ActionTimestamp.y(new ActionTimestamp[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 31906953555842L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String[] stringArray = SshAgentIpcService.y();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (stringArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-358476450 + -((char)-28405), 358476450 + 25722, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-358476450 + -((char)-28409), -358476450 + -10063, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-358476450 + -((char)-28398), 358476450 + 21913, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-358476450 + -((char)-28405), 358476450 + 25722, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-358476450 + -((char)-28409), -358476450 + -10063, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-358476450 + -((char)-28397), -358476450 + -17299, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String[] stringArray;
                    block13: {
                        long l2 = 12045292388232L;
                        String[] stringArray2 = SshAgentIpcService.y();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-2090828640 + -((char)-22432), -2090828640 + -((char)-27756), (int)l2));
                        stringArray = stringArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (stringArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (stringArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-2090828640 + -((char)-22435), 2090828640 + (char)-29447, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (stringArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 31719440544171L;
                String[] stringArray2 = SshAgentIpcService.y();
                this.assertConnectionThread();
                stringArray = stringArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (stringArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (stringArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1107017220 + 23670, -1107017220 + -28871, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1107017220 + 23674, 1107017220 + (char)-19934, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1107017220 + 23645, 1107017220 + 32722, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1107017220 + 23674, 1107017220 + (char)-19934, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1107017220 + 23668, -1107017220 + -((char)-20362), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1107017220 + 23670, -1107017220 + -28871, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1107017220 + 23674, 1107017220 + (char)-19934, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1107017220 + 23658, 1107017220 + 17350, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (stringArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1107017220 + 23670, -1107017220 + -28871, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1107017220 + 23674, 1107017220 + (char)-19934, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1107017220 + 23659, 1107017220 + 32294, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (stringArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1107017220 + 23670, -1107017220 + -28871, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1107017220 + 23674, 1107017220 + (char)-19934, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1107017220 + 23656, -1107017220 + -32192, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String[] stringArray;
                block16: {
                    l2 = 48933676105985L;
                    Object object = this.lock;
                    stringArray = SshAgentIpcService.y();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (stringArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1113701790 - 4814, -1113701790 - -7997, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1113701790 - 4810, 1113701790 + 750, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1113701790 - 4823, -1113701790 - -3059, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1113701790 - 4830, -1113701790 - -11473, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1113701790 - 4814, -1113701790 - -7997, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1113701790 - 4810, 1113701790 + 750, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1113701790 - 4829, 1113701790 - 3570, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (stringArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (stringArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1113701790 - 4814, -1113701790 - -7997, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1113701790 - 4810, 1113701790 + 750, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1113701790 - 4828, -1113701790 - -11999, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1113701790 - 4814, -1113701790 - -7997, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1113701790 - 4810, 1113701790 + 750, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1113701790 - 4827, -1113701790 + -16191, (int)l2));
                    if (stringArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1113701790 - 4814, -1113701790 - -7997, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1113701790 - 4810, 1113701790 + 750, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1113701790 - 4770, 1113701790 + 16018, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1113701790 - 4769, 1113701790 - 5917, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00b8\u00ad\u00d3ML\u00d5a\u00a7\u0014\u0001\u00f9\u00dc S\u00f0-\u0019\u00ac\u001cC\u00b6w\u0099L\u0005\u00b6\u00a9\u00f2a\u0006\u0094iV\u00d5\u0096\u0087\u0018\u0014\u00e6\u001e\u00f3\u0089Ot.O\u00870\u00b5\u007f\u0006\u001ftu\u00ee\u00a4\u0014\u00ef\u00d0\u00ee$\t\u00c2\u00f0Z\u0080j\u00be\u0010X\u00ff\u0005,2A\u00ben\b\u00e7O8`cV\u00825\u0014\u0006PD\u008e--\u00d75\u009dD\u00ce\t\u008c\u00cd\u0088b<\u0096Z\u00c4\u0005\u00cc\u0013]\u009a\u00ed\u001e\u00cc\u00c7Hd\u00d2y\u00bd\u0092\u00d3\u0004\u00e8B(\u00d8W\u00cb\u009d\u0088k,\u00ba\u00f8H\u00ec\u0088\rZ4=\u00b4\u0010\u00bd\u001a\u0082\u001a\u00dc\u0084\u008a\u00d4H~\u0016\u00f0\u00f1\u00db\u00c34\t\u0002&\u0094K\u00e0\u00e0g\f\u00ff\u0010\u00cc\u00be\u00ac\u008e\u0019\u00162\u0086_4\u00f4\u00b9\u00ad\u00f2H\u0011?\u00edCd\u00f4Zb)\u009d04\u00d1\u00bf\u00b0\u0091y\u00db\u009d\u00ef\u0016\u0005\u009b\u008f\u0017ds\u00f4(\u00bfD\u0093\u00c5\u00fd\u00024\u00ce\u00de\u00c6\u00fard\u0015\u00e1P\u00f4\u00a1d\u00e0\u008fxR\u00c5\u00ae\u000b\u00b2\b\u00c0\u00e3\r\u00e6\u0004J|H\bX\u00ed\u00cf4\u009d\u00dc]d\f_\u00e8?\u008f\u009e\u00c9\u00d3\u00c1J\u0094\u0004\u00a9FN\u00fe\u001dM\u00da\u0091[\u00ca[\u00f9,\u00c0\u0099vC\u0001&\u00d3a-g\u00d8\u008b\u00bc\u00d6\u00c4o\u00b2\u0013\u001b\u0015\u00d0$'\u00c8\u009d\u00dc\u00df\u009a\u0004\u009b\u00f8\n,4\u00fa\u0006!C\u007f\u00c4\u00a1\u00c4\u00c5\u00e75\u0081\u00c7<\u00e1\"\u00a9\u0019\u00e7\u0086\u0092\u0090\u00cb\u00ec\u009e\u001fp[\u00df\u00f7 \u000b\u00e3\u00dc\u0018\u00cd\u0091{\u0007\u00e2\u00b9=;\u00be\u00c2 D\u00f9@g\u00e8\u00acA\u00ccCZ\u001d\u000brI\u009a\u00bb*OE\u0011\u0098\u0082T\u0015\u0086\u00e4\u0004\r\u00fe\u00f13\u00bbh7\u0082\u00ef\u00db\u00dc?\u00ac\u0010\u0018z\u008de)d\u00fb]\u00e3p\u0089\u00e9\u008cY\u00c7\u00b9:\u0006\u00c0\u0007|\u00b3\u001e\b\u0093\u00ed\u00f7\u00b3\u00be\u00f9\u00de\u00b4\u00fa\u00d2h\u00ad\u0080\u00cd\u0088\u0093\u00e5\u00a9\u00cd\u00bf\u00ef\u009c\u0007\u00c6\u00e4\u0003\u001a\u009f\u00eb\u008f\u0007W\u0007U\n\u00b2\u0006<(\u0013\u007f\u00ffR\u0094\u00d5\u0083 d\u00854D\u0094\u008e\u00176\u00b6\u00fa\u0006LM2\u00c8\u00cd\u0006\f\u00fd\u00db\u00cc,\u00b5\u00115\u00d1\u0012c#`}\u00a9\u000f\u00a6\u00df\u0007oc\u001e\u00d8\u009az_VNx\u009b\u0014\"\u0014@S\u0094\u00b1g\u00d1Q^|YM\u0019\"\u0080\u00ee\u00a8e\u00e1\u00be:R\u00e9Z!\u0016b=,\u00a2\u00d0\u00deL\u00b0\u000e\u0013\u0099\u00b1\u00a7\u00b5\u0007\u0002\u00b9!;=\u00c2\u0019\u0000\u001b\u001e\u00ab\u0017\u00e4\u009a\u00dar^x@\u009b\u00ac\u009d\u00fb6\u00c3\u00d6j\u0093\u00c3O\u00c94\u008f\u00d1\u00c1)\n>\u00c4\u00d7\u000e\u0096c C\u0099\u0081\u0018/\u00061\\_q\u00ebuU\u00ec\u00fc\u00a6\u00c8\u00e9`\u00a0k\u0007\u00f3\u0017;\u0018\u00e1\u00e6)*\u00b2\u0094\u00caI\u00ac\u00ce(\u00bdS%\u00a8\u0091\u009bjl`i\u00ad\u00b8c\u0082+\u001c\u009f\u0018\u00e5\u00ce\u00ab\u00b29Jz\u000f\u00b0\u0081\u0013e\u00e8\u00fav\t\n\u0002\u0095\u00d1\u00ca|t\u00c4 ";
                var4_3 = "\u00b8\u00ad\u00d3ML\u00d5a\u00a7\u0014\u0001\u00f9\u00dc S\u00f0-\u0019\u00ac\u001cC\u00b6w\u0099L\u0005\u00b6\u00a9\u00f2a\u0006\u0094iV\u00d5\u0096\u0087\u0018\u0014\u00e6\u001e\u00f3\u0089Ot.O\u00870\u00b5\u007f\u0006\u001ftu\u00ee\u00a4\u0014\u00ef\u00d0\u00ee$\t\u00c2\u00f0Z\u0080j\u00be\u0010X\u00ff\u0005,2A\u00ben\b\u00e7O8`cV\u00825\u0014\u0006PD\u008e--\u00d75\u009dD\u00ce\t\u008c\u00cd\u0088b<\u0096Z\u00c4\u0005\u00cc\u0013]\u009a\u00ed\u001e\u00cc\u00c7Hd\u00d2y\u00bd\u0092\u00d3\u0004\u00e8B(\u00d8W\u00cb\u009d\u0088k,\u00ba\u00f8H\u00ec\u0088\rZ4=\u00b4\u0010\u00bd\u001a\u0082\u001a\u00dc\u0084\u008a\u00d4H~\u0016\u00f0\u00f1\u00db\u00c34\t\u0002&\u0094K\u00e0\u00e0g\f\u00ff\u0010\u00cc\u00be\u00ac\u008e\u0019\u00162\u0086_4\u00f4\u00b9\u00ad\u00f2H\u0011?\u00edCd\u00f4Zb)\u009d04\u00d1\u00bf\u00b0\u0091y\u00db\u009d\u00ef\u0016\u0005\u009b\u008f\u0017ds\u00f4(\u00bfD\u0093\u00c5\u00fd\u00024\u00ce\u00de\u00c6\u00fard\u0015\u00e1P\u00f4\u00a1d\u00e0\u008fxR\u00c5\u00ae\u000b\u00b2\b\u00c0\u00e3\r\u00e6\u0004J|H\bX\u00ed\u00cf4\u009d\u00dc]d\f_\u00e8?\u008f\u009e\u00c9\u00d3\u00c1J\u0094\u0004\u00a9FN\u00fe\u001dM\u00da\u0091[\u00ca[\u00f9,\u00c0\u0099vC\u0001&\u00d3a-g\u00d8\u008b\u00bc\u00d6\u00c4o\u00b2\u0013\u001b\u0015\u00d0$'\u00c8\u009d\u00dc\u00df\u009a\u0004\u009b\u00f8\n,4\u00fa\u0006!C\u007f\u00c4\u00a1\u00c4\u00c5\u00e75\u0081\u00c7<\u00e1\"\u00a9\u0019\u00e7\u0086\u0092\u0090\u00cb\u00ec\u009e\u001fp[\u00df\u00f7 \u000b\u00e3\u00dc\u0018\u00cd\u0091{\u0007\u00e2\u00b9=;\u00be\u00c2 D\u00f9@g\u00e8\u00acA\u00ccCZ\u001d\u000brI\u009a\u00bb*OE\u0011\u0098\u0082T\u0015\u0086\u00e4\u0004\r\u00fe\u00f13\u00bbh7\u0082\u00ef\u00db\u00dc?\u00ac\u0010\u0018z\u008de)d\u00fb]\u00e3p\u0089\u00e9\u008cY\u00c7\u00b9:\u0006\u00c0\u0007|\u00b3\u001e\b\u0093\u00ed\u00f7\u00b3\u00be\u00f9\u00de\u00b4\u00fa\u00d2h\u00ad\u0080\u00cd\u0088\u0093\u00e5\u00a9\u00cd\u00bf\u00ef\u009c\u0007\u00c6\u00e4\u0003\u001a\u009f\u00eb\u008f\u0007W\u0007U\n\u00b2\u0006<(\u0013\u007f\u00ffR\u0094\u00d5\u0083 d\u00854D\u0094\u008e\u00176\u00b6\u00fa\u0006LM2\u00c8\u00cd\u0006\f\u00fd\u00db\u00cc,\u00b5\u00115\u00d1\u0012c#`}\u00a9\u000f\u00a6\u00df\u0007oc\u001e\u00d8\u009az_VNx\u009b\u0014\"\u0014@S\u0094\u00b1g\u00d1Q^|YM\u0019\"\u0080\u00ee\u00a8e\u00e1\u00be:R\u00e9Z!\u0016b=,\u00a2\u00d0\u00deL\u00b0\u000e\u0013\u0099\u00b1\u00a7\u00b5\u0007\u0002\u00b9!;=\u00c2\u0019\u0000\u001b\u001e\u00ab\u0017\u00e4\u009a\u00dar^x@\u009b\u00ac\u009d\u00fb6\u00c3\u00d6j\u0093\u00c3O\u00c94\u008f\u00d1\u00c1)\n>\u00c4\u00d7\u000e\u0096c C\u0099\u0081\u0018/\u00061\\_q\u00ebuU\u00ec\u00fc\u00a6\u00c8\u00e9`\u00a0k\u0007\u00f3\u0017;\u0018\u00e1\u00e6)*\u00b2\u0094\u00caI\u00ac\u00ce(\u00bdS%\u00a8\u0091\u009bjl`i\u00ad\u00b8c\u0082+\u001c\u009f\u0018\u00e5\u00ce\u00ab\u00b29Jz\u000f\u00b0\u0081\u0013e\u00e8\u00fav\t\n\u0002\u0095\u00d1\u00ca|t\u00c4 ".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 26;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00b2\u00ce\u00ff=\\*\u0014\u0080\u009e>9}jYmL\u00f8\u0019\u0096J)\u009b\u00e9\u0099\u0014\u00cc}iP\u0014\u00a7\u00f9pX\u00be\u0087\u00e8\u008fl\u00b6#\u009b\u0003D\u00ba\u00c6\u0010\u00a9^\u0019";
                    var4_3 = "\u00b2\u00ce\u00ff=\\*\u0014\u0080\u009e>9}jYmL\u00f8\u0019\u0096J)\u009b\u00e9\u0099\u0014\u00cc}iP\u0014\u00a7\u00f9pX\u00be\u0087\u00e8\u008fl\u00b6#\u009b\u0003D\u00ba\u00c6\u0010\u00a9^\u0019".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 1;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 77;
                            break;
                        }
                        case 1: {
                            v15 = 63;
                            break;
                        }
                        case 2: {
                            v15 = 58;
                            break;
                        }
                        case 3: {
                            v15 = 103;
                            break;
                        }
                        case 4: {
                            v15 = 6;
                            break;
                        }
                        case 5: {
                            v15 = 97;
                            break;
                        }
                        default: {
                            v15 = 95;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x6BDD) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 94;
                case 1 -> 3;
                case 2 -> 80;
                case 3 -> 28;
                case 4 -> 254;
                case 5 -> 197;
                case 6 -> 79;
                case 7 -> 216;
                case 8 -> 166;
                case 9 -> 15;
                case 10 -> 26;
                case 11 -> 12;
                case 12 -> 42;
                case 13 -> 193;
                case 14 -> 159;
                case 15 -> 248;
                case 16 -> 141;
                case 17 -> 99;
                case 18 -> 209;
                case 19 -> 142;
                case 20 -> 112;
                case 21 -> 83;
                case 22 -> 195;
                case 23 -> 130;
                case 24 -> 1;
                case 25 -> 175;
                case 26 -> 66;
                case 27 -> 227;
                case 28 -> 131;
                case 29 -> 129;
                case 30 -> 173;
                case 31 -> 67;
                case 32 -> 199;
                case 33 -> 45;
                case 34 -> 71;
                case 35 -> 105;
                case 36 -> 35;
                case 37 -> 179;
                case 38 -> 160;
                case 39 -> 233;
                case 40 -> 54;
                case 41 -> 78;
                case 42 -> 98;
                case 43 -> 58;
                case 44 -> 171;
                case 45 -> 69;
                case 46 -> 208;
                case 47 -> 183;
                case 48 -> 186;
                case 49 -> 104;
                case 50 -> 128;
                case 51 -> 64;
                case 52 -> 90;
                case 53 -> 176;
                case 54 -> 46;
                case 55 -> 120;
                case 56 -> 2;
                case 57 -> 238;
                case 58 -> 136;
                case 59 -> 108;
                case 60 -> 194;
                case 61 -> 0;
                case 62 -> 39;
                case 63 -> 55;
                case 64 -> 76;
                case 65 -> 214;
                case 66 -> 9;
                case 67 -> 8;
                case 68 -> 25;
                case 69 -> 243;
                case 70 -> 17;
                case 71 -> 84;
                case 72 -> 65;
                case 73 -> 225;
                case 74 -> 10;
                case 75 -> 82;
                case 76 -> 188;
                case 77 -> 161;
                case 78 -> 228;
                case 79 -> 74;
                case 80 -> 180;
                case 81 -> 125;
                case 82 -> 239;
                case 83 -> 47;
                case 84 -> 155;
                case 85 -> 111;
                case 86 -> 191;
                case 87 -> 157;
                case 88 -> 16;
                case 89 -> 213;
                case 90 -> 137;
                case 91 -> 181;
                case 92 -> 51;
                case 93 -> 187;
                case 94 -> 138;
                case 95 -> 204;
                case 96 -> 57;
                case 97 -> 202;
                case 98 -> 92;
                case 99 -> 31;
                case 100 -> 97;
                case 101 -> 117;
                case 102 -> 149;
                case 103 -> 93;
                case 104 -> 196;
                case 105 -> 237;
                case 106 -> 232;
                case 107 -> 156;
                case 108 -> 49;
                case 109 -> 62;
                case 110 -> 231;
                case 111 -> 255;
                case 112 -> 115;
                case 113 -> 244;
                case 114 -> 205;
                case 115 -> 6;
                case 116 -> 32;
                case 117 -> 75;
                case 118 -> 95;
                case 119 -> 38;
                case 120 -> 107;
                case 121 -> 22;
                case 122 -> 63;
                case 123 -> 4;
                case 124 -> 102;
                case 125 -> 249;
                case 126 -> 234;
                case 127 -> 147;
                case 128 -> 85;
                case 129 -> 14;
                case 130 -> 165;
                case 131 -> 56;
                case 132 -> 200;
                case 133 -> 96;
                case 134 -> 207;
                case 135 -> 114;
                case 136 -> 132;
                case 137 -> 177;
                case 138 -> 73;
                case 139 -> 126;
                case 140 -> 40;
                case 141 -> 60;
                case 142 -> 18;
                case 143 -> 148;
                case 144 -> 172;
                case 145 -> 163;
                case 146 -> 50;
                case 147 -> 33;
                case 148 -> 103;
                case 149 -> 144;
                case 150 -> 7;
                case 151 -> 101;
                case 152 -> 121;
                case 153 -> 218;
                case 154 -> 19;
                case 155 -> 162;
                case 156 -> 143;
                case 157 -> 210;
                case 158 -> 89;
                case 159 -> 20;
                case 160 -> 224;
                case 161 -> 41;
                case 162 -> 37;
                case 163 -> 242;
                case 164 -> 174;
                case 165 -> 61;
                case 166 -> 236;
                case 167 -> 113;
                case 168 -> 88;
                case 169 -> 68;
                case 170 -> 154;
                case 171 -> 43;
                case 172 -> 223;
                case 173 -> 189;
                case 174 -> 140;
                case 175 -> 24;
                case 176 -> 86;
                case 177 -> 247;
                case 178 -> 23;
                case 179 -> 203;
                case 180 -> 170;
                case 181 -> 190;
                case 182 -> 110;
                case 183 -> 201;
                case 184 -> 151;
                case 185 -> 153;
                case 186 -> 123;
                case 187 -> 235;
                case 188 -> 185;
                case 189 -> 127;
                case 190 -> 27;
                case 191 -> 168;
                case 192 -> 212;
                case 193 -> 91;
                case 194 -> 167;
                case 195 -> 145;
                case 196 -> 226;
                case 197 -> 133;
                case 198 -> 119;
                case 199 -> 21;
                case 200 -> 164;
                case 201 -> 146;
                case 202 -> 251;
                case 203 -> 52;
                case 204 -> 184;
                case 205 -> 220;
                case 206 -> 169;
                case 207 -> 118;
                case 208 -> 100;
                case 209 -> 206;
                case 210 -> 135;
                case 211 -> 59;
                case 212 -> 70;
                case 213 -> 241;
                case 214 -> 250;
                case 215 -> 230;
                case 216 -> 30;
                case 217 -> 44;
                case 218 -> 53;
                case 219 -> 182;
                case 220 -> 11;
                case 221 -> 116;
                case 222 -> 245;
                case 223 -> 215;
                case 224 -> 240;
                case 225 -> 211;
                case 226 -> 5;
                case 227 -> 77;
                case 228 -> 81;
                case 229 -> 178;
                case 230 -> 124;
                case 231 -> 139;
                case 232 -> 217;
                case 233 -> 158;
                case 234 -> 229;
                case 235 -> 222;
                case 236 -> 122;
                case 237 -> 34;
                case 238 -> 219;
                case 239 -> 252;
                case 240 -> 87;
                case 241 -> 150;
                case 242 -> 36;
                case 243 -> 134;
                case 244 -> 13;
                case 245 -> 48;
                case 246 -> 29;
                case 247 -> 221;
                case 248 -> 106;
                case 249 -> 72;
                case 250 -> 152;
                case 251 -> 192;
                case 252 -> 246;
                case 253 -> 253;
                case 254 -> 109;
                default -> 198;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 6459581470058L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-49282320 + -((char)-13380), -49282320 + -((char)-20719), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String[] stringArray;
                        block4: {
                            l2 = 135585094112235L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            stringArray = SshAgentIpcService.y();
                            try {
                                hANDLE2 = hANDLE;
                                if (stringArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (stringArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1566548640 - 28908, 1566548640 - 13290, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1566548640 - 28905, -1566548640 - -9616, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1566548640 - 28906, -1566548640 - -((char)-28102), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "I\u00f3\u00c1\u00b4%\u00b4\u0091\u00f0\u0010\u00d2\u00e2C7\u00cf\u007f5\u00d0\u00a9\u00d2\u0018Nn\u00d1Kc";
                    var4_3 = "I\u00f3\u00c1\u00b4%\u00b4\u0091\u00f0\u0010\u00d2\u00e2C7\u00cf\u007f5\u00d0\u00a9\u00d2\u0018Nn\u00d1Kc".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 116;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0014\u0091\u00a57\u00165\\\u00c1\u00bbQ\u0007E\u00fb\u00f3\u00c8\u00c2iCxUC\u00b6'v26\u0011\u00d839k\u0014\u00a5\u009b\u00d1\u00feE\u00ea\n\u00fb\u00d9\u00d28\u00b2\u0014\u00e2\u00f8\f\u00cex\u00c4\u00e3Z|\u0089n1\u00ef-";
                        var4_3 = "\u0014\u0091\u00a57\u00165\\\u00c1\u00bbQ\u0007E\u00fb\u00f3\u00c8\u00c2iCxUC\u00b6'v26\u0011\u00d839k\u0014\u00a5\u009b\u00d1\u00feE\u00ea\n\u00fb\u00d9\u00d28\u00b2\u0014\u00e2\u00f8\f\u00cex\u00c4\u00e3Z|\u0089n1\u00ef-".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 122;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 83;
                                break;
                            }
                            case 1: {
                                v15 = 65;
                                break;
                            }
                            case 2: {
                                v15 = 118;
                                break;
                            }
                            case 3: {
                                v15 = 57;
                                break;
                            }
                            case 4: {
                                v15 = 7;
                                break;
                            }
                            case 5: {
                                v15 = 87;
                                break;
                            }
                            default: {
                                v15 = 1;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x225E) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 131;
                    case 1 -> 162;
                    case 2 -> 170;
                    case 3 -> 48;
                    case 4 -> 229;
                    case 5 -> 52;
                    case 6 -> 161;
                    case 7 -> 235;
                    case 8 -> 89;
                    case 9 -> 43;
                    case 10 -> 64;
                    case 11 -> 230;
                    case 12 -> 101;
                    case 13 -> 123;
                    case 14 -> 47;
                    case 15 -> 237;
                    case 16 -> 78;
                    case 17 -> 179;
                    case 18 -> 12;
                    case 19 -> 165;
                    case 20 -> 75;
                    case 21 -> 212;
                    case 22 -> 93;
                    case 23 -> 23;
                    case 24 -> 218;
                    case 25 -> 98;
                    case 26 -> 147;
                    case 27 -> 116;
                    case 28 -> 105;
                    case 29 -> 135;
                    case 30 -> 82;
                    case 31 -> 22;
                    case 32 -> 245;
                    case 33 -> 191;
                    case 34 -> 27;
                    case 35 -> 211;
                    case 36 -> 159;
                    case 37 -> 138;
                    case 38 -> 86;
                    case 39 -> 121;
                    case 40 -> 169;
                    case 41 -> 54;
                    case 42 -> 30;
                    case 43 -> 13;
                    case 44 -> 255;
                    case 45 -> 70;
                    case 46 -> 157;
                    case 47 -> 74;
                    case 48 -> 79;
                    case 49 -> 216;
                    case 50 -> 7;
                    case 51 -> 88;
                    case 52 -> 1;
                    case 53 -> 145;
                    case 54 -> 190;
                    case 55 -> 140;
                    case 56 -> 221;
                    case 57 -> 155;
                    case 58 -> 242;
                    case 59 -> 17;
                    case 60 -> 224;
                    case 61 -> 206;
                    case 62 -> 18;
                    case 63 -> 63;
                    case 64 -> 60;
                    case 65 -> 196;
                    case 66 -> 236;
                    case 67 -> 100;
                    case 68 -> 66;
                    case 69 -> 215;
                    case 70 -> 195;
                    case 71 -> 172;
                    case 72 -> 127;
                    case 73 -> 24;
                    case 74 -> 0;
                    case 75 -> 252;
                    case 76 -> 207;
                    case 77 -> 4;
                    case 78 -> 3;
                    case 79 -> 253;
                    case 80 -> 247;
                    case 81 -> 250;
                    case 82 -> 87;
                    case 83 -> 134;
                    case 84 -> 56;
                    case 85 -> 174;
                    case 86 -> 198;
                    case 87 -> 124;
                    case 88 -> 10;
                    case 89 -> 160;
                    case 90 -> 241;
                    case 91 -> 182;
                    case 92 -> 42;
                    case 93 -> 239;
                    case 94 -> 194;
                    case 95 -> 2;
                    case 96 -> 109;
                    case 97 -> 5;
                    case 98 -> 112;
                    case 99 -> 83;
                    case 100 -> 81;
                    case 101 -> 166;
                    case 102 -> 244;
                    case 103 -> 129;
                    case 104 -> 33;
                    case 105 -> 11;
                    case 106 -> 173;
                    case 107 -> 183;
                    case 108 -> 149;
                    case 109 -> 16;
                    case 110 -> 151;
                    case 111 -> 118;
                    case 112 -> 210;
                    case 113 -> 202;
                    case 114 -> 248;
                    case 115 -> 180;
                    case 116 -> 20;
                    case 117 -> 34;
                    case 118 -> 153;
                    case 119 -> 176;
                    case 120 -> 106;
                    case 121 -> 185;
                    case 122 -> 168;
                    case 123 -> 204;
                    case 124 -> 6;
                    case 125 -> 72;
                    case 126 -> 146;
                    case 127 -> 192;
                    case 128 -> 32;
                    case 129 -> 91;
                    case 130 -> 94;
                    case 131 -> 117;
                    case 132 -> 200;
                    case 133 -> 251;
                    case 134 -> 59;
                    case 135 -> 39;
                    case 136 -> 38;
                    case 137 -> 35;
                    case 138 -> 189;
                    case 139 -> 199;
                    case 140 -> 103;
                    case 141 -> 164;
                    case 142 -> 222;
                    case 143 -> 9;
                    case 144 -> 115;
                    case 145 -> 205;
                    case 146 -> 92;
                    case 147 -> 187;
                    case 148 -> 177;
                    case 149 -> 108;
                    case 150 -> 96;
                    case 151 -> 231;
                    case 152 -> 57;
                    case 153 -> 133;
                    case 154 -> 141;
                    case 155 -> 143;
                    case 156 -> 62;
                    case 157 -> 238;
                    case 158 -> 178;
                    case 159 -> 142;
                    case 160 -> 201;
                    case 161 -> 132;
                    case 162 -> 223;
                    case 163 -> 193;
                    case 164 -> 217;
                    case 165 -> 14;
                    case 166 -> 110;
                    case 167 -> 44;
                    case 168 -> 95;
                    case 169 -> 150;
                    case 170 -> 53;
                    case 171 -> 214;
                    case 172 -> 171;
                    case 173 -> 128;
                    case 174 -> 97;
                    case 175 -> 186;
                    case 176 -> 28;
                    case 177 -> 243;
                    case 178 -> 154;
                    case 179 -> 67;
                    case 180 -> 36;
                    case 181 -> 209;
                    case 182 -> 152;
                    case 183 -> 225;
                    case 184 -> 137;
                    case 185 -> 249;
                    case 186 -> 197;
                    case 187 -> 73;
                    case 188 -> 8;
                    case 189 -> 228;
                    case 190 -> 50;
                    case 191 -> 184;
                    case 192 -> 40;
                    case 193 -> 37;
                    case 194 -> 130;
                    case 195 -> 232;
                    case 196 -> 254;
                    case 197 -> 104;
                    case 198 -> 175;
                    case 199 -> 136;
                    case 200 -> 113;
                    case 201 -> 167;
                    case 202 -> 31;
                    case 203 -> 19;
                    case 204 -> 208;
                    case 205 -> 226;
                    case 206 -> 219;
                    case 207 -> 125;
                    case 208 -> 76;
                    case 209 -> 102;
                    case 210 -> 41;
                    case 211 -> 240;
                    case 212 -> 156;
                    case 213 -> 158;
                    case 214 -> 85;
                    case 215 -> 90;
                    case 216 -> 68;
                    case 217 -> 46;
                    case 218 -> 45;
                    case 219 -> 163;
                    case 220 -> 25;
                    case 221 -> 80;
                    case 222 -> 120;
                    case 223 -> 213;
                    case 224 -> 181;
                    case 225 -> 233;
                    case 226 -> 107;
                    case 227 -> 51;
                    case 228 -> 188;
                    case 229 -> 71;
                    case 230 -> 26;
                    case 231 -> 246;
                    case 232 -> 15;
                    case 233 -> 21;
                    case 234 -> 114;
                    case 235 -> 119;
                    case 236 -> 122;
                    case 237 -> 29;
                    case 238 -> 144;
                    case 239 -> 65;
                    case 240 -> 49;
                    case 241 -> 84;
                    case 242 -> 61;
                    case 243 -> 111;
                    case 244 -> 58;
                    case 245 -> 203;
                    case 246 -> 69;
                    case 247 -> 126;
                    case 248 -> 148;
                    case 249 -> 55;
                    case 250 -> 77;
                    case 251 -> 99;
                    case 252 -> 139;
                    case 253 -> 220;
                    case 254 -> 234;
                    default -> 227;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 123739281516542L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "5\b\f^\u0002C[l\t2\u0002\u001fTO\u0001FpD";
                    var5_4 = "5\b\f^\u0002C[l\t2\u0002\u001fTO\u0001FpD".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 115;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 45;
                                    break;
                                }
                                case 1: {
                                    v11 = 30;
                                    break;
                                }
                                case 2: {
                                    v11 = 13;
                                    break;
                                }
                                case 3: {
                                    v11 = 67;
                                    break;
                                }
                                case 4: {
                                    v11 = 20;
                                    break;
                                }
                                case 5: {
                                    v11 = 92;
                                    break;
                                }
                                default: {
                                    v11 = 27;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 117059971653513L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "ts\u0004H6RE\u0004rm\bR\n~r\u0003R:P]Ts\n\t~r\u0003R:P]Xy\ryt\u001e_0]GX~\u0019U1T";
                    var5_4 = "ts\u0004H6RE\u0004rm\bR\n~r\u0003R:P]Ts\n\t~r\u0003R:P]Xy\ryt\u001e_0]GX~\u0019U1T".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 87;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "uz\tD=VE\u0006uz\tD1\\";
                        var5_4 = "uz\tD=VE\u0006uz\tD1\\".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 92;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 106;
                                break;
                            }
                            case 1: {
                                v15 = 74;
                                break;
                            }
                            case 2: {
                                v15 = 58;
                                break;
                            }
                            case 3: {
                                v15 = 107;
                                break;
                            }
                            case 4: {
                                v15 = 8;
                                break;
                            }
                            case 5: {
                                v15 = 100;
                                break;
                            }
                            default: {
                                v15 = 126;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 136394242829622L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1033618020 - 21605, 1033618020 - (char)-27294, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 134959716391269L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\fiU\u00e9c\u0003\u007ff\u008f\u0005\u00c1c\u00cals\r\u00ddY\u007fa0\u00f5\u0095Y\u00b0}\u0012\u00b1\u001c\u0010 \u0019\u0007\u0082\u0000\u001c\u00b8Y\u00dc\u00f9|l7\u00e1\u0085\u00a1\u0005\u0080\u00e9\u00e2=v3z\u0019\u00acT\u00a0\u0082\u009c\u009e%\u00fc\u00c8\u00e5g\u0081\u00a3\u00b2\u00de\u00e8\u00f2\u00ff\u0015\u00cd\u00de\u00c6\u0018\u00fc8k\u00f6_K\u0086\u0082\u00ca\u0093\u00b5\u0080\u00c9\u00b6\u000f+P\u008f\u00caH\u00c2-hU\u00f6Q";
                    var4_3 = "\fiU\u00e9c\u0003\u007ff\u008f\u0005\u00c1c\u00cals\r\u00ddY\u007fa0\u00f5\u0095Y\u00b0}\u0012\u00b1\u001c\u0010 \u0019\u0007\u0082\u0000\u001c\u00b8Y\u00dc\u00f9|l7\u00e1\u0085\u00a1\u0005\u0080\u00e9\u00e2=v3z\u0019\u00acT\u00a0\u0082\u009c\u009e%\u00fc\u00c8\u00e5g\u0081\u00a3\u00b2\u00de\u00e8\u00f2\u00ff\u0015\u00cd\u00de\u00c6\u0018\u00fc8k\u00f6_K\u0086\u0082\u00ca\u0093\u00b5\u0080\u00c9\u00b6\u000f+P\u008f\u00caH\u00c2-hU\u00f6Q".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 81;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0010\u0080I\u00f9\u0081;\u00c0\u00f5\u009b$\u00dc\u009fk\u00d7F/L\u0007=\\\u0084\t\\\u00bfw\u00fd\u00e7\u00bc^ia\u0095\u0080U74\u00ba\u00edI\u00a3\u00bc\u00dc\u0010\u00cdx\u00fa<m\u00cd\u001e\u00059\u0018\u00af\u00ea!E\u00a7\u00ac\u0099`\u00d7\u0001]`\u00e1\u008bgZ\u00c0\u00d1M\u00bf\u0099\u00ac\u0018\u00b9\u0085p\u00f8\u007fU\u00ff\u00a0#\u00805\u00fe\u00da\u00d7Ci\u00a3";
                        var4_3 = "\u0010\u0080I\u00f9\u0081;\u00c0\u00f5\u009b$\u00dc\u009fk\u00d7F/L\u0007=\\\u0084\t\\\u00bfw\u00fd\u00e7\u00bc^ia\u0095\u0080U74\u00ba\u00edI\u00a3\u00bc\u00dc\u0010\u00cdx\u00fa<m\u00cd\u001e\u00059\u0018\u00af\u00ea!E\u00a7\u00ac\u0099`\u00d7\u0001]`\u00e1\u008bgZ\u00c0\u00d1M\u00bf\u0099\u00ac\u0018\u00b9\u0085p\u00f8\u007fU\u00ff\u00a0#\u00805\u00fe\u00da\u00d7Ci\u00a3".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 17;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 53;
                                break;
                            }
                            case 1: {
                                v15 = 10;
                                break;
                            }
                            case 2: {
                                v15 = 33;
                                break;
                            }
                            case 3: {
                                v15 = 27;
                                break;
                            }
                            case 4: {
                                v15 = 43;
                                break;
                            }
                            case 5: {
                                v15 = 71;
                                break;
                            }
                            default: {
                                v15 = 113;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFC0C9) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 111;
                    case 1 -> 197;
                    case 2 -> 48;
                    case 3 -> 140;
                    case 4 -> 60;
                    case 5 -> 249;
                    case 6 -> 7;
                    case 7 -> 95;
                    case 8 -> 218;
                    case 9 -> 134;
                    case 10 -> 123;
                    case 11 -> 70;
                    case 12 -> 216;
                    case 13 -> 2;
                    case 14 -> 73;
                    case 15 -> 229;
                    case 16 -> 90;
                    case 17 -> 234;
                    case 18 -> 56;
                    case 19 -> 65;
                    case 20 -> 201;
                    case 21 -> 79;
                    case 22 -> 6;
                    case 23 -> 227;
                    case 24 -> 26;
                    case 25 -> 98;
                    case 26 -> 145;
                    case 27 -> 36;
                    case 28 -> 54;
                    case 29 -> 37;
                    case 30 -> 152;
                    case 31 -> 179;
                    case 32 -> 59;
                    case 33 -> 139;
                    case 34 -> 228;
                    case 35 -> 119;
                    case 36 -> 58;
                    case 37 -> 23;
                    case 38 -> 193;
                    case 39 -> 245;
                    case 40 -> 120;
                    case 41 -> 19;
                    case 42 -> 85;
                    case 43 -> 108;
                    case 44 -> 14;
                    case 45 -> 78;
                    case 46 -> 164;
                    case 47 -> 41;
                    case 48 -> 1;
                    case 49 -> 182;
                    case 50 -> 112;
                    case 51 -> 132;
                    case 52 -> 87;
                    case 53 -> 222;
                    case 54 -> 147;
                    case 55 -> 162;
                    case 56 -> 253;
                    case 57 -> 131;
                    case 58 -> 224;
                    case 59 -> 177;
                    case 60 -> 86;
                    case 61 -> 175;
                    case 62 -> 251;
                    case 63 -> 42;
                    case 64 -> 173;
                    case 65 -> 24;
                    case 66 -> 4;
                    case 67 -> 57;
                    case 68 -> 174;
                    case 69 -> 172;
                    case 70 -> 151;
                    case 71 -> 158;
                    case 72 -> 189;
                    case 73 -> 243;
                    case 74 -> 195;
                    case 75 -> 208;
                    case 76 -> 160;
                    case 77 -> 110;
                    case 78 -> 205;
                    case 79 -> 203;
                    case 80 -> 81;
                    case 81 -> 223;
                    case 82 -> 47;
                    case 83 -> 235;
                    case 84 -> 11;
                    case 85 -> 214;
                    case 86 -> 191;
                    case 87 -> 82;
                    case 88 -> 32;
                    case 89 -> 12;
                    case 90 -> 248;
                    case 91 -> 10;
                    case 92 -> 84;
                    case 93 -> 238;
                    case 94 -> 105;
                    case 95 -> 154;
                    case 96 -> 51;
                    case 97 -> 102;
                    case 98 -> 149;
                    case 99 -> 68;
                    case 100 -> 247;
                    case 101 -> 40;
                    case 102 -> 52;
                    case 103 -> 232;
                    case 104 -> 43;
                    case 105 -> 91;
                    case 106 -> 184;
                    case 107 -> 92;
                    case 108 -> 242;
                    case 109 -> 136;
                    case 110 -> 244;
                    case 111 -> 107;
                    case 112 -> 113;
                    case 113 -> 30;
                    case 114 -> 88;
                    case 115 -> 142;
                    case 116 -> 167;
                    case 117 -> 127;
                    case 118 -> 29;
                    case 119 -> 252;
                    case 120 -> 250;
                    case 121 -> 176;
                    case 122 -> 168;
                    case 123 -> 94;
                    case 124 -> 219;
                    case 125 -> 254;
                    case 126 -> 135;
                    case 127 -> 194;
                    case 128 -> 38;
                    case 129 -> 20;
                    case 130 -> 3;
                    case 131 -> 241;
                    case 132 -> 122;
                    case 133 -> 130;
                    case 134 -> 204;
                    case 135 -> 9;
                    case 136 -> 83;
                    case 137 -> 101;
                    case 138 -> 157;
                    case 139 -> 143;
                    case 140 -> 148;
                    case 141 -> 53;
                    case 142 -> 150;
                    case 143 -> 44;
                    case 144 -> 170;
                    case 145 -> 181;
                    case 146 -> 153;
                    case 147 -> 66;
                    case 148 -> 125;
                    case 149 -> 97;
                    case 150 -> 126;
                    case 151 -> 220;
                    case 152 -> 156;
                    case 153 -> 22;
                    case 154 -> 233;
                    case 155 -> 106;
                    case 156 -> 25;
                    case 157 -> 67;
                    case 158 -> 63;
                    case 159 -> 69;
                    case 160 -> 246;
                    case 161 -> 185;
                    case 162 -> 141;
                    case 163 -> 61;
                    case 164 -> 100;
                    case 165 -> 55;
                    case 166 -> 45;
                    case 167 -> 5;
                    case 168 -> 210;
                    case 169 -> 187;
                    case 170 -> 71;
                    case 171 -> 211;
                    case 172 -> 165;
                    case 173 -> 72;
                    case 174 -> 35;
                    case 175 -> 114;
                    case 176 -> 103;
                    case 177 -> 34;
                    case 178 -> 46;
                    case 179 -> 0;
                    case 180 -> 28;
                    case 181 -> 17;
                    case 182 -> 104;
                    case 183 -> 75;
                    case 184 -> 115;
                    case 185 -> 77;
                    case 186 -> 21;
                    case 187 -> 239;
                    case 188 -> 236;
                    case 189 -> 231;
                    case 190 -> 27;
                    case 191 -> 215;
                    case 192 -> 31;
                    case 193 -> 62;
                    case 194 -> 240;
                    case 195 -> 15;
                    case 196 -> 128;
                    case 197 -> 64;
                    case 198 -> 212;
                    case 199 -> 171;
                    case 200 -> 230;
                    case 201 -> 255;
                    case 202 -> 96;
                    case 203 -> 121;
                    case 204 -> 206;
                    case 205 -> 180;
                    case 206 -> 209;
                    case 207 -> 89;
                    case 208 -> 163;
                    case 209 -> 190;
                    case 210 -> 118;
                    case 211 -> 18;
                    case 212 -> 196;
                    case 213 -> 39;
                    case 214 -> 138;
                    case 215 -> 80;
                    case 216 -> 133;
                    case 217 -> 137;
                    case 218 -> 217;
                    case 219 -> 155;
                    case 220 -> 117;
                    case 221 -> 129;
                    case 222 -> 225;
                    case 223 -> 202;
                    case 224 -> 13;
                    case 225 -> 161;
                    case 226 -> 16;
                    case 227 -> 192;
                    case 228 -> 178;
                    case 229 -> 8;
                    case 230 -> 188;
                    case 231 -> 199;
                    case 232 -> 99;
                    case 233 -> 76;
                    case 234 -> 207;
                    case 235 -> 186;
                    case 236 -> 200;
                    case 237 -> 221;
                    case 238 -> 109;
                    case 239 -> 93;
                    case 240 -> 213;
                    case 241 -> 159;
                    case 242 -> 183;
                    case 243 -> 144;
                    case 244 -> 74;
                    case 245 -> 124;
                    case 246 -> 169;
                    case 247 -> 146;
                    case 248 -> 166;
                    case 249 -> 33;
                    case 250 -> 198;
                    case 251 -> 49;
                    case 252 -> 116;
                    case 253 -> 237;
                    case 254 -> 50;
                    default -> 226;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 93623081292853L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1384230270 - -((char)-8596), -1384099200 + -((char)-3454), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 64665900827380L;
                    String[] stringArray = SshAgentIpcService.y();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-873188340 + -((char)-29218), 873188340 + (char)-30250, (int)l2));
                    String[] stringArray2 = stringArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (stringArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 19271138923854L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00cc\u00ed=\u000b\u0090\u0003S\u001c\u0098";
                var4_3 = "\u00cc\u00ed=\u000b\u0090\u0003S\u001c\u0098".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 81;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 15;
                                break;
                            }
                            case 1: {
                                v11 = 104;
                                break;
                            }
                            case 2: {
                                v11 = 22;
                                break;
                            }
                            case 3: {
                                v11 = 37;
                                break;
                            }
                            case 4: {
                                v11 = 51;
                                break;
                            }
                            case 5: {
                                v11 = 68;
                                break;
                            }
                            default: {
                                v11 = 117;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFE4DB) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 109;
                    case 1 -> 194;
                    case 2 -> 4;
                    case 3 -> 9;
                    case 4 -> 159;
                    case 5 -> 203;
                    case 6 -> 70;
                    case 7 -> 138;
                    case 8 -> 198;
                    case 9 -> 255;
                    case 10 -> 232;
                    case 11 -> 152;
                    case 12 -> 17;
                    case 13 -> 192;
                    case 14 -> 12;
                    case 15 -> 184;
                    case 16 -> 235;
                    case 17 -> 157;
                    case 18 -> 69;
                    case 19 -> 214;
                    case 20 -> 80;
                    case 21 -> 168;
                    case 22 -> 244;
                    case 23 -> 193;
                    case 24 -> 77;
                    case 25 -> 72;
                    case 26 -> 64;
                    case 27 -> 181;
                    case 28 -> 170;
                    case 29 -> 62;
                    case 30 -> 95;
                    case 31 -> 202;
                    case 32 -> 156;
                    case 33 -> 96;
                    case 34 -> 94;
                    case 35 -> 130;
                    case 36 -> 178;
                    case 37 -> 27;
                    case 38 -> 224;
                    case 39 -> 207;
                    case 40 -> 247;
                    case 41 -> 145;
                    case 42 -> 97;
                    case 43 -> 151;
                    case 44 -> 187;
                    case 45 -> 200;
                    case 46 -> 38;
                    case 47 -> 196;
                    case 48 -> 153;
                    case 49 -> 208;
                    case 50 -> 226;
                    case 51 -> 195;
                    case 52 -> 221;
                    case 53 -> 25;
                    case 54 -> 213;
                    case 55 -> 103;
                    case 56 -> 147;
                    case 57 -> 217;
                    case 58 -> 48;
                    case 59 -> 107;
                    case 60 -> 61;
                    case 61 -> 162;
                    case 62 -> 122;
                    case 63 -> 126;
                    case 64 -> 93;
                    case 65 -> 41;
                    case 66 -> 2;
                    case 67 -> 59;
                    case 68 -> 101;
                    case 69 -> 115;
                    case 70 -> 161;
                    case 71 -> 10;
                    case 72 -> 90;
                    case 73 -> 135;
                    case 74 -> 39;
                    case 75 -> 47;
                    case 76 -> 11;
                    case 77 -> 76;
                    case 78 -> 123;
                    case 79 -> 245;
                    case 80 -> 31;
                    case 81 -> 57;
                    case 82 -> 176;
                    case 83 -> 177;
                    case 84 -> 65;
                    case 85 -> 209;
                    case 86 -> 14;
                    case 87 -> 86;
                    case 88 -> 114;
                    case 89 -> 220;
                    case 90 -> 120;
                    case 91 -> 169;
                    case 92 -> 33;
                    case 93 -> 218;
                    case 94 -> 98;
                    case 95 -> 233;
                    case 96 -> 92;
                    case 97 -> 199;
                    case 98 -> 185;
                    case 99 -> 240;
                    case 100 -> 131;
                    case 101 -> 190;
                    case 102 -> 113;
                    case 103 -> 91;
                    case 104 -> 246;
                    case 105 -> 100;
                    case 106 -> 175;
                    case 107 -> 163;
                    case 108 -> 75;
                    case 109 -> 140;
                    case 110 -> 24;
                    case 111 -> 60;
                    case 112 -> 78;
                    case 113 -> 26;
                    case 114 -> 238;
                    case 115 -> 88;
                    case 116 -> 21;
                    case 117 -> 53;
                    case 118 -> 49;
                    case 119 -> 206;
                    case 120 -> 205;
                    case 121 -> 51;
                    case 122 -> 104;
                    case 123 -> 186;
                    case 124 -> 239;
                    case 125 -> 243;
                    case 126 -> 143;
                    case 127 -> 241;
                    case 128 -> 87;
                    case 129 -> 3;
                    case 130 -> 35;
                    case 131 -> 28;
                    case 132 -> 210;
                    case 133 -> 167;
                    case 134 -> 160;
                    case 135 -> 253;
                    case 136 -> 43;
                    case 137 -> 16;
                    case 138 -> 55;
                    case 139 -> 46;
                    case 140 -> 1;
                    case 141 -> 229;
                    case 142 -> 171;
                    case 143 -> 45;
                    case 144 -> 225;
                    case 145 -> 134;
                    case 146 -> 216;
                    case 147 -> 121;
                    case 148 -> 141;
                    case 149 -> 40;
                    case 150 -> 50;
                    case 151 -> 179;
                    case 152 -> 5;
                    case 153 -> 148;
                    case 154 -> 124;
                    case 155 -> 67;
                    case 156 -> 128;
                    case 157 -> 211;
                    case 158 -> 42;
                    case 159 -> 154;
                    case 160 -> 8;
                    case 161 -> 182;
                    case 162 -> 58;
                    case 163 -> 34;
                    case 164 -> 63;
                    case 165 -> 81;
                    case 166 -> 116;
                    case 167 -> 204;
                    case 168 -> 119;
                    case 169 -> 37;
                    case 170 -> 44;
                    case 171 -> 102;
                    case 172 -> 174;
                    case 173 -> 125;
                    case 174 -> 108;
                    case 175 -> 242;
                    case 176 -> 132;
                    case 177 -> 183;
                    case 178 -> 144;
                    case 179 -> 248;
                    case 180 -> 158;
                    case 181 -> 7;
                    case 182 -> 227;
                    case 183 -> 173;
                    case 184 -> 254;
                    case 185 -> 164;
                    case 186 -> 191;
                    case 187 -> 139;
                    case 188 -> 18;
                    case 189 -> 252;
                    case 190 -> 13;
                    case 191 -> 66;
                    case 192 -> 85;
                    case 193 -> 84;
                    case 194 -> 219;
                    case 195 -> 201;
                    case 196 -> 22;
                    case 197 -> 197;
                    case 198 -> 249;
                    case 199 -> 250;
                    case 200 -> 137;
                    case 201 -> 228;
                    case 202 -> 222;
                    case 203 -> 180;
                    case 204 -> 106;
                    case 205 -> 29;
                    case 206 -> 230;
                    case 207 -> 83;
                    case 208 -> 234;
                    case 209 -> 251;
                    case 210 -> 231;
                    case 211 -> 112;
                    case 212 -> 166;
                    case 213 -> 149;
                    case 214 -> 118;
                    case 215 -> 172;
                    case 216 -> 36;
                    case 217 -> 15;
                    case 218 -> 212;
                    case 219 -> 117;
                    case 220 -> 89;
                    case 221 -> 236;
                    case 222 -> 73;
                    case 223 -> 188;
                    case 224 -> 54;
                    case 225 -> 52;
                    case 226 -> 0;
                    case 227 -> 23;
                    case 228 -> 82;
                    case 229 -> 56;
                    case 230 -> 6;
                    case 231 -> 142;
                    case 232 -> 74;
                    case 233 -> 19;
                    case 234 -> 20;
                    case 235 -> 127;
                    case 236 -> 155;
                    case 237 -> 150;
                    case 238 -> 105;
                    case 239 -> 32;
                    case 240 -> 133;
                    case 241 -> 68;
                    case 242 -> 165;
                    case 243 -> 129;
                    case 244 -> 189;
                    case 245 -> 99;
                    case 246 -> 136;
                    case 247 -> 146;
                    case 248 -> 223;
                    case 249 -> 71;
                    case 250 -> 111;
                    case 251 -> 79;
                    case 252 -> 110;
                    case 253 -> 237;
                    case 254 -> 30;
                    default -> 215;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

