/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOIndexedException;
import org.apache.commons.io.function.IOStreams;
import org.apache.commons.io.function.Uncheck;

@FunctionalInterface
public interface IOConsumer<T> {
    public static final IOConsumer<?> NOOP_IO_CONSUMER = t -> {};

    public static <T> void forAll(IOConsumer<T> action2, Iterable<T> iterable) throws IOExceptionList {
        IOStreams.forAll(IOStreams.of(iterable), action2);
    }

    public static <T> void forAll(IOConsumer<T> action2, Stream<T> stream) throws IOExceptionList {
        IOStreams.forAll(stream, action2, IOIndexedException::new);
    }

    @SafeVarargs
    public static <T> void forAll(IOConsumer<T> action2, T ... array2) throws IOExceptionList {
        IOStreams.forAll(IOStreams.of(array2), action2);
    }

    public static <T> void forEach(Iterable<T> iterable, IOConsumer<T> action2) throws IOException {
        IOStreams.forEach(IOStreams.of(iterable), action2);
    }

    public static <T> void forEach(Stream<T> stream, IOConsumer<T> action2) throws IOException {
        IOStreams.forEach(stream, action2);
    }

    public static <T> void forEach(T[] array2, IOConsumer<T> action2) throws IOException {
        IOStreams.forEach(IOStreams.of(array2), action2);
    }

    public static <T> IOConsumer<T> noop() {
        return NOOP_IO_CONSUMER;
    }

    public void accept(T var1) throws IOException;

    default public IOConsumer<T> andThen(IOConsumer<? super T> after) {
        Objects.requireNonNull(after, "after");
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    default public Consumer<T> asConsumer() {
        return t -> Uncheck.accept(this, t);
    }
}

