/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.huggingFace.cacheManager.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.python.community.impl.huggingFace.service.HuggingFaceCardsUsageCollector;
import com.intellij.python.huggingFace.HuggingFaceProBundle;
import com.intellij.python.huggingFace.cacheManager.service.HfCacheEntryData;
import com.intellij.python.huggingFace.cacheManager.service.HfCacheEnvUtils;
import com.intellij.python.huggingFace.cacheManager.ui.HfCacheToolbarFactory;
import com.intellij.ui.IdeBorderFactory;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.border.CompoundBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/python/huggingFace/cacheManager/ui/HfCacheToolbarFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "getSelectedItems", "Lkotlin/Function0;", "", "Lcom/intellij/python/huggingFace/cacheManager/service/HfCacheEntryData;", "updateData", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "createToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "createReloadAction", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lorg/jetbrains/annotations/NotNull;", "createRevealInFinderAction", "createDeleteFromCacheAction", "intellij.python.huggingFace"})
public final class HfCacheToolbarFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<List<HfCacheEntryData>> getSelectedItems;
    @NotNull
    private final Function0<Unit> updateData;

    public HfCacheToolbarFactory(@NotNull Project project, @NotNull Function0<? extends List<HfCacheEntryData>> getSelectedItems, @NotNull Function0<Unit> updateData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(getSelectedItems, (String)"getSelectedItems");
        Intrinsics.checkNotNullParameter(updateData, (String)"updateData");
        this.project = project;
        this.getSelectedItems = getSelectedItems;
        this.updateData = updateData;
    }

    @NotNull
    public final ActionToolbar createToolbar() {
        ActionToolbar toolbar;
        ActionToolbar actionToolbar;
        DumbAwareAction reloadAction = this.createReloadAction();
        DumbAwareAction revealInFinderAction = this.createRevealInFinderAction();
        DumbAwareAction clearCacheAction = this.createDeleteFromCacheAction();
        AnAction[] anActionArray = new AnAction[]{reloadAction, revealInFinderAction, clearCacheAction};
        DefaultActionGroup actionGroup = new DefaultActionGroup(anActionArray);
        ActionToolbar actionToolbar2 = ActionManager.getInstance().createActionToolbar("HfToolwindow", (ActionGroup)actionGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"createActionToolbar(...)");
        ActionToolbar $this$createToolbar_u24lambda_u240 = actionToolbar = (toolbar = actionToolbar2);
        boolean bl = false;
        $this$createToolbar_u24lambda_u240.getComponent().setBorder(new CompoundBorder(IdeBorderFactory.createBorder((int)4), $this$createToolbar_u24lambda_u240.getComponent().getBorder()));
        return actionToolbar;
    }

    private final DumbAwareAction createReloadAction() {
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)HuggingFaceProBundle.INSTANCE.message("action.title.refresh", new Object[0]), (Icon)AllIcons.General.Refresh, arg_0 -> HfCacheToolbarFactory.createReloadAction$lambda$1(arg_0 -> HfCacheToolbarFactory.createReloadAction$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        return dumbAwareAction;
    }

    private final DumbAwareAction createRevealInFinderAction() {
        String string = HuggingFaceProBundle.INSTANCE.message("action.title.reveal.in.finder", new Object[0]);
        Icon icon = AllIcons.Nodes.Folder;
        return new DumbAwareAction(this, string, icon){
            final /* synthetic */ HfCacheToolbarFactory this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                HfCacheEntryData hfCacheEntryData = (HfCacheEntryData)CollectionsKt.firstOrNull((List)((List)HfCacheToolbarFactory.access$getGetSelectedItems$p(this.this$0).invoke()));
                if (hfCacheEntryData != null) {
                    HfCacheEntryData it = hfCacheEntryData;
                    boolean bl = false;
                    RevealFileAction.openDirectory((File)new File(it.getPath()));
                }
                HuggingFaceCardsUsageCollector.INSTANCE.getHF_CACHE_REVEAL_ITEM_IN_FILE_BROWSER().log();
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(!((Collection)HfCacheToolbarFactory.access$getGetSelectedItems$p(this.this$0).invoke()).isEmpty());
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }
        };
    }

    private final DumbAwareAction createDeleteFromCacheAction() {
        String string = HuggingFaceProBundle.INSTANCE.message("action.title.remove.from.cache", new Object[0]);
        Icon icon = AllIcons.General.Delete;
        return new DumbAwareAction(this, string, icon){
            final /* synthetic */ HfCacheToolbarFactory this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                HfCacheEntryData hfCacheEntryData = (HfCacheEntryData)CollectionsKt.firstOrNull((List)((List)HfCacheToolbarFactory.access$getGetSelectedItems$p(this.this$0).invoke()));
                if (hfCacheEntryData == null) {
                    return;
                }
                HfCacheEntryData item = hfCacheEntryData;
                Object[] objectArray = new Object[]{item.getRepoType().getPrintName(), item.getRepoId()};
                boolean confirmed = MessageDialogBuilder.Companion.yesNo(HuggingFaceProBundle.INSTANCE.message("action.remove.from.cache.alert.message", objectArray), HuggingFaceProBundle.INSTANCE.message("action.remove.from.cache.alert.undo.warn", new Object[0])).ask(HfCacheToolbarFactory.access$getProject$p(this.this$0));
                HuggingFaceCardsUsageCollector.INSTANCE.getHF_CACHE_MANAGEMENT_DELETE_ITEM().log((Object)HuggingFaceCardsUsageCollector.CacheManagementActionSource.TOOLBAR, (Object)HuggingFaceCardsUsageCollector.INSTANCE.boolToDialogStatus(confirmed), (Object)HuggingFaceCardsUsageCollector.INSTANCE.closestPowerOfTwo(item.getSizeOnDisk()));
                if (confirmed) {
                    HfCacheEnvUtils.INSTANCE.doDeleteItemAndUpdateTable(item, (Function0<Unit>)((Function0)() -> createDeleteFromCacheAction.1.actionPerformed$lambda$0(this.this$0)));
                }
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(!((Collection)HfCacheToolbarFactory.access$getGetSelectedItems$p(this.this$0).invoke()).isEmpty());
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            private static final Unit actionPerformed$lambda$0(HfCacheToolbarFactory this$0) {
                HfCacheToolbarFactory.access$getUpdateData$p(this$0).invoke();
                return Unit.INSTANCE;
            }
        };
    }

    private static final Unit createReloadAction$lambda$0(HfCacheToolbarFactory this$0, AnActionEvent it) {
        this$0.updateData.invoke();
        HuggingFaceCardsUsageCollector.INSTANCE.getHF_CACHE_MANAGEMENT_TOOLWINDOW_UPDATE().log();
        return Unit.INSTANCE;
    }

    private static final void createReloadAction$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Function0 access$getGetSelectedItems$p(HfCacheToolbarFactory $this) {
        return $this.getSelectedItems;
    }

    public static final /* synthetic */ Project access$getProject$p(HfCacheToolbarFactory $this) {
        return $this.project;
    }

    public static final /* synthetic */ Function0 access$getUpdateData$p(HfCacheToolbarFactory $this) {
        return $this.updateData;
    }
}

