/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;
import org.jetbrains.idea.perforce.perforce.connections.P4ParamsCalculator;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceExternalConfigTracker;
import org.jetbrains.idea.perforce.perforce.connections.PerforceLocalConnection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceWorkspaceConfigurator;
import org.jetbrains.idea.perforce.perforce.connections.SingletonConnection;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J2\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0016J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rH\u0002J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002J2\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002J\u001d\u0010\u001a\u001a\u00020\u001b2\u000b\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J,\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\"H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u001d2\u0006\u0010'\u001a\u00020\u001dH\u0002J*\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0\"2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0002\u00a8\u0006*"}, d2={"Lorg/jetbrains/idea/perforce/perforce/P4RootChecker;", "Lcom/intellij/openapi/vcs/VcsRootChecker;", "<init>", "()V", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "isRoot", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "validateRoot", "shouldAlwaysRunInitialDetection", "detectProjectMappings", "", "project", "Lcom/intellij/openapi/project/Project;", "projectRoots", "mappedDirs", "", "doDetectMappings", "trackConfigs", "", "configs", "Lorg/jetbrains/idea/perforce/perforce/connections/PerforceWorkspaceConfigurator$P4Config;", "detectSingletonConnectionMappings", "detectContextConnectionMappings", "detectEnvConnectionParametersFor", "Lorg/jetbrains/idea/perforce/perforce/connections/P4ConnectionParameters;", "baseDir", "", "Lorg/jetbrains/annotations/SystemIndependent;", "settings", "Lorg/jetbrains/idea/perforce/perforce/PerforceSettings;", "detectMappingsForConnection", "", "connection", "Lorg/jetbrains/idea/perforce/perforce/connections/P4Connection;", "unmappedRoots", "parseP4Info", "output", "collectUnmappedDirs", "Companion", "intellij.vcs.perforce"})
@SourceDebugExtension(value={"SMAP\nP4RootChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P4RootChecker.kt\norg/jetbrains/idea/perforce/perforce/P4RootChecker\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,183:1\n30#2,2:184\n30#2,2:186\n30#2,2:188\n1563#3:190\n1634#3,3:191\n774#3:194\n865#3,2:195\n774#3:197\n865#3:198\n866#3:201\n2275#4,2:199\n*S KotlinDebug\n*F\n+ 1 P4RootChecker.kt\norg/jetbrains/idea/perforce/perforce/P4RootChecker\n*L\n40#1:184,2\n47#1:186,2\n89#1:188,2\n91#1:190\n91#1:191,3\n152#1:194\n152#1:195,2\n173#1:197\n173#1:198\n173#1:201\n175#1:199,2\n*E\n"})
public final class P4RootChecker
extends VcsRootChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = PerforceVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey(...)");
        return vcsKey;
    }

    public boolean isRoot(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return false;
    }

    public boolean validateRoot(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    public boolean shouldAlwaysRunInitialDetection() {
        return true;
    }

    @NotNull
    public Collection<VirtualFile> detectProjectMappings(@NotNull Project project, @NotNull Collection<? extends VirtualFile> projectRoots, @NotNull Set<? extends VirtualFile> mappedDirs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(projectRoots, (String)"projectRoots");
        Intrinsics.checkNotNullParameter(mappedDirs, (String)"mappedDirs");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<PerforceWorkspaceConfigurator> serviceClass$iv = PerforceWorkspaceConfigurator.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Collection<PerforceWorkspaceConfigurator.P4Config> configs = ((PerforceWorkspaceConfigurator)object).configure(projectRoots, false);
        this.trackConfigs(project, configs);
        Collection<VirtualFile> mappedRoots = this.doDetectMappings(project, projectRoots, mappedDirs);
        if (mappedRoots.isEmpty()) {
            ComponentManager $this$service$iv2 = (ComponentManager)project;
            boolean $i$f$service2 = false;
            Class<PerforceWorkspaceConfigurator> serviceClass$iv2 = PerforceWorkspaceConfigurator.class;
            Object object2 = $this$service$iv2.getService(serviceClass$iv2);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
            }
            configs = ((PerforceWorkspaceConfigurator)object2).configure(projectRoots, true);
            if (!configs.isEmpty()) {
                this.trackConfigs(project, configs);
                mappedRoots = this.doDetectMappings(project, projectRoots, mappedDirs);
            }
        }
        if (PerforceManager.getInstance(project).isActive()) {
            PerforceConnectionManager.getInstance(project).updateConnections();
        }
        return mappedRoots;
    }

    private final Collection<VirtualFile> doDetectMappings(Project project, Collection<? extends VirtualFile> projectRoots, Set<? extends VirtualFile> mappedDirs) {
        Collection<VirtualFile> collection;
        PerforceConnectionManagerI connectionManager = PerforceConnectionManager.getInstance(project);
        if (connectionManager.isSingletonConnectionUsed()) {
            LOG.debug("detecting for singleton connection");
            collection = this.detectSingletonConnectionMappings(project, projectRoots, mappedDirs);
        } else {
            LOG.debug("detecting for context connection");
            collection = this.detectContextConnectionMappings(project, projectRoots, mappedDirs);
        }
        Collection<VirtualFile> collection2 = collection;
        return collection2;
    }

    /*
     * WARNING - void declaration
     */
    private final void trackConfigs(Project project, Collection<PerforceWorkspaceConfigurator.P4Config> configs) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (configs.isEmpty()) {
            return;
        }
        Object $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<PerforceExternalConfigTracker> serviceClass$iv = PerforceExternalConfigTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        PerforceExternalConfigTracker configTracker = (PerforceExternalConfigTracker)object;
        configTracker.startTracking();
        $this$service$iv = configs;
        PerforceExternalConfigTracker perforceExternalConfigTracker = configTracker;
        boolean $i$f$map = false;
        serviceClass$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerforceWorkspaceConfigurator.P4Config p4Config = (PerforceWorkspaceConfigurator.P4Config)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getConfigFile().getPath());
        }
        perforceExternalConfigTracker.addConfigsToTrack(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    private final Collection<VirtualFile> detectSingletonConnectionMappings(Project project, Collection<? extends VirtualFile> projectRoots, Set<? extends VirtualFile> mappedDirs) {
        List<VirtualFile> unmappedRoots = this.collectUnmappedDirs(mappedDirs, projectRoots);
        if (unmappedRoots.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PerforceSettings settings = PerforceSettings.getSettings(project);
        SingletonConnection singletonConnection = SingletonConnection.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)singletonConnection, (String)"getInstance(...)");
        P4Connection connection = singletonConnection;
        Intrinsics.checkNotNull((Object)settings);
        return this.detectMappingsForConnection(connection, settings, unmappedRoots);
    }

    private final Collection<VirtualFile> detectContextConnectionMappings(Project project, Collection<? extends VirtualFile> projectRoots, Set<? extends VirtualFile> mappedDirs) {
        String string = project.getBasePath();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String baseDir = string;
        List<VirtualFile> unmappedRoots = this.collectUnmappedDirs(mappedDirs, projectRoots);
        if (unmappedRoots.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PerforceSettings settings = PerforceSettings.getSettings(project);
        Intrinsics.checkNotNull((Object)settings);
        P4ConnectionParameters parameters = this.detectEnvConnectionParametersFor(baseDir, settings);
        LOG.debug("detected connection parameters: " + parameters);
        P4ParametersConnection testConnection = new P4ParametersConnection(parameters, new ConnectionId(null, baseDir));
        return this.detectMappingsForConnection(testConnection, settings, unmappedRoots);
    }

    private final P4ConnectionParameters detectEnvConnectionParametersFor(String baseDir, PerforceSettings settings) {
        P4Connection localConnection = new PerforceLocalConnection(baseDir);
        String[] stringArray = new String[]{"set"};
        ExecResult p4SetOut = localConnection.runP4CommandLine(settings, stringArray, null);
        P4ConnectionParameters defaultParameters = new P4ConnectionParameters();
        P4ConnectionParameters parameters = new P4ConnectionParameters();
        P4ParamsCalculator.parseSetOutput(defaultParameters, parameters, p4SetOut.getStdout());
        return parameters;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> detectMappingsForConnection(P4Connection connection, PerforceSettings settings, List<? extends VirtualFile> unmappedRoots) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{"info"};
        ExecResult p4InfoOut = connection.runP4CommandLine(settings, stringArray, null);
        String string = p4InfoOut.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String root = this.parseP4Info(string);
        if (root == null) {
            String string2 = p4InfoOut.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
            String stderr = string2;
            Throwable processException = p4InfoOut.getException();
            if (p4InfoOut.getExitCode() < 0 && processException instanceof ProcessNotCreatedException) {
                return CollectionsKt.emptyList();
            }
            if (processException != null) {
                throw new VcsException(processException);
            }
            if (!StringsKt.isBlank((CharSequence)stderr)) {
                throw new VcsException(stderr);
            }
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(root);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile rootFile = virtualFile;
        LOG.debug("found root file: " + rootFile.getPath());
        Iterable $this$filter$iv = unmappedRoots;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!VfsUtil.isAncestor((VirtualFile)rootFile, (VirtualFile)it, (boolean)false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String parseP4Info(String output) {
        String result = null;
        for (String line : StringsKt.lineSequence((CharSequence)output)) {
            String path;
            if (!StringsKt.startsWith$default((String)line, (String)"Client root:", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)"Client root:"))).toString()), (String)"toSystemIndependentName(...)");
            if (result != null) {
                LOG.warn("unexpected: two roots in output: '" + result + "' and '" + path + "'");
                return null;
            }
            result = path;
        }
        LOG.debug("parseP4Info - root path: " + result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectUnmappedDirs(Set<? extends VirtualFile> mappedDirs, Collection<? extends VirtualFile> projectRoots) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = projectRoots;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block2: {
                void $this$none$iv;
                VirtualFile root = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                Sequence sequence = SequencesKt.generateSequence((Object)root, P4RootChecker::collectUnmappedDirs$lambda$0$0);
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    VirtualFile parent = (VirtualFile)element$iv;
                    boolean bl3 = false;
                    if (!mappedDirs.contains(parent)) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final VirtualFile collectUnmappedDirs$lambda$0$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    static {
        Logger logger = Logger.getInstance(P4RootChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/perforce/perforce/P4RootChecker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.perforce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

