/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableNoisyStatement;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.dialects.db2.plan.Db2BuilderState;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.util.Functions;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2RawPlanData
extends RawPlanData {
    public final Map<Db2BuilderState.NodeId, Db2BuilderState.Stream> streamBySourceId = new HashMap<Db2BuilderState.NodeId, Db2BuilderState.Stream>();
    public final Map<Db2BuilderState.NodeId, List<Db2BuilderState.Stream>> streamsByTargetId = new HashMap<Db2BuilderState.NodeId, List<Db2BuilderState.Stream>>();
    public final Int2ObjectMap<Db2BuilderState.Operator> operatorById = new Int2ObjectOpenHashMap();
    public final Map<Db2BuilderState.ObjectId, Db2BuilderState.Obj> objectById = new HashMap<Db2BuilderState.ObjectId, Db2BuilderState.Obj>();

    public void load(final @NotNull DatabaseConnectionCore connection, final @NotNull String statement, boolean run) {
        if (connection == null) {
            Db2RawPlanData.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            Db2RawPlanData.$$$reportNull$$$0(1);
        }
        Db2RawPlanData.useStatementWithPreserved((DatabaseConnectionCore)connection, (RawPlanData.ResourceUser)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            public void use(ReusableSmartStatement<String> s) throws PlanRetrievalException, SQLException {
                String uuid = AbstractPlanModelBuilder.randomShorterUUID().substring(0, 20);
                s.barren().execute((Object)("EXPLAIN PLAN SET QUERYTAG = '" + uuid + "' FOR " + statement));
                String schema = (String)s.noisy().execute((Object)"select case when 4 = (select count(TABNAME) from SYSCAT.TABLES where TABSCHEMA = current_user and  TABNAME in ('EXPLAIN_STATEMENT', 'EXPLAIN_STREAM', 'EXPLAIN_OPERATOR', 'EXPLAIN_OBJECT')) then current_user else 'SYSTOOLS' end from sysibm.SYSDUMMY1", StandardResultsProcessors.FIRST_STRING);
                NamingService ns = NamingServices.getNamingService((Dbms)connection.getDbms());
                this.extractPlan((ReusableNoisyStatement<String>)s.noisy(), ns.catToScript(schema, ObjectKind.SCHEMA), uuid);
            }

            private void extractPlan(ReusableNoisyStatement<String> noisy, String schema, String uuid) throws SQLException {
                noisy.execute((Object)("SELECT STREAM_ID, SOURCE_TYPE, SOURCE_ID, TARGET_TYPE, TARGET_ID, OBJECT_SCHEMA, OBJECT_NAME, STREAM_COUNT, PREDICATE_ID\nFROM " + schema + ".EXPLAIN_STATEMENT es\n  JOIN " + schema + ".EXPLAIN_STREAM ess\n    ON es.STMTNO = ess.STMTNO\n       AND es.SECTNO = ess.SECTNO\n       AND es.EXPLAIN_TIME = ess.EXPLAIN_TIME\n       AND es.EXPLAIN_LEVEL = ess.EXPLAIN_LEVEL\n  WHERE QUERYTAG = '" + uuid + "'"), Db2RawPlanData.processing((ThrowableConsumer)rs -> Db2RawPlanData.this.extractStreams((RemoteResultSet)rs)));
                noisy.execute((Object)("SELECT OPERATOR_ID, OPERATOR_TYPE, eos.TOTAL_COST, IO_COST, CPU_COST, FIRST_ROW_COST\nFROM " + schema + ".EXPLAIN_STATEMENT es\n  JOIN " + schema + ".EXPLAIN_OPERATOR eos\n    ON es.STMTNO = eos.STMTNO\n       AND es.SECTNO = eos.SECTNO\n       AND es.EXPLAIN_TIME = eos.EXPLAIN_TIME\n       AND es.EXPLAIN_LEVEL = eos.EXPLAIN_LEVEL\n  WHERE QUERYTAG = '" + uuid + "'"), Db2RawPlanData.processing((ThrowableConsumer)rs -> Db2RawPlanData.this.extractOperators((RemoteResultSet)rs)));
                noisy.execute((Object)("SELECT OBJECT_SCHEMA, OBJECT_NAME, OBJECT_TYPE\nFROM " + schema + ".EXPLAIN_STATEMENT es\n  JOIN " + schema + ".EXPLAIN_OBJECT eo\n    ON es.STMTNO = eo.STMTNO\n       AND es.SECTNO = eo.SECTNO\n       AND es.EXPLAIN_TIME = eo.EXPLAIN_TIME\n       AND es.EXPLAIN_LEVEL = eo.EXPLAIN_LEVEL\n       AND es.SOURCE_NAME = eo.SOURCE_NAME\n  WHERE QUERYTAG = '" + uuid + "'"), Db2RawPlanData.processing((ThrowableConsumer)rs -> Db2RawPlanData.this.extractObjects((RemoteResultSet)rs)));
            }
        }, (RawPlanData.StateSaver[])new RawPlanData.StateSaver[0]);
    }

    private void extractStreams(@Nullable RemoteResultSet resultSet) throws Exception {
        if (resultSet == null) {
            Db2RawPlanData.unsupportedFormat();
        }
        while (resultSet.next()) {
            Db2BuilderState.NodeId tid;
            Db2BuilderState.NodeId sid;
            int id = resultSet.getInt("STREAM_ID");
            String sourceType = resultSet.getString("SOURCE_TYPE");
            int sourceId = resultSet.getInt("SOURCE_ID");
            String targetType = resultSet.getString("TARGET_TYPE");
            int targetId = resultSet.getInt("TARGET_ID");
            String objectSchema = resultSet.getString("OBJECT_SCHEMA");
            String objectName = resultSet.getString("OBJECT_NAME");
            BigDecimal streamCount = resultSet.getBigDecimal("STREAM_COUNT");
            int predicateId = resultSet.getInt("PREDICATE_ID");
            if (sourceType.equals("O")) {
                if (sourceId == -1) {
                    Db2RawPlanData.unsupportedFormat();
                }
                sid = new Db2BuilderState.NodeId(sourceId);
            } else {
                sid = new Db2BuilderState.NodeId(new Db2BuilderState.ObjectId(objectSchema, objectName));
            }
            if (targetType.equals("O")) {
                if (targetId == -1) {
                    Db2RawPlanData.unsupportedFormat();
                }
                tid = new Db2BuilderState.NodeId(targetId);
            } else {
                if (sourceId == -1) {
                    Db2RawPlanData.unsupportedFormat();
                }
                tid = new Db2BuilderState.NodeId(new Db2BuilderState.ObjectId(objectSchema, objectName));
            }
            Db2BuilderState.Stream stream = new Db2BuilderState.Stream(id, streamCount, predicateId, sid, tid);
            List<Db2BuilderState.Stream> streams = this.streamsByTargetId.get(tid);
            if (streams == null) {
                streams = new ArrayList<Db2BuilderState.Stream>(2);
                this.streamsByTargetId.put(tid, streams);
            }
            streams.add(stream);
            this.streamBySourceId.put(sid, stream);
        }
    }

    private void extractOperators(@Nullable RemoteResultSet resultSet) throws Exception {
        if (resultSet == null) {
            Db2RawPlanData.unsupportedFormat();
        }
        while (resultSet.next()) {
            int id = resultSet.getInt("OPERATOR_ID");
            String operatorType = resultSet.getString("OPERATOR_TYPE").trim();
            double totalCost = resultSet.getDouble("TOTAL_COST");
            double ioCost = resultSet.getDouble("IO_COST");
            double cpuCost = resultSet.getDouble("CPU_COST");
            double firstRowCost = resultSet.getDouble("FIRST_ROW_COST");
            Db2BuilderState.Operator operator = new Db2BuilderState.Operator(id, operatorType, totalCost, ioCost, cpuCost, firstRowCost);
            this.operatorById.put(id, (Object)operator);
        }
    }

    private void extractObjects(@Nullable RemoteResultSet resultSet) throws Exception {
        if (resultSet == null) {
            Db2RawPlanData.unsupportedFormat();
        }
        while (resultSet.next()) {
            String objectSchema = resultSet.getString("OBJECT_SCHEMA");
            String objectName = resultSet.getString("OBJECT_NAME");
            String objectType = resultSet.getString("OBJECT_TYPE");
            Db2BuilderState.Obj obj = new Db2BuilderState.Obj(new Db2BuilderState.ObjectId(objectSchema, objectName), objectType);
            this.objectById.put(obj.id, obj);
        }
    }

    private static void unsupportedFormat() {
        throw new PlanRetrievalException("Database returned plan in unsupported format");
    }

    public void load(@NotNull String dump) {
        if (dump == null) {
            Db2RawPlanData.$$$reportNull$$$0(2);
        }
        try {
            JSONObject json = new JSONObject(dump);
            this.loadObjects(json.getJSONArray("objects"));
            this.loadOperators(json.getJSONArray("operators"));
            this.loadStreams(json.getJSONArray("streams"));
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Load failed", (Throwable)e);
        }
    }

    private void loadStreams(JSONArray streams) throws JSONException {
        this.streamBySourceId.clear();
        this.streamsByTargetId.clear();
        int e = streams.length();
        for (int i = 0; i < e; ++i) {
            Db2BuilderState.Stream s = Db2RawPlanData.loadStream(streams.getJSONObject(i));
            this.streamBySourceId.put(s.sourceId, s);
            this.streamsByTargetId.computeIfAbsent(s.targetId, k -> new ArrayList()).add(s);
        }
    }

    private static Db2BuilderState.Stream loadStream(JSONObject object) throws JSONException {
        return new Db2BuilderState.Stream(object.getInt("id"), new BigDecimal(object.getString("numRows")), object.getInt("predId"), Db2RawPlanData.loadNodeId(object.getJSONObject("sourceId")), Db2RawPlanData.loadNodeId(object.getJSONObject("targetId")));
    }

    private static Db2BuilderState.NodeId loadNodeId(JSONObject object) throws JSONException {
        JSONObject objectId = object.optJSONObject("objectId");
        if (objectId != null) {
            return new Db2BuilderState.NodeId(Db2RawPlanData.loadObjectId(objectId));
        }
        return new Db2BuilderState.NodeId(object.getInt("operatorId"));
    }

    private void loadOperators(JSONArray operators) throws JSONException {
        this.operatorById.clear();
        int e = operators.length();
        for (int i = 0; i < e; ++i) {
            Db2BuilderState.Operator op = Db2RawPlanData.loadOperator(operators.getJSONObject(i));
            this.operatorById.put(op.id, (Object)op);
        }
    }

    private static Db2BuilderState.Operator loadOperator(JSONObject object) throws JSONException {
        return new Db2BuilderState.Operator(object.getInt("id"), object.getString("type"), object.getDouble("totalCost"), object.getDouble("ioCost"), object.getDouble("cpuCost"), object.getDouble("firstRowCost"));
    }

    private void loadObjects(JSONArray objects) throws JSONException {
        this.objectById.clear();
        int e = objects.length();
        for (int i = 0; i < e; ++i) {
            Db2BuilderState.Obj obj = Db2RawPlanData.loadObject(objects.getJSONObject(i));
            this.objectById.put(obj.id, obj);
        }
    }

    private static Db2BuilderState.Obj loadObject(JSONObject object) throws JSONException {
        return new Db2BuilderState.Obj(Db2RawPlanData.loadObjectId(object.getJSONObject("id")), object.getString("type"));
    }

    @NotNull
    private static Db2BuilderState.ObjectId loadObjectId(JSONObject object) throws JSONException {
        return new Db2BuilderState.ObjectId(object.getString("schema"), object.getString("name"));
    }

    public String dump() {
        try {
            JSONObject res = new JSONObject();
            res.put("objects", (Object)this.dumpObjects());
            res.put("operators", (Object)this.dumpOperators());
            res.put("streams", (Object)this.dumpStreams());
            return res.toString(2);
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Dump failed", (Throwable)e);
        }
    }

    @NotNull
    private JSONArray dumpStreams() throws JSONException {
        JSONArray streams = new JSONArray();
        for (Db2BuilderState.Stream s : JBIterable.from(this.streamsByTargetId.values()).flatten(Functions.identity()).append(this.streamBySourceId.values()).unique()) {
            streams.put((Object)Db2RawPlanData.dumpStream(s));
        }
        JSONArray jSONArray = streams;
        if (jSONArray == null) {
            Db2RawPlanData.$$$reportNull$$$0(3);
        }
        return jSONArray;
    }

    @NotNull
    private static JSONObject dumpStream(Db2BuilderState.Stream s) throws JSONException {
        JSONObject str = new JSONObject();
        str.put("id", s.id);
        str.put("numRows", (Object)s.numRows);
        str.put("predId", s.predId);
        str.put("sourceId", (Object)Db2RawPlanData.dumpNodeId(s.sourceId));
        str.put("targetId", (Object)Db2RawPlanData.dumpNodeId(s.targetId));
        JSONObject jSONObject = str;
        if (jSONObject == null) {
            Db2RawPlanData.$$$reportNull$$$0(4);
        }
        return jSONObject;
    }

    @NotNull
    private JSONArray dumpOperators() throws JSONException {
        JSONArray operators = new JSONArray();
        ObjectIterator it = this.operatorById.values().iterator();
        while (it.hasNext()) {
            operators.put((Object)Db2RawPlanData.dumpOperator((Db2BuilderState.Operator)it.next()));
        }
        JSONArray jSONArray = operators;
        if (jSONArray == null) {
            Db2RawPlanData.$$$reportNull$$$0(5);
        }
        return jSONArray;
    }

    @NotNull
    private static JSONObject dumpOperator(Db2BuilderState.Operator op) throws JSONException {
        JSONObject oper = new JSONObject();
        oper.put("id", op.id);
        oper.put("type", (Object)op.type);
        oper.put("totalCost", op.totalCost);
        oper.put("ioCost", op.ioCost);
        oper.put("cpuCost", op.cpuCost);
        oper.put("firstRowCost", op.firstRowCost);
        JSONObject jSONObject = oper;
        if (jSONObject == null) {
            Db2RawPlanData.$$$reportNull$$$0(6);
        }
        return jSONObject;
    }

    private JSONArray dumpObjects() throws JSONException {
        JSONArray objects = new JSONArray();
        for (Db2BuilderState.Obj obj : this.objectById.values()) {
            objects.put((Object)Db2RawPlanData.dumpObject(obj));
        }
        return objects;
    }

    @NotNull
    private static JSONObject dumpObject(Db2BuilderState.Obj obj) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("id", (Object)Db2RawPlanData.dumpObjectId(obj.id));
        object.put("type", (Object)obj.type);
        JSONObject jSONObject = object;
        if (jSONObject == null) {
            Db2RawPlanData.$$$reportNull$$$0(7);
        }
        return jSONObject;
    }

    @NotNull
    private static JSONObject dumpObjectId(Db2BuilderState.ObjectId id) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("schema", (Object)id.schema);
        object.put("name", (Object)id.name);
        JSONObject jSONObject = object;
        if (jSONObject == null) {
            Db2RawPlanData.$$$reportNull$$$0(8);
        }
        return jSONObject;
    }

    @NotNull
    private static JSONObject dumpNodeId(Db2BuilderState.NodeId id) throws JSONException {
        JSONObject object = new JSONObject();
        if (id.operatorId == null) {
            object.put("objectId", (Object)Db2RawPlanData.dumpObjectId(id.objectId));
        } else {
            object.put("operatorId", (Object)id.operatorId);
        }
        JSONObject jSONObject = object;
        if (jSONObject == null) {
            Db2RawPlanData.$$$reportNull$$$0(9);
        }
        return jSONObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/db2/plan/Db2RawPlanData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/db2/plan/Db2RawPlanData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpStreams";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpStream";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpOperators";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpOperator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpObject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpObjectId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpNodeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

