/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.path;

import com.github.weisj.jsvg.geometry.path.BuildHistory;
import com.github.weisj.jsvg.geometry.path.PathCommand;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;

final class MoveTo
extends PathCommand {
    private final float x;
    private final float y;

    public MoveTo(boolean isRelative, float x2, float y2) {
        super(isRelative, 2);
        this.x = x2;
        this.y = y2;
    }

    @Override
    public void appendPath(@NotNull Path2D path2, @NotNull BuildHistory hist) {
        Point2D.Float offset = this.offset(hist);
        path2.moveTo(this.x + offset.x, this.y + offset.y);
        hist.setStartPoint(path2.getCurrentPoint());
        hist.setLastPoint(path2.getCurrentPoint());
        hist.setLastKnot(path2.getCurrentPoint());
    }

    public String toString() {
        return "M " + this.x + " " + this.y;
    }
}

