/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.planargraph.NodeMap;

public abstract class PlanarGraph {
    protected Set edges = new HashSet();
    protected Set dirEdges = new HashSet();
    protected NodeMap nodeMap = new NodeMap();

    public Node findNode(Coordinate pt) {
        return this.nodeMap.find(pt);
    }

    protected void add(Node node) {
        this.nodeMap.add(node);
    }

    protected void add(Edge edge) {
        this.edges.add(edge);
        this.add(edge.getDirEdge(0));
        this.add(edge.getDirEdge(1));
    }

    protected void add(DirectedEdge dirEdge) {
        this.dirEdges.add(dirEdge);
    }

    public Iterator nodeIterator() {
        return this.nodeMap.iterator();
    }

    public boolean contains(Edge e) {
        return this.edges.contains(e);
    }

    public boolean contains(DirectedEdge de) {
        return this.dirEdges.contains(de);
    }

    public Collection getNodes() {
        return this.nodeMap.values();
    }

    public Iterator dirEdgeIterator() {
        return this.dirEdges.iterator();
    }

    public Iterator edgeIterator() {
        return this.edges.iterator();
    }

    public Collection getEdges() {
        return this.edges;
    }

    public void remove(Edge edge) {
        this.remove(edge.getDirEdge(0));
        this.remove(edge.getDirEdge(1));
        this.edges.remove(edge);
        edge.remove();
    }

    public void remove(DirectedEdge de) {
        DirectedEdge sym = de.getSym();
        if (sym != null) {
            sym.setSym(null);
        }
        de.getFromNode().remove(de);
        de.remove();
        this.dirEdges.remove(de);
    }

    public void remove(Node node) {
        List<DirectedEdge> outEdges = node.getOutEdges().getEdges();
        for (DirectedEdge de : outEdges) {
            DirectedEdge sym = de.getSym();
            if (sym != null) {
                this.remove(sym);
            }
            this.dirEdges.remove(de);
            Edge edge = de.getEdge();
            if (edge == null) continue;
            this.edges.remove(edge);
        }
        this.nodeMap.remove(node.getCoordinate());
        node.remove();
    }

    public List findNodesOfDegree(int degree) {
        ArrayList<Node> nodesFound = new ArrayList<Node>();
        Iterator i2 = this.nodeIterator();
        while (i2.hasNext()) {
            Node node = (Node)i2.next();
            if (node.getDegree() != degree) continue;
            nodesFound.add(node);
        }
        return nodesFound;
    }
}

