/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.AbstractWslDistribution;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.sync.WslSync;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.python.remoteInterpreter.PyRemoteSkeletonGeneratorWithRemoteSources;
import com.intellij.python.wsl.PyWSLProcessHandler;
import com.intellij.python.wsl.PyWSLUtilsKt;
import com.intellij.python.wsl.PythonWslBundle;
import com.jetbrains.python.Result;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.sdk.skeletons.LineWiseProcessOutputListener;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJO\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014\u00a2\u0006\u0002\u0010\u001aJL\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0014J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/intellij/python/wsl/PyWslSkeletonGenerator;", "Lcom/intellij/python/remoteInterpreter/PyRemoteSkeletonGeneratorWithRemoteSources;", "project", "Lcom/intellij/openapi/project/Project;", "skeletonPath", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/projectRoots/Sdk;)V", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "getData", "()Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "getProcessOutput", "Lcom/intellij/execution/process/ProcessOutput;", "homePath", "commandLine", "", "stdin", "extraEnv", "", "timeout", "", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;I)Lcom/intellij/execution/process/ProcessOutput;", "runProcessWithLineOutputListener", "cmd", "", "env", "listener", "Lcom/jetbrains/python/sdk/skeletons/LineWiseProcessOutputListener;", "downloadSourcesToLocalFolder", "", "localFolder", "remoteFiles", "", "Lcom/jetbrains/python/remote/PyRemoteSourceItem;", "intellij.python.wsl"})
@SourceDebugExtension(value={"SMAP\nPyWSLSkeletonGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyWSLSkeletonGenerator.kt\ncom/intellij/python/wsl/PyWslSkeletonGenerator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,90:1\n11561#2:91\n11896#2,3:92\n1563#3:95\n1634#3,3:96\n1193#3,2:99\n1267#3,4:101\n216#4,2:105\n*S KotlinDebug\n*F\n+ 1 PyWSLSkeletonGenerator.kt\ncom/intellij/python/wsl/PyWslSkeletonGenerator\n*L\n41#1:91\n41#1:92,3\n58#1:95\n58#1:96,3\n71#1:99,2\n71#1:101,4\n71#1:105,2\n*E\n"})
public final class PyWslSkeletonGenerator
extends PyRemoteSkeletonGeneratorWithRemoteSources {
    @NotNull
    private final String skeletonPath;
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final WSLDistribution distribution;

    /*
     * WARNING - void declaration
     */
    public PyWslSkeletonGenerator(@Nullable Project project, @NotNull String skeletonPath, @NotNull Sdk sdk2) {
        void it;
        Intrinsics.checkNotNullParameter((Object)skeletonPath, (String)"skeletonPath");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        super(skeletonPath, sdk2, null, project);
        this.skeletonPath = skeletonPath;
        this.sdk = sdk2;
        Result<WSLDistribution, String> result = PyWSLUtilsKt.getDistribution(this.sdk);
        PyWslSkeletonGenerator pyWslSkeletonGenerator = this;
        boolean bl = false;
        void var6_7 = it;
        if (var6_7 == null) {
            throw new ExecutionException(PythonWslBundle.message("wsl.no_sdk_distrib", new Object[0]));
        }
        if (!(var6_7 instanceof Result.Success)) {
            if (var6_7 instanceof Result.Failure) {
                throw new ExecutionException((String)((Result.Failure)it).getError());
            }
            throw new NoWhenBranchMatchedException();
        }
        pyWslSkeletonGenerator.distribution = (WSLDistribution)((Result.Success)it).getResult();
    }

    private final PyRemoteSdkAdditionalDataBase getData() {
        SdkAdditionalData sdkAdditionalData = this.sdk.getSdkAdditionalData();
        Intrinsics.checkNotNull((Object)sdkAdditionalData, (String)"null cannot be cast to non-null type com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase");
        return (PyRemoteSdkAdditionalDataBase)sdkAdditionalData;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected ProcessOutput getProcessOutput(@Nullable String homePath, @NotNull String[] commandLine, @Nullable String stdin, @Nullable Map<String, String> extraEnv, int timeout) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        this.createPathMappings(this.myProject, (PyRemoteSdkAdditionalDataBase)this.getRemoteSdkAdditionalData());
        String[] stringArray = commandLine;
        Project project = null;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_15 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PyWSLUtilsKt.toRemotePath(this.distribution, (String)it));
        }
        List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        BaseProcessHandler baseProcessHandler = (BaseProcessHandler)PyWSLUtilsKt.startWslProcess$default(project, new GeneralCommandLine(list), this.getData(), false, PyWSLUtilsKt.toRemotePath(this.distribution, this.skeletonPath), false, 32, null);
        ProcessOutput processOutput = new CapturingProcessRunner(baseProcessHandler).runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected ProcessOutput runProcessWithLineOutputListener(@NotNull String homePath, @NotNull List<String> cmd, @NotNull Map<String, String> env, @Nullable String stdin, int timeout, @NotNull LineWiseProcessOutputListener listener) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        Intrinsics.checkNotNullParameter(cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.createPathMappings(this.myProject, (PyRemoteSdkAdditionalDataBase)this.getRemoteSdkAdditionalData());
        Iterable iterable = cmd;
        Project project = null;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PyWSLUtilsKt.toRemotePath(this.distribution, (String)it));
        }
        List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        PyWSLProcessHandler handler = PyWSLUtilsKt.startWslProcess$default(project, new GeneralCommandLine(list), this.getData(), false, PyWSLUtilsKt.toRemotePath(this.distribution, this.skeletonPath), false, 32, null);
        handler.addProcessListener((ProcessListener)new LineWiseProcessOutputListener.Adapter(listener));
        if (stdin != null) {
            PyRemoteSkeletonGeneratorWithRemoteSources.sendLineToProcessInput((BaseProcessHandler)((BaseProcessHandler)handler), (String)stdin);
        }
        ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)handler).runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    /*
     * WARNING - void declaration
     */
    protected void downloadSourcesToLocalFolder(@NotNull String localFolder, @NotNull Collection<PyRemoteSourceItem> remoteFiles) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)localFolder, (String)"localFolder");
        Intrinsics.checkNotNullParameter(remoteFiles, (String)"remoteFiles");
        Iterable $this$associate$iv = remoteFiles;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            PyRemoteSourceItem it = (PyRemoteSourceItem)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getLocalPrefix(), (Object)it.getRootPath());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String prefix = (String)entry.getKey();
            String remotePath = (String)entry.getValue();
            File localPathFile = new File(localFolder, prefix);
            localPathFile.mkdirs();
            Intrinsics.checkNotNull((Object)remotePath);
            Path path = localPathFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            WslSync.Companion.syncWslFolders$default((WslSync.Companion)WslSync.Companion, (String)remotePath, (Path)path, (AbstractWslDistribution)((AbstractWslDistribution)this.distribution), (boolean)true, null, (boolean)false, (boolean)false, (int)112, null);
        }
    }
}

