/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.intellij.jinja.psi.Jinja2StringLiteral;
import com.intellij.jinja.template.psi.impl.Jinja2MemberExpressionImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.DjangoFunctionParams;
import com.jetbrains.django.util.DjangoCoreUtil;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import java.util.ArrayList;
import java.util.List;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpRecursiveElementVisitor;
import org.jetbrains.annotations.NotNull;

public class ViewParameters {
    private final PsiFile myFile;
    private String myMethodName;
    private PyFile myViewsFile;
    private String myViewsPath;
    private String myFullPath;
    private List<String> myParameters = null;
    private String myUrl;

    ViewParameters(PsiFile file) {
        this.myFile = file;
    }

    public static ViewParameters fromElement(PsiElement element) {
        ViewParameters result = new ViewParameters(DjangoPsiUtil.getFile(element));
        PyStringLiteralExpression urlElement = ViewParameters.findUrlElement(element);
        if (urlElement != null) {
            result.setUrl(urlElement.getStringValue());
        }
        result.setPath(element);
        if (ViewParameters.isReferenceFromCall(element) || ViewParameters.isReferenceFromUrlTag(element)) {
            String name = element.getText();
            if (!name.contains(".")) {
                result.setMethodName(name);
                PsiDirectory folder = DjangoPsiUtil.getFile(element).getParent();
                result.setViewsFile(folder != null ? folder.findFile("views.py") : null);
            } else {
                result.setViewFromPath(name, element);
            }
        }
        return result;
    }

    private static PyStringLiteralExpression findUrlElement(PsiElement element) {
        if (element.getParent() instanceof PyTupleExpression) {
            PyExpression[] elements = ((PyTupleExpression)element.getParent()).getElements();
            if (elements.length > 1 && element == elements[1] && elements[0] instanceof PyStringLiteralExpression) {
                return (PyStringLiteralExpression)elements[0];
            }
        } else {
            PyExpression[] arguments;
            PyArgumentList argumentList = (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element, PyArgumentList.class);
            if (argumentList != null && (arguments = argumentList.getArguments()).length > 1 && ViewParameters.isViewArgument(element, argumentList.getCallExpression()) && arguments[0] instanceof PyStringLiteralExpression) {
                return (PyStringLiteralExpression)arguments[0];
            }
        }
        return null;
    }

    private static boolean isViewArgument(PsiElement psiElement, PyCallExpression call) {
        if (call == null) {
            return false;
        }
        PyArgumentList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        return psiElement.equals((Object)argumentList.getValueExpressionForParam((FunctionParameter)DjangoFunctionParams.URL_VIEW));
    }

    private static boolean isReferenceFromCall(PsiElement element) {
        return element instanceof PyReferenceExpression && element.getParent() instanceof PyArgumentList;
    }

    private static boolean isReferenceFromUrlTag(PsiElement element) {
        return element instanceof Jinja2MemberExpressionImpl || element instanceof Jinja2StringLiteral;
    }

    private void setPath(PsiElement element) {
        PsiElement el;
        PsiReference ref;
        PyExpression qualifier;
        if (element instanceof PyReferenceExpressionImpl && (qualifier = ((PyReferenceExpressionImpl)element).getQualifier()) != null && (ref = qualifier.getReference()) != null && (el = ref.resolve()) != null) {
            this.setViewsFile(el.getContainingFile());
            this.setMethodName(((PyReferenceExpressionImpl)element).getName());
            return;
        }
        String path2 = PyPsiUtils.getStringValue((PsiElement)element);
        if (path2 == null) {
            return;
        }
        this.setViewFromPath(path2, element);
    }

    private void setViewFromPath(@NotNull String viewMethodPath, PsiElement element) {
        if (viewMethodPath == null) {
            ViewParameters.$$$reportNull$$$0(0);
        }
        this.setFullPath(viewMethodPath);
        int pos = viewMethodPath.lastIndexOf(".");
        if (pos == -1) {
            return;
        }
        String path2 = viewMethodPath.substring(0, pos);
        String name = viewMethodPath.substring(pos + 1);
        PsiFile viewFile = DjangoCoreUtil.searchFile(path2, element);
        if (viewFile != null) {
            this.setMethodName(name);
            this.setViewsPath(path2);
            this.setViewsFile(viewFile);
        }
    }

    private void setViewsFile(PsiFile file) {
        if (file instanceof PyFile) {
            this.myViewsFile = (PyFile)file;
        }
    }

    private void setUrl(String url) {
        this.myUrl = url;
    }

    private void parseParameters() {
        this.myParameters = new ArrayList<String>();
        RegExpFile file = (RegExpFile)PsiFileFactory.getInstance((Project)this.myFile.getProject()).createFileFromText("a.regexp", (FileType)RegExpFileType.INSTANCE, (CharSequence)this.myUrl);
        file.acceptChildren((PsiElementVisitor)new RegExpRecursiveElementVisitor(){

            public void visitRegExpGroup(RegExpGroup group) {
                super.visitRegExpGroup(group);
                if (group.getType() == RegExpGroup.Type.PYTHON_NAMED_GROUP) {
                    ViewParameters.this.myParameters.add(group.getGroupName());
                } else {
                    ViewParameters.this.myParameters.add("p" + (ViewParameters.this.myParameters.size() + 1));
                }
            }
        });
    }

    public void setMethodName(String methodName) {
        this.myMethodName = methodName;
    }

    public void setViewsPath(String viewsPath) {
        this.myViewsPath = viewsPath;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    public PyFile getViewsFile() {
        return this.myViewsFile;
    }

    public String getViewsPath() {
        return this.myViewsPath;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public String getFullPath() {
        return this.myFullPath;
    }

    public void setFullPath(String fullPath) {
        this.myFullPath = fullPath;
    }

    public List<String> getParameters() {
        if (this.myParameters == null) {
            this.parseParameters();
        }
        return this.myParameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewMethodPath", "com/jetbrains/django/ref/ViewParameters", "setViewFromPath"));
    }
}

