/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryUtil;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.URLUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\nJ \u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/NpmsIoService;", "", "<init>", "()V", "createSearchQuery", "Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryService$SearchQuery;", "text", "", "preferSuggestions", "", "createSearchQuery$intellij_javascript_backend", "parseScopeAndName", "Lcom/intellij/openapi/util/Pair;", "SearchResultsReader", "intellij.javascript.backend"})
public final class NpmsIoService {
    @NotNull
    public static final NpmsIoService INSTANCE = new NpmsIoService();

    private NpmsIoService() {
    }

    @JvmStatic
    @Nullable
    public static final NpmRegistryService.SearchQuery createSearchQuery$intellij_javascript_backend(@NotNull String text, boolean preferSuggestions) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Pair<String, String> scopeAndName = INSTANCE.parseScopeAndName(text);
        if (scopeAndName == null) {
            return null;
        }
        String pkgScope = (String)scopeAndName.first;
        String pkgName = (String)scopeAndName.second;
        boolean suggestions = preferSuggestions && pkgScope == null;
        return new NpmRegistryService.SearchQuery(text, suggestions, pkgScope, pkgName){
            final /* synthetic */ String $text;
            final /* synthetic */ boolean $suggestions;
            final /* synthetic */ String $pkgScope;
            final /* synthetic */ String $pkgName;
            {
                this.$text = $text;
                this.$suggestions = $suggestions;
                this.$pkgScope = $pkgScope;
                this.$pkgName = $pkgName;
                super($text);
            }

            public String getQueryUrl(int from, int limit) {
                if (this.$suggestions) {
                    return "https://api.npms.io/v2/search/suggestions?q=" + URLUtil.encodeURIComponent((String)this.$text) + "&size=" + (from + limit);
                }
                String query = this.$pkgScope != null ? ((Object)StringsKt.trimEnd((CharSequence)("scope:" + this.$pkgScope + " " + this.$pkgName))).toString() : this.$pkgName;
                return "https://api.npms.io/v2/search?q=" + URLUtil.encodeURIComponent((String)query) + "&from=" + from + "&size=" + limit;
            }

            public int getMaxQueryBatchSize() {
                return 100;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<NodePackageBasicInfo> parseContent(String content) throws IOException {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                Closeable closeable = (Closeable)new JsonReader((Reader)new StringReader(content));
                boolean bl = this.$suggestions;
                Throwable throwable = null;
                try {
                    JsonReader reader = (JsonReader)closeable;
                    boolean bl2 = false;
                    List<NodePackageBasicInfo> list = new SearchResultsReader(reader, bl).read();
                    return list;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }

            public String toString() {
                return "'" + this.$text + "*' (powered by npms.io)";
            }
        };
    }

    private final Pair<String, String> parseScopeAndName(String text) {
        int slashInd;
        if (StringsKt.startsWith$default((String)text, (String)"@", (boolean)false, (int)2, null) && (slashInd = StringsKt.indexOf$default((CharSequence)text, (char)'/', (int)1, (boolean)false, (int)4, null)) != -1) {
            String string = text.substring(1, slashInd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String scope2 = string;
            String string2 = text.substring(Math.min(slashInd + 1, text.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String name = string2;
            if (((CharSequence)name).length() == 0 || name.length() >= 4) {
                return Pair.create((Object)scope2, (Object)name);
            }
            return null;
        }
        return Pair.create(null, (Object)text);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/NpmsIoService$SearchResultsReader;", "", "myReader", "Lcom/google/gson/stream/JsonReader;", "mySuggestions", "", "<init>", "(Lcom/google/gson/stream/JsonReader;Z)V", "myResults", "", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "read", "", "readSearchResults", "", "readPackageProp", "intellij.javascript.backend"})
    private static final class SearchResultsReader {
        @NotNull
        private final JsonReader myReader;
        private final boolean mySuggestions;
        @NotNull
        private final List<NodePackageBasicInfo> myResults;

        public SearchResultsReader(@NotNull JsonReader myReader, boolean mySuggestions) {
            Intrinsics.checkNotNullParameter((Object)myReader, (String)"myReader");
            this.myReader = myReader;
            this.mySuggestions = mySuggestions;
            this.myResults = new ArrayList();
        }

        @NotNull
        public final List<NodePackageBasicInfo> read() throws IOException {
            if (!this.mySuggestions) {
                if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                    this.myReader.skipValue();
                    return CollectionsKt.emptyList();
                }
                this.myReader.beginObject();
                while (this.myReader.hasNext()) {
                    String name = this.myReader.nextName();
                    if (Intrinsics.areEqual((Object)"results", (Object)name)) {
                        this.readSearchResults();
                        continue;
                    }
                    this.myReader.skipValue();
                }
                this.myReader.endObject();
            } else {
                this.readSearchResults();
            }
            return CollectionsKt.toList((Iterable)this.myResults);
        }

        public final void readSearchResults() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_ARRAY) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginArray();
            while (this.myReader.hasNext()) {
                this.readPackageProp();
            }
            this.myReader.endArray();
        }

        public final void readPackageProp() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String propName = this.myReader.nextName();
                if (Intrinsics.areEqual((Object)"package", (Object)propName)) {
                    UtilKt.addIfNotNull(this.myResults, (Object)NpmRegistryUtil.readPackageInfo(this.myReader));
                    continue;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
        }
    }
}

