/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.colab.helper;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.py.colab.assignments.ColabAssignedServer;
import com.intellij.jupyter.py.helpers.JupyterPyHelperProvider;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/py/colab/helper/ColabPyHelperProvider;", "Lcom/intellij/jupyter/py/helpers/JupyterPyHelperProvider;", "<init>", "()V", "serverRoot", "Ljava/nio/file/Path;", "getServerRoot", "()Ljava/nio/file/Path;", "isApplicable", "", "file", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getPaths", "", "intellij.jupyter.py.colab"})
public final class ColabPyHelperProvider
implements JupyterPyHelperProvider {
    @NotNull
    private final Path serverRoot;

    public ColabPyHelperProvider() {
        Path path = Paths.get("/content/", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = path.resolve("pycharm-libs");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        this.serverRoot = path2;
    }

    @NotNull
    public Path getServerRoot() {
        return this.serverRoot;
    }

    public boolean isApplicable(@NotNull BackedNotebookVirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JupyterServerConfig config = JupyterConnectionSettingsManager.Companion.getInstance().getConfigForVirtualFile(file, project);
        return config instanceof ColabAssignedServer;
    }

    @NotNull
    public List<Path> getPaths(@NotNull BackedNotebookVirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path libPath = this.getServerRoot().resolve("pydev");
        Path jupyterDebug = this.getServerRoot().resolve("jupyter_debug");
        Object[] objectArray = new Path[]{libPath, jupyterDebug};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

