"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperationReplyAddressInfo = exports.OperationReplyChannelInfo = exports.OperationReplyInfo = exports.OperationInfo = exports.Operation = void 0;
var react_1 = __importStar(require("react"));
var Message_1 = require("../Messages/Message");
var Security_1 = require("../Servers/Security");
var components_1 = require("../../components");
var Href_1 = require("../../components/Href");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var constants_1 = require("../../constants");
var types_1 = require("../../types");
var Operation = function (props) {
    var _a = props.type, type = _a === void 0 ? types_1.PayloadType.SEND : _a, operation = props.operation, channelName = props.channelName, channel = props.channel;
    var config = (0, contexts_1.useConfig)();
    if (!operation || !channel) {
        return null;
    }
    var servers = typeof channel.servers === 'function' && channel.servers().all();
    var security = typeof operation.security === 'function' && operation.security();
    var parameters = channel.parameters() !== undefined
        ? helpers_1.SchemaHelpers.parametersToSchema(channel.parameters())
        : undefined;
    return (react_1.default.createElement("div", null,
        react_1.default.createElement("div", { className: "panel-item--center px-8" },
            react_1.default.createElement(exports.OperationInfo, __assign({}, props)),
            servers && servers.length > 0 ? (react_1.default.createElement("div", { className: "mt-2 text-sm" },
                react_1.default.createElement("p", null, "Available only on servers:"),
                react_1.default.createElement("ul", { className: "flex flex-wrap leading-normal" }, servers.map(function (server) { return (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2", key: server.id() },
                    react_1.default.createElement("a", { href: "".concat(window.location.pathname, "#").concat(helpers_1.CommonHelpers.getIdentifier('server-' + server.id(), config)), className: "border border-solid border-blue-300 hover:bg-blue-300 hover:text-blue-600 text-blue-500 font-bold no-underline text-xs rounded px-3 py-1 cursor-pointer" },
                        react_1.default.createElement("span", { className: "underline" }, server.id())))); })))) : null,
            parameters && (react_1.default.createElement("div", { className: "mt-2", id: helpers_1.CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-parameters"), config) },
                react_1.default.createElement(components_1.Schema, { schemaName: "Parameters", schema: parameters, expanded: true }))),
            security && (react_1.default.createElement("div", { className: "mt-2", id: helpers_1.CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-security"), config) },
                react_1.default.createElement(Security_1.Security, { security: security, header: "Additional security requirements" }))),
            channel.bindings() && (react_1.default.createElement("div", { className: "mt-2" },
                react_1.default.createElement(components_1.Bindings, { name: "Channel specific information", bindings: channel.bindings() }))),
            react_1.default.createElement(components_1.Extensions, { name: "Channel Extensions", item: channel }),
            operation.bindings() && (react_1.default.createElement("div", { className: "mt-2" },
                react_1.default.createElement(components_1.Bindings, { name: "Operation specific information", bindings: operation.bindings() }))),
            react_1.default.createElement(components_1.Extensions, { name: "Operation Extensions", item: operation }),
            operation.tags() && (react_1.default.createElement("div", { className: "mt-2" },
                react_1.default.createElement(components_1.Tags, { tags: operation.tags() })))),
        react_1.default.createElement("div", { className: "w-full mt-4", id: helpers_1.CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-message"), config) }, operation.messages().length > 1 ? (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement("p", { className: "px-8" },
                "Accepts ",
                react_1.default.createElement("strong", null, "one of"),
                " the following messages:"),
            react_1.default.createElement("ul", null, operation
                .messages()
                .all()
                .map(function (msg, idx) { return (react_1.default.createElement("li", { className: "mt-4", key: msg.id() },
                react_1.default.createElement(Message_1.Message, { message: msg, index: idx, showExamples: true }))); })))) : (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement("p", { className: "px-8" }, "Accepts the following message:"),
            react_1.default.createElement("div", { className: "mt-2" },
                react_1.default.createElement(Message_1.Message, { message: operation.messages().all()[0], showExamples: true }))))),
        react_1.default.createElement(exports.OperationReplyInfo, __assign({}, props))));
};
exports.Operation = Operation;
var OperationInfo = function (props) {
    var _a = props.type, type = _a === void 0 ? types_1.PayloadType.SEND : _a, operation = props.operation, channelName = props.channelName, channel = props.channel;
    var config = (0, contexts_1.useConfig)();
    var operationSummary = operation.summary();
    var externalDocs = operation.externalDocs();
    var operationId = operation.id();
    var specV = (0, contexts_1.useSpec)().version();
    var version = specV.localeCompare('2.6.0', undefined, { numeric: true });
    var isAsyncAPIv2 = version === 0;
    var _b = helpers_1.CommonHelpers.getOperationDesignInformation({
        type: type,
        config: config,
        isAsyncAPIv2: isAsyncAPIv2,
    }), backgroundColor = _b.backgroundColor, typeLabel = _b.typeLabel;
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("div", { className: "mb-4" },
            react_1.default.createElement("h3", null,
                react_1.default.createElement("span", { className: "font-mono text-white uppercase p-1 rounded mr-2 ".concat(backgroundColor), title: type }, typeLabel),
                ' ',
                react_1.default.createElement("span", { className: "font-mono text-base" }, channelName))),
        channel.hasDescription() && (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement(components_1.Markdown, null, channel.description()))),
        operationSummary && (react_1.default.createElement("p", { className: "text-gray-600 text-sm mt-2" }, operationSummary)),
        operation.hasDescription() && (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement(components_1.Markdown, null, operation.description()))),
        externalDocs && (react_1.default.createElement("ul", { className: "leading-normal mt-2 mb-4 space-x-2 space-y-2" }, externalDocs && (react_1.default.createElement("li", { className: "inline-block" },
            react_1.default.createElement(Href_1.Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: externalDocs.url() },
                react_1.default.createElement("span", null, constants_1.EXTERAL_DOCUMENTATION_TEXT)))))),
        operationId && (react_1.default.createElement("div", { className: "border bg-gray-100 rounded px-4 py-2 mt-2" },
            react_1.default.createElement("div", { className: "text-sm text-gray-700" },
                "Operation ID",
                react_1.default.createElement("span", { className: "bg-orange-600 text-white rounded text-xs ml-2 py-0 px-2" }, operationId))))));
};
exports.OperationInfo = OperationInfo;
var OperationReplyInfo = function (props) {
    var _a;
    var _b = props.type, type = _b === void 0 ? types_1.PayloadType.SEND : _b, operation = props.operation;
    var _c = (0, react_1.useState)(false), showMessages = _c[0], setShowMessages = _c[1];
    var _d = (0, react_1.useState)(false), showChannel = _d[0], setShowChannel = _d[1];
    if (type !== types_1.PayloadType.REPLY && type !== types_1.PayloadType.REQUEST) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    var reply = operation.reply();
    if (reply === undefined) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    var replyMessages = reply.messages();
    var explicitChannel = reply.channel();
    var replyAddress = (_a = reply.address()) === null || _a === void 0 ? void 0 : _a.location();
    return (react_1.default.createElement("div", { className: "panel-item" },
        react_1.default.createElement("div", { className: "panel-item--center" },
            react_1.default.createElement("div", { className: "font-mono px-8 py-4" },
                react_1.default.createElement("div", { className: "border rounded" },
                    react_1.default.createElement("div", { className: "w-full ".concat(type === types_1.PayloadType.REPLY
                            ? 'bg-green-600 border-green-600'
                            : 'bg-blue-600 border-blue-600', " text-sm rounded-t h-8 px-4 border text-white flex items-center") },
                        react_1.default.createElement("strong", null, "REPLY INFORMATION")),
                    react_1.default.createElement("div", { className: "flex" },
                        react_1.default.createElement("div", { className: "w-1 h-11 ".concat(type === types_1.PayloadType.REPLY ? 'bg-green-600' : 'bg-blue-600', " mt-4") }),
                        react_1.default.createElement("div", { className: "p-4" },
                            react_1.default.createElement("h3", { className: "text-xs" },
                                react_1.default.createElement("span", { className: "mr-2", title: type }, "REPLY CHANNEL INFORMATION")),
                            (explicitChannel === null || explicitChannel === void 0 ? void 0 : explicitChannel.address()) ? (react_1.default.createElement("div", { className: "text-xs text-gray-700" },
                                "Reply will be provided via this designated address:",
                                ' ',
                                react_1.default.createElement("span", { className: "border text-orange-600 rounded text-xs ml-2 py-0 px-2" },
                                    explicitChannel.address(),
                                    ' '))) : (replyAddress != null && (react_1.default.createElement("div", { className: "text-xs text-gray-700" },
                                "Reply will be directed to the address specified at this location:",
                                ' ',
                                react_1.default.createElement("span", { className: "border text-orange-600 rounded text-xs ml-2 py-0 px-2" }, replyAddress)))),
                            react_1.default.createElement("div", { className: "mt-2" },
                                explicitChannel && (react_1.default.createElement(components_1.CollapseButton, { onClick: function () { return setShowChannel(function (prev) { return !prev; }); }, expanded: showChannel },
                                    react_1.default.createElement("span", { className: "inline-block py-0.5 mr-1 text-gray-500 text-xs text-center rounded focus:outline-none" }, "View channel details"))),
                                explicitChannel && (react_1.default.createElement("div", { className: "w-full mt-4 ".concat(showChannel ? 'block' : 'hidden') },
                                    react_1.default.createElement(exports.OperationReplyChannelInfo, __assign({}, props)),
                                    ' '))))),
                    react_1.default.createElement(exports.OperationReplyAddressInfo, __assign({}, props)),
                    replyMessages.isEmpty() === false && (react_1.default.createElement("div", { className: "p-4" },
                        react_1.default.createElement(components_1.CollapseButton, { onClick: function () { return setShowMessages(function (prev) { return !prev; }); }, expanded: showMessages },
                            react_1.default.createElement("span", { className: "inline-block py-0.5 mr-1 text-gray-500 text-xs text-center rounded focus:outline-none" },
                                "Expected Reply",
                                ' ',
                                replyMessages.length > 1 ? 'Messages' : 'Message')),
                        react_1.default.createElement("div", { className: "w-full mt-4 ".concat(showMessages ? 'block' : 'hidden') }, replyMessages.length > 1 ? (react_1.default.createElement("div", { className: "mt-2" },
                            react_1.default.createElement("ul", null, replyMessages.all().map(function (msg, idx) { return (react_1.default.createElement("li", { className: "mt-4", key: msg.id() },
                                react_1.default.createElement(Message_1.Message, { message: msg, index: idx, showExamples: true }))); })))) : (react_1.default.createElement("div", { className: "mt-2" },
                            react_1.default.createElement("div", { className: "mt-2" },
                                react_1.default.createElement(Message_1.Message, { message: replyMessages.all()[0], showExamples: true }))))))))),
            react_1.default.createElement(components_1.Extensions, { name: "Operation Reply Extensions", item: reply }))));
};
exports.OperationReplyInfo = OperationReplyInfo;
var OperationReplyChannelInfo = function (_a) {
    var _b;
    var _c = _a.type, type = _c === void 0 ? types_1.PayloadType.SEND : _c, operation = _a.operation;
    var reply = operation.reply();
    var channel = reply === null || reply === void 0 ? void 0 : reply.channel();
    var channelName = (_b = channel === null || channel === void 0 ? void 0 : channel.address()) !== null && _b !== void 0 ? _b : '';
    var config = (0, contexts_1.useConfig)();
    var servers = typeof (channel === null || channel === void 0 ? void 0 : channel.servers) === 'function' && channel.servers().all();
    var parameters = (channel === null || channel === void 0 ? void 0 : channel.parameters()) !== undefined
        ? helpers_1.SchemaHelpers.parametersToSchema(channel.parameters())
        : undefined;
    if (!channel) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    return (react_1.default.createElement("div", null,
        channel.address() && (react_1.default.createElement("div", { className: "mt-2 text-xs text-gray-700" },
            "Address:",
            ' ',
            react_1.default.createElement("span", { className: "border text-orange-600 rounded text-xs py-0 px-2" }, channel.address()))),
        channel.hasDescription() && (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement(components_1.Markdown, null, channel.description()))),
        servers && servers.length > 0 ? (react_1.default.createElement("div", { className: "mt-2 text-sm" },
            react_1.default.createElement("p", null, "Available only on servers:"),
            react_1.default.createElement("ul", { className: "flex flex-wrap leading-normal" }, servers.map(function (server) { return (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2", key: server.id() },
                react_1.default.createElement("a", { href: "".concat(window.location.pathname, "#").concat(helpers_1.CommonHelpers.getIdentifier('server-' + server.id(), config)), className: "border border-solid border-blue-300 hover:bg-blue-300 hover:text-blue-600 text-blue-500 font-bold no-underline text-xs rounded px-3 py-1 cursor-pointer" },
                    react_1.default.createElement("span", { className: "underline" }, server.id())))); })))) : null,
        channel.messages().all().length > 1 ? (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement("span", { className: "text-xs text-gray-700" }, "Messages:"),
            react_1.default.createElement("ul", null, channel
                .messages()
                .all()
                .map(function (msg, idx) { return (react_1.default.createElement("li", { className: "mt-4", key: msg.id() },
                react_1.default.createElement(Message_1.Message, { message: msg, index: idx, showExamples: true }))); })))) : (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement("span", { className: "text-xs text-gray-700" }, "Message:"),
            react_1.default.createElement("div", { className: "mt-2" },
                react_1.default.createElement(Message_1.Message, { message: channel.messages().all()[0], showExamples: true })))),
        parameters && (react_1.default.createElement("div", { className: "mt-2", id: helpers_1.CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-parameters"), config) },
            react_1.default.createElement(components_1.Schema, { schemaName: "Parameters", schema: parameters, expanded: true }))),
        channel.bindings() && (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement(components_1.Bindings, { name: "Bindings", bindings: channel.bindings() })))));
};
exports.OperationReplyChannelInfo = OperationReplyChannelInfo;
var OperationReplyAddressInfo = function (_a) {
    var _b = _a.type, type = _b === void 0 ? types_1.PayloadType.SEND : _b, operation = _a.operation;
    if (type !== types_1.PayloadType.REPLY && type !== types_1.PayloadType.REQUEST) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    var reply = operation.reply();
    if (!(reply === null || reply === void 0 ? void 0 : reply.address)) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    var replyAddress = reply.address();
    if (!replyAddress) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    var replyAddressLocation = replyAddress.location();
    return (react_1.default.createElement("div", { className: "flex" },
        react_1.default.createElement("div", { className: "w-1 h-11 ".concat(type === types_1.PayloadType.REPLY ? 'bg-green-600' : 'bg-blue-600', " mt-4") }),
        react_1.default.createElement("div", { className: "p-4" },
            react_1.default.createElement("h3", { className: "text-xs" },
                react_1.default.createElement("span", { className: "mr-2 uppercase", title: type }, "REPLY address information")),
            replyAddressLocation && (react_1.default.createElement("div", { className: "text-xs text-gray-700" },
                "REPLY will be sent to the address provided in:",
                react_1.default.createElement("span", { className: "border text-orange-600 rounded text-xs ml-2 py-0 px-2" }, replyAddressLocation))),
            replyAddress.hasDescription() && (react_1.default.createElement("div", { className: "mt-2" },
                react_1.default.createElement(components_1.Markdown, null, replyAddress.description()))),
            react_1.default.createElement(components_1.Extensions, { name: "Operation Reply Address Extensions", item: reply }))));
};
exports.OperationReplyAddressInfo = OperationReplyAddressInfo;
//# sourceMappingURL=Operation.js.map