/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 113462159607950L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-2008516680 + -((char)-8226), 2008516680 + (char)-2626, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-2008516680 + -((char)-8227), 2008516680 + (char)-19228, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 57417316864669L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.J();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(2100921030 - 29947, 2100921030 - 24389, (int)l2) + string + WindowsNamedPipeAgentIpc.b(2100921030 - 29948, -2100921030 - -30489, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(2100921030 - 29945, -2100921030 - -7936, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String string;
                l2 = 18133628406791L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    string = SshAgentIpcService.J();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-276426630 + -((char)-17116), -276426630 + -((char)-1507), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-276426630 + -((char)-17115), 276426630 + (char)-15483, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-276426630 + -((char)-17114), -276426630 + -((char)-18681), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-276426630 + -((char)-17121), -276426630 + -((char)-21317), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-276426630 + -((char)-17120), -276426630 + -((char)-19255), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-276426630 + -((char)-17119), 276426630 + (char)-20949, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-276426630 + -((char)-17121), -276426630 + -((char)-21317), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-276426630 + -((char)-17118), 276426630 + (char)-10921, (int)l2));
            if (ActionTimestamp.J()) {
                SshAgentIpcService.J("zn0OBb");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 20957825613679L;
                    string = SshAgentIpcService.J();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    String string;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 9286167976236L;
                            this.assertConnectionThread();
                            Object object3 = this.lock;
                            string = SshAgentIpcService.J();
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (string != null) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-448652610 + -21578, 448652610 + 32482, (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(-448652610 + -21582, -448652610 + -9258, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-448652610 + -21577, 448652610 + (char)-28513, (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string2 = WindowsNamedPipeAgentIpc.b(-448652610 + -21582, -448652610 + -9258, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-448652610 + -21576, 448652610 + (char)-31474, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string2.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-448652610 + -21578, 448652610 + 32482, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-448652610 + -21582, -448652610 + -9258, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-448652610 + -21575, 448652610 + 7864, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (string != null) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n2 = Kernel32.INSTANCE.GetLastError();
                            if (n2 == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-448652610 + -21578, 448652610 + 32482, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-448652610 + -21582, -448652610 + -9258, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-448652610 + -21590, 448652610 + 27848, (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-448652610 + -21582, -448652610 + -9258, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-448652610 + -21589, -448652610 + -11652, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string != null) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string3 = WindowsNamedPipeAgentIpc.b(-448652610 + -21582, -448652610 + -9258, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-448652610 + -21576, 448652610 + (char)-31474, (int)l2) + this.state;
                            throw new IllegalArgumentException(string3.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-448652610 + -21578, 448652610 + 32482, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-448652610 + -21582, -448652610 + -9258, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-448652610 + -21588, 448652610 + 27874, (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 3034772641063L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1769182860 + -((char)-20080), -1769182860 + -((char)-31763), (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 17439233329713L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1666161840 - (char)-19523, -1666030770 + -((char)-2800), (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "~\u00dc'm\u00bd\u0016\u00aaIH\u009b4Bp'\u00ea\u009fb@ \u0014 \u00d9\u00ec\u00cb\u00df\u0000\u009b\u000e\u00ecueK\u0098\u00ff6\u000f\u0014\u0094\u00e9\u00fb";
                                        var4_3 = "~\u00dc'm\u00bd\u0016\u00aaIH\u009b4Bp'\u00ea\u009fb@ \u0014 \u00d9\u00ec\u00cb\u00df\u0000\u009b\u000e\u00ecueK\u0098\u00ff6\u000f\u0014\u0094\u00e9\u00fb".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 49;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 48;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 105;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 45;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 76;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 28;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 53;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 95;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n2, int n3, int n4) {
                                    int n5 = (n2 ^ n4 ^ 0x22C3) & 0xFFFF;
                                    if (b[n5] == null) {
                                        int n6;
                                        char[] cArray = a[n5].toCharArray();
                                        int n7 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 88;
                                            case 1 -> 190;
                                            case 2 -> 7;
                                            case 3 -> 123;
                                            case 4 -> 64;
                                            case 5 -> 231;
                                            case 6 -> 144;
                                            case 7 -> 75;
                                            case 8 -> 238;
                                            case 9 -> 184;
                                            case 10 -> 180;
                                            case 11 -> 13;
                                            case 12 -> 233;
                                            case 13 -> 221;
                                            case 14 -> 105;
                                            case 15 -> 195;
                                            case 16 -> 70;
                                            case 17 -> 127;
                                            case 18 -> 113;
                                            case 19 -> 85;
                                            case 20 -> 189;
                                            case 21 -> 134;
                                            case 22 -> 46;
                                            case 23 -> 8;
                                            case 24 -> 159;
                                            case 25 -> 246;
                                            case 26 -> 236;
                                            case 27 -> 38;
                                            case 28 -> 229;
                                            case 29 -> 220;
                                            case 30 -> 126;
                                            case 31 -> 55;
                                            case 32 -> 102;
                                            case 33 -> 192;
                                            case 34 -> 185;
                                            case 35 -> 150;
                                            case 36 -> 247;
                                            case 37 -> 19;
                                            case 38 -> 161;
                                            case 39 -> 119;
                                            case 40 -> 18;
                                            case 41 -> 104;
                                            case 42 -> 96;
                                            case 43 -> 98;
                                            case 44 -> 137;
                                            case 45 -> 135;
                                            case 46 -> 61;
                                            case 47 -> 201;
                                            case 48 -> 218;
                                            case 49 -> 168;
                                            case 50 -> 26;
                                            case 51 -> 153;
                                            case 52 -> 116;
                                            case 53 -> 76;
                                            case 54 -> 110;
                                            case 55 -> 28;
                                            case 56 -> 198;
                                            case 57 -> 222;
                                            case 58 -> 16;
                                            case 59 -> 142;
                                            case 60 -> 72;
                                            case 61 -> 9;
                                            case 62 -> 167;
                                            case 63 -> 164;
                                            case 64 -> 74;
                                            case 65 -> 30;
                                            case 66 -> 108;
                                            case 67 -> 215;
                                            case 68 -> 60;
                                            case 69 -> 6;
                                            case 70 -> 219;
                                            case 71 -> 151;
                                            case 72 -> 71;
                                            case 73 -> 244;
                                            case 74 -> 136;
                                            case 75 -> 225;
                                            case 76 -> 232;
                                            case 77 -> 90;
                                            case 78 -> 227;
                                            case 79 -> 118;
                                            case 80 -> 194;
                                            case 81 -> 160;
                                            case 82 -> 177;
                                            case 83 -> 254;
                                            case 84 -> 130;
                                            case 85 -> 240;
                                            case 86 -> 14;
                                            case 87 -> 152;
                                            case 88 -> 235;
                                            case 89 -> 157;
                                            case 90 -> 68;
                                            case 91 -> 115;
                                            case 92 -> 211;
                                            case 93 -> 141;
                                            case 94 -> 36;
                                            case 95 -> 200;
                                            case 96 -> 145;
                                            case 97 -> 80;
                                            case 98 -> 213;
                                            case 99 -> 132;
                                            case 100 -> 216;
                                            case 101 -> 226;
                                            case 102 -> 193;
                                            case 103 -> 33;
                                            case 104 -> 86;
                                            case 105 -> 196;
                                            case 106 -> 228;
                                            case 107 -> 78;
                                            case 108 -> 49;
                                            case 109 -> 171;
                                            case 110 -> 182;
                                            case 111 -> 95;
                                            case 112 -> 209;
                                            case 113 -> 155;
                                            case 114 -> 92;
                                            case 115 -> 89;
                                            case 116 -> 3;
                                            case 117 -> 39;
                                            case 118 -> 84;
                                            case 119 -> 4;
                                            case 120 -> 93;
                                            case 121 -> 109;
                                            case 122 -> 251;
                                            case 123 -> 117;
                                            case 124 -> 166;
                                            case 125 -> 101;
                                            case 126 -> 241;
                                            case 127 -> 143;
                                            case 128 -> 174;
                                            case 129 -> 62;
                                            case 130 -> 186;
                                            case 131 -> 65;
                                            case 132 -> 187;
                                            case 133 -> 32;
                                            case 134 -> 255;
                                            case 135 -> 63;
                                            case 136 -> 170;
                                            case 137 -> 158;
                                            case 138 -> 197;
                                            case 139 -> 50;
                                            case 140 -> 82;
                                            case 141 -> 249;
                                            case 142 -> 210;
                                            case 143 -> 230;
                                            case 144 -> 23;
                                            case 145 -> 106;
                                            case 146 -> 202;
                                            case 147 -> 131;
                                            case 148 -> 207;
                                            case 149 -> 52;
                                            case 150 -> 56;
                                            case 151 -> 179;
                                            case 152 -> 81;
                                            case 153 -> 99;
                                            case 154 -> 94;
                                            case 155 -> 239;
                                            case 156 -> 83;
                                            case 157 -> 91;
                                            case 158 -> 172;
                                            case 159 -> 129;
                                            case 160 -> 17;
                                            case 161 -> 146;
                                            case 162 -> 15;
                                            case 163 -> 59;
                                            case 164 -> 199;
                                            case 165 -> 147;
                                            case 166 -> 103;
                                            case 167 -> 223;
                                            case 168 -> 51;
                                            case 169 -> 111;
                                            case 170 -> 149;
                                            case 171 -> 22;
                                            case 172 -> 58;
                                            case 173 -> 188;
                                            case 174 -> 156;
                                            case 175 -> 191;
                                            case 176 -> 175;
                                            case 177 -> 69;
                                            case 178 -> 173;
                                            case 179 -> 169;
                                            case 180 -> 148;
                                            case 181 -> 27;
                                            case 182 -> 234;
                                            case 183 -> 205;
                                            case 184 -> 2;
                                            case 185 -> 40;
                                            case 186 -> 42;
                                            case 187 -> 25;
                                            case 188 -> 29;
                                            case 189 -> 217;
                                            case 190 -> 47;
                                            case 191 -> 243;
                                            case 192 -> 242;
                                            case 193 -> 139;
                                            case 194 -> 57;
                                            case 195 -> 20;
                                            case 196 -> 41;
                                            case 197 -> 165;
                                            case 198 -> 34;
                                            case 199 -> 44;
                                            case 200 -> 31;
                                            case 201 -> 112;
                                            case 202 -> 140;
                                            case 203 -> 128;
                                            case 204 -> 208;
                                            case 205 -> 97;
                                            case 206 -> 1;
                                            case 207 -> 248;
                                            case 208 -> 204;
                                            case 209 -> 114;
                                            case 210 -> 24;
                                            case 211 -> 122;
                                            case 212 -> 10;
                                            case 213 -> 245;
                                            case 214 -> 43;
                                            case 215 -> 252;
                                            case 216 -> 79;
                                            case 217 -> 224;
                                            case 218 -> 138;
                                            case 219 -> 5;
                                            case 220 -> 48;
                                            case 221 -> 45;
                                            case 222 -> 37;
                                            case 223 -> 100;
                                            case 224 -> 163;
                                            case 225 -> 181;
                                            case 226 -> 154;
                                            case 227 -> 66;
                                            case 228 -> 73;
                                            case 229 -> 77;
                                            case 230 -> 214;
                                            case 231 -> 124;
                                            case 232 -> 87;
                                            case 233 -> 125;
                                            case 234 -> 121;
                                            case 235 -> 237;
                                            case 236 -> 250;
                                            case 237 -> 178;
                                            case 238 -> 53;
                                            case 239 -> 107;
                                            case 240 -> 253;
                                            case 241 -> 11;
                                            case 242 -> 206;
                                            case 243 -> 120;
                                            case 244 -> 54;
                                            case 245 -> 21;
                                            case 246 -> 212;
                                            case 247 -> 35;
                                            case 248 -> 133;
                                            case 249 -> 162;
                                            case 250 -> 12;
                                            case 251 -> 0;
                                            case 252 -> 203;
                                            case 253 -> 176;
                                            case 254 -> 67;
                                            default -> 183;
                                        };
                                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                                        if (n8 < 0) {
                                            n8 += 256;
                                        }
                                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                            n6 += 256;
                                        }
                                        int n9 = 0;
                                        while (n9 < cArray.length) {
                                            int n10 = n9 % 2;
                                            int n11 = n9;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n11];
                                            if (n10 == 0) {
                                                cArray2[n11] = (char)(c2 ^ n8);
                                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                            } else {
                                                cArray2[n11] = (char)(c2 ^ n6);
                                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                            }
                                            ++n9;
                                        }
                                        accept.3.b[n5] = new String(cArray).intern();
                                    }
                                    return b[n5];
                                }
                            };
                            if (string == null) break block32;
                            if (!ActionTimestamp.J()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.J(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 59638891787024L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.J();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1024049910 + 26962, -1024049910 + -((char)-20750), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1024049910 + 26966, 1024049910 + 22962, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1024049910 + 26977, -1024049910 + -29347, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1024049910 + 26962, -1024049910 + -((char)-20750), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1024049910 + 26966, 1024049910 + 22962, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1024049910 + 26970, -1024049910 + -26802, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 69609505375031L;
                        String string3 = SshAgentIpcService.J();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-970442280 - -((char)-23906), 970442280 - (char)-18069, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-970442280 - -((char)-23907), -970442280 - -((char)-25492), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 71645813156882L;
                String string2 = SshAgentIpcService.J();
                this.assertConnectionThread();
                string = string2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23564), 1463658690 + 26712, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23568), -1463658690 + -((char)-11372), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23571), -1463658690 + -23801, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23568), -1463658690 + -((char)-11372), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23562), 1463658690 + 30380, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23564), 1463658690 + 26712, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23568), -1463658690 + -((char)-11372), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23584), 1463658690 + (char)-12551, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23564), 1463658690 + 26712, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23568), -1463658690 + -((char)-11372), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23585), -1463658690 + -((char)-32720), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23564), 1463658690 + 26712, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23568), -1463658690 + -((char)-11372), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1463658690 + -((char)-23582), 1463658690 + (char)-11973, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 4272342141669L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                string = SshAgentIpcService.J();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1150270320 + 23117, -1150270320 + -((char)-29533), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1150270320 + 23113, 1150270320 + 27117, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1150270320 + 23098, 1150270320 + (char)-31039, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1150270320 + 23101, -1150270320 + -((char)-18974), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1150270320 + 23117, -1150270320 + -((char)-29533), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1150270320 + 23113, 1150270320 + 27117, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1150270320 + 23100, -1150270320 + -((char)-17753), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1150270320 + 23117, -1150270320 + -((char)-29533), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1150270320 + 23113, 1150270320 + 27117, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1150270320 + 23103, 1150270320 + 26094, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1150270320 + 23117, -1150270320 + -((char)-29533), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1150270320 + 23113, 1150270320 + 27117, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1150270320 + 23102, -1150270320 + -26840, (int)l2));
                    if (string != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1150270320 + 23117, -1150270320 + -((char)-29533), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1150270320 + 23113, 1150270320 + 27117, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1150270320 + 23073, 1150270320 + 19050, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1150270320 + 23072, 1150270320 + 22954, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "d#u5;\u00fa5\u00c3\u0014\u00cbM\u00b8\u001f|7r`\u00d6\u000e\u00a5W\u008b\u001fRDH(\u008eq\u0006\u0090N\u00eb\u0098\u0082\u000e\u0018\u00d8;\u00ba\u00e1\u00be-(\u00e3U\u0003\u00da\u0086\u0002\u00da1~\u008d\u0006\u0018)\u00c2\u00f6\u00da\u00dd\t\u00fc\u00a5\u00a0\u0083\u0096\u00fe5\u00d1\u00ca\u0005\u00841iw\u00c8\b\u009f>\n\u00e7\u0086\u0086\u0084\u00ae\u0014Ky\u00d0\u0002\u001c\u009cK\u0082\u009f\u008f'\u00d3\u0091,\u00aa\u00cfE\u008a\u00d6g\u0005b^\u00b5\u009aS\u001e\u00be\u00ef;\u00c8\u001f\u00cc\u00be\u00a5\"\u00df\u007f\u009a\u00fay\u008cn\u00db\u0095\u0000\u00afm\t#\u00efL\u00ce\u00e2\u00f6\u00ab}\u0010\u0004\u00c1\u0088\u00c8>\u00fel\u001a\u0005\u009a\u0016\u00cf\u00d1\u0086F\u000e\t\u00a5\u00bd]\u0091z\u009b\u008e\u00e2S\u0010M\u00bc\u00a1g\u001b\u000b\u00c8\u00a4\u0091M\u00845\u0083\u00d9\f\u00e5?\u0002\u0095\u00a4\u0087\u00e1,\u00e4\u00d5\u0018\u0000}\u009a\u0005\u008fN\u0089F\f\u00ceY:\u0085\u00b2\u0018n\u00d8\u00ab\u0080\u00b5\u00e5\u00c6\u009a\u00c1\u00f8\f\u00c6\u000f\u00c4\u00e2\u0000'\u00d7\u0097\u00a3d'\u00fb\u00c7\u00a1\u00dao\u0082\u00f7\u0094\u00b7\u00be\u0095S\u0015f\u0097\u0010I\b+V\u009c\u00eaT'\u00de\u009a\f\u0014\u00a6k\u00ef\u00b7\u00e5L\u00c5()\u00e1\u00bdF1j\u00cfv#\u00d6\u00de\u00a3z\u00e9\u00a1a\b\u00f8\u00f0Amr\u00ab9\u0084\u00dbf\u00e1\u00c2\u00cc\u00cd\t\u00c6\u00fd\u0092\u00a5w\u00a9\u0018\u00cdW\u00e8BA\u00a0\u00ea\u00ec\u00ff\u00d5)\u0099{\n\u00b5|\u00c5z\u00ea\u0010j\u00fe\u00bd\u00ee\u0007\u00dbU\u009c\u00f9\u00a7l\u001d\u00b7}\u00ab\u001fk\u00ff\u0081\u00caH\u008cT\u00ad\u007f\u00de\u00d4\u00ba\u008f`)\u00fc\u0014/\u008426:\u009f\"\u00ba\u00a7+\u0017\u008f\u00b0\u00b9\u000b\u00ab\u0082\u009ckIu\u0093\u00d7\u00d3g\u0094\u0015(\u001c\u00ec\u00bb@\u0007^\u00e4T\u00e1\u00ac\u0096>I\u0002\u008f\u008a\u00d5\u008a\u0014\u00c1)ElD\u00b8\u00f0\u00c2Cd\u009d\u00e7\u0088\u009d\u0000\u008eF$\u00a6\u00bc\t\u00e7w\u00f8qb\b\u00e6\u00aaG\u0090N\u00d8\u00ed\u00c0\u0005\u0088\u00d5[\u00f6H+B\u0007\u0092\u0083\u00b4_\u00cac\u009f\u0007\u00fb\u00f9\u00fd|\u0004\u00e8P(\u00e5\u0003\u001ctK1\u00c2=\u00dd\u001b\u00aa4g:\u00e81t\u00b3\u00fdE\u0088\u0092\u00e1\u00e4\u008a\u008aL\u00b1{\u00f0~#\u00ef\u00b7\u00f3.\u008e\u00f4a\u0098\u000fS\u00bb\u0084J\u00b0\u009a\u0018\u008b\u00f3@\u00ce\u000eK)\u00f3\"\u0095\u009c^\u00a6\u00b3\u0001+\u001c\u0090\u00e8)|7\u00be\u00c4\u00ec\u001d\u008c\u00f4\u00a3\"p{#\u00da\u009a=\u0016FV\u00a0\u00e9\u00e1v\u000eL\u00dcg\u00a6\u00cc\u0007\u00978\u00026\u00f0\u00c0\u0080\u00fa\u001b\u00dd\u00ffR\u00c7\u0091\u009e\u00a9W\u0092\\o\u008c#E`\u0085!\u000b\u00ce\u00cf^\u00c9\u0087\u00b2\u000e\u00c5\u00f2\n\u001aqn\u0011\u0002\u00a0\b\u00ba\r\u0083\u0018\u009f\u00a2\u001aa\u0099\u00f6\u0089\u0004\u0088\u00ff\u00eeg\u00aak\u00ada\u00ef\u0096\u00c0\u0005\u00e7\u00db\u00eb\u00a3)MKE\\\u00d0^G\u00f7\u001d\u0095\u0098\u00d3\u0006N\u0019G3\u00a5d\u0001\u00e04\u00ca\u00f7\n\u00c6w\u00afx\u000f~T1\u00ecc|\u00f8\u00e7<\t\u00cc\t\u0085\u0087Y\u00c8\u00f0\u007f\u0089%\u000e";
                var4_3 = "d#u5;\u00fa5\u00c3\u0014\u00cbM\u00b8\u001f|7r`\u00d6\u000e\u00a5W\u008b\u001fRDH(\u008eq\u0006\u0090N\u00eb\u0098\u0082\u000e\u0018\u00d8;\u00ba\u00e1\u00be-(\u00e3U\u0003\u00da\u0086\u0002\u00da1~\u008d\u0006\u0018)\u00c2\u00f6\u00da\u00dd\t\u00fc\u00a5\u00a0\u0083\u0096\u00fe5\u00d1\u00ca\u0005\u00841iw\u00c8\b\u009f>\n\u00e7\u0086\u0086\u0084\u00ae\u0014Ky\u00d0\u0002\u001c\u009cK\u0082\u009f\u008f'\u00d3\u0091,\u00aa\u00cfE\u008a\u00d6g\u0005b^\u00b5\u009aS\u001e\u00be\u00ef;\u00c8\u001f\u00cc\u00be\u00a5\"\u00df\u007f\u009a\u00fay\u008cn\u00db\u0095\u0000\u00afm\t#\u00efL\u00ce\u00e2\u00f6\u00ab}\u0010\u0004\u00c1\u0088\u00c8>\u00fel\u001a\u0005\u009a\u0016\u00cf\u00d1\u0086F\u000e\t\u00a5\u00bd]\u0091z\u009b\u008e\u00e2S\u0010M\u00bc\u00a1g\u001b\u000b\u00c8\u00a4\u0091M\u00845\u0083\u00d9\f\u00e5?\u0002\u0095\u00a4\u0087\u00e1,\u00e4\u00d5\u0018\u0000}\u009a\u0005\u008fN\u0089F\f\u00ceY:\u0085\u00b2\u0018n\u00d8\u00ab\u0080\u00b5\u00e5\u00c6\u009a\u00c1\u00f8\f\u00c6\u000f\u00c4\u00e2\u0000'\u00d7\u0097\u00a3d'\u00fb\u00c7\u00a1\u00dao\u0082\u00f7\u0094\u00b7\u00be\u0095S\u0015f\u0097\u0010I\b+V\u009c\u00eaT'\u00de\u009a\f\u0014\u00a6k\u00ef\u00b7\u00e5L\u00c5()\u00e1\u00bdF1j\u00cfv#\u00d6\u00de\u00a3z\u00e9\u00a1a\b\u00f8\u00f0Amr\u00ab9\u0084\u00dbf\u00e1\u00c2\u00cc\u00cd\t\u00c6\u00fd\u0092\u00a5w\u00a9\u0018\u00cdW\u00e8BA\u00a0\u00ea\u00ec\u00ff\u00d5)\u0099{\n\u00b5|\u00c5z\u00ea\u0010j\u00fe\u00bd\u00ee\u0007\u00dbU\u009c\u00f9\u00a7l\u001d\u00b7}\u00ab\u001fk\u00ff\u0081\u00caH\u008cT\u00ad\u007f\u00de\u00d4\u00ba\u008f`)\u00fc\u0014/\u008426:\u009f\"\u00ba\u00a7+\u0017\u008f\u00b0\u00b9\u000b\u00ab\u0082\u009ckIu\u0093\u00d7\u00d3g\u0094\u0015(\u001c\u00ec\u00bb@\u0007^\u00e4T\u00e1\u00ac\u0096>I\u0002\u008f\u008a\u00d5\u008a\u0014\u00c1)ElD\u00b8\u00f0\u00c2Cd\u009d\u00e7\u0088\u009d\u0000\u008eF$\u00a6\u00bc\t\u00e7w\u00f8qb\b\u00e6\u00aaG\u0090N\u00d8\u00ed\u00c0\u0005\u0088\u00d5[\u00f6H+B\u0007\u0092\u0083\u00b4_\u00cac\u009f\u0007\u00fb\u00f9\u00fd|\u0004\u00e8P(\u00e5\u0003\u001ctK1\u00c2=\u00dd\u001b\u00aa4g:\u00e81t\u00b3\u00fdE\u0088\u0092\u00e1\u00e4\u008a\u008aL\u00b1{\u00f0~#\u00ef\u00b7\u00f3.\u008e\u00f4a\u0098\u000fS\u00bb\u0084J\u00b0\u009a\u0018\u008b\u00f3@\u00ce\u000eK)\u00f3\"\u0095\u009c^\u00a6\u00b3\u0001+\u001c\u0090\u00e8)|7\u00be\u00c4\u00ec\u001d\u008c\u00f4\u00a3\"p{#\u00da\u009a=\u0016FV\u00a0\u00e9\u00e1v\u000eL\u00dcg\u00a6\u00cc\u0007\u00978\u00026\u00f0\u00c0\u0080\u00fa\u001b\u00dd\u00ffR\u00c7\u0091\u009e\u00a9W\u0092\\o\u008c#E`\u0085!\u000b\u00ce\u00cf^\u00c9\u0087\u00b2\u000e\u00c5\u00f2\n\u001aqn\u0011\u0002\u00a0\b\u00ba\r\u0083\u0018\u009f\u00a2\u001aa\u0099\u00f6\u0089\u0004\u0088\u00ff\u00eeg\u00aak\u00ada\u00ef\u0096\u00c0\u0005\u00e7\u00db\u00eb\u00a3)MKE\\\u00d0^G\u00f7\u001d\u0095\u0098\u00d3\u0006N\u0019G3\u00a5d\u0001\u00e04\u00ca\u00f7\n\u00c6w\u00afx\u000f~T1\u00ecc|\u00f8\u00e7<\t\u00cc\t\u0085\u0087Y\u00c8\u00f0\u007f\u0089%\u000e".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 63;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0084\u0002\u0083\u008a\u00f7{\\\u00ac\u0081\u0001\u00f4\u00bet\u001c\u00a8\u00f2\u00fa\u00e0\u00f2\u00d2\u0098\u008e\u00c9\u0081>\u00eb\u009f\u00b0\n\u0014.e\u00fb\u00e5\u00eb\u0097\u007f\u008b\u0088\u008c\u0091\u00f8\u00f2\u0015\u0082\u00fa\u00ad\u0000\u00cd\u008b";
                    var4_3 = "\u0084\u0002\u0083\u008a\u00f7{\\\u00ac\u0081\u0001\u00f4\u00bet\u001c\u00a8\u00f2\u00fa\u00e0\u00f2\u00d2\u0098\u008e\u00c9\u0081>\u00eb\u009f\u00b0\n\u0014.e\u00fb\u00e5\u00eb\u0097\u007f\u008b\u0088\u008c\u0091\u00f8\u00f2\u0015\u0082\u00fa\u00ad\u0000\u00cd\u008b".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 106;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 96;
                            break;
                        }
                        case 1: {
                            v15 = 76;
                            break;
                        }
                        case 2: {
                            v15 = 35;
                            break;
                        }
                        case 3: {
                            v15 = 33;
                            break;
                        }
                        case 4: {
                            v15 = 7;
                            break;
                        }
                        case 5: {
                            v15 = 8;
                            break;
                        }
                        default: {
                            v15 = 68;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFF9F54) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 97;
                case 1 -> 149;
                case 2 -> 137;
                case 3 -> 159;
                case 4 -> 171;
                case 5 -> 99;
                case 6 -> 109;
                case 7 -> 244;
                case 8 -> 3;
                case 9 -> 236;
                case 10 -> 186;
                case 11 -> 237;
                case 12 -> 115;
                case 13 -> 187;
                case 14 -> 231;
                case 15 -> 30;
                case 16 -> 32;
                case 17 -> 71;
                case 18 -> 147;
                case 19 -> 198;
                case 20 -> 29;
                case 21 -> 249;
                case 22 -> 43;
                case 23 -> 60;
                case 24 -> 221;
                case 25 -> 66;
                case 26 -> 40;
                case 27 -> 77;
                case 28 -> 132;
                case 29 -> 124;
                case 30 -> 215;
                case 31 -> 208;
                case 32 -> 38;
                case 33 -> 234;
                case 34 -> 10;
                case 35 -> 11;
                case 36 -> 146;
                case 37 -> 182;
                case 38 -> 103;
                case 39 -> 91;
                case 40 -> 155;
                case 41 -> 195;
                case 42 -> 152;
                case 43 -> 216;
                case 44 -> 82;
                case 45 -> 141;
                case 46 -> 232;
                case 47 -> 248;
                case 48 -> 179;
                case 49 -> 78;
                case 50 -> 144;
                case 51 -> 194;
                case 52 -> 8;
                case 53 -> 230;
                case 54 -> 81;
                case 55 -> 92;
                case 56 -> 133;
                case 57 -> 220;
                case 58 -> 117;
                case 59 -> 61;
                case 60 -> 63;
                case 61 -> 107;
                case 62 -> 207;
                case 63 -> 88;
                case 64 -> 177;
                case 65 -> 191;
                case 66 -> 213;
                case 67 -> 36;
                case 68 -> 21;
                case 69 -> 226;
                case 70 -> 14;
                case 71 -> 199;
                case 72 -> 180;
                case 73 -> 1;
                case 74 -> 123;
                case 75 -> 101;
                case 76 -> 126;
                case 77 -> 114;
                case 78 -> 253;
                case 79 -> 190;
                case 80 -> 127;
                case 81 -> 192;
                case 82 -> 86;
                case 83 -> 203;
                case 84 -> 48;
                case 85 -> 50;
                case 86 -> 19;
                case 87 -> 214;
                case 88 -> 113;
                case 89 -> 250;
                case 90 -> 56;
                case 91 -> 122;
                case 92 -> 72;
                case 93 -> 102;
                case 94 -> 217;
                case 95 -> 90;
                case 96 -> 37;
                case 97 -> 34;
                case 98 -> 45;
                case 99 -> 35;
                case 100 -> 52;
                case 101 -> 201;
                case 102 -> 185;
                case 103 -> 164;
                case 104 -> 53;
                case 105 -> 65;
                case 106 -> 178;
                case 107 -> 157;
                case 108 -> 136;
                case 109 -> 116;
                case 110 -> 210;
                case 111 -> 145;
                case 112 -> 241;
                case 113 -> 57;
                case 114 -> 222;
                case 115 -> 174;
                case 116 -> 46;
                case 117 -> 170;
                case 118 -> 96;
                case 119 -> 42;
                case 120 -> 79;
                case 121 -> 148;
                case 122 -> 196;
                case 123 -> 209;
                case 124 -> 33;
                case 125 -> 161;
                case 126 -> 251;
                case 127 -> 119;
                case 128 -> 129;
                case 129 -> 16;
                case 130 -> 28;
                case 131 -> 74;
                case 132 -> 23;
                case 133 -> 206;
                case 134 -> 224;
                case 135 -> 39;
                case 136 -> 200;
                case 137 -> 150;
                case 138 -> 204;
                case 139 -> 120;
                case 140 -> 163;
                case 141 -> 162;
                case 142 -> 139;
                case 143 -> 135;
                case 144 -> 67;
                case 145 -> 140;
                case 146 -> 247;
                case 147 -> 105;
                case 148 -> 197;
                case 149 -> 233;
                case 150 -> 85;
                case 151 -> 176;
                case 152 -> 31;
                case 153 -> 89;
                case 154 -> 87;
                case 155 -> 94;
                case 156 -> 193;
                case 157 -> 239;
                case 158 -> 68;
                case 159 -> 158;
                case 160 -> 84;
                case 161 -> 212;
                case 162 -> 112;
                case 163 -> 24;
                case 164 -> 156;
                case 165 -> 106;
                case 166 -> 240;
                case 167 -> 172;
                case 168 -> 154;
                case 169 -> 235;
                case 170 -> 168;
                case 171 -> 25;
                case 172 -> 166;
                case 173 -> 49;
                case 174 -> 151;
                case 175 -> 95;
                case 176 -> 202;
                case 177 -> 59;
                case 178 -> 118;
                case 179 -> 255;
                case 180 -> 183;
                case 181 -> 80;
                case 182 -> 228;
                case 183 -> 143;
                case 184 -> 27;
                case 185 -> 173;
                case 186 -> 189;
                case 187 -> 134;
                case 188 -> 130;
                case 189 -> 62;
                case 190 -> 7;
                case 191 -> 218;
                case 192 -> 18;
                case 193 -> 131;
                case 194 -> 181;
                case 195 -> 121;
                case 196 -> 9;
                case 197 -> 242;
                case 198 -> 184;
                case 199 -> 100;
                case 200 -> 211;
                case 201 -> 169;
                case 202 -> 44;
                case 203 -> 238;
                case 204 -> 20;
                case 205 -> 205;
                case 206 -> 13;
                case 207 -> 93;
                case 208 -> 55;
                case 209 -> 73;
                case 210 -> 138;
                case 211 -> 5;
                case 212 -> 75;
                case 213 -> 98;
                case 214 -> 4;
                case 215 -> 225;
                case 216 -> 2;
                case 217 -> 128;
                case 218 -> 125;
                case 219 -> 175;
                case 220 -> 6;
                case 221 -> 227;
                case 222 -> 69;
                case 223 -> 160;
                case 224 -> 110;
                case 225 -> 219;
                case 226 -> 229;
                case 227 -> 64;
                case 228 -> 17;
                case 229 -> 0;
                case 230 -> 15;
                case 231 -> 188;
                case 232 -> 104;
                case 233 -> 22;
                case 234 -> 167;
                case 235 -> 165;
                case 236 -> 142;
                case 237 -> 254;
                case 238 -> 223;
                case 239 -> 108;
                case 240 -> 76;
                case 241 -> 70;
                case 242 -> 245;
                case 243 -> 41;
                case 244 -> 58;
                case 245 -> 51;
                case 246 -> 252;
                case 247 -> 47;
                case 248 -> 83;
                case 249 -> 246;
                case 250 -> 26;
                case 251 -> 243;
                case 252 -> 12;
                case 253 -> 54;
                case 254 -> 153;
                default -> 111;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 74487843977362L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-226095750 + -((char)-13903), -226095750 + -((char)-26459), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 24260914010276L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.J();
                            try {
                                hANDLE2 = hANDLE;
                                if (string != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1356312360 - (char)-13526, -1356312360 - -((char)-11243), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1356312360 - (char)-13525, 1356312360 - (char)-8831, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1356312360 - (char)-13524, 1356312360 - (char)-11868, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "T\u0096\u00e5\u00c9\u00dbr*Y\u0010\u00dd\u00ca%\u00e3y\u008c\u0087\u00df\u00d4\u00b4f\u00f8\u00c8c\u00ee\u001e";
                    var4_3 = "T\u0096\u00e5\u00c9\u00dbr*Y\u0010\u00dd\u00ca%\u00e3y\u008c\u0087\u00df\u00d4\u00b4f\u00f8\u00c8c\u00ee\u001e".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 56;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "y\u008asyJ5]\u0098\u00e0W\u00ea\u0010\u00de\u00d4\u00bb]*6\u0085cq\u00a7\u001ay\u0013B\u00ad\u00dbs\"N\u00f1\u0094\u00bfz\u00adK\u00adM\u0086\u00a9\u00f0\u00e1\u008d\u0002\u0083\u00af\u00b8\u00a99S\u00e6.I\u009fE$\u00f1\u00a2";
                        var4_3 = "y\u008asyJ5]\u0098\u00e0W\u00ea\u0010\u00de\u00d4\u00bb]*6\u0085cq\u00a7\u001ay\u0013B\u00ad\u00dbs\"N\u00f1\u0094\u00bfz\u00adK\u00adM\u0086\u00a9\u00f0\u00e1\u008d\u0002\u0083\u00af\u00b8\u00a99S\u00e6.I\u009fE$\u00f1\u00a2".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 41;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 35;
                                break;
                            }
                            case 1: {
                                v15 = 67;
                                break;
                            }
                            case 2: {
                                v15 = 58;
                                break;
                            }
                            case 3: {
                                v15 = 109;
                                break;
                            }
                            case 4: {
                                v15 = 49;
                                break;
                            }
                            case 5: {
                                v15 = 113;
                                break;
                            }
                            default: {
                                v15 = 102;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFBB5B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 5;
                    case 1 -> 177;
                    case 2 -> 42;
                    case 3 -> 119;
                    case 4 -> 202;
                    case 5 -> 84;
                    case 6 -> 150;
                    case 7 -> 69;
                    case 8 -> 112;
                    case 9 -> 73;
                    case 10 -> 106;
                    case 11 -> 103;
                    case 12 -> 6;
                    case 13 -> 144;
                    case 14 -> 136;
                    case 15 -> 140;
                    case 16 -> 105;
                    case 17 -> 51;
                    case 18 -> 3;
                    case 19 -> 212;
                    case 20 -> 254;
                    case 21 -> 9;
                    case 22 -> 127;
                    case 23 -> 222;
                    case 24 -> 78;
                    case 25 -> 92;
                    case 26 -> 41;
                    case 27 -> 33;
                    case 28 -> 237;
                    case 29 -> 66;
                    case 30 -> 195;
                    case 31 -> 90;
                    case 32 -> 15;
                    case 33 -> 2;
                    case 34 -> 146;
                    case 35 -> 75;
                    case 36 -> 72;
                    case 37 -> 118;
                    case 38 -> 100;
                    case 39 -> 134;
                    case 40 -> 94;
                    case 41 -> 162;
                    case 42 -> 221;
                    case 43 -> 37;
                    case 44 -> 185;
                    case 45 -> 49;
                    case 46 -> 98;
                    case 47 -> 89;
                    case 48 -> 125;
                    case 49 -> 226;
                    case 50 -> 79;
                    case 51 -> 58;
                    case 52 -> 50;
                    case 53 -> 201;
                    case 54 -> 225;
                    case 55 -> 32;
                    case 56 -> 232;
                    case 57 -> 216;
                    case 58 -> 62;
                    case 59 -> 47;
                    case 60 -> 67;
                    case 61 -> 137;
                    case 62 -> 142;
                    case 63 -> 208;
                    case 64 -> 194;
                    case 65 -> 183;
                    case 66 -> 188;
                    case 67 -> 60;
                    case 68 -> 154;
                    case 69 -> 65;
                    case 70 -> 247;
                    case 71 -> 35;
                    case 72 -> 156;
                    case 73 -> 231;
                    case 74 -> 23;
                    case 75 -> 68;
                    case 76 -> 253;
                    case 77 -> 209;
                    case 78 -> 223;
                    case 79 -> 8;
                    case 80 -> 175;
                    case 81 -> 53;
                    case 82 -> 80;
                    case 83 -> 213;
                    case 84 -> 55;
                    case 85 -> 178;
                    case 86 -> 135;
                    case 87 -> 179;
                    case 88 -> 186;
                    case 89 -> 121;
                    case 90 -> 52;
                    case 91 -> 131;
                    case 92 -> 111;
                    case 93 -> 57;
                    case 94 -> 248;
                    case 95 -> 27;
                    case 96 -> 132;
                    case 97 -> 115;
                    case 98 -> 171;
                    case 99 -> 184;
                    case 100 -> 22;
                    case 101 -> 217;
                    case 102 -> 74;
                    case 103 -> 109;
                    case 104 -> 161;
                    case 105 -> 158;
                    case 106 -> 234;
                    case 107 -> 199;
                    case 108 -> 219;
                    case 109 -> 59;
                    case 110 -> 211;
                    case 111 -> 11;
                    case 112 -> 191;
                    case 113 -> 252;
                    case 114 -> 108;
                    case 115 -> 0;
                    case 116 -> 48;
                    case 117 -> 44;
                    case 118 -> 153;
                    case 119 -> 14;
                    case 120 -> 160;
                    case 121 -> 38;
                    case 122 -> 141;
                    case 123 -> 244;
                    case 124 -> 227;
                    case 125 -> 238;
                    case 126 -> 163;
                    case 127 -> 167;
                    case 128 -> 102;
                    case 129 -> 77;
                    case 130 -> 123;
                    case 131 -> 86;
                    case 132 -> 149;
                    case 133 -> 145;
                    case 134 -> 128;
                    case 135 -> 129;
                    case 136 -> 85;
                    case 137 -> 205;
                    case 138 -> 180;
                    case 139 -> 20;
                    case 140 -> 46;
                    case 141 -> 159;
                    case 142 -> 1;
                    case 143 -> 28;
                    case 144 -> 210;
                    case 145 -> 240;
                    case 146 -> 182;
                    case 147 -> 172;
                    case 148 -> 120;
                    case 149 -> 114;
                    case 150 -> 215;
                    case 151 -> 192;
                    case 152 -> 45;
                    case 153 -> 246;
                    case 154 -> 70;
                    case 155 -> 255;
                    case 156 -> 18;
                    case 157 -> 203;
                    case 158 -> 63;
                    case 159 -> 29;
                    case 160 -> 30;
                    case 161 -> 122;
                    case 162 -> 16;
                    case 163 -> 95;
                    case 164 -> 31;
                    case 165 -> 139;
                    case 166 -> 130;
                    case 167 -> 187;
                    case 168 -> 155;
                    case 169 -> 13;
                    case 170 -> 204;
                    case 171 -> 81;
                    case 172 -> 25;
                    case 173 -> 242;
                    case 174 -> 152;
                    case 175 -> 39;
                    case 176 -> 113;
                    case 177 -> 214;
                    case 178 -> 110;
                    case 179 -> 241;
                    case 180 -> 229;
                    case 181 -> 34;
                    case 182 -> 207;
                    case 183 -> 151;
                    case 184 -> 133;
                    case 185 -> 228;
                    case 186 -> 148;
                    case 187 -> 239;
                    case 188 -> 235;
                    case 189 -> 197;
                    case 190 -> 88;
                    case 191 -> 249;
                    case 192 -> 181;
                    case 193 -> 198;
                    case 194 -> 54;
                    case 195 -> 82;
                    case 196 -> 164;
                    case 197 -> 230;
                    case 198 -> 168;
                    case 199 -> 17;
                    case 200 -> 206;
                    case 201 -> 196;
                    case 202 -> 218;
                    case 203 -> 251;
                    case 204 -> 107;
                    case 205 -> 101;
                    case 206 -> 189;
                    case 207 -> 24;
                    case 208 -> 200;
                    case 209 -> 243;
                    case 210 -> 220;
                    case 211 -> 87;
                    case 212 -> 245;
                    case 213 -> 40;
                    case 214 -> 10;
                    case 215 -> 56;
                    case 216 -> 233;
                    case 217 -> 19;
                    case 218 -> 21;
                    case 219 -> 126;
                    case 220 -> 97;
                    case 221 -> 99;
                    case 222 -> 143;
                    case 223 -> 93;
                    case 224 -> 7;
                    case 225 -> 174;
                    case 226 -> 250;
                    case 227 -> 169;
                    case 228 -> 157;
                    case 229 -> 236;
                    case 230 -> 76;
                    case 231 -> 116;
                    case 232 -> 166;
                    case 233 -> 83;
                    case 234 -> 104;
                    case 235 -> 91;
                    case 236 -> 36;
                    case 237 -> 190;
                    case 238 -> 173;
                    case 239 -> 26;
                    case 240 -> 124;
                    case 241 -> 71;
                    case 242 -> 117;
                    case 243 -> 4;
                    case 244 -> 165;
                    case 245 -> 12;
                    case 246 -> 138;
                    case 247 -> 147;
                    case 248 -> 176;
                    case 249 -> 43;
                    case 250 -> 170;
                    case 251 -> 193;
                    case 252 -> 96;
                    case 253 -> 64;
                    case 254 -> 61;
                    default -> 224;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 132991915876977L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "_\u001bA\t\u0019\u00192\u0006\tX\u0011R\u0003T[/\u001aW";
                    var5_4 = "_\u001bA\t\u0019\u00192\u0006\tX\u0011R\u0003T[/\u001aW".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 50;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 6;
                                    break;
                                }
                                case 1: {
                                    v11 = 76;
                                    break;
                                }
                                case 2: {
                                    v11 = 1;
                                    break;
                                }
                                case 3: {
                                    v11 = 85;
                                    break;
                                }
                                case 4: {
                                    v11 = 78;
                                    break;
                                }
                                case 5: {
                                    v11 = 71;
                                    break;
                                }
                                default: {
                                    v11 = 51;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 27947107945879L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "/\u001aW$=H\b\u0004)\u0004[>\n%\u001bP>1J\u0010\u000f\u001aY\t%\u001bP>1J\u0010\u0003\u0010\r\"\u001dM3;G\n\u0003\u0017J9:N";
                    var5_4 = "/\u001aW$=H\b\u0004)\u0004[>\n%\u001bP>1J\u0010\u000f\u001aY\t%\u001bP>1J\u0010\u0003\u0010\r\"\u001dM3;G\n\u0003\u0017J9:N".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 55;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0019$m\u001f\u0001{?\u0006\u0019$m\u001f\rq";
                        var5_4 = "\u0019$m\u001f\u0001{?\u0006\u0019$m\u001f\rq".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 11;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 81;
                                break;
                            }
                            case 1: {
                                v15 = 67;
                                break;
                            }
                            case 2: {
                                v15 = 9;
                                break;
                            }
                            case 3: {
                                v15 = 103;
                                break;
                            }
                            case 4: {
                                v15 = 99;
                                break;
                            }
                            case 5: {
                                v15 = 30;
                                break;
                            }
                            default: {
                                v15 = 83;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 122966898081314L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1984399800 - 19972, 1984399800 - 26328, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 42944505368090L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u008c\u001c\u00a3\u00b2\u00da\u0003O;o\u0005\u0096\u00e4\u00c6i\u0095\r\u00fe|\u00fd0\u0007:\u00cb\u00e9N\u008d8\u00c8\u00bc\u0010!#\u00c10\u00bf\u00af\u00f7f\u0000\u00f8\u0012+\u001f\u00b1\u00c9\u009e\u0005=\u00be\u00b3\";3d6\u0089Dce\\+\b\u00ac\u0098\u0088\u0088\u0094\u0017%\u00ae\u00ef\u009b\u00fa\u0080$Y\u001d\u001d\u00e0}P\u0017\r\u00919\u00be\u00d8\u00ac\u00beRN\u0019\u0098;\u001a\u00c4\u00b6\u00c7\u00b8\u00bb\u00c2?\u00ea)";
                    var4_3 = "\u008c\u001c\u00a3\u00b2\u00da\u0003O;o\u0005\u0096\u00e4\u00c6i\u0095\r\u00fe|\u00fd0\u0007:\u00cb\u00e9N\u008d8\u00c8\u00bc\u0010!#\u00c10\u00bf\u00af\u00f7f\u0000\u00f8\u0012+\u001f\u00b1\u00c9\u009e\u0005=\u00be\u00b3\";3d6\u0089Dce\\+\b\u00ac\u0098\u0088\u0088\u0094\u0017%\u00ae\u00ef\u009b\u00fa\u0080$Y\u001d\u001d\u00e0}P\u0017\r\u00919\u00be\u00d8\u00ac\u00beRN\u0019\u0098;\u001a\u00c4\u00b6\u00c7\u00b8\u00bb\u00c2?\u00ea)".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 101;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0080)\\\u00d8\u00a5\u001b\u001dY\u00f4\u00b6%KP\u0014\u0089\u0083Lps\u00b5Y\u00b2\u00e3\u0091(\u00ec\u000b\u008aE\u00ab[e\u0013LQ\u0091r\u0000\u00f8\u00ca\u008d\u00e5\u00b0\u00ee56A\u00f3vKv\u00ca\u00de\u00055`8\u008bZ\u00b4juT\u008f\u00ce\u00e2\u00f6\u00d3\u00f2BB\u0019\u0094\u00bb\u001d[\u009bk0|\u00df\u0011\u00ec<\u00c7\u0017\u00f0\u00a4\u00b6\u009b\u00daf\u0094";
                        var4_3 = "\u0080)\\\u00d8\u00a5\u001b\u001dY\u00f4\u00b6%KP\u0014\u0089\u0083Lps\u00b5Y\u00b2\u00e3\u0091(\u00ec\u000b\u008aE\u00ab[e\u0013LQ\u0091r\u0000\u00f8\u00ca\u008d\u00e5\u00b0\u00ee56A\u00f3vKv\u00ca\u00de\u00055`8\u008bZ\u00b4juT\u008f\u00ce\u00e2\u00f6\u00d3\u00f2BB\u0019\u0094\u00bb\u001d[\u009bk0|\u00df\u0011\u00ec<\u00c7\u0017\u00f0\u00a4\u00b6\u009b\u00daf\u0094".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 73;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 44;
                                break;
                            }
                            case 1: {
                                v15 = 32;
                                break;
                            }
                            case 2: {
                                v15 = 86;
                                break;
                            }
                            case 3: {
                                v15 = 25;
                                break;
                            }
                            case 4: {
                                v15 = 16;
                                break;
                            }
                            case 5: {
                                v15 = 80;
                                break;
                            }
                            default: {
                                v15 = 28;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x4596) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 191;
                    case 1 -> 244;
                    case 2 -> 109;
                    case 3 -> 38;
                    case 4 -> 102;
                    case 5 -> 14;
                    case 6 -> 116;
                    case 7 -> 225;
                    case 8 -> 64;
                    case 9 -> 54;
                    case 10 -> 74;
                    case 11 -> 91;
                    case 12 -> 24;
                    case 13 -> 187;
                    case 14 -> 3;
                    case 15 -> 194;
                    case 16 -> 151;
                    case 17 -> 199;
                    case 18 -> 129;
                    case 19 -> 36;
                    case 20 -> 4;
                    case 21 -> 144;
                    case 22 -> 156;
                    case 23 -> 172;
                    case 24 -> 75;
                    case 25 -> 149;
                    case 26 -> 61;
                    case 27 -> 148;
                    case 28 -> 120;
                    case 29 -> 90;
                    case 30 -> 234;
                    case 31 -> 140;
                    case 32 -> 210;
                    case 33 -> 250;
                    case 34 -> 130;
                    case 35 -> 162;
                    case 36 -> 185;
                    case 37 -> 113;
                    case 38 -> 17;
                    case 39 -> 105;
                    case 40 -> 164;
                    case 41 -> 110;
                    case 42 -> 212;
                    case 43 -> 235;
                    case 44 -> 224;
                    case 45 -> 150;
                    case 46 -> 58;
                    case 47 -> 167;
                    case 48 -> 92;
                    case 49 -> 207;
                    case 50 -> 28;
                    case 51 -> 21;
                    case 52 -> 168;
                    case 53 -> 124;
                    case 54 -> 12;
                    case 55 -> 170;
                    case 56 -> 242;
                    case 57 -> 206;
                    case 58 -> 237;
                    case 59 -> 205;
                    case 60 -> 232;
                    case 61 -> 220;
                    case 62 -> 186;
                    case 63 -> 233;
                    case 64 -> 175;
                    case 65 -> 254;
                    case 66 -> 49;
                    case 67 -> 198;
                    case 68 -> 39;
                    case 69 -> 184;
                    case 70 -> 10;
                    case 71 -> 72;
                    case 72 -> 41;
                    case 73 -> 213;
                    case 74 -> 253;
                    case 75 -> 31;
                    case 76 -> 5;
                    case 77 -> 81;
                    case 78 -> 147;
                    case 79 -> 45;
                    case 80 -> 249;
                    case 81 -> 171;
                    case 82 -> 216;
                    case 83 -> 163;
                    case 84 -> 146;
                    case 85 -> 218;
                    case 86 -> 131;
                    case 87 -> 7;
                    case 88 -> 181;
                    case 89 -> 44;
                    case 90 -> 221;
                    case 91 -> 79;
                    case 92 -> 179;
                    case 93 -> 246;
                    case 94 -> 152;
                    case 95 -> 89;
                    case 96 -> 96;
                    case 97 -> 134;
                    case 98 -> 190;
                    case 99 -> 29;
                    case 100 -> 169;
                    case 101 -> 119;
                    case 102 -> 26;
                    case 103 -> 123;
                    case 104 -> 165;
                    case 105 -> 241;
                    case 106 -> 161;
                    case 107 -> 67;
                    case 108 -> 19;
                    case 109 -> 69;
                    case 110 -> 32;
                    case 111 -> 226;
                    case 112 -> 77;
                    case 113 -> 95;
                    case 114 -> 180;
                    case 115 -> 173;
                    case 116 -> 114;
                    case 117 -> 145;
                    case 118 -> 139;
                    case 119 -> 25;
                    case 120 -> 176;
                    case 121 -> 174;
                    case 122 -> 20;
                    case 123 -> 65;
                    case 124 -> 188;
                    case 125 -> 126;
                    case 126 -> 122;
                    case 127 -> 155;
                    case 128 -> 103;
                    case 129 -> 18;
                    case 130 -> 159;
                    case 131 -> 87;
                    case 132 -> 11;
                    case 133 -> 53;
                    case 134 -> 55;
                    case 135 -> 115;
                    case 136 -> 214;
                    case 137 -> 104;
                    case 138 -> 157;
                    case 139 -> 66;
                    case 140 -> 71;
                    case 141 -> 73;
                    case 142 -> 238;
                    case 143 -> 248;
                    case 144 -> 37;
                    case 145 -> 84;
                    case 146 -> 158;
                    case 147 -> 178;
                    case 148 -> 1;
                    case 149 -> 200;
                    case 150 -> 202;
                    case 151 -> 183;
                    case 152 -> 201;
                    case 153 -> 166;
                    case 154 -> 121;
                    case 155 -> 195;
                    case 156 -> 133;
                    case 157 -> 189;
                    case 158 -> 227;
                    case 159 -> 203;
                    case 160 -> 52;
                    case 161 -> 192;
                    case 162 -> 118;
                    case 163 -> 8;
                    case 164 -> 35;
                    case 165 -> 16;
                    case 166 -> 197;
                    case 167 -> 100;
                    case 168 -> 68;
                    case 169 -> 13;
                    case 170 -> 27;
                    case 171 -> 99;
                    case 172 -> 143;
                    case 173 -> 56;
                    case 174 -> 204;
                    case 175 -> 111;
                    case 176 -> 252;
                    case 177 -> 211;
                    case 178 -> 228;
                    case 179 -> 57;
                    case 180 -> 215;
                    case 181 -> 22;
                    case 182 -> 135;
                    case 183 -> 107;
                    case 184 -> 42;
                    case 185 -> 142;
                    case 186 -> 50;
                    case 187 -> 23;
                    case 188 -> 62;
                    case 189 -> 128;
                    case 190 -> 153;
                    case 191 -> 245;
                    case 192 -> 219;
                    case 193 -> 94;
                    case 194 -> 101;
                    case 195 -> 208;
                    case 196 -> 43;
                    case 197 -> 30;
                    case 198 -> 108;
                    case 199 -> 177;
                    case 200 -> 193;
                    case 201 -> 93;
                    case 202 -> 6;
                    case 203 -> 127;
                    case 204 -> 97;
                    case 205 -> 2;
                    case 206 -> 240;
                    case 207 -> 47;
                    case 208 -> 255;
                    case 209 -> 231;
                    case 210 -> 63;
                    case 211 -> 78;
                    case 212 -> 112;
                    case 213 -> 230;
                    case 214 -> 182;
                    case 215 -> 59;
                    case 216 -> 40;
                    case 217 -> 86;
                    case 218 -> 243;
                    case 219 -> 106;
                    case 220 -> 83;
                    case 221 -> 76;
                    case 222 -> 15;
                    case 223 -> 85;
                    case 224 -> 125;
                    case 225 -> 48;
                    case 226 -> 251;
                    case 227 -> 88;
                    case 228 -> 98;
                    case 229 -> 209;
                    case 230 -> 33;
                    case 231 -> 239;
                    case 232 -> 160;
                    case 233 -> 138;
                    case 234 -> 141;
                    case 235 -> 9;
                    case 236 -> 60;
                    case 237 -> 51;
                    case 238 -> 46;
                    case 239 -> 132;
                    case 240 -> 247;
                    case 241 -> 196;
                    case 242 -> 229;
                    case 243 -> 236;
                    case 244 -> 217;
                    case 245 -> 70;
                    case 246 -> 117;
                    case 247 -> 80;
                    case 248 -> 137;
                    case 249 -> 222;
                    case 250 -> 82;
                    case 251 -> 34;
                    case 252 -> 223;
                    case 253 -> 154;
                    case 254 -> 136;
                    default -> 0;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 16301582685055L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-2113110540 + -((char)-22550), -2113110540 + -((char)-11259), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 64292718839428L;
                    String string = SshAgentIpcService.J();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1353428820 - 27492, 1353428820 - (char)-25605, (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 56681344333089L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00d9~\u00da\u00c9\u00ac\u0003qs\u0099";
                var4_3 = "\u00d9~\u00da\u00c9\u00ac\u0003qs\u0099".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 7;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 19;
                                break;
                            }
                            case 1: {
                                v11 = 72;
                                break;
                            }
                            case 2: {
                                v11 = 76;
                                break;
                            }
                            case 3: {
                                v11 = 13;
                                break;
                            }
                            case 4: {
                                v11 = 36;
                                break;
                            }
                            case 5: {
                                v11 = 37;
                                break;
                            }
                            default: {
                                v11 = 77;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x4575) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 32;
                    case 1 -> 157;
                    case 2 -> 115;
                    case 3 -> 88;
                    case 4 -> 218;
                    case 5 -> 233;
                    case 6 -> 231;
                    case 7 -> 86;
                    case 8 -> 151;
                    case 9 -> 179;
                    case 10 -> 51;
                    case 11 -> 197;
                    case 12 -> 66;
                    case 13 -> 6;
                    case 14 -> 17;
                    case 15 -> 103;
                    case 16 -> 214;
                    case 17 -> 232;
                    case 18 -> 170;
                    case 19 -> 23;
                    case 20 -> 126;
                    case 21 -> 220;
                    case 22 -> 78;
                    case 23 -> 227;
                    case 24 -> 251;
                    case 25 -> 238;
                    case 26 -> 12;
                    case 27 -> 239;
                    case 28 -> 46;
                    case 29 -> 44;
                    case 30 -> 208;
                    case 31 -> 21;
                    case 32 -> 24;
                    case 33 -> 125;
                    case 34 -> 142;
                    case 35 -> 166;
                    case 36 -> 181;
                    case 37 -> 229;
                    case 38 -> 9;
                    case 39 -> 81;
                    case 40 -> 136;
                    case 41 -> 72;
                    case 42 -> 185;
                    case 43 -> 73;
                    case 44 -> 215;
                    case 45 -> 188;
                    case 46 -> 209;
                    case 47 -> 108;
                    case 48 -> 70;
                    case 49 -> 234;
                    case 50 -> 109;
                    case 51 -> 89;
                    case 52 -> 87;
                    case 53 -> 169;
                    case 54 -> 129;
                    case 55 -> 100;
                    case 56 -> 222;
                    case 57 -> 90;
                    case 58 -> 33;
                    case 59 -> 143;
                    case 60 -> 204;
                    case 61 -> 195;
                    case 62 -> 74;
                    case 63 -> 106;
                    case 64 -> 180;
                    case 65 -> 92;
                    case 66 -> 61;
                    case 67 -> 80;
                    case 68 -> 206;
                    case 69 -> 175;
                    case 70 -> 164;
                    case 71 -> 31;
                    case 72 -> 203;
                    case 73 -> 22;
                    case 74 -> 49;
                    case 75 -> 59;
                    case 76 -> 128;
                    case 77 -> 4;
                    case 78 -> 30;
                    case 79 -> 196;
                    case 80 -> 216;
                    case 81 -> 8;
                    case 82 -> 36;
                    case 83 -> 50;
                    case 84 -> 1;
                    case 85 -> 48;
                    case 86 -> 243;
                    case 87 -> 255;
                    case 88 -> 253;
                    case 89 -> 249;
                    case 90 -> 132;
                    case 91 -> 159;
                    case 92 -> 67;
                    case 93 -> 117;
                    case 94 -> 37;
                    case 95 -> 177;
                    case 96 -> 183;
                    case 97 -> 163;
                    case 98 -> 149;
                    case 99 -> 96;
                    case 100 -> 156;
                    case 101 -> 199;
                    case 102 -> 130;
                    case 103 -> 97;
                    case 104 -> 194;
                    case 105 -> 201;
                    case 106 -> 52;
                    case 107 -> 127;
                    case 108 -> 139;
                    case 109 -> 29;
                    case 110 -> 104;
                    case 111 -> 77;
                    case 112 -> 189;
                    case 113 -> 184;
                    case 114 -> 68;
                    case 115 -> 165;
                    case 116 -> 193;
                    case 117 -> 0;
                    case 118 -> 140;
                    case 119 -> 63;
                    case 120 -> 69;
                    case 121 -> 83;
                    case 122 -> 121;
                    case 123 -> 34;
                    case 124 -> 242;
                    case 125 -> 76;
                    case 126 -> 54;
                    case 127 -> 82;
                    case 128 -> 137;
                    case 129 -> 134;
                    case 130 -> 16;
                    case 131 -> 168;
                    case 132 -> 85;
                    case 133 -> 43;
                    case 134 -> 38;
                    case 135 -> 41;
                    case 136 -> 118;
                    case 137 -> 39;
                    case 138 -> 53;
                    case 139 -> 119;
                    case 140 -> 58;
                    case 141 -> 131;
                    case 142 -> 182;
                    case 143 -> 226;
                    case 144 -> 153;
                    case 145 -> 174;
                    case 146 -> 158;
                    case 147 -> 111;
                    case 148 -> 148;
                    case 149 -> 79;
                    case 150 -> 192;
                    case 151 -> 113;
                    case 152 -> 172;
                    case 153 -> 211;
                    case 154 -> 247;
                    case 155 -> 101;
                    case 156 -> 13;
                    case 157 -> 250;
                    case 158 -> 110;
                    case 159 -> 205;
                    case 160 -> 173;
                    case 161 -> 224;
                    case 162 -> 240;
                    case 163 -> 161;
                    case 164 -> 116;
                    case 165 -> 2;
                    case 166 -> 230;
                    case 167 -> 147;
                    case 168 -> 71;
                    case 169 -> 112;
                    case 170 -> 162;
                    case 171 -> 191;
                    case 172 -> 213;
                    case 173 -> 225;
                    case 174 -> 35;
                    case 175 -> 95;
                    case 176 -> 62;
                    case 177 -> 145;
                    case 178 -> 186;
                    case 179 -> 65;
                    case 180 -> 26;
                    case 181 -> 236;
                    case 182 -> 241;
                    case 183 -> 171;
                    case 184 -> 200;
                    case 185 -> 217;
                    case 186 -> 124;
                    case 187 -> 28;
                    case 188 -> 219;
                    case 189 -> 235;
                    case 190 -> 167;
                    case 191 -> 7;
                    case 192 -> 221;
                    case 193 -> 107;
                    case 194 -> 3;
                    case 195 -> 154;
                    case 196 -> 27;
                    case 197 -> 207;
                    case 198 -> 15;
                    case 199 -> 202;
                    case 200 -> 60;
                    case 201 -> 91;
                    case 202 -> 20;
                    case 203 -> 64;
                    case 204 -> 190;
                    case 205 -> 228;
                    case 206 -> 18;
                    case 207 -> 198;
                    case 208 -> 141;
                    case 209 -> 254;
                    case 210 -> 56;
                    case 211 -> 160;
                    case 212 -> 155;
                    case 213 -> 55;
                    case 214 -> 212;
                    case 215 -> 10;
                    case 216 -> 248;
                    case 217 -> 98;
                    case 218 -> 99;
                    case 219 -> 114;
                    case 220 -> 57;
                    case 221 -> 245;
                    case 222 -> 252;
                    case 223 -> 47;
                    case 224 -> 42;
                    case 225 -> 84;
                    case 226 -> 5;
                    case 227 -> 75;
                    case 228 -> 122;
                    case 229 -> 237;
                    case 230 -> 246;
                    case 231 -> 176;
                    case 232 -> 40;
                    case 233 -> 102;
                    case 234 -> 144;
                    case 235 -> 19;
                    case 236 -> 105;
                    case 237 -> 120;
                    case 238 -> 178;
                    case 239 -> 150;
                    case 240 -> 187;
                    case 241 -> 138;
                    case 242 -> 11;
                    case 243 -> 152;
                    case 244 -> 210;
                    case 245 -> 135;
                    case 246 -> 146;
                    case 247 -> 25;
                    case 248 -> 93;
                    case 249 -> 223;
                    case 250 -> 45;
                    case 251 -> 133;
                    case 252 -> 94;
                    case 253 -> 244;
                    case 254 -> 14;
                    default -> 123;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

