/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;

public class BasicMetaProperty<E extends BasicElement, T>
implements BasicMetaField<E> {
    public static final int ORDINARY_PROP = 0;
    public static final int INTERNAL_PROP = 1;
    public static final int ABSTRACT_PROP = 2;
    public final BasicMetaPropertyId<T> id;
    public final Function<E, T> getter;
    public final PairConsumer<E, T> setter;
    public final int flags;
    protected Object defOrDesc;

    public BasicMetaProperty(BasicMetaPropertyId<T> id, T def, Function<E, T> getter, PairConsumer<E, T> setter, int flags) {
        this(id, getter, setter, flags, def);
    }

    protected BasicMetaProperty(BasicMetaPropertyId<T> id, Function<E, T> getter, PairConsumer<E, T> setter, int flags, Object defOrDesc) {
        this.id = id;
        this.defOrDesc = defOrDesc;
        this.getter = getter;
        this.setter = setter;
        this.flags = flags;
    }

    public BasicMetaProperty<E, T> copy() {
        return new BasicMetaProperty<E, T>(this.id, this.getter, this.setter, this.flags, this.defOrDesc);
    }

    @Override
    public boolean isAbstract() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isInternal() {
        return (this.flags & 1) != 0;
    }

    public T get(E obj) {
        return (T)this.getter.fun(obj);
    }

    public void set(E obj, T val) {
        this.setter.consume(obj, val);
    }

    public <U> BasicMetaProperty<E, U> tryCast(@NotNull Class<U> clazz) {
        if (clazz == null) {
            BasicMetaProperty.$$$reportNull$$$0(0);
        }
        if (clazz.isAssignableFrom(this.id.getValueClass())) {
            return this;
        }
        return null;
    }

    public <U> BasicMetaProperty<E, U> asId(@NotNull BasicMetaPropertyId<U> id) {
        if (id == null) {
            BasicMetaProperty.$$$reportNull$$$0(1);
        }
        if (this.id == id) {
            return this.tryCast(id.getValueClass());
        }
        return null;
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    @NotNull
    public BasicMetaPropertyId<T> getId() {
        BasicMetaPropertyId<T> basicMetaPropertyId = this.id;
        if (basicMetaPropertyId == null) {
            BasicMetaProperty.$$$reportNull$$$0(2);
        }
        return basicMetaPropertyId;
    }

    public T getDefaultValue() {
        return (T)this.defOrDesc;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaProperty";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "asId";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

