/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.actions;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.server.JupyterServer;
import com.intellij.jupyter.core.jupyter.connections.server.JupyterServers;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelSpec;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"getMostSuitableKernelSpec", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelSpec;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getPython3KernelSpec", "intellij.jupyter.py"})
public final class JupyterKernelSpecGuesserKt {
    @Nullable
    public static final JupyterKernelSpec getMostSuitableKernelSpec(@Nullable BackedNotebookVirtualFile virtualFile, @NotNull Project project) {
        JupyterKernelSpec jupyterKernelSpec;
        JupyterServerConfig config;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JupyterServerConfig jupyterServerConfig = config = JupyterConnectionSettingsManager.Companion.getInstance().getConfigForVirtualFileOrDefault(virtualFile, project);
        if (jupyterServerConfig instanceof JupyterManagedServerConfig) {
            jupyterKernelSpec = JupyterKernelSpecGuesserKt.getPython3KernelSpec();
        } else if (jupyterServerConfig instanceof JupyterConfiguredServerConfig) {
            JupyterConnectionParameters connectionParameters = ((JupyterConfiguredServerConfig)config).getConnectionParameters(project, virtualFile);
            JupyterServer server = JupyterServers.Companion.getInstance().getCachedServer(connectionParameters);
            jupyterKernelSpec = server;
            if (jupyterKernelSpec == null || (jupyterKernelSpec = jupyterKernelSpec.getDefaultKernel()) == null) {
                jupyterKernelSpec = JupyterKernelSpecGuesserKt.getPython3KernelSpec();
            }
        } else {
            jupyterKernelSpec = JupyterKernelSpecGuesserKt.getPython3KernelSpec();
        }
        return jupyterKernelSpec;
    }

    @NotNull
    public static final JupyterKernelSpec getPython3KernelSpec() {
        return (JupyterKernelSpec)new JupyterKernelBase("Python 3", "python", "python3", null, null, 24, null);
    }
}

