/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.wsl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.python.wsl.PyWSLProcessHandler;
import com.intellij.python.wsl.PyWSLSocketProvider;
import com.intellij.python.wsl.PyWSLUtilsKt;
import com.intellij.python.wsl.PythonWslBundle;
import com.intellij.wsl.remoteSdk.WSLCredentialsHolder;
import com.intellij.wsl.remoteSdk.WSLCredentialsType;
import com.jetbrains.python.Result;
import com.jetbrains.python.console.PydevConsoleCli;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleCommunicationClient;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.extensions.ProgressManagerExtKt;
import com.jetbrains.python.remote.PyRemoteInterpreterUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001a\u001a\n \u001b*\u0004\u0018\u00010\u00140\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/python/wsl/PyWSLConsoleCreator;", "Lcom/jetbrains/python/console/PythonConsoleRemoteProcessCreator;", "Lcom/intellij/wsl/remoteSdk/WSLCredentialsHolder;", "<init>", "()V", "credentialsType", "Lcom/intellij/wsl/remoteSdk/WSLCredentialsType;", "getCredentialsType", "()Lcom/intellij/wsl/remoteSdk/WSLCredentialsType;", "createRemoteConsoleProcess", "Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "runnerFileFromHelpers", "", "credentials", "createClient", "Lcom/jetbrains/python/console/PydevConsoleCommunicationClient;", "process", "Ljava/lang/Process;", "getLinuxIp", "kotlin.jvm.PlatformType", "intellij.python.wsl"})
public final class PyWSLConsoleCreator
implements PythonConsoleRemoteProcessCreator<WSLCredentialsHolder> {
    @NotNull
    public WSLCredentialsType getCredentialsType() {
        WSLCredentialsType wSLCredentialsType = WSLCredentialsType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)wSLCredentialsType, (String)"getInstance(...)");
        return wSLCredentialsType;
    }

    @NotNull
    public RemoteConsoleProcessData createRemoteConsoleProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, @NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @NotNull String runnerFileFromHelpers, @NotNull WSLCredentialsHolder credentials) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)pathMapper, (String)"pathMapper");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)runnerFileFromHelpers, (String)"runnerFileFromHelpers");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        File dir = commandLine.getWorkDirectory();
        boolean bl = false;
        if (!dir.exists()) {
            String string = credentials.getDistribution().getWindowsPath(FileUtil.toSystemIndependentName((String)dir.getPath()));
            if (string != null) {
                String winPath = string;
                boolean bl2 = false;
                commandLine.setWorkDirectory(new File(winPath));
            }
        }
        PydevConsoleCli.setupPythonConsoleScriptInServerMode$default((GeneralCommandLine)commandLine, (SdkAdditionalData)((SdkAdditionalData)data), null, (int)2, null);
        PyWSLProcessHandler processHandler = PyWSLUtilsKt.startWslProcess$default(project, commandLine, data, false, null, false, 32, null);
        Process process = processHandler.getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
        Process process2 = process;
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        String string = PythonWslBundle.message("wsl.accessing_wsl", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        PydevConsoleCommunicationClient client = (PydevConsoleCommunicationClient)ProgressManagerExtKt.runUnderProgress((ProgressManager)progressManager, (String)string, () -> PyWSLConsoleCreator.createRemoteConsoleProcess$lambda$1(this, process2, project, data));
        client.connect();
        PyWSLSocketProvider socketProvider = new PyWSLSocketProvider(project, data);
        PyRemoteInterpreterUtil.closeOnProcessTermination((ProcessHandler)((ProcessHandler)processHandler), (Closeable)((Closeable)((Object)socketProvider)));
        PydevConsoleCommunication pydevConsoleCommunication = (PydevConsoleCommunication)client;
        String string2 = processHandler.getCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCommandLine(...)");
        return new RemoteConsoleProcessData(pydevConsoleCommunication, string2, process2, (PyRemoteSocketToLocalHostProvider)socketProvider);
    }

    private final PydevConsoleCommunicationClient createClient(Process process, Project project, PyRemoteSdkAdditionalDataBase data) {
        int remotePort = PydevConsoleRunnerImpl.getRemotePortFromProcess((Process)process);
        String ip = this.getLinuxIp(project, data);
        Intrinsics.checkNotNull((Object)ip);
        return new PydevConsoleCommunicationClient(project, ip, remotePort, process);
    }

    private final String getLinuxIp(Project project, PyRemoteSdkAdditionalDataBase data) {
        String string;
        if (PyWSLUtilsKt.isWsl1(project, data)) {
            string = "127.0.0.1";
        } else {
            Result<WSLDistribution, String> wsl2Ip = PyWSLUtilsKt.getDistribution(data);
            if (wsl2Ip instanceof Result.Success) {
                string = ((WSLDistribution)((Result.Success)wsl2Ip).getResult()).getWslIpAddress().getHostAddress();
            } else if (wsl2Ip instanceof Result.Failure) {
                Logger.getInstance(PyWSLConsoleCreator.class).warn("Can't get linux ip: " + ((Result.Failure)wsl2Ip).getError());
                string = "127.0.0.1";
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final PydevConsoleCommunicationClient createRemoteConsoleProcess$lambda$1(PyWSLConsoleCreator this$0, Process $process, Project $project, PyRemoteSdkAdditionalDataBase $data) {
        return this$0.createClient($process, $project, $data);
    }
}

