/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerService;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.PlatformUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

final class UltimateUpdateCheckerService
extends UpdateCheckerService {
    private static final Logger LOG = Logger.getInstance(UltimateUpdateCheckerService.class);
    private final AtomicBoolean myFirstCheckPending = new AtomicBoolean(true);
    private final AtomicBoolean myFirstCheckAllowed = new AtomicBoolean(false);

    UltimateUpdateCheckerService() {
    }

    public void scheduleFirstCheck(UpdateSettings settings) {
        if (this.myFirstCheckAllowed.get()) {
            super.scheduleFirstCheck(settings);
        } else {
            LOG.debug("update check blocked");
        }
    }

    private void J() {
        if (this.myFirstCheckPending.getAndSet(false)) {
            LOG.debug("triggering update check");
            if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
                super.scheduleFirstCheck(UpdateSettings.getInstance());
            } else {
                this.myFirstCheckAllowed.set(true);
            }
        }
    }

    static final class LicenseStateListener
    implements LicensingFacade.LicenseStateListener {
        LicenseStateListener() {
        }

        public void licenseStateChanged(@Nullable LicensingFacade newState) {
            if (newState != null && (newState.licensedTo != null || LicenseStateListener.J())) {
                ((UltimateUpdateCheckerService)UpdateCheckerService.getInstance()).J();
            }
        }

        private static boolean J() {
            return (PlatformUtils.isIdeaUltimate() || PlatformUtils.isPyCharm()) && PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID);
        }
    }
}

