/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.highlighting;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.highlighting.LspDocumentHighlightingCacheKt;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00052\u0014\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u0013H\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J.\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/lsp/impl/highlighting/LspDocumentHighlightingCache;", "", "LspDocumentHighlightingCache", "()V", "lastPosition", "Lorg/eclipse/lsp4j/Position;", "lastFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "lastPsiModificationCount", "", "lastResult", "", "Lorg/eclipse/lsp4j/DocumentHighlight;", "getOrCompute", "project", "Lcom/intellij/openapi/project/Project;", "file", "position", "compute", "Lkotlin/Function0;", "clearCache", "", "J", "psiModCount", "payload", "J", "", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspDocumentHighlightingCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspDocumentHighlightingCache.kt\ncom/intellij/platform/lsp/impl/highlighting/LspDocumentHighlightingCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1761#2,3:65\n*S KotlinDebug\n*F\n+ 1 LspDocumentHighlightingCache.kt\ncom/intellij/platform/lsp/impl/highlighting/LspDocumentHighlightingCache\n*L\n59#1:65,3\n*E\n"})
public final class LspDocumentHighlightingCache {
    @Nullable
    private Position lastPosition;
    @Nullable
    private VirtualFile lastFile;
    private long lastPsiModificationCount = -1L;
    @Nullable
    private List<? extends DocumentHighlight> lastResult;

    @RequiresBackgroundThread
    @Nullable
    public final synchronized List<DocumentHighlight> getOrCompute(@NotNull Project project, @NotNull VirtualFile file, @NotNull Position position, @NotNull Function0<? extends List<? extends DocumentHighlight>> compute) {
        List<? extends DocumentHighlight> list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        ProgressManager.checkCanceled();
        long l2 = PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount();
        List<? extends DocumentHighlight> list2 = list = Intrinsics.areEqual((Object)this.lastFile, (Object)file) && this.lastPsiModificationCount == l2 && this.J(position) ? this.lastResult : null;
        if (list != null) {
            this.lastPosition = position;
            return list;
        }
        List list3 = (List)compute.invoke();
        if (list3 == null) {
            return null;
        }
        List list4 = list3;
        this.J(file, position, l2, list4);
        return list4;
    }

    public final synchronized void clearCache() {
        this.lastPosition = null;
        this.lastFile = null;
        this.lastPsiModificationCount = -1L;
        this.lastResult = null;
    }

    private final void J(VirtualFile virtualFile, Position position, long l2, List<? extends DocumentHighlight> list) {
        this.lastPosition = position;
        this.lastFile = virtualFile;
        this.lastPsiModificationCount = l2;
        this.lastResult = list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean J(Position position) {
        Range range;
        if (Intrinsics.areEqual((Object)this.lastPosition, (Object)position)) return true;
        List<? extends DocumentHighlight> list = this.lastResult;
        if (list == null) return false;
        Iterable iterable = list;
        boolean bl = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return false;
        }
        Iterator iterator = iterable.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object t2 = iterator.next();
            DocumentHighlight documentHighlight = (DocumentHighlight)t2;
            boolean bl2 = false;
            range = documentHighlight.getRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
        } while (!LspDocumentHighlightingCacheKt.access$containsPosition(range, position));
        return true;
    }
}

