/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.parallelStacks.base.view;

import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBLabel;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksColors;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksNodeComponent;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksNodeRealizer;
import com.intellij.xdebugger.impl.parallelStacks.base.view.UpdatableGraph2DView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H$J\b\u0010\u0015\u001a\u00020\u0016H$J\b\u0010\u0017\u001a\u00020\fH\u0002J\b\u0010\u0018\u001a\u00020\fH\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksNodeHeader;", "Lcom/intellij/ui/components/JBLabel;", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksNodeComponent;", "frameRealizer", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksNodeRealizer;", "graphView", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;", "ParallelStacksNodeHeader", "(Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksNodeRealizer;Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;)V", "headerHint", "Lcom/intellij/ui/LightweightHint;", "mouseLeft", "", "onWheelMoved", "mouseMoved", "point", "Ljava/awt/Point;", "activityChanged", "isActive", "", "shouldShowHint", "createHeaderHintComponent", "Ljavax/swing/JComponent;", "J", "k", "J", "intellij.platform.debugger.parallelStacks"})
public abstract class ParallelStacksNodeHeader
extends JBLabel
implements ParallelStacksNodeComponent {
    @NotNull
    private final ParallelStacksNodeRealizer<?> frameRealizer;
    @NotNull
    private final UpdatableGraph2DView graphView;
    @Nullable
    private LightweightHint headerHint;

    public ParallelStacksNodeHeader(@NotNull ParallelStacksNodeRealizer<?> frameRealizer, @NotNull UpdatableGraph2DView graphView) {
        Intrinsics.checkNotNullParameter(frameRealizer, (String)"frameRealizer");
        Intrinsics.checkNotNullParameter((Object)graphView, (String)"graphView");
        this.frameRealizer = frameRealizer;
        this.graphView = graphView;
        this.setName("Header");
    }

    @Override
    public void mouseLeft() {
        this.k();
    }

    @Override
    public void onWheelMoved() {
        this.k();
    }

    @Override
    public void mouseMoved(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (!this.J() && this.shouldShowHint()) {
            this.J();
        }
    }

    @Override
    public void activityChanged(boolean isActive) {
        this.setForeground(isActive ? (Color)ParallelStacksColors.INSTANCE.getACTIVE_HEADER_TEXT_COLOR() : (Color)ParallelStacksColors.INSTANCE.getNODE_HEADER_TEXT_COLOR());
    }

    protected abstract boolean shouldShowHint();

    @NotNull
    protected abstract JComponent createHeaderHintComponent();

    private final void J() {
        JComponent jComponent = this.createHeaderHintComponent();
        LightweightHint lightweightHint = new LightweightHint(jComponent);
        double d2 = this.frameRealizer.J() - this.graphView.k().getX();
        double d3 = this.frameRealizer.v() - this.graphView.k().getY();
        Point point = new Point((int)((d2 + (double)this.getX() + (double)this.getWidth() / 2.0) * this.graphView.J()), (int)((d3 + (double)this.getY() + (double)this.getHeight() / 2.0) * this.graphView.J()));
        HintHint hintHint = new HintHint((Component)this.graphView, point).setPreferredPosition(Balloon.Position.above).setAwtTooltip(true).setShowImmediately(true).setCalloutShift(this.getHeight() / 2 - 1);
        lightweightHint.show((JComponent)this.graphView, point.x, point.y, (JComponent)this.graphView, hintHint);
        this.headerHint = lightweightHint;
    }

    private final void k() {
        block0: {
            LightweightHint lightweightHint = this.headerHint;
            if (lightweightHint == null) break block0;
            lightweightHint.hide();
        }
    }

    private final boolean J() {
        LightweightHint lightweightHint = this.headerHint;
        return lightweightHint != null ? lightweightHint.isVisible() : false;
    }
}

