/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.io.HtmlKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB%\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016J\u0011\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\u0000J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/DataFrameHtmlData;", "", "style", "", "body", "script", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getStyle", "()Ljava/lang/String;", "getBody", "getScript", "toString", "plus", "other", "writeHTML", "", "destination", "Ljava/io/File;", "Ljava/nio/file/Path;", "openInBrowser", "withTableDefinitions", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "", "Companion", "core"})
public final class DataFrameHtmlData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String style;
    @NotNull
    private final String body;
    @NotNull
    private final String script;

    public DataFrameHtmlData(@Language(value="css") @NotNull String style, @Language(value="html", prefix="<body>", suffix="</body>") @NotNull String body, @Language(value="js") @NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.style = style;
        this.body = body;
        this.script = script;
    }

    public /* synthetic */ DataFrameHtmlData(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        this(string, string2, string3);
    }

    @NotNull
    public final String getStyle() {
        return this.style;
    }

    @NotNull
    public final String getBody() {
        return this.body;
    }

    @NotNull
    public final String getScript() {
        return this.script;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$toString_u24lambda_u240.append("<html>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        if (!StringsKt.isBlank((CharSequence)this.style)) {
            StringBuilder stringBuilder3 = $this$toString_u24lambda_u240.append("<head>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder4 = $this$toString_u24lambda_u240.append("<style type=\"text/css\">");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder5 = $this$toString_u24lambda_u240.append(this.style);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder6 = $this$toString_u24lambda_u240.append("</style>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder7 = $this$toString_u24lambda_u240.append("</head>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        }
        if (!StringsKt.isBlank((CharSequence)this.body)) {
            StringBuilder stringBuilder8 = $this$toString_u24lambda_u240.append("<body>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder9 = $this$toString_u24lambda_u240.append(this.body);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder10 = $this$toString_u24lambda_u240.append("</body>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
        }
        if (!StringsKt.isBlank((CharSequence)this.script)) {
            StringBuilder stringBuilder11 = $this$toString_u24lambda_u240.append("<script>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder12 = $this$toString_u24lambda_u240.append(this.script);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder13 = $this$toString_u24lambda_u240.append("</script>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13.append('\n'), (String)"append(...)");
        }
        StringBuilder stringBuilder14 = $this$toString_u24lambda_u240.append("</html>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final DataFrameHtmlData plus(@NotNull DataFrameHtmlData other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new DataFrameHtmlData(StringsKt.isBlank((CharSequence)this.style) ? other.style : (StringsKt.isBlank((CharSequence)other.style) ? this.style : this.style + '\n' + other.style), StringsKt.isBlank((CharSequence)this.body) ? other.body : (StringsKt.isBlank((CharSequence)other.body) ? this.body : this.body + '\n' + other.body), StringsKt.isBlank((CharSequence)this.script) ? other.script : (StringsKt.isBlank((CharSequence)other.script) ? this.script : this.script + '\n' + other.script));
    }

    public final void writeHTML(@NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        FilesKt.writeText$default((File)destination, (String)this.toString(), null, (int)2, null);
    }

    public final void writeHTML(@NotNull Path destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        PathsKt.writeText$default((Path)destination, (CharSequence)this.toString(), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    public final void openInBrowser() {
        File file = File.createTempFile("df_rendering", ".html");
        Intrinsics.checkNotNull((Object)file);
        this.writeHTML(file);
        URI uri = file.toURI();
        Desktop desktop = Desktop.getDesktop();
        desktop.browse(uri);
    }

    @NotNull
    public final DataFrameHtmlData withTableDefinitions() {
        return org.jetbrains.kotlinx.dataframe.io.DataFrameHtmlData$Companion.tableDefinitions$default(Companion, false, false, 3, null).plus(this);
    }

    @NotNull
    public final String component1() {
        return this.style;
    }

    @NotNull
    public final String component2() {
        return this.body;
    }

    @NotNull
    public final String component3() {
        return this.script;
    }

    @NotNull
    public final DataFrameHtmlData copy(@Language(value="css") @NotNull String style, @Language(value="html", prefix="<body>", suffix="</body>") @NotNull String body, @Language(value="js") @NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return new DataFrameHtmlData(style, body, script);
    }

    public static /* synthetic */ DataFrameHtmlData copy$default(DataFrameHtmlData dataFrameHtmlData, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = dataFrameHtmlData.style;
        }
        if ((n & 2) != 0) {
            string2 = dataFrameHtmlData.body;
        }
        if ((n & 4) != 0) {
            string3 = dataFrameHtmlData.script;
        }
        return dataFrameHtmlData.copy(string, string2, string3);
    }

    public int hashCode() {
        int result = this.style.hashCode();
        result = result * 31 + this.body.hashCode();
        result = result * 31 + this.script.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataFrameHtmlData)) {
            return false;
        }
        DataFrameHtmlData dataFrameHtmlData = (DataFrameHtmlData)other;
        if (!Intrinsics.areEqual((Object)this.style, (Object)dataFrameHtmlData.style)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)dataFrameHtmlData.body)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.script, (Object)dataFrameHtmlData.script);
    }

    public DataFrameHtmlData() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/DataFrameHtmlData$Companion;", "", "<init>", "()V", "tableDefinitions", "Lorg/jetbrains/kotlinx/dataframe/io/DataFrameHtmlData;", "includeJs", "", "includeCss", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataFrameHtmlData tableDefinitions(boolean includeJs, boolean includeCss) {
            String string;
            String[] stringArray;
            if (includeCss) {
                stringArray = new String[]{"/table.css"};
                string = HtmlKt.getResources(stringArray);
            } else {
                string = "";
            }
            String string2 = string;
            stringArray = includeJs ? HtmlKt.getResourceText("/init.js", new Pair[0]) : "";
            return new DataFrameHtmlData(string2, "", (String)stringArray);
        }

        public static /* synthetic */ DataFrameHtmlData tableDefinitions$default(Companion companion, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            return companion.tableDefinitions(bl, bl2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

