/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.colab.auth.impl;

import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.gson.GsonFactory;
import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.jupyter.py.colab.auth.impl.GoogleAuthServiceConfig;
import com.intellij.jupyter.py.colab.auth.impl.GoogleCredentials;
import com.intellij.jupyter.py.colab.auth.impl.GoogleOAuthRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Url;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0010\u0011B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/py/colab/auth/impl/GoogleOAuthCredentialsAcquirer;", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "Lcom/intellij/jupyter/py/colab/auth/impl/GoogleCredentials;", "request", "Lcom/intellij/jupyter/py/colab/auth/impl/GoogleOAuthRequest;", "<init>", "(Lcom/intellij/jupyter/py/colab/auth/impl/GoogleOAuthRequest;)V", "codeVerifier", "", "acquireCredentials", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer$AcquireCredentialsResult;", "code", "exchangeCodeForToken", "Lcom/intellij/jupyter/py/colab/auth/impl/GoogleOAuthCredentialsAcquirer$TokenResponse;", "extractEmailFromIdToken", "idToken", "TokenResponse", "Companion", "intellij.jupyter.py.colab"})
@SourceDebugExtension(value={"SMAP\nGoogleOAuthCredentialsAcquirer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleOAuthCredentialsAcquirer.kt\ncom/intellij/jupyter/py/colab/auth/impl/GoogleOAuthCredentialsAcquirer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,100:1\n23#2:101\n23#2:102\n*S KotlinDebug\n*F\n+ 1 GoogleOAuthCredentialsAcquirer.kt\ncom/intellij/jupyter/py/colab/auth/impl/GoogleOAuthCredentialsAcquirer\n*L\n35#1:101\n83#1:102\n*E\n"})
public final class GoogleOAuthCredentialsAcquirer
implements OAuthCredentialsAcquirer<GoogleCredentials> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GoogleOAuthRequest request;
    @NotNull
    private final String codeVerifier;
    @NotNull
    private static final NetHttpTransport httpTransport = new NetHttpTransport();
    private static final GsonFactory jsonFactory = GsonFactory.getDefaultInstance();

    public GoogleOAuthCredentialsAcquirer(@NotNull GoogleOAuthRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        this.codeVerifier = this.request.getCodeVerifier$intellij_jupyter_py_colab();
    }

    @NotNull
    public OAuthCredentialsAcquirer.AcquireCredentialsResult<GoogleCredentials> acquireCredentials(@NotNull String code) {
        OAuthCredentialsAcquirer.AcquireCredentialsResult acquireCredentialsResult;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        try {
            TokenResponse tokenResponse = this.exchangeCodeForToken(code);
            String userEmail = this.extractEmailFromIdToken(tokenResponse.getIdToken());
            String string = tokenResponse.getAccessToken();
            String string2 = tokenResponse.getRefreshToken();
            Long l = tokenResponse.getExpiresInSeconds();
            Long l2 = tokenResponse.getExpiresInSeconds();
            long l3 = System.currentTimeMillis() + (l2 != null ? l2 : 3600L) * (long)1000;
            GoogleCredentials credentials2 = new GoogleCredentials(string, string2, l, userEmail, l3);
            acquireCredentialsResult = (OAuthCredentialsAcquirer.AcquireCredentialsResult)new OAuthCredentialsAcquirer.AcquireCredentialsResult.Success((Credentials)credentials2);
        }
        catch (Exception e) {
            GoogleOAuthCredentialsAcquirer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GoogleOAuthCredentialsAcquirer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to acquire credentials", (Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                string = "Failed to acquire credentials";
            }
            acquireCredentialsResult = (OAuthCredentialsAcquirer.AcquireCredentialsResult)new OAuthCredentialsAcquirer.AcquireCredentialsResult.Error(string);
        }
        return acquireCredentialsResult;
    }

    private final TokenResponse exchangeCodeForToken(String code) {
        Url redirectUri = this.request.getAuthorizationCodeUrl();
        TokenRequest request = new TokenRequest(httpTransport, jsonFactory, GoogleAuthServiceConfig.INSTANCE.getTOKEN_URL(), "authorization_code");
        request.put("client_id", (Object)"745829361237-p4pr918qut71sv8h0ljtq2v8g6ua4bsp.apps.googleusercontent.com");
        request.put("client_secret", (Object)"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");
        request.put("code", (Object)code);
        request.put("code_verifier", (Object)this.codeVerifier);
        request.put("redirect_uri", (Object)redirectUri);
        com.google.api.client.auth.oauth2.TokenResponse response2 = request.execute();
        Object object = response2.get("access_token");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String string = (String)object;
        Object object2 = response2.get("refresh_token");
        String string2 = object2 instanceof String ? (String)object2 : null;
        Object object3 = response2.get("expires_in");
        Number number = object3 instanceof Number ? (Number)((Number)object3) : (Number)null;
        Long l = number != null ? Long.valueOf(number.longValue()) : null;
        Object object4 = response2.get("id_token");
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.String");
        return new TokenResponse(string, string2, l, (String)object4);
    }

    private final String extractEmailFromIdToken(String idToken) {
        String string;
        try {
            String[] stringArray = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)idToken, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 3) {
                throw new IllegalStateException(("idToken has wrong format: " + idToken).toString());
            }
            byte[] byArray = Base64.getUrlDecoder().decode((String)parts.get(1));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            byte[] byArray2 = byArray;
            String payload = new String(byArray2, Charsets.UTF_8);
            JsonParser json = jsonFactory.createJsonParser(payload);
            Map map = json.parse(Map.class);
            Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map claims = map;
            Object v = claims.get("email");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)v;
        }
        catch (Exception e) {
            GoogleOAuthCredentialsAcquirer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GoogleOAuthCredentialsAcquirer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to extract email from id_token", (Throwable)e);
            throw e;
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/py/colab/auth/impl/GoogleOAuthCredentialsAcquirer$Companion;", "", "<init>", "()V", "httpTransport", "Lcom/google/api/client/http/javanet/NetHttpTransport;", "jsonFactory", "Lcom/google/api/client/json/gson/GsonFactory;", "kotlin.jvm.PlatformType", "intellij.jupyter.py.colab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J:\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/py/colab/auth/impl/GoogleOAuthCredentialsAcquirer$TokenResponse;", "", "accessToken", "", "refreshToken", "expiresInSeconds", "", "idToken", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "getRefreshToken", "getExpiresInSeconds", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getIdToken", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;)Lcom/intellij/jupyter/py/colab/auth/impl/GoogleOAuthCredentialsAcquirer$TokenResponse;", "equals", "", "other", "hashCode", "", "toString", "intellij.jupyter.py.colab"})
    private static final class TokenResponse {
        @NotNull
        private final String accessToken;
        @Nullable
        private final String refreshToken;
        @Nullable
        private final Long expiresInSeconds;
        @NotNull
        private final String idToken;

        public TokenResponse(@NotNull String accessToken, @Nullable String refreshToken2, @Nullable Long expiresInSeconds, @NotNull String idToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
            this.accessToken = accessToken;
            this.refreshToken = refreshToken2;
            this.expiresInSeconds = expiresInSeconds;
            this.idToken = idToken;
        }

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        @Nullable
        public final String getRefreshToken() {
            return this.refreshToken;
        }

        @Nullable
        public final Long getExpiresInSeconds() {
            return this.expiresInSeconds;
        }

        @NotNull
        public final String getIdToken() {
            return this.idToken;
        }

        @NotNull
        public final String component1() {
            return this.accessToken;
        }

        @Nullable
        public final String component2() {
            return this.refreshToken;
        }

        @Nullable
        public final Long component3() {
            return this.expiresInSeconds;
        }

        @NotNull
        public final String component4() {
            return this.idToken;
        }

        @NotNull
        public final TokenResponse copy(@NotNull String accessToken, @Nullable String refreshToken2, @Nullable Long expiresInSeconds, @NotNull String idToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
            return new TokenResponse(accessToken, refreshToken2, expiresInSeconds, idToken);
        }

        public static /* synthetic */ TokenResponse copy$default(TokenResponse tokenResponse, String string, String string2, Long l, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = tokenResponse.accessToken;
            }
            if ((n & 2) != 0) {
                string2 = tokenResponse.refreshToken;
            }
            if ((n & 4) != 0) {
                l = tokenResponse.expiresInSeconds;
            }
            if ((n & 8) != 0) {
                string3 = tokenResponse.idToken;
            }
            return tokenResponse.copy(string, string2, l, string3);
        }

        @NotNull
        public String toString() {
            return "TokenResponse(accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", expiresInSeconds=" + this.expiresInSeconds + ", idToken=" + this.idToken + ")";
        }

        public int hashCode() {
            int result = this.accessToken.hashCode();
            result = result * 31 + (this.refreshToken == null ? 0 : this.refreshToken.hashCode());
            result = result * 31 + (this.expiresInSeconds == null ? 0 : ((Object)this.expiresInSeconds).hashCode());
            result = result * 31 + this.idToken.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenResponse)) {
                return false;
            }
            TokenResponse tokenResponse = (TokenResponse)other;
            if (!Intrinsics.areEqual((Object)this.accessToken, (Object)tokenResponse.accessToken)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refreshToken, (Object)tokenResponse.refreshToken)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expiresInSeconds, (Object)tokenResponse.expiresInSeconds)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.idToken, (Object)tokenResponse.idToken);
        }
    }
}

