/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.feature;

import com.jetbrains.mlapi.feature.FeatureEntitySpecification;
import com.jetbrains.mlapi.feature.FeatureValueType;
import com.jetbrains.mlapi.feature.NullFeatureSignature;
import com.jetbrains.mlapi.feature.PrimitiveType;
import com.jetbrains.mlapi.feature.UnionFeatureSignature;
import com.jetbrains.mlapi.feature.UnionType;
import com.jetbrains.mlapi.logs.LogsMetadata;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B#\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0000J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0004J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003H&R\u0014\u0010\t\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u0082\u0001\u0003\u001f !\u00a8\u0006\""}, d2={"Lcom/jetbrains/mlapi/feature/FeatureSignature;", "Lcom/jetbrains/mlapi/feature/FeatureEntitySpecification;", "name", "", "type", "Lcom/jetbrains/mlapi/feature/FeatureValueType;", "logsMetadata", "Lcom/jetbrains/mlapi/logs/LogsMetadata;", "(Ljava/lang/String;Lcom/jetbrains/mlapi/feature/FeatureValueType;Lcom/jetbrains/mlapi/logs/LogsMetadata;)V", "asNonNullable", "getAsNonNullable", "()Lcom/jetbrains/mlapi/feature/FeatureSignature;", "isNullable", "", "()Z", "getLogsMetadata", "()Lcom/jetbrains/mlapi/logs/LogsMetadata;", "getName", "()Ljava/lang/String;", "getType", "()Lcom/jetbrains/mlapi/feature/FeatureValueType;", "equals", "other", "", "hashCode", "", "isSupersetOf", "toString", "united", "withName", "newName", "Lcom/jetbrains/mlapi/feature/FeatureDeclaration;", "Lcom/jetbrains/mlapi/feature/NullFeatureSignature;", "Lcom/jetbrains/mlapi/feature/UnionFeatureSignature;", "mlapi-core"})
public abstract class FeatureSignature
implements FeatureEntitySpecification {
    @NotNull
    private final String name;
    @NotNull
    private final FeatureValueType type;
    @Nullable
    private final LogsMetadata logsMetadata;

    private FeatureSignature(String name, FeatureValueType type, LogsMetadata logsMetadata) {
        this.name = name;
        this.type = type;
        this.logsMetadata = logsMetadata;
    }

    public /* synthetic */ FeatureSignature(String string, FeatureValueType featureValueType, LogsMetadata logsMetadata, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            logsMetadata = null;
        }
        this(string, featureValueType, logsMetadata, null);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public FeatureValueType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public LogsMetadata getLogsMetadata() {
        return this.logsMetadata;
    }

    public final boolean isNullable() {
        return this.getType().isNullable();
    }

    public final boolean isSupersetOf(@NotNull FeatureSignature other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)other.getName())) {
            return false;
        }
        return this.getType().isSupersetOf(other.getType());
    }

    @Nullable
    public abstract FeatureSignature getAsNonNullable();

    @NotNull
    public final FeatureSignature united(@NotNull FeatureSignature other) {
        FeatureSignature featureSignature;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)other.getName())) {
            boolean $i$a$-require-FeatureSignature$united$32 = false;
            String $i$a$-require-FeatureSignature$united$32 = "Features " + this + " and " + other + " can't be united, as they have different names";
            throw new IllegalArgumentException($i$a$-require-FeatureSignature$united$32.toString());
        }
        if (!(!(other instanceof NullFeatureSignature))) {
            boolean bl = false;
            String string = "Can't be united with Null. Use FeatureDeclaration.<type>().nullable() instead to create nullable feature signatures.";
            throw new IllegalArgumentException(string.toString());
        }
        FeatureValueType unitedType = this.getType().united(other.getType());
        if (unitedType instanceof UnionType) {
            featureSignature = new UnionFeatureSignature(this.getName(), (UnionType)unitedType, null);
        } else if (unitedType instanceof PrimitiveType) {
            featureSignature = this;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return featureSignature;
    }

    @Override
    @NotNull
    public abstract FeatureSignature withName(@NotNull String var1);

    @NotNull
    public String toString() {
        String string = this.getName();
        FeatureValueType featureValueType = this.getType();
        Object object = this.getLogsMetadata();
        if (object == null) {
            object = "";
        }
        return string + "(" + featureValueType + object + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FeatureSignature)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)((FeatureSignature)other).getName())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getType(), (Object)((FeatureSignature)other).getType());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getType().hashCode();
        return result;
    }

    public /* synthetic */ FeatureSignature(String name, FeatureValueType type, LogsMetadata logsMetadata, DefaultConstructorMarker $constructor_marker) {
        this(name, type, logsMetadata);
    }
}

