/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.index.VueComponentsIndexKt;
import org.jetbrains.vuejs.index.VueIndexData;
import org.jetbrains.vuejs.index.VueIndexKt;
import org.jetbrains.vuejs.lang.html.VueFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/vuejs/model/source/VueComponentsCalculation;", "", "<init>", "()V", "Companion", "ComponentsData", "intellij.vuejs.backend"})
public final class VueComponentsCalculation {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\fH\u0002JJ\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00182$\u0010\u0019\u001a \u0012\u0004\u0012\u00020\u0013\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0\u000b0\u001a0\u0018H\u0002J.\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0\u000b2\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0\u000b0\u001eH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/vuejs/model/source/VueComponentsCalculation$Companion;", "", "<init>", "()V", "calculateScopeComponents", "Lorg/jetbrains/vuejs/model/source/VueComponentsCalculation$ComponentsData;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "globalize", "", "findObjectLiteralOfGlobalRegistration", "Lkotlin/Pair;", "Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;", "element", "Lcom/intellij/lang/javascript/psi/stubs/JSImplicitElement;", "resolveGlobalComponentName", "Lorg/jetbrains/vuejs/model/source/VueComponentsCalculation$Companion$SingleGlobalRegistration;", "descriptor", "getNameFromDescriptor", "", "processComponentGroupRegistration", "", "objLiteral", "libCompResolveMap", "", "componentData", "", "Lcom/intellij/psi/PsiElement;", "selectComponentDefinition", "list", "", "SingleGlobalRegistration", "intellij.vuejs.backend"})
    @SourceDebugExtension(value={"SMAP\nVueComponentsCalculation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueComponentsCalculation.kt\norg/jetbrains/vuejs/model/source/VueComponentsCalculation$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,179:1\n1#2:180\n19#3:181\n19#3:182\n*S KotlinDebug\n*F\n+ 1 VueComponentsCalculation.kt\norg/jetbrains/vuejs/model/source/VueComponentsCalculation$Companion\n*L\n106#1:181\n114#1:182\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ComponentsData calculateScopeComponents(@NotNull GlobalSearchScope scope, boolean globalize) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Sequence<JSImplicitElement> allValues = VueIndexKt.getForAllKeys(scope, VueComponentsIndexKt.getVUE_COMPONENTS_INDEX_KEY());
            Map libCompResolveMap = new LinkedHashMap();
            Map componentData = new LinkedHashMap();
            for (JSImplicitElement value : allValues) {
                boolean isGlobal;
                VueIndexData indexData;
                if (VueIndexKt.getVueIndexData(value) == null) continue;
                String name = indexData.getOriginalName();
                boolean bl = isGlobal = indexData.isGlobal() || globalize;
                if (isGlobal && StringsKt.endsWith$default((String)name, (String)"*", (boolean)false, (int)2, null)) {
                    Pair<JSObjectLiteralExpression, Boolean> pair = this.findObjectLiteralOfGlobalRegistration(value);
                    boolean bl2 = pair != null ? ((Boolean)pair.getSecond()).booleanValue() : false;
                    if (bl2) {
                        this.processComponentGroupRegistration((JSObjectLiteralExpression)pair.getFirst(), libCompResolveMap, componentData);
                        continue;
                    }
                    Pair<JSObjectLiteralExpression, Boolean> pair2 = pair;
                    SingleGlobalRegistration singleGlobalRegistration = this.resolveGlobalComponentName(value, (JSObjectLiteralExpression)(pair2 != null ? (JSObjectLiteralExpression)pair2.getFirst() : null));
                    if (singleGlobalRegistration == null || !(!StringsKt.isBlank((CharSequence)singleGlobalRegistration.getRealName()))) continue;
                    String normalizedName = VueUtilKt.fromAsset$default(singleGlobalRegistration.getRealName(), false, 2, null);
                    String normalizedAlias = VueUtilKt.fromAsset$default(StringsKt.isBlank((CharSequence)singleGlobalRegistration.getAlias()) ? StringsKt.substringBefore$default((String)name, (String)"*", null, (int)2, null) : singleGlobalRegistration.getAlias(), false, 2, null);
                    libCompResolveMap.put(normalizedAlias, normalizedName);
                    UtilKt.putValue((Map)componentData, (Object)normalizedName, (Object)new Pair((Object)singleGlobalRegistration.getElement(), (Object)true));
                    continue;
                }
                UtilKt.putValue((Map)componentData, (Object)VueUtilKt.fromAsset$default(name, false, 2, null), (Object)new Pair((Object)value, (Object)isGlobal));
            }
            Map componentsMap = new LinkedHashMap();
            for (Map.Entry entry : componentData.entrySet()) {
                componentsMap.put(entry.getKey(), this.selectComponentDefinition((List)entry.getValue()));
            }
            return new ComponentsData(componentsMap, libCompResolveMap);
        }

        private final Pair<JSObjectLiteralExpression, Boolean> findObjectLiteralOfGlobalRegistration(JSImplicitElement element) {
            Pair pair;
            PsiElement psiElement = element.getContext();
            JSCallExpression jSCallExpression = psiElement instanceof JSCallExpression ? (JSCallExpression)psiElement : null;
            if (jSCallExpression == null) {
                return null;
            }
            JSCallExpression context = jSCallExpression;
            VueIndexData indexData = VueIndexKt.getVueIndexData(element);
            Object object = indexData;
            if (object == null || (object = ((VueIndexData)object).getDescriptorQualifiedReference()) == null) {
                return null;
            }
            Object qualifiedReference = object;
            PsiElement psiElement2 = JSStubBasedPsiTreeUtil.resolveLocally((String)qualifiedReference, (PsiElement)((PsiElement)context));
            if (psiElement2 == null) {
                return null;
            }
            PsiElement resolved = psiElement2;
            boolean indexedAccessUsed = indexData.getIndexedAccessUsed();
            JSObjectLiteralExpression jSObjectLiteralExpression = VueUtilKt.objectLiteralFor(resolved);
            if (jSObjectLiteralExpression != null) {
                JSObjectLiteralExpression it = jSObjectLiteralExpression;
                boolean bl = false;
                pair = new Pair((Object)it, (Object)indexedAccessUsed);
            } else {
                pair = null;
            }
            return pair;
        }

        private final SingleGlobalRegistration resolveGlobalComponentName(JSImplicitElement element, JSObjectLiteralExpression descriptor) {
            SingleGlobalRegistration singleGlobalRegistration;
            String string;
            PsiElement psiElement = element.getContext();
            JSCallExpression jSCallExpression = psiElement instanceof JSCallExpression ? (JSCallExpression)psiElement : null;
            if (jSCallExpression == null) {
                return null;
            }
            JSCallExpression context = jSCallExpression;
            VueIndexData indexData = VueIndexKt.getVueIndexData(element);
            Object object = indexData;
            if (object == null || (object = ((VueIndexData)object).getNameQualifiedReference()) == null) {
                return null;
            }
            Object nameReference = object;
            Object object2 = new char[]{'.'};
            List nameReferenceParts = StringsKt.split$default((CharSequence)((CharSequence)nameReference), (char[])object2, (boolean)false, (int)0, (int)6, null);
            if (nameReferenceParts.size() > 2) {
                return null;
            }
            if (nameReferenceParts.size() == 2) {
                if (!Intrinsics.areEqual(nameReferenceParts.get(0), (Object)indexData.getDescriptorQualifiedReference())) {
                    return null;
                }
                if (descriptor == null) {
                    return new SingleGlobalRegistration((String)nameReferenceParts.get(0), (String)nameReferenceParts.get(0), (PsiElement)context);
                }
                if (!descriptor.isValid()) {
                    return null;
                }
                JSProperty property = descriptor.findProperty((String)nameReferenceParts.get(1));
                if (property != null) {
                    Object object3;
                    Object alias;
                    Object object4;
                    JSType $this$asSafely$iv = property.getJSType();
                    boolean $i$f$asSafely = false;
                    JSType jSType = $this$asSafely$iv;
                    if (!(jSType instanceof JSStringLiteralTypeImpl)) {
                        jSType = null;
                    }
                    if ((object4 = (JSStringLiteralTypeImpl)jSType) == null || (object4 = object4.getLiteral()) == null) {
                        object4 = alias = "";
                    }
                    if (Intrinsics.areEqual((Object)"name", nameReferenceParts.get(1))) {
                        object3 = alias;
                    } else {
                        object3 = this.getNameFromDescriptor(descriptor);
                        if (object3 == null) {
                            object3 = alias;
                        }
                    }
                    Object realName = object3;
                    return new SingleGlobalRegistration((String)realName, (String)alias, (PsiElement)descriptor);
                }
                return null;
            }
            if (descriptor == null) {
                return null;
            }
            PsiElement realName = JSStubBasedPsiTreeUtil.resolveLocally((String)nameReference, (PsiElement)((PsiElement)context));
            JSVariable alias = realName instanceof JSVariable ? (JSVariable)realName : null;
            JSType $this$asSafely$iv = alias != null ? alias.getJSType() : null;
            boolean $i$f$asSafely = false;
            JSType jSType = $this$asSafely$iv;
            if (!(jSType instanceof JSStringLiteralTypeImpl)) {
                jSType = null;
            }
            if ((object2 = (Object)((JSStringLiteralTypeImpl)jSType)) != null && (string = object2.getLiteral()) != null) {
                String it = string;
                boolean bl = false;
                String string2 = Companion.getNameFromDescriptor(descriptor);
                if (string2 == null) {
                    string2 = "";
                }
                singleGlobalRegistration = new SingleGlobalRegistration(string2, it, (PsiElement)descriptor);
            } else {
                singleGlobalRegistration = null;
            }
            return singleGlobalRegistration;
        }

        private final String getNameFromDescriptor(JSObjectLiteralExpression descriptor) {
            JSProperty jSProperty = descriptor.findProperty("name");
            JSType jSType = jSProperty != null ? jSProperty.getJSType() : null;
            JSStringLiteralTypeImpl jSStringLiteralTypeImpl = jSType instanceof JSStringLiteralTypeImpl ? (JSStringLiteralTypeImpl)jSType : null;
            return jSStringLiteralTypeImpl != null ? jSStringLiteralTypeImpl.getLiteral() : null;
        }

        private final void processComponentGroupRegistration(JSObjectLiteralExpression objLiteral, Map<String, String> libCompResolveMap, Map<String, List<Pair<PsiElement, Boolean>>> componentData) {
            ArrayDeque queue = new ArrayDeque();
            Collection collection = queue;
            JSElement[] jSElementArray = objLiteral.getPropertiesIncludingSpreads();
            Intrinsics.checkNotNullExpressionValue((Object)jSElementArray, (String)"getPropertiesIncludingSpreads(...)");
            CollectionsKt.addAll((Collection)collection, (Object[])jSElementArray);
            Set visited = new LinkedHashSet();
            while (!queue.isEmpty()) {
                PsiElement element = (PsiElement)queue.removeFirst();
                Intrinsics.checkNotNull((Object)element);
                if (!visited.add(element)) continue;
                PsiElement psiElement = element;
                if (psiElement instanceof JSSpreadExpression) {
                    JSObjectLiteralExpression jSObjectLiteralExpression = VueUtilKt.objectLiteralFor((PsiElement)((JSSpreadExpression)element).getExpression());
                    if (jSObjectLiteralExpression == null) continue;
                    JSObjectLiteralExpression it = jSObjectLiteralExpression;
                    boolean bl = false;
                    Collection collection2 = queue;
                    JSElement[] jSElementArray2 = it.getPropertiesIncludingSpreads();
                    Intrinsics.checkNotNullExpressionValue((Object)jSElementArray2, (String)"getPropertiesIncludingSpreads(...)");
                    CollectionsKt.addAll((Collection)collection2, (Object[])jSElementArray2);
                    continue;
                }
                if (!(psiElement instanceof JSProperty)) continue;
                String propName = ((JSProperty)element).getName();
                JSObjectLiteralExpression descriptor = VueUtilKt.objectLiteralFor(element);
                if (propName == null) continue;
                JSObjectLiteralExpression jSObjectLiteralExpression = descriptor;
                String string = VueUtilKt.getTextIfLiteral$default((PsiElement)(jSObjectLiteralExpression != null && (jSObjectLiteralExpression = jSObjectLiteralExpression.findProperty("name")) != null ? jSObjectLiteralExpression.getValue() : null), false, 2, null);
                if (string == null) {
                    string = propName;
                }
                String nameFromDescriptor = string;
                String normalizedName = VueUtilKt.fromAsset$default(propName, false, 2, null);
                String realName = VueUtilKt.fromAsset$default(nameFromDescriptor, false, 2, null);
                libCompResolveMap.put(normalizedName, realName);
                JSObjectLiteralExpression jSObjectLiteralExpression2 = descriptor;
                UtilKt.putValue(componentData, (Object)realName, (Object)new Pair((Object)(jSObjectLiteralExpression2 != null ? (JSElement)jSObjectLiteralExpression2 : (JSElement)element), (Object)true));
            }
        }

        private final Pair<PsiElement, Boolean> selectComponentDefinition(List<? extends Pair<? extends PsiElement, Boolean>> list) {
            Pair<? extends PsiElement, Boolean> selected = null;
            for (Pair<? extends PsiElement, Boolean> pair : list) {
                boolean isVue = ((PsiElement)pair.getFirst()).getContainingFile() instanceof VueFile;
                if (((Boolean)pair.getSecond()).booleanValue()) {
                    if (isVue) {
                        return pair;
                    }
                    selected = pair;
                    continue;
                }
                if (selected != null || !isVue) continue;
                selected = pair;
            }
            Pair<? extends PsiElement, Boolean> pair = selected;
            if (pair == null) {
                pair = list.get(0);
            }
            return pair;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/vuejs/model/source/VueComponentsCalculation$Companion$SingleGlobalRegistration;", "", "realName", "", "alias", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getRealName", "()Ljava/lang/String;", "getAlias", "getElement", "()Lcom/intellij/psi/PsiElement;", "intellij.vuejs.backend"})
        private static final class SingleGlobalRegistration {
            @NotNull
            private final String realName;
            @NotNull
            private final String alias;
            @NotNull
            private final PsiElement element;

            public SingleGlobalRegistration(@NotNull String realName, @NotNull String alias, @NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)realName, (String)"realName");
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                this.realName = realName;
                this.alias = alias;
                this.element = element;
            }

            @NotNull
            public final String getRealName() {
                return this.realName;
            }

            @NotNull
            public final String getAlias() {
                return this.alias;
            }

            @NotNull
            public final PsiElement getElement() {
                return this.element;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\t\u0010\nR)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/vuejs/model/source/VueComponentsCalculation$ComponentsData;", "", "map", "", "", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "", "libCompResolveMap", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getMap", "()Ljava/util/Map;", "getLibCompResolveMap", "intellij.vuejs.backend"})
    public static final class ComponentsData {
        @NotNull
        private final Map<String, Pair<PsiElement, Boolean>> map;
        @NotNull
        private final Map<String, String> libCompResolveMap;

        public ComponentsData(@NotNull Map<String, ? extends Pair<? extends PsiElement, Boolean>> map, @NotNull Map<String, String> libCompResolveMap) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter(libCompResolveMap, (String)"libCompResolveMap");
            this.map = map;
            this.libCompResolveMap = libCompResolveMap;
        }

        @NotNull
        public final Map<String, Pair<PsiElement, Boolean>> getMap() {
            return this.map;
        }

        @NotNull
        public final Map<String, String> getLibCompResolveMap() {
            return this.libCompResolveMap;
        }
    }
}

