/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.portForwarding;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.CreatePortForwardingDialogBase;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/CreatePortForwardingDialog;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/CreatePortForwardingDialogBase;", "project", "Lcom/intellij/openapi/project/Project;", "alreadyForwardedPorts", "", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "myPortTypePicker", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortType;", "kotlin.jvm.PlatformType", "myPortTypeLabel", "Lcom/intellij/ui/components/JBLabel;", "myPortNumTexBox", "Lcom/intellij/ui/components/JBTextField;", "myPortNumLabel", "createCenterPanel", "Ljavax/swing/JComponent;", "getResult", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/CreatePortForwardingDialog$ForwardedPort;", "ForwardedPort", "intellij.platform.split"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCreatePortForwardingDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreatePortForwardingDialog.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/CreatePortForwardingDialog\n+ 2 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n81#2,6:69\n1#3:75\n*S KotlinDebug\n*F\n+ 1 CreatePortForwardingDialog.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/CreatePortForwardingDialog\n*L\n18#1:69,6\n*E\n"})
public final class CreatePortForwardingDialog
extends CreatePortForwardingDialogBase {
    @NotNull
    private final Set<Integer> alreadyForwardedPorts;
    @NotNull
    private final ComboBox<PortType> myPortTypePicker;
    @NotNull
    private final JBLabel myPortTypeLabel;
    @NotNull
    private final JBTextField myPortNumTexBox;
    @NotNull
    private final JBLabel myPortNumLabel;

    /*
     * WARNING - void declaration
     */
    public CreatePortForwardingDialog(@NotNull Project project, @NotNull Set<Integer> alreadyForwardedPorts) {
        void $this$myPortNumLabel_u24lambda_u240;
        JBLabel $this$myPortTypeLabel_u24lambda_u240;
        PortType[] portTypeArray;
        JBLabel elt$iv;
        void $this$remove$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(alreadyForwardedPorts, (String)"alreadyForwardedPorts");
        super(project);
        this.alreadyForwardedPorts = alreadyForwardedPorts;
        JBLabel jBLabel = PortType.values();
        PortType portType = PortType.NON_USER_TCP;
        CreatePortForwardingDialog createPortForwardingDialog = this;
        boolean $i$f$remove = false;
        int idx$iv = ArraysKt.indexOf((Object[])$this$remove$iv, (Object)elt$iv);
        if (idx$iv == -1) {
            portTypeArray = $this$remove$iv;
        } else {
            int n = ((void)$this$remove$iv).length - 1;
            PortType[] portTypeArray2 = new PortType[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                portTypeArray2[n2] = n2 < idx$iv ? $this$remove$iv[n2] : $this$remove$iv[n2 + 1];
            }
            portTypeArray = portTypeArray2;
        }
        List list = ArraysKt.toList((Object[])portTypeArray);
        int n = 100;
        ComboBoxModel comboBoxModel = (ComboBoxModel)new CollectionComboBoxModel(list);
        createPortForwardingDialog.myPortTypePicker = new ComboBox(comboBoxModel, n);
        elt$iv = jBLabel = new JBLabel(PlatformSplitBundle.INSTANCE.message("portForwarding.createPortForwardingDialog.portType", new Object[0]));
        createPortForwardingDialog = this;
        boolean bl = false;
        $this$myPortTypeLabel_u24lambda_u240.setLabelFor((Component)this.myPortTypePicker);
        createPortForwardingDialog.myPortTypeLabel = jBLabel;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        this.myPortNumTexBox = CreatePortForwardingDialogBase.Companion.getPortTextBoxWithValidation(this.alreadyForwardedPorts, disposable, (Function1<? super Boolean, Unit>)((Function1)arg_0 -> CreatePortForwardingDialog.myPortNumTexBox$lambda$0(this, arg_0)));
        $this$myPortTypeLabel_u24lambda_u240 = jBLabel = new JBLabel(PlatformSplitBundle.INSTANCE.message("portForwarding.createPortForwardingDialog.portNumber", new Object[0]));
        createPortForwardingDialog = this;
        boolean bl2 = false;
        $this$myPortNumLabel_u24lambda_u240.setLabelFor((Component)this.myPortNumTexBox);
        createPortForwardingDialog.myPortNumLabel = jBLabel;
        this.setTitle(PlatformSplitBundle.INSTANCE.message("portForwarding.createPortForwardingDialog", new Object[0]));
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        SpringLayout layout = new SpringLayout();
        JPanel frame = new JPanel(layout);
        frame.add((Component)this.myPortNumLabel);
        frame.add((Component)this.myPortNumTexBox);
        frame.add((Component)this.myPortTypeLabel);
        frame.add((Component)this.myPortTypePicker);
        int spacing = 6;
        this.createGridConstraints(frame, 2, 2, spacing, spacing, spacing, spacing);
        return frame;
    }

    @NotNull
    public final ForwardedPort getResult() {
        String string = this.myPortNumTexBox.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Integer portNumber = StringsKt.toIntOrNull((String)string);
        if (portNumber == null) {
            throw new IllegalStateException("Not a valid port number".toString());
        }
        if (portNumber < 1 || portNumber > 65535) {
            throw new IllegalStateException("Not a valid port number".toString());
        }
        if (this.alreadyForwardedPorts.contains(portNumber)) {
            throw new IllegalStateException("Port already forwarded".toString());
        }
        int n = portNumber;
        Object object = this.myPortTypePicker.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        return new ForwardedPort(n, (PortType)((Object)object));
    }

    private static final Unit myPortNumTexBox$lambda$0(CreatePortForwardingDialog this$0, boolean it) {
        this$0.setOKActionEnabled(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/CreatePortForwardingDialog$ForwardedPort;", "", "port", "", "type", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortType;", "<init>", "(ILcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortType;)V", "getPort", "()I", "getType", "()Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.split"})
    public static final class ForwardedPort {
        private final int port;
        @NotNull
        private final PortType type;

        public ForwardedPort(int port, @NotNull PortType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.port = port;
            this.type = type;
        }

        public final int getPort() {
            return this.port;
        }

        @NotNull
        public final PortType getType() {
            return this.type;
        }

        public final int component1() {
            return this.port;
        }

        @NotNull
        public final PortType component2() {
            return this.type;
        }

        @NotNull
        public final ForwardedPort copy(int port, @NotNull PortType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new ForwardedPort(port, type);
        }

        public static /* synthetic */ ForwardedPort copy$default(ForwardedPort forwardedPort, int n, PortType portType, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = forwardedPort.port;
            }
            if ((n2 & 2) != 0) {
                portType = forwardedPort.type;
            }
            return forwardedPort.copy(n, portType);
        }

        @NotNull
        public String toString() {
            return "ForwardedPort(port=" + this.port + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.port);
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ForwardedPort)) {
                return false;
            }
            ForwardedPort forwardedPort = (ForwardedPort)other;
            if (this.port != forwardedPort.port) {
                return false;
            }
            return this.type == forwardedPort.type;
        }
    }
}

