/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ%\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000eJ%\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001d\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001aJ\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/MathUtil;", "", "()V", "addX", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "v", "x", "", "addX$plot_builder", "areEqual", "", "a", "b", "epsilon", "areEqual$plot_builder", "p1", "p2", "bottomEdgeOf", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "leftEdgeOf", "liesOnSegment", "c", "rightEdgeOf", "subtractX", "subtractX$plot_builder", "topEdgeOf", "plot-builder"})
public final class MathUtil {
    @NotNull
    public static final MathUtil INSTANCE = new MathUtil();

    private MathUtil() {
    }

    public final boolean liesOnSegment(@NotNull DoubleVector p1, @NotNull DoubleVector p2, @NotNull DoubleVector c, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new DoubleSegment(p1, p2).distance(c) < epsilon;
    }

    public final boolean areEqual$plot_builder(@NotNull DoubleVector p1, @NotNull DoubleVector p2, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return p1.subtract(p2).length() < epsilon;
    }

    public final boolean areEqual$plot_builder(double a2, double b2, double epsilon) {
        return Math.abs(a2 - b2) < epsilon;
    }

    @NotNull
    public final DoubleVector subtractX$plot_builder(@NotNull DoubleVector v, double x2) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleVector(v.getX() - x2, v.getY());
    }

    @NotNull
    public final DoubleVector addX$plot_builder(@NotNull DoubleVector v, double x2) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleVector(v.getX() + x2, v.getY());
    }

    @NotNull
    public final DoubleSegment leftEdgeOf(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return new DoubleSegment(new DoubleVector(rect2.getLeft(), rect2.getTop()), new DoubleVector(rect2.getLeft(), rect2.getBottom()));
    }

    @NotNull
    public final DoubleSegment topEdgeOf(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return new DoubleSegment(new DoubleVector(rect2.getLeft(), rect2.getTop()), new DoubleVector(rect2.getRight(), rect2.getTop()));
    }

    @NotNull
    public final DoubleSegment rightEdgeOf(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return new DoubleSegment(new DoubleVector(rect2.getRight(), rect2.getTop()), new DoubleVector(rect2.getRight(), rect2.getBottom()));
    }

    @NotNull
    public final DoubleSegment bottomEdgeOf(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return new DoubleSegment(new DoubleVector(rect2.getLeft(), rect2.getBottom()), new DoubleVector(rect2.getRight(), rect2.getBottom()));
    }
}

