/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.util;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.settings.QueryFileSettings;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.nio.file.Paths;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0014J\n\u0010\r\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/actions/util/SelectPathAndNameDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "doOnOkAction", "Lcom/intellij/database/actions/util/SelectPathAndNameDialog$OnOkAction;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/actions/util/SelectPathAndNameDialog$OnOkAction;)V", "nameTextField", "Ljavax/swing/JTextField;", "locationTextField", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "doOKAction", "", "validateNameInput", "Lcom/intellij/openapi/ui/ValidationInfo;", "textField", "validatePathInput", "validateFilePathOnApply", "OnOkAction", "intellij.database.impl"})
public final class SelectPathAndNameDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final OnOkAction doOnOkAction;
    @Nullable
    private JTextField nameTextField;
    @Nullable
    private JTextField locationTextField;

    public SelectPathAndNameDialog(@NotNull Project project, @NotNull OnOkAction doOnOkAction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)doOnOkAction, (String)"doOnOkAction");
        super(project);
        this.project = project;
        this.doOnOkAction = doOnOkAction;
        this.setTitle(DatabaseBundle.message((String)"file.creation.dialog.title", (Object[])new Object[0]));
        this.init();
        this.initValidation();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel it = dialogPanel = BuilderKt.panel(arg_0 -> SelectPathAndNameDialog.createCenterPanel$lambda$0(this, arg_0));
        boolean bl = false;
        it.registerValidators(SelectPathAndNameDialog::createCenterPanel$lambda$1$0);
        it.setMinimumSize(new Dimension(JBUI.scale((int)400), it.getPreferredSize().height));
        it.setBorder((Border)JBUI.Borders.empty((int)0, (int)8, (int)8, (int)8));
        return (JComponent)dialogPanel;
    }

    @Nullable
    public JTextField getPreferredFocusedComponent() {
        return this.nameTextField;
    }

    protected void doOKAction() {
        JTextField locationTextField = this.locationTextField;
        JTextField nameTextField = this.nameTextField;
        if (locationTextField == null || nameTextField == null) {
            this.close(0);
            return;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(locationTextField.getText());
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string = nameTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String name = ((Object)StringsKt.trim((CharSequence)string)).toString();
        QueryFileSettings.Companion.getInstance(this.project).setLastUsedQueriesDirectory(VirtualFileUtil.toNioPathOrNull((VirtualFile)virtualFile2));
        this.doOnOkAction.invoke(name, virtualFile2);
        this.close(0);
    }

    private final ValidationInfo validateNameInput(JTextField textField) {
        String string = textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String name = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (((CharSequence)name).length() == 0) {
            return new ValidationInfo(DatabaseBundle.message((String)"file.creation.dialog.name.validation.info.empty", (Object[])new Object[0]), (JComponent)textField);
        }
        if (!PathUtilRt.isValidFileName((String)name, (boolean)true)) {
            return new ValidationInfo(DatabaseBundle.message((String)"file.creation.dialog.name.validation.info.unknown", (Object[])new Object[0]), (JComponent)textField);
        }
        return null;
    }

    private final ValidationInfo validatePathInput(JTextField textField) {
        Object object;
        String string = textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String path = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (((CharSequence)path).length() == 0) {
            return new ValidationInfo(DatabaseBundle.message((String)"file.creation.dialog.path.validation.info.empty", (Object[])new Object[0]), (JComponent)textField);
        }
        Object object2 = this;
        try {
            SelectPathAndNameDialog $this$validatePathInput_u24lambda_u240 = object2;
            boolean bl = false;
            if (Paths.get(path, new String[0]) == null) {
                return new ValidationInfo(DatabaseBundle.message((String)"file.creation.dialog.path.validation.info.unknown", (Object[])new Object[0]), (JComponent)textField);
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            String string2 = ((Throwable)it).getMessage();
            if (string2 == null) {
                String string3 = DatabaseBundle.message((String)"file.creation.dialog.path.validation.info.unknown", (Object[])new Object[0]);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            }
            return new ValidationInfo(string2);
        }
        return null;
    }

    private final ValidationInfo validateFilePathOnApply(JTextField textField) {
        ValidationInfo info2;
        ValidationInfo validationInfo = info2 = this.validatePathInput(textField);
        if (validationInfo != null) {
            return validationInfo;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(textField.getText());
        if (virtualFile == null) {
            return new ValidationInfo(DatabaseBundle.message((String)"file.creation.dialog.path.validation.info.cant.resolve", (Object[])new Object[0]), (JComponent)textField);
        }
        VirtualFile evaluatedVirtualFile = virtualFile;
        if (!evaluatedVirtualFile.isDirectory()) {
            return new ValidationInfo(DatabaseBundle.message((String)"file.creation.dialog.path.validation.info.not.directory", (Object[])new Object[0]), (JComponent)textField);
        }
        return null;
    }

    private static final Unit createCenterPanel$lambda$0(SelectPathAndNameDialog this$0, Panel $this$panel) {
        Object pathString;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string2 = DatabaseBundle.message((String)"file.creation.dialog.file.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> SelectPathAndNameDialog.createCenterPanel$lambda$0$0(this$0, arg_0));
        Object object = QueryFileSettings.Companion.getInstance(this$0.project).getLastUsedQueriesDirectory();
        if (object == null || (object = object.toString()) == null) {
            object = this$0.project.getBasePath();
        }
        if ((string = PathUtil.toSystemDependentName((String)(pathString = object))) == null) {
            string = "";
        }
        String systemDependentPath = string;
        String string3 = DatabaseBundle.message((String)"file.creation.dialog.file.path", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> SelectPathAndNameDialog.createCenterPanel$lambda$0$1(this$0, systemDependentPath, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(SelectPathAndNameDialog this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell $this$createCenterPanel_u24lambda_u240_u240_u240 = cell = $this$row.textField();
        boolean bl = false;
        JBTextField textField = (JBTextField)$this$createCenterPanel_u24lambda_u240_u240_u240.getComponent();
        this$0.nameTextField = (JTextField)textField;
        TextFieldKt.text((Cell)$this$createCenterPanel_u24lambda_u240_u240_u240, (String)"Query");
        $this$createCenterPanel_u24lambda_u240_u240_u240.validationOnInput((arg_0, arg_1) -> SelectPathAndNameDialog.createCenterPanel$lambda$0$0$0$0(this$0, textField, arg_0, arg_1));
        $this$createCenterPanel_u24lambda_u240_u240_u240.validationOnApply((arg_0, arg_1) -> SelectPathAndNameDialog.createCenterPanel$lambda$0$0$0$1(this$0, textField, arg_0, arg_1));
        $this$createCenterPanel_u24lambda_u240_u240_u240.align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$0$0$0$0(SelectPathAndNameDialog this$0, JBTextField $textField, ValidationInfoBuilder $this$validationOnInput, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateNameInput((JTextField)$textField);
    }

    private static final ValidationInfo createCenterPanel$lambda$0$0$0$1(SelectPathAndNameDialog this$0, JBTextField $textField, ValidationInfoBuilder $this$validationOnApply, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateNameInput((JTextField)$textField);
    }

    private static final Unit createCenterPanel$lambda$0$1(SelectPathAndNameDialog this$0, String $systemDependentPath, Row $this$row) {
        JTextField textField;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.singleDir();
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"singleDir(...)");
        Cell $this$createCenterPanel_u24lambda_u240_u241_u240 = cell = Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)fileChooserDescriptor, (Project)this$0.project, null, (int)4, null);
        boolean bl = false;
        JTextField jTextField = ((TextFieldWithBrowseButton)$this$createCenterPanel_u24lambda_u240_u241_u240.getComponent()).getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextField(...)");
        this$0.locationTextField = textField = jTextField;
        TextFieldWithBrowseButtonKt.text((Cell)$this$createCenterPanel_u24lambda_u240_u241_u240, (String)$systemDependentPath);
        $this$createCenterPanel_u24lambda_u240_u241_u240.validationOnInput((arg_0, arg_1) -> SelectPathAndNameDialog.createCenterPanel$lambda$0$1$0$0(this$0, textField, arg_0, arg_1));
        $this$createCenterPanel_u24lambda_u240_u241_u240.validationOnApply((arg_0, arg_1) -> SelectPathAndNameDialog.createCenterPanel$lambda$0$1$0$1(this$0, textField, arg_0, arg_1));
        $this$createCenterPanel_u24lambda_u240_u241_u240.align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$0$1$0$0(SelectPathAndNameDialog this$0, JTextField $textField, ValidationInfoBuilder $this$validationOnInput, TextFieldWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validatePathInput($textField);
    }

    private static final ValidationInfo createCenterPanel$lambda$0$1$0$1(SelectPathAndNameDialog this$0, JTextField $textField, ValidationInfoBuilder $this$validationOnApply, TextFieldWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateFilePathOnApply($textField);
    }

    private static final void createCenterPanel$lambda$1$0() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/actions/util/SelectPathAndNameDialog$OnOkAction;", "", "invoke", "", "fileName", "", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.database.impl"})
    public static interface OnOkAction {
        public void invoke(@NotNull String var1, @NotNull VirtualFile var2);
    }
}

