/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.github.dockerjava.api.model.Image;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerStatus;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.progress.DockerProgressDetailsFormat;
import com.intellij.docker.agent.util.DockerUtil;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.runtimes.DockerPhysicalRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimeDetailsProvider;
import com.intellij.docker.runtimes.presentation.DockerImageRuntimePresentationInterface;
import com.intellij.docker.view.details.image.DockerImageDetailsProvider;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001'B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H&J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H&R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lcom/intellij/docker/runtimes/DockerImageRuntime;", "Lcom/intellij/docker/runtimes/DockerPhysicalRuntime;", "Lcom/intellij/docker/agent/DockerAgentImage;", "Lcom/intellij/docker/runtimes/presentation/DockerImageRuntimePresentationInterface;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "agentImage", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/docker/agent/DockerAgentImage;Lcom/intellij/openapi/project/Project;)V", "id", "", "getId", "()Ljava/lang/String;", "value", "agentApplication", "getAgentApplication", "()Lcom/intellij/docker/agent/DockerAgentImage;", "setAgentApplication$intellij_clouds_docker", "(Lcom/intellij/docker/agent/DockerAgentImage;)V", "image", "Lcom/github/dockerjava/api/model/Image;", "getImage", "()Lcom/github/dockerjava/api/model/Image;", "imageRepoTags", "", "getImageRepoTags", "()Ljava/util/Set;", "detailsProvider", "Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "getDetailsProvider", "()Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "deleteImage", "Ljava/util/concurrent/CompletableFuture;", "", "push", "repositoryModel", "Lcom/intellij/docker/registry/DockerRepositoryModel;", "Companion", "intellij.clouds.docker"})
public abstract class DockerImageRuntime
extends DockerPhysicalRuntime<DockerAgentImage>
implements DockerImageRuntimePresentationInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile DockerAgentImage agentApplication;
    @NotNull
    private final DockerRuntimeDetailsProvider detailsProvider;

    public DockerImageRuntime(@NotNull DockerRuntimeContext context, @NotNull DockerAgentImage agentImage, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)agentImage, (String)"agentImage");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(context, project);
        this.agentApplication = agentImage;
        this.getRuntimeStatusState().setValue((Object)DockerImageRuntime.Companion.createStatus(agentImage));
        this.detailsProvider = new DockerImageDetailsProvider(this);
    }

    @Override
    @NotNull
    public String getId() {
        return this.getAgentApplication().getImageId();
    }

    @Override
    @NotNull
    public DockerAgentImage getAgentApplication() {
        return this.agentApplication;
    }

    public void setAgentApplication$intellij_clouds_docker(@NotNull DockerAgentImage value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getRuntimeStatusState().setValue((Object)DockerImageRuntime.Companion.createStatus(value));
        this.agentApplication = value;
    }

    @NotNull
    public final Image getImage() {
        return this.getAgentApplication().getImage();
    }

    @NotNull
    public final Set<String> getImageRepoTags() {
        String[] stringArray = this.getAgentApplication().getImageRepoTags();
        return SetsKt.setOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
    }

    @Override
    @NotNull
    public DockerRuntimeDetailsProvider getDetailsProvider() {
        return this.detailsProvider;
    }

    @NotNull
    public abstract CompletableFuture<Unit> deleteImage();

    @NotNull
    public abstract CompletableFuture<Unit> push(@NotNull Project var1, @NotNull DockerRepositoryModel var2);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/runtimes/DockerImageRuntime$Companion;", "", "<init>", "()V", "createStatus", "Lcom/intellij/docker/DockerStatus;", "Lcom/intellij/docker/agent/DockerAgentImage;", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        private final DockerStatus createStatus(DockerAgentImage $this$createStatus) {
            Icon icon = DockerIcons.SingleImage;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SingleImage");
            return DockerStatus.Companion.create(icon, () -> Companion.createStatus$lambda$0($this$createStatus));
        }

        private static final String createStatus$lambda$0(DockerAgentImage $this_createStatus) {
            String string;
            String string2;
            Long l = $this_createStatus.getImage().getCreated();
            if (l != null) {
                long secondsSinceTimeStart = ((Number)l).longValue();
                boolean bl = false;
                string2 = DockerUtil.formatDuration((long)(System.currentTimeMillis() / (long)1000 - secondsSinceTimeStart));
            } else {
                string2 = null;
            }
            String created = string2;
            Long l2 = $this_createStatus.getImage().getVirtualSize();
            if (l2 != null) {
                long bytes = ((Number)l2).longValue();
                boolean bl = false;
                string = DockerProgressDetailsFormat.Companion.humanSizeBytes((double)bytes);
            } else {
                string = null;
            }
            String size = string;
            Object[] objectArray = new String[]{created, size};
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" / ", null, null, (int)0, null, Companion::createStatus$lambda$0$2, (int)30, null);
        }

        private static final CharSequence createStatus$lambda$0$2(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

