/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.panel;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridWithNestedTables;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.scientific.tables.DSGridLoader;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.panel.DSTable;
import com.intellij.scientific.tables.utils.DSTablesEventListener;
import com.intellij.ui.components.JBLoadingPanel;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0000H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/intellij/scientific/tables/panel/DSTableImpl;", "Lcom/intellij/scientific/tables/panel/DSTable;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "loader", "Lcom/intellij/scientific/tables/DSGridLoader;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/scientific/tables/DSGridLoader;)V", "getGrid", "()Lcom/intellij/database/datagrid/DataGrid;", "getLoader", "()Lcom/intellij/scientific/tables/DSGridLoader;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "fetchData", "Lcom/intellij/openapi/util/ActionCallback;", "tableDataRetriever", "Lcom/intellij/scientific/tables/api/DSTableDataRetrieverFromDataSource;", "isUpdate", "", "setVisibleRowCount", "", "v", "", "getTableDataRetrieverFromDataSource", "getDimensionsText", "", "notifyTableCreatedAndDataLoadedCreated", "table", "intellij.scientific.tables"})
public abstract class DSTableImpl
implements DSTable {
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final DSGridLoader loader;

    public DSTableImpl(@NotNull DataGrid grid2, @NotNull DSGridLoader loader) {
        Intrinsics.checkNotNullParameter((Object)grid2, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)((Object)loader), (String)"loader");
        this.grid = grid2;
        this.loader = loader;
    }

    @NotNull
    public final DataGrid getGrid() {
        return this.grid;
    }

    @NotNull
    public final DSGridLoader getLoader() {
        return this.loader;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JBLoadingPanel jBLoadingPanel = this.grid.getPanel().getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jBLoadingPanel, (String)"getComponent(...)");
        return (JComponent)jBLoadingPanel;
    }

    @Override
    @NotNull
    public Disposable getDisposable() {
        return (Disposable)this.grid;
    }

    @Override
    @NotNull
    public ActionCallback fetchData(@NotNull DSTableDataRetrieverFromDataSource tableDataRetriever, boolean isUpdate) {
        Intrinsics.checkNotNullParameter((Object)tableDataRetriever, (String)"tableDataRetriever");
        this.loader.setTableDataRetrieverFromDataSource(tableDataRetriever);
        GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this.grid));
        if (isUpdate) {
            this.loader.loadAndSetColumns(source);
        } else {
            this.loader.loadFirstPage(source);
            this.notifyTableCreatedAndDataLoadedCreated(this);
        }
        ActionCallback actionCallback = source.getActionCallback();
        Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"getActionCallback(...)");
        return actionCallback;
    }

    @Override
    public void setVisibleRowCount(int v) {
        this.grid.getAppearance().setResultViewVisibleRowCount(v);
    }

    @Override
    @Nullable
    public DSTableDataRetrieverFromDataSource getTableDataRetrieverFromDataSource() {
        return this.loader.getTableDataRetrieverFromDataSource();
    }

    @Override
    @NlsSafe
    @Nullable
    public String getDimensionsText(@NotNull DSTableDataRetrieverFromDataSource tableDataRetriever) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)tableDataRetriever, (String)"tableDataRetriever");
        if (!(this.grid instanceof DataGridWithNestedTables) || !((DataGridWithNestedTables)this.grid).isNestedTableStatic()) {
            object = tableDataRetriever.getDimensionText();
        } else {
            GridModel gridModel = this.grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
            Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
            GridModel model = gridModel;
            object = model.getRowCount() + "x" + model.getColumnCount();
        }
        return object;
    }

    private final void notifyTableCreatedAndDataLoadedCreated(DSTableImpl table) {
        ((DSTablesEventListener)table.grid.getProject().getMessageBus().syncPublisher(DSTablesEventListener.Companion.getDS_TABLE_CREATED_TOPIC())).tableCreatedAndDataLoaded(table);
    }
}

