/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.model.specification.SwaggerFileHelper;
import com.intellij.swagger.core.settings.SwaggerSettings;
import com.intellij.swagger.core.settings.SwaggerSettingsState;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.SwaggerEditorWithPreview;
import com.intellij.swagger.core.ui.SwaggerUIEditorProviderKt;
import com.intellij.swagger.core.ui.browser.SwPreviewCefBrowser;
import com.intellij.swagger.core.ui.browser.strategy.AsyncApiProviderStrategy;
import com.intellij.swagger.core.ui.browser.strategy.RedocProviderStrategy;
import com.intellij.swagger.core.ui.browser.strategy.SwPreviewProviderStrategy;
import com.intellij.swagger.core.ui.browser.strategy.SwaggerUiProviderStrategy;
import com.intellij.ui.jcef.JBCefApp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/swagger/core/ui/SwaggerUIEditorProvider;", "Lcom/intellij/openapi/fileEditor/AsyncFileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "acceptRequiresReadAction", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "createEditorAsync", "Lcom/intellij/openapi/fileEditor/AsyncFileEditorProvider$Builder;", "prepareEditorBuilder", "EditorBuilder", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwaggerUIEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerUIEditorProvider.kt\ncom/intellij/swagger/core/ui/SwaggerUIEditorProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
final class SwaggerUIEditorProvider
implements AsyncFileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!SwaggerFileHelper.INSTANCE.isSuitableFileType$intellij_swagger_core(file)) {
            return false;
        }
        Object object = ApplicationManager.getApplication().runReadAction(() -> SwaggerUIEditorProvider.accept$lambda$0(project, file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        return (Boolean)object;
    }

    public boolean acceptRequiresReadAction() {
        return false;
    }

    @NotNull
    public String getEditorTypeId() {
        return "intellij.swagger.ui.editor.with.preview";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SwaggerUIEditorProviderKt.access$createTextEditor(project, file);
    }

    @NotNull
    public AsyncFileEditorProvider.Builder createEditorAsync(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.prepareEditorBuilder(project, file);
    }

    private final AsyncFileEditorProvider.Builder prepareEditorBuilder(Project project, VirtualFile file) {
        SwSpecificationType swSpecificationType;
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile2 != null) {
            PsiFile it = psiFile2;
            boolean bl = false;
            swSpecificationType = SwSpecificationDetectionKt.detectPrimarySpecificationType(file, psiFile);
        } else {
            swSpecificationType = null;
        }
        SwSpecificationType specificationType = swSpecificationType;
        SwPreviewType lastSelectedPreviewType = ((SwaggerSettingsState)SwaggerSettings.Companion.getInstance(project).getState()).getDefaultPreviewType();
        SwPreviewProviderStrategy previewProvider = specificationType instanceof SwSpecificationType.NONE || specificationType == null ? null : (specificationType instanceof SwSpecificationType.AsyncAPIFamily ? (SwPreviewProviderStrategy)AsyncApiProviderStrategy.INSTANCE : (lastSelectedPreviewType == SwPreviewType.REDOC && Registry.Companion.is("swagger.redoc.preview.enabled.key") ? (SwPreviewProviderStrategy)RedocProviderStrategy.INSTANCE : (SwPreviewProviderStrategy)SwaggerUiProviderStrategy.INSTANCE));
        return new EditorBuilder(project, file, previewProvider);
    }

    private static final Boolean accept$lambda$0(Project $project, VirtualFile $file) {
        PsiFile psiFile = PsiManager.getInstance((Project)$project).findFile($file);
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        SwSpecificationType primarySpecificationType = SwSpecificationDetectionKt.detectPrimarySpecificationType($file, psiFile2);
        return !(primarySpecificationType instanceof SwSpecificationType.NONE);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/swagger/core/ui/SwaggerUIEditorProvider$EditorBuilder;", "Lcom/intellij/openapi/fileEditor/AsyncFileEditorProvider$Builder;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "previewProvider", "Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewProviderStrategy;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewProviderStrategy;)V", "build", "Lcom/intellij/openapi/fileEditor/FileEditor;", "buildJcefPreviewEditor", "Lcom/intellij/swagger/core/ui/SwaggerEditorWithPreview;", "generalEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "intellij.swagger.core"})
    private static final class EditorBuilder
    extends AsyncFileEditorProvider.Builder {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile file;
        @Nullable
        private final SwPreviewProviderStrategy previewProvider;

        public EditorBuilder(@NotNull Project project, @NotNull VirtualFile file, @Nullable SwPreviewProviderStrategy previewProvider) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.project = project;
            this.file = file;
            this.previewProvider = previewProvider;
        }

        @NotNull
        public FileEditor build() {
            FileEditor generalEditor = SwaggerUIEditorProviderKt.access$createTextEditor(this.project, this.file);
            return this.previewProvider != null && generalEditor instanceof TextEditor && JBCefApp.isSupported() ? (FileEditor)this.buildJcefPreviewEditor((TextEditor)generalEditor, this.previewProvider) : generalEditor;
        }

        private final SwaggerEditorWithPreview buildJcefPreviewEditor(TextEditor generalEditor, SwPreviewProviderStrategy previewProvider) {
            return new SwaggerEditorWithPreview(generalEditor, new SwPreviewCefBrowser(this.file, generalEditor, this.project, previewProvider));
        }
    }
}

