/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.timeTracking;

import com.intellij.concurrency.ThreadContext;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ReportValue;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.timeTracking.TasksToolWindowFactory;
import com.intellij.tasks.timeTracking.model.WorkItem;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.util.ui.TimerUtil;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TimeTrackingManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\b\u0001\u0018\u0000 #2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002#$B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0016J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001bJ\b\u0010\u001f\u001a\u00020\u0016H\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\u00a8\u0006%"}, d2={"Lcom/intellij/tasks/timeTracking/TimeTrackingManager;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/tasks/timeTracking/TimeTrackingManager$Config;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "config", "timeTrackingTimer", "Ljavax/swing/Timer;", "activityListener", "Ljava/lang/Runnable;", "lastActiveTask", "Lcom/intellij/tasks/LocalTask;", "activityListenerDisposable", "idleRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lkotlin/time/Duration;", "startTimeTrackingTimer", "", "startTimeTrackingTimer$intellij_tasks_timeTracking", "startIdleAlarm", "updateTimeTrackingToolWindow", "isTimeTrackingToolWindowAvailable", "", "()Z", "setAutoMode", "on", "dispose", "getState", "loadState", "state", "Companion", "Config", "intellij.tasks.timeTracking"})
@SourceDebugExtension(value={"SMAP\nTimeTrackingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeTrackingManager.kt\ncom/intellij/tasks/timeTracking/TimeTrackingManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1#2:217\n*E\n"})
public final class TimeTrackingManager
implements Disposable,
PersistentStateComponent<Config> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private Config config;
    @Nullable
    private Timer timeTrackingTimer;
    @NotNull
    private final Runnable activityListener;
    @Nullable
    private LocalTask lastActiveTask;
    @Nullable
    private Disposable activityListenerDisposable;
    @NotNull
    private final MutableSharedFlow<Duration> idleRequests;
    private static final int TIME_TRACKING_TIME_UNIT = 1000;

    public TimeTrackingManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.config = new Config();
        this.idleRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        PluginVerifier.verifyUltimatePlugin();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Timer timeTrackingTimer;
            Timer timer = TimerUtil.createNamedTimer((String)"TaskManager time tracking", (int)1000, arg_0 -> TimeTrackingManager._init_$lambda$0(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)timer, (String)"createNamedTimer(...)");
            this.timeTrackingTimer = timeTrackingTimer = timer;
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, timeTrackingTimer, null){
                int label;
                final /* synthetic */ TimeTrackingManager this$0;
                final /* synthetic */ Timer $timeTrackingTimer;
                {
                    this.this$0 = $receiver;
                    this.$timeTrackingTimer = $timeTrackingTimer;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.idleRequests), (Function2)((Function2)new Function2<Duration, Continuation<? super Unit>, Object>(this.$timeTrackingTimer, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ Timer $timeTrackingTimer;
                                {
                                    this.$timeTrackingTimer = $timeTrackingTimer;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var2_2 = (Duration)this.L$0;
                                    var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            if (it == null) {
                                                return Unit.INSTANCE;
                                            }
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                            this.label = 1;
                                            v0 = DelayKt.delay-VtjQ1oo((long)it.unbox-impl(), (Continuation)((Continuation)this));
                                            if (v0 == var3_3) {
                                                return var3_3;
                                            }
                                            ** GOTO lbl17
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl17:
                                            // 2 sources

                                            if (this.$timeTrackingTimer.isRunning()) {
                                                this.$timeTrackingTimer.stop();
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = (Duration)value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke-dnQKTGw(Duration p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            this.activityListener = () -> TimeTrackingManager._init_$lambda$1(this);
            if (this.getState().autoMode) {
                IdeEventQueue.Companion.getInstance().addActivityListener(ThreadContext.captureThreadContext((Runnable)this.activityListener), this.coroutineScope);
            }
        } else {
            this.timeTrackingTimer = null;
            Runnable runnable = EmptyRunnable.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"getInstance(...)");
            this.activityListener = runnable;
        }
    }

    public final void startTimeTrackingTimer$intellij_tasks_timeTracking() {
        Timer timer = this.timeTrackingTimer;
        if (timer != null) {
            Timer timer2;
            Timer it = timer2 = timer;
            boolean bl = false;
            timer = !it.isRunning() ? timer2 : null;
            if (timer != null) {
                timer.start();
            }
        }
        this.startIdleAlarm();
    }

    public final void startIdleAlarm() {
        this.idleRequests.tryEmit((Object)Duration.box-impl((long)DurationKt.toDuration((int)this.getState().suspendDelayInSeconds, (DurationUnit)DurationUnit.SECONDS)));
    }

    public final void updateTimeTrackingToolWindow() {
        Ref.ObjectRef toolWindow = new Ref.ObjectRef();
        toolWindow.element = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Time Tracking");
        if (this.isTimeTrackingToolWindowAvailable()) {
            if (toolWindow.element == null) {
                ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.project);
                ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.RIGHT;
                Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"RIGHT");
                toolWindow.element = toolWindowManager.registerToolWindow("Time Tracking", true, toolWindowAnchor, (Disposable)this, true);
                new TasksToolWindowFactory().createToolWindowContent(this.project, (ToolWindow)toolWindow.element);
            }
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<ToolWindow>)toolWindow, null){
                int label;
                final /* synthetic */ Ref.ObjectRef<ToolWindow> $toolWindow;
                {
                    this.$toolWindow = $toolWindow;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ((ToolWindow)this.$toolWindow.element).setAvailable(true);
                            ((ToolWindow)this.$toolWindow.element).show(null);
                            ((ToolWindow)this.$toolWindow.element).activate(null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        } else if (toolWindow.element != null) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<ToolWindow>)toolWindow, null){
                int label;
                final /* synthetic */ Ref.ObjectRef<ToolWindow> $toolWindow;
                {
                    this.$toolWindow = $toolWindow;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ((ToolWindow)this.$toolWindow.element).setAvailable(false);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public final boolean isTimeTrackingToolWindowAvailable() {
        return this.getState().enabled;
    }

    public final void setAutoMode(boolean on) {
        boolean oldState = this.getState().autoMode;
        if (on == oldState) {
            return;
        }
        this.getState().autoMode = on;
        Disposable activityListenerDisposable = this.activityListenerDisposable;
        if (on) {
            if (activityListenerDisposable == null) {
                this.activityListenerDisposable = activityListenerDisposable = Disposer.newDisposable();
            }
            IdeEventQueue.Companion.getInstance().addActivityListener(this.activityListener, activityListenerDisposable);
        } else {
            if (activityListenerDisposable != null) {
                this.activityListenerDisposable = null;
                Disposer.dispose((Disposable)activityListenerDisposable);
            }
            this.idleRequests.tryEmit(null);
            Timer timer = this.timeTrackingTimer;
            Intrinsics.checkNotNull((Object)timer);
            if (!timer.isRunning()) {
                Timer timer2 = this.timeTrackingTimer;
                Intrinsics.checkNotNull((Object)timer2);
                timer2.start();
            }
        }
    }

    public void dispose() {
        block0: {
            Timer timer = this.timeTrackingTimer;
            if (timer == null) break block0;
            Timer it = timer;
            boolean bl = false;
            it.stop();
            this.timeTrackingTimer = null;
        }
    }

    @NotNull
    public Config getState() {
        return this.config;
    }

    public void loadState(@NotNull Config state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.config = state;
    }

    private static final void _init_$lambda$0(TimeTrackingManager this$0, ActionEvent it) {
        LocalTask localTask = TaskManager.getManager((Project)this$0.project).getActiveTask();
        Intrinsics.checkNotNullExpressionValue((Object)localTask, (String)"getActiveTask(...)");
        LocalTask activeTask = localTask;
        if (this$0.lastActiveTask != activeTask) {
            activeTask.addWorkItem(new WorkItem(new Date()));
        }
        if (activeTask.isRunning() || this$0.getState().autoMode) {
            WorkItem lastWorkItem = (WorkItem)activeTask.getWorkItems().get(activeTask.getWorkItems().size() - 1);
            lastWorkItem.duration += 1000L;
            Config config = this$0.getState();
            config.totallyTimeSpent += 1000L;
        }
        this$0.lastActiveTask = activeTask;
    }

    private static final void _init_$lambda$1(TimeTrackingManager this$0) {
        IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (ideFrame == null) {
            return;
        }
        IdeFrame frame = ideFrame;
        Project p = frame.getProject();
        if (p != null && this$0.project == p) {
            this$0.startTimeTrackingTimer$intellij_tasks_timeTracking();
        }
    }

    @JvmStatic
    @NotNull
    public static final TimeTrackingManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/tasks/timeTracking/TimeTrackingManager$Companion;", "", "<init>", "()V", "TIME_TRACKING_TIME_UNIT", "", "getInstance", "Lcom/intellij/tasks/timeTracking/TimeTrackingManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.tasks.timeTracking"})
    @SourceDebugExtension(value={"SMAP\nTimeTrackingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeTrackingManager.kt\ncom/intellij/tasks/timeTracking/TimeTrackingManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,216:1\n30#2,2:217\n*S KotlinDebug\n*F\n+ 1 TimeTrackingManager.kt\ncom/intellij/tasks/timeTracking/TimeTrackingManager$Companion\n*L\n103#1:217,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TimeTrackingManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TimeTrackingManager> serviceClass$iv = TimeTrackingManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TimeTrackingManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/tasks/timeTracking/TimeTrackingManager$Config;", "", "<init>", "()V", "enabled", "", "totallyTimeSpent", "", "suspendDelayInSeconds", "", "autoMode", "showClosedTasks", "showSpentTimeFromLastPost", "intellij.tasks.timeTracking"})
    public static final class Config {
        @JvmField
        public boolean enabled;
        @JvmField
        public long totallyTimeSpent;
        @ReportValue
        @JvmField
        public int suspendDelayInSeconds = 600;
        @JvmField
        public boolean autoMode = true;
        @JvmField
        public boolean showClosedTasks = true;
        @JvmField
        public boolean showSpentTimeFromLastPost;
    }
}

