/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 82552590742752L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-975685080 - -((char)-20199), 975685080 - 30381, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-975685080 - -((char)-20200), 975685080 - 18160, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 71334137460341L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.b();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-974374380 + -4158, 974374380 - 15938, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-974374380 + -4157, 974374380 + 8438, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-974374380 + -4164, -974374380 + -5883, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                int[] nArray;
                l2 = 104866440663144L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    nArray = SshAgentIpcService.b();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(519168270 - 20802, 519168270 - 17409, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(519168270 - 20799, 519168270 - 8633, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(519168270 - 20800, 519168270 + 4769, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(519168270 - 20813, -519168270 + -43, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(519168270 - 20814, -519168270 - -24771, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(519168270 - 20811, -519168270 - -11177, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(519168270 - 20813, -519168270 + -43, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(519168270 - 20812, -519168270 - -10503, (int)l2));
            if (ActionTimestamp.b() == null) {
                SshAgentIpcService.b(new int[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 133908669780394L;
                    nArray = SshAgentIpcService.b();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block27: {
            block28: {
                l2 = 122606672159258L;
                int[] nArray2 = SshAgentIpcService.b();
                this.assertConnectionThread();
                nArray = nArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1759221540 - -5339, 1759221540 + 11932, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1759221540 - -5335, 1759221540 + 21905, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1759221540 - -5338, -1759221540 + -3053, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1759221540 - -5335, 1759221540 + 21905, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1759221540 - -5337, -1759221540 + -9719, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1759221540 - -5339, 1759221540 + 11932, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1759221540 - -5335, 1759221540 + 21905, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1759221540 - -5336, 1759221540 + 20298, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1759221540 - -5339, 1759221540 + 11932, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1759221540 - -5335, 1759221540 + 21905, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1759221540 - -5327, 1759221540 + 9851, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1759221540 - -5335, 1759221540 + 21905, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1759221540 - -5326, -1759221540 + -24413, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1759221540 - -5335, 1759221540 + 21905, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1759221540 - -5337, -1759221540 + -9719, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1759221540 - -5339, 1759221540 + 11932, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1759221540 - -5335, 1759221540 + 21905, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1759221540 - -5325, -1759221540 + -3365, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 27068807618357L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1923714390 - 1312, 1923714390 - 2054, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 111094308416331L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(684316470 + 25875, 684316470 + 13093, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00ccjc\u00ba\u0087\u00a2c$\u00ca$e\u0007\u0014\u0001\u009d\u00e0\u009e\u00ae\r\u0014=]]Z[|\u0085z\u0094\u00e9kj\u0017U<\u00e1GH1.";
                        var4_3 = "\u00ccjc\u00ba\u0087\u00a2c$\u00ca$e\u0007\u0014\u0001\u009d\u00e0\u009e\u00ae\r\u0014=]]Z[|\u0085z\u0094\u00e9kj\u0017U<\u00e1GH1.".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 75;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 113;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 9;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 34;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 116;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 122;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 73;
                                        break;
                                    }
                                    default: {
                                        v11 = 40;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x1703) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 194;
                            case 1 -> 110;
                            case 2 -> 114;
                            case 3 -> 212;
                            case 4 -> 132;
                            case 5 -> 80;
                            case 6 -> 223;
                            case 7 -> 167;
                            case 8 -> 90;
                            case 9 -> 81;
                            case 10 -> 171;
                            case 11 -> 83;
                            case 12 -> 143;
                            case 13 -> 9;
                            case 14 -> 234;
                            case 15 -> 5;
                            case 16 -> 117;
                            case 17 -> 77;
                            case 18 -> 122;
                            case 19 -> 45;
                            case 20 -> 100;
                            case 21 -> 124;
                            case 22 -> 215;
                            case 23 -> 43;
                            case 24 -> 105;
                            case 25 -> 56;
                            case 26 -> 182;
                            case 27 -> 68;
                            case 28 -> 13;
                            case 29 -> 242;
                            case 30 -> 74;
                            case 31 -> 227;
                            case 32 -> 93;
                            case 33 -> 108;
                            case 34 -> 156;
                            case 35 -> 73;
                            case 36 -> 147;
                            case 37 -> 118;
                            case 38 -> 102;
                            case 39 -> 148;
                            case 40 -> 210;
                            case 41 -> 253;
                            case 42 -> 46;
                            case 43 -> 92;
                            case 44 -> 25;
                            case 45 -> 22;
                            case 46 -> 129;
                            case 47 -> 126;
                            case 48 -> 183;
                            case 49 -> 125;
                            case 50 -> 1;
                            case 51 -> 23;
                            case 52 -> 175;
                            case 53 -> 137;
                            case 54 -> 229;
                            case 55 -> 72;
                            case 56 -> 218;
                            case 57 -> 169;
                            case 58 -> 236;
                            case 59 -> 85;
                            case 60 -> 36;
                            case 61 -> 6;
                            case 62 -> 203;
                            case 63 -> 87;
                            case 64 -> 202;
                            case 65 -> 107;
                            case 66 -> 221;
                            case 67 -> 193;
                            case 68 -> 76;
                            case 69 -> 246;
                            case 70 -> 98;
                            case 71 -> 97;
                            case 72 -> 135;
                            case 73 -> 160;
                            case 74 -> 252;
                            case 75 -> 161;
                            case 76 -> 232;
                            case 77 -> 141;
                            case 78 -> 18;
                            case 79 -> 111;
                            case 80 -> 207;
                            case 81 -> 119;
                            case 82 -> 53;
                            case 83 -> 138;
                            case 84 -> 10;
                            case 85 -> 254;
                            case 86 -> 237;
                            case 87 -> 139;
                            case 88 -> 50;
                            case 89 -> 19;
                            case 90 -> 231;
                            case 91 -> 172;
                            case 92 -> 3;
                            case 93 -> 233;
                            case 94 -> 145;
                            case 95 -> 179;
                            case 96 -> 41;
                            case 97 -> 62;
                            case 98 -> 220;
                            case 99 -> 32;
                            case 100 -> 34;
                            case 101 -> 180;
                            case 102 -> 130;
                            case 103 -> 88;
                            case 104 -> 191;
                            case 105 -> 120;
                            case 106 -> 55;
                            case 107 -> 16;
                            case 108 -> 196;
                            case 109 -> 38;
                            case 110 -> 59;
                            case 111 -> 123;
                            case 112 -> 239;
                            case 113 -> 185;
                            case 114 -> 49;
                            case 115 -> 84;
                            case 116 -> 14;
                            case 117 -> 146;
                            case 118 -> 89;
                            case 119 -> 158;
                            case 120 -> 250;
                            case 121 -> 176;
                            case 122 -> 197;
                            case 123 -> 94;
                            case 124 -> 166;
                            case 125 -> 31;
                            case 126 -> 30;
                            case 127 -> 159;
                            case 128 -> 11;
                            case 129 -> 162;
                            case 130 -> 222;
                            case 131 -> 188;
                            case 132 -> 163;
                            case 133 -> 95;
                            case 134 -> 211;
                            case 135 -> 65;
                            case 136 -> 154;
                            case 137 -> 71;
                            case 138 -> 66;
                            case 139 -> 4;
                            case 140 -> 241;
                            case 141 -> 174;
                            case 142 -> 69;
                            case 143 -> 51;
                            case 144 -> 198;
                            case 145 -> 178;
                            case 146 -> 75;
                            case 147 -> 228;
                            case 148 -> 181;
                            case 149 -> 101;
                            case 150 -> 57;
                            case 151 -> 150;
                            case 152 -> 8;
                            case 153 -> 20;
                            case 154 -> 177;
                            case 155 -> 79;
                            case 156 -> 226;
                            case 157 -> 54;
                            case 158 -> 219;
                            case 159 -> 230;
                            case 160 -> 168;
                            case 161 -> 152;
                            case 162 -> 64;
                            case 163 -> 17;
                            case 164 -> 29;
                            case 165 -> 170;
                            case 166 -> 142;
                            case 167 -> 127;
                            case 168 -> 225;
                            case 169 -> 240;
                            case 170 -> 67;
                            case 171 -> 187;
                            case 172 -> 63;
                            case 173 -> 151;
                            case 174 -> 134;
                            case 175 -> 189;
                            case 176 -> 15;
                            case 177 -> 37;
                            case 178 -> 112;
                            case 179 -> 40;
                            case 180 -> 82;
                            case 181 -> 44;
                            case 182 -> 2;
                            case 183 -> 199;
                            case 184 -> 190;
                            case 185 -> 224;
                            case 186 -> 173;
                            case 187 -> 249;
                            case 188 -> 201;
                            case 189 -> 28;
                            case 190 -> 39;
                            case 191 -> 26;
                            case 192 -> 42;
                            case 193 -> 136;
                            case 194 -> 213;
                            case 195 -> 186;
                            case 196 -> 47;
                            case 197 -> 99;
                            case 198 -> 157;
                            case 199 -> 109;
                            case 200 -> 204;
                            case 201 -> 12;
                            case 202 -> 208;
                            case 203 -> 21;
                            case 204 -> 195;
                            case 205 -> 61;
                            case 206 -> 24;
                            case 207 -> 35;
                            case 208 -> 206;
                            case 209 -> 121;
                            case 210 -> 209;
                            case 211 -> 58;
                            case 212 -> 251;
                            case 213 -> 214;
                            case 214 -> 52;
                            case 215 -> 153;
                            case 216 -> 91;
                            case 217 -> 133;
                            case 218 -> 131;
                            case 219 -> 248;
                            case 220 -> 165;
                            case 221 -> 255;
                            case 222 -> 113;
                            case 223 -> 128;
                            case 224 -> 104;
                            case 225 -> 60;
                            case 226 -> 115;
                            case 227 -> 164;
                            case 228 -> 245;
                            case 229 -> 70;
                            case 230 -> 33;
                            case 231 -> 244;
                            case 232 -> 78;
                            case 233 -> 149;
                            case 234 -> 7;
                            case 235 -> 48;
                            case 236 -> 27;
                            case 237 -> 243;
                            case 238 -> 155;
                            case 239 -> 86;
                            case 240 -> 192;
                            case 241 -> 103;
                            case 242 -> 116;
                            case 243 -> 235;
                            case 244 -> 184;
                            case 245 -> 144;
                            case 246 -> 205;
                            case 247 -> 216;
                            case 248 -> 106;
                            case 249 -> 217;
                            case 250 -> 238;
                            case 251 -> 96;
                            case 252 -> 0;
                            case 253 -> 247;
                            case 254 -> 140;
                            default -> 200;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray != null) {
                ActionTimestamp.b("nR1cpc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 76869179502668L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.b();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2145222690 - -((char)-20477), 2145222690 - (char)-6004, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2145222690 - -((char)-20473), 2145222690 - (char)-16065, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2145222690 - -((char)-20448), 2145222690 - (char)-32614, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2145222690 - -((char)-20477), 2145222690 - (char)-6004, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-2145222690 - -((char)-20473), 2145222690 - (char)-16065, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2145222690 - -((char)-20453), 2145222690 - (char)-23481, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 24686867402371L;
                        int[] nArray2 = SshAgentIpcService.b();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-604625910 + -4819, -604625910 - -17074, (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-604625910 + -4822, -604625910 + -4695, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 113190955840744L;
                int[] nArray2 = SshAgentIpcService.b();
                this.assertConnectionThread();
                nArray = nArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1387638090 + (char)-517, -1387769160 - -((char)-16262), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1387638090 + (char)-521, -1387769160 - -((char)-6257), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1387638090 + (char)-492, 1387638090 + (char)-264, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1387638090 + (char)-521, -1387769160 - -((char)-6257), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1387638090 + (char)-515, 1387638090 + (char)-6451, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1387638090 + (char)-517, -1387769160 - -((char)-16262), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1387638090 + (char)-521, -1387769160 - -((char)-6257), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1387638090 + (char)-505, -1387638090 + -((char)-356), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1387638090 + (char)-517, -1387769160 - -((char)-16262), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1387638090 + (char)-521, -1387769160 - -((char)-6257), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1387638090 + (char)-506, -1387638090 + -((char)-7990), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1387638090 + (char)-517, -1387769160 - -((char)-16262), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1387638090 + (char)-521, -1387769160 - -((char)-6257), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1387638090 + (char)-503, -1387769160 - -((char)-1470), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 51746609867882L;
                    Object object = this.lock;
                    nArray = SshAgentIpcService.b();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(843959730 - (char)-9749, -843828660 + -((char)-6500), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(843959730 - (char)-9745, -843828660 + -((char)-12409), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(843959730 - (char)-9758, 843828660 + (char)-11695, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(843959730 - (char)-9765, -843828660 + -((char)-1938), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(843959730 - (char)-9749, -843828660 + -((char)-6500), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(843959730 - (char)-9745, -843828660 + -((char)-12409), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(843959730 - (char)-9764, -843828660 + -((char)-14081), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(843959730 - (char)-9749, -843828660 + -((char)-6500), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(843959730 - (char)-9745, -843828660 + -((char)-12409), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(843959730 - (char)-9763, 843828660 + (char)-7528, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(843959730 - (char)-9749, -843828660 + -((char)-6500), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(843959730 - (char)-9745, -843828660 + -((char)-12409), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(843959730 - (char)-9762, 843828660 + (char)-14775, (int)l2));
                    if (nArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(843959730 - (char)-9749, -843828660 + -((char)-6500), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(843959730 - (char)-9745, -843828660 + -((char)-12409), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(843959730 - (char)-9785, 843828660 + (char)-762, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(843959730 - (char)-9784, -843959730 - -((char)-7351), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "Mn\u00c2\u0089\u0006$,\u0089\u0014j\u00c5\u001e\u001bc\u00fe/\u00c8\u00a8\u0089\u007fl\u0099\u00c6\u0081\u00aa\u00a0\u00e0X!\u0006\u00a2#? \u00d3P\u0018*.vV\u00ec\u0092\u00dc\u0085\u001e]\u00a6\u0086\u00c4dx|6S\u00a4\u00ca\u00eb\u001b*\u00f2\t\u0090\u001f\u00bf\u00c1\u00be\u00ff\u008e`h\u0005\u00ff\u00a4\u0094\u00d0\u00bc\b\u0082\u00a4;\u00a1k\u0007\u0087\u000f\u0014\u00b5\n\u009dy~\u00ba\u00b9\u00d7\u0014\u00b7C\u001fT\u000b\u0083\u00fe\u00f2\u00b9\u00ebH\u0005\u00c4\u0094\u00f3\u00d6P\u001e?a\u0099\f\u0080\u001d\u00f3\u000e^8\u00e5\u00ad\u00e0!^\u00b0\u0013[\u00d2?\u0089\u008aj\rpY,\u00ba\u00e3!\u0010\u00a3\u00b0\u00ee\u00f39\u00d02N\u001b\u0082\u00c0\u0007B!\u00a5/\tx\u000et\u00f2\u0094\u00be\u00ed\u00d7\u00ea\u0010S\u000e\u00f0$\u00fa*J\u0011\u0014i!z~\u008e\"\u00da?6\u00cf\u00b0\u00d9\u00a8\u00aes\u0014?\u00aa\u008c\u0004r\u00e21\u00f1;\u0016\u00aaS\bU!\u0090\t\u0002\u000ee\u0090\u008c\u00f0\u00a2\u00cc\u00b6\u0013\u009e9]1\u00f8\u0014v`B\b\u000e\u00bd\u00ab\u00d7\u00c6t\u0093\u0081}0=\u00f4\u00f6\u00ab\u00c7\u008bmt\bS\u00c4\u0001\u00ad,\u0086o?\f9\u0019\\\r\u009a\u00f0W\u00f6\u009e\u00dd\"\u00e8F\u00e4n\u00e7\u00e3\u00ed-\u00b9MC\u00a6\u0093C\u0007\u0002\u0080\u00cb\u00f16\u00f3\u00f81r\u0005F\u00bb\u00f3\u00abP\u009b\u0003\u00abo\u009b\u00b9;^\u00e6\ba\u0096\u008d\u00ae\u00d8\u00a2\u00c1\u0097\u00d0\u00e5\u009d\u00f7[\u001f\u008bzg\u00c6\u0081\u00fd\u0093\u001a\u00bf\u00bf\u00ae54gz\u001d\u00d8@\u001f\u00fa\u00d0!:\u0097\u00db\u0011\u00d6\u0002#n\u00ce\u0091P{/\u00cc@T\u0096\u0092?\u00de\u0010\u0087*\u00c5\u0018\u00c3\u0084\u00a2\u000b\u0080<k\u00a9|d\u008bd\u0005\u0083[\u0015vQ\u00b5\u0007\u00a0\u00d9\u00fc\u00ae\u00d5:\u0089&\u00d3\u00e1.O\u009d\u00d8\u00a3\u00fcZ)I\rW\u0081Y\u00ac\u00c889\u00fe\tuy-\u00f8\u0085\u00e3\u009dj\u008a\u00a5\u00c4\u00few\u00ec\u008f\u007f\u00d4\u00bb\u00e9/\f\u00f5p\u0090\u00ea\u008d\u0083\u0087N\u00f2\u0007\u00ee\u00af\u00a9\u00cf\u00a28,\u0007\u0017N\u00f2\u009f.\u00dd\u00ab(\u00b5D\u0084\u0089\u0093\u00c7gr\u00bc`\u0093\u0090\t\u0010\u00b4\u00a1m\u00b4\u0015\u00ec+6@\u00e2\u00ab\u0081!nG\u00dek\u00f3\u0086\u00e4`\u00d5)\u0019\u0080\u00ee\u000f\u0003\u00a1\u001c\u001ch\u0019\u00bdj\u0092\u00ee\u00f7\u0010%T\u00af\"!\u00d2Zz\u00f8\u00d3\u00fc\u00d7\u00bf\u0003\u00d9\u00ca`\u00d6\u00bf4\u00e0\u0082\u0080+\u0012\u00f0\u00a8\u00a1\u00b5\u0001\u0099\u00dbC:\u0092ql,\u000e\u0081WL\u00c2b\u00c2\u00fc\u0011\u00ba\u0081\u00f2\u00fd\u0089\u00e3\u001b\u00a52\u00cfk\u00e9B\u0018]q\u008f\u0006=G\u00cd}A\u0010\u0086#7]G2\u00f1\u00adf\u00cf\n\u0015\u0094\u001d\u00b8\u00a7\u00dc\u0002\u00a4\u0099\u00d2\u0018\u008aX*+T\u00f6\u008e\u0095\u00bd_]\u00b8\u0095.\u00db\u001c\u00b3,\u0080\u001bQ\u0089\u00e8{)\u001ed\u00bd\u00ac\u0004\tc\u008cLh\u00a7\u00a7\u00a8~]\u0094)\u00ca\u00ec\u00a5O1\u00ea\u00c5\u001bK\u001c\u00a0\u0084;s\u00c7[\u00d7\u0090\u008aS\u00ab\\K\u0089\tIaR\u0001Z\u000fb\u00ba\u00a6";
                var4_3 = "Mn\u00c2\u0089\u0006$,\u0089\u0014j\u00c5\u001e\u001bc\u00fe/\u00c8\u00a8\u0089\u007fl\u0099\u00c6\u0081\u00aa\u00a0\u00e0X!\u0006\u00a2#? \u00d3P\u0018*.vV\u00ec\u0092\u00dc\u0085\u001e]\u00a6\u0086\u00c4dx|6S\u00a4\u00ca\u00eb\u001b*\u00f2\t\u0090\u001f\u00bf\u00c1\u00be\u00ff\u008e`h\u0005\u00ff\u00a4\u0094\u00d0\u00bc\b\u0082\u00a4;\u00a1k\u0007\u0087\u000f\u0014\u00b5\n\u009dy~\u00ba\u00b9\u00d7\u0014\u00b7C\u001fT\u000b\u0083\u00fe\u00f2\u00b9\u00ebH\u0005\u00c4\u0094\u00f3\u00d6P\u001e?a\u0099\f\u0080\u001d\u00f3\u000e^8\u00e5\u00ad\u00e0!^\u00b0\u0013[\u00d2?\u0089\u008aj\rpY,\u00ba\u00e3!\u0010\u00a3\u00b0\u00ee\u00f39\u00d02N\u001b\u0082\u00c0\u0007B!\u00a5/\tx\u000et\u00f2\u0094\u00be\u00ed\u00d7\u00ea\u0010S\u000e\u00f0$\u00fa*J\u0011\u0014i!z~\u008e\"\u00da?6\u00cf\u00b0\u00d9\u00a8\u00aes\u0014?\u00aa\u008c\u0004r\u00e21\u00f1;\u0016\u00aaS\bU!\u0090\t\u0002\u000ee\u0090\u008c\u00f0\u00a2\u00cc\u00b6\u0013\u009e9]1\u00f8\u0014v`B\b\u000e\u00bd\u00ab\u00d7\u00c6t\u0093\u0081}0=\u00f4\u00f6\u00ab\u00c7\u008bmt\bS\u00c4\u0001\u00ad,\u0086o?\f9\u0019\\\r\u009a\u00f0W\u00f6\u009e\u00dd\"\u00e8F\u00e4n\u00e7\u00e3\u00ed-\u00b9MC\u00a6\u0093C\u0007\u0002\u0080\u00cb\u00f16\u00f3\u00f81r\u0005F\u00bb\u00f3\u00abP\u009b\u0003\u00abo\u009b\u00b9;^\u00e6\ba\u0096\u008d\u00ae\u00d8\u00a2\u00c1\u0097\u00d0\u00e5\u009d\u00f7[\u001f\u008bzg\u00c6\u0081\u00fd\u0093\u001a\u00bf\u00bf\u00ae54gz\u001d\u00d8@\u001f\u00fa\u00d0!:\u0097\u00db\u0011\u00d6\u0002#n\u00ce\u0091P{/\u00cc@T\u0096\u0092?\u00de\u0010\u0087*\u00c5\u0018\u00c3\u0084\u00a2\u000b\u0080<k\u00a9|d\u008bd\u0005\u0083[\u0015vQ\u00b5\u0007\u00a0\u00d9\u00fc\u00ae\u00d5:\u0089&\u00d3\u00e1.O\u009d\u00d8\u00a3\u00fcZ)I\rW\u0081Y\u00ac\u00c889\u00fe\tuy-\u00f8\u0085\u00e3\u009dj\u008a\u00a5\u00c4\u00few\u00ec\u008f\u007f\u00d4\u00bb\u00e9/\f\u00f5p\u0090\u00ea\u008d\u0083\u0087N\u00f2\u0007\u00ee\u00af\u00a9\u00cf\u00a28,\u0007\u0017N\u00f2\u009f.\u00dd\u00ab(\u00b5D\u0084\u0089\u0093\u00c7gr\u00bc`\u0093\u0090\t\u0010\u00b4\u00a1m\u00b4\u0015\u00ec+6@\u00e2\u00ab\u0081!nG\u00dek\u00f3\u0086\u00e4`\u00d5)\u0019\u0080\u00ee\u000f\u0003\u00a1\u001c\u001ch\u0019\u00bdj\u0092\u00ee\u00f7\u0010%T\u00af\"!\u00d2Zz\u00f8\u00d3\u00fc\u00d7\u00bf\u0003\u00d9\u00ca`\u00d6\u00bf4\u00e0\u0082\u0080+\u0012\u00f0\u00a8\u00a1\u00b5\u0001\u0099\u00dbC:\u0092ql,\u000e\u0081WL\u00c2b\u00c2\u00fc\u0011\u00ba\u0081\u00f2\u00fd\u0089\u00e3\u001b\u00a52\u00cfk\u00e9B\u0018]q\u008f\u0006=G\u00cd}A\u0010\u0086#7]G2\u00f1\u00adf\u00cf\n\u0015\u0094\u001d\u00b8\u00a7\u00dc\u0002\u00a4\u0099\u00d2\u0018\u008aX*+T\u00f6\u008e\u0095\u00bd_]\u00b8\u0095.\u00db\u001c\u00b3,\u0080\u001bQ\u0089\u00e8{)\u001ed\u00bd\u00ac\u0004\tc\u008cLh\u00a7\u00a7\u00a8~]\u0094)\u00ca\u00ec\u00a5O1\u00ea\u00c5\u001bK\u001c\u00a0\u0084;s\u00c7[\u00d7\u0090\u008aS\u00ab\\K\u0089\tIaR\u0001Z\u000fb\u00ba\u00a6".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 82;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\f\u00eaM\u00cf\u00a8\u00d7D\u00e5\u001a\u00f7\u00df\u00e6\u0015\u00e4Xu;HL\u00c3\u00bcp\u00d5\u0081\u00e5m\u00e0\u00939\u0014f\u00d7-\u00eb\u00b7R\u0007\u00ef\u001f\u00df;\u0014\u00a3{t\u00af\u00ac\u00f2k\u00d1";
                    var4_3 = "\f\u00eaM\u00cf\u00a8\u00d7D\u00e5\u001a\u00f7\u00df\u00e6\u0015\u00e4Xu;HL\u00c3\u00bcp\u00d5\u0081\u00e5m\u00e0\u00939\u0014f\u00d7-\u00eb\u00b7R\u0007\u00ef\u001f\u00df;\u0014\u00a3{t\u00af\u00ac\u00f2k\u00d1".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 102;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 120;
                            break;
                        }
                        case 1: {
                            v15 = 18;
                            break;
                        }
                        case 2: {
                            v15 = 114;
                            break;
                        }
                        case 3: {
                            v15 = 63;
                            break;
                        }
                        case 4: {
                            v15 = 38;
                            break;
                        }
                        case 5: {
                            v15 = 66;
                            break;
                        }
                        default: {
                            v15 = 30;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x5FA1) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 119;
                case 1 -> 224;
                case 2 -> 159;
                case 3 -> 215;
                case 4 -> 13;
                case 5 -> 122;
                case 6 -> 44;
                case 7 -> 190;
                case 8 -> 87;
                case 9 -> 147;
                case 10 -> 12;
                case 11 -> 211;
                case 12 -> 60;
                case 13 -> 91;
                case 14 -> 219;
                case 15 -> 14;
                case 16 -> 248;
                case 17 -> 247;
                case 18 -> 168;
                case 19 -> 75;
                case 20 -> 236;
                case 21 -> 174;
                case 22 -> 1;
                case 23 -> 47;
                case 24 -> 106;
                case 25 -> 198;
                case 26 -> 18;
                case 27 -> 187;
                case 28 -> 207;
                case 29 -> 20;
                case 30 -> 116;
                case 31 -> 250;
                case 32 -> 167;
                case 33 -> 46;
                case 34 -> 163;
                case 35 -> 69;
                case 36 -> 95;
                case 37 -> 57;
                case 38 -> 11;
                case 39 -> 172;
                case 40 -> 218;
                case 41 -> 223;
                case 42 -> 35;
                case 43 -> 176;
                case 44 -> 130;
                case 45 -> 153;
                case 46 -> 2;
                case 47 -> 245;
                case 48 -> 6;
                case 49 -> 244;
                case 50 -> 124;
                case 51 -> 217;
                case 52 -> 24;
                case 53 -> 220;
                case 54 -> 205;
                case 55 -> 164;
                case 56 -> 196;
                case 57 -> 143;
                case 58 -> 66;
                case 59 -> 59;
                case 60 -> 134;
                case 61 -> 226;
                case 62 -> 191;
                case 63 -> 161;
                case 64 -> 255;
                case 65 -> 110;
                case 66 -> 197;
                case 67 -> 39;
                case 68 -> 70;
                case 69 -> 234;
                case 70 -> 40;
                case 71 -> 82;
                case 72 -> 42;
                case 73 -> 112;
                case 74 -> 3;
                case 75 -> 48;
                case 76 -> 208;
                case 77 -> 133;
                case 78 -> 22;
                case 79 -> 136;
                case 80 -> 84;
                case 81 -> 243;
                case 82 -> 41;
                case 83 -> 184;
                case 84 -> 202;
                case 85 -> 132;
                case 86 -> 249;
                case 87 -> 9;
                case 88 -> 185;
                case 89 -> 177;
                case 90 -> 97;
                case 91 -> 206;
                case 92 -> 94;
                case 93 -> 127;
                case 94 -> 77;
                case 95 -> 52;
                case 96 -> 240;
                case 97 -> 179;
                case 98 -> 157;
                case 99 -> 62;
                case 100 -> 26;
                case 101 -> 138;
                case 102 -> 216;
                case 103 -> 180;
                case 104 -> 203;
                case 105 -> 64;
                case 106 -> 54;
                case 107 -> 28;
                case 108 -> 253;
                case 109 -> 105;
                case 110 -> 86;
                case 111 -> 81;
                case 112 -> 238;
                case 113 -> 227;
                case 114 -> 109;
                case 115 -> 237;
                case 116 -> 0;
                case 117 -> 73;
                case 118 -> 158;
                case 119 -> 76;
                case 120 -> 204;
                case 121 -> 188;
                case 122 -> 212;
                case 123 -> 92;
                case 124 -> 34;
                case 125 -> 32;
                case 126 -> 229;
                case 127 -> 83;
                case 128 -> 43;
                case 129 -> 45;
                case 130 -> 178;
                case 131 -> 53;
                case 132 -> 251;
                case 133 -> 152;
                case 134 -> 232;
                case 135 -> 228;
                case 136 -> 231;
                case 137 -> 5;
                case 138 -> 38;
                case 139 -> 149;
                case 140 -> 100;
                case 141 -> 115;
                case 142 -> 233;
                case 143 -> 186;
                case 144 -> 49;
                case 145 -> 165;
                case 146 -> 23;
                case 147 -> 102;
                case 148 -> 125;
                case 149 -> 222;
                case 150 -> 151;
                case 151 -> 55;
                case 152 -> 195;
                case 153 -> 36;
                case 154 -> 209;
                case 155 -> 88;
                case 156 -> 90;
                case 157 -> 74;
                case 158 -> 96;
                case 159 -> 235;
                case 160 -> 141;
                case 161 -> 194;
                case 162 -> 79;
                case 163 -> 16;
                case 164 -> 68;
                case 165 -> 50;
                case 166 -> 19;
                case 167 -> 181;
                case 168 -> 171;
                case 169 -> 51;
                case 170 -> 29;
                case 171 -> 129;
                case 172 -> 99;
                case 173 -> 33;
                case 174 -> 78;
                case 175 -> 89;
                case 176 -> 4;
                case 177 -> 173;
                case 178 -> 121;
                case 179 -> 27;
                case 180 -> 170;
                case 181 -> 61;
                case 182 -> 246;
                case 183 -> 108;
                case 184 -> 175;
                case 185 -> 10;
                case 186 -> 214;
                case 187 -> 111;
                case 188 -> 103;
                case 189 -> 169;
                case 190 -> 183;
                case 191 -> 93;
                case 192 -> 162;
                case 193 -> 131;
                case 194 -> 126;
                case 195 -> 193;
                case 196 -> 139;
                case 197 -> 65;
                case 198 -> 71;
                case 199 -> 160;
                case 200 -> 201;
                case 201 -> 135;
                case 202 -> 21;
                case 203 -> 140;
                case 204 -> 156;
                case 205 -> 58;
                case 206 -> 145;
                case 207 -> 254;
                case 208 -> 123;
                case 209 -> 241;
                case 210 -> 252;
                case 211 -> 137;
                case 212 -> 15;
                case 213 -> 192;
                case 214 -> 199;
                case 215 -> 80;
                case 216 -> 166;
                case 217 -> 114;
                case 218 -> 8;
                case 219 -> 144;
                case 220 -> 142;
                case 221 -> 155;
                case 222 -> 25;
                case 223 -> 148;
                case 224 -> 154;
                case 225 -> 120;
                case 226 -> 113;
                case 227 -> 150;
                case 228 -> 189;
                case 229 -> 7;
                case 230 -> 182;
                case 231 -> 56;
                case 232 -> 30;
                case 233 -> 107;
                case 234 -> 31;
                case 235 -> 72;
                case 236 -> 85;
                case 237 -> 230;
                case 238 -> 17;
                case 239 -> 210;
                case 240 -> 225;
                case 241 -> 37;
                case 242 -> 221;
                case 243 -> 200;
                case 244 -> 242;
                case 245 -> 146;
                case 246 -> 67;
                case 247 -> 63;
                case 248 -> 118;
                case 249 -> 117;
                case 250 -> 128;
                case 251 -> 104;
                case 252 -> 98;
                case 253 -> 101;
                case 254 -> 239;
                default -> 213;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 133219571044777L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1724487990 + -30674, 1724487990 + (char)-23527, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 69278196000594L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.b();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(373549500 - (char)-11846, -373549500 - -27947, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(373549500 - (char)-11845, 373549500 - (char)-29668, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(373549500 - (char)-11844, 373549500 - (char)-29564, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u0007c\u00c8\u0081\u00ac\u0001\u0004\u00aa\u0010r\u00ee\u0097\u0091\u00fd\u00b8\u00d7\u00c4+\u0090o\u00ae\u0093i\u0018\u00aa";
                    var4_3 = "\u0007c\u00c8\u0081\u00ac\u0001\u0004\u00aa\u0010r\u00ee\u0097\u0091\u00fd\u00b8\u00d7\u00c4+\u0090o\u00ae\u0093i\u0018\u00aa".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 83;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0013\u0095\u00ce\u00db\u00985\u00f9\u00f4\u0084\u009b\u0003D\u0094t\u00b0\u00b9\n\u00cfL+b\u00ec\u0088Q$\u008a<\u00e8\u0003\u00b4\u0001F\u00b0>\u00d4\u00dfn\u00a2\u008c\u00aa\u00e6_J\u00886F\u00e4w\u00ea\u0082\u00cb\u00d0XB&\u000eQhM";
                        var4_3 = "\u0013\u0095\u00ce\u00db\u00985\u00f9\u00f4\u0084\u009b\u0003D\u0094t\u00b0\u00b9\n\u00cfL+b\u00ec\u0088Q$\u008a<\u00e8\u0003\u00b4\u0001F\u00b0>\u00d4\u00dfn\u00a2\u008c\u00aa\u00e6_J\u00886F\u00e4w\u00ea\u0082\u00cb\u00d0XB&\u000eQhM".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 87;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 91;
                                break;
                            }
                            case 1: {
                                v15 = 28;
                                break;
                            }
                            case 2: {
                                v15 = 116;
                                break;
                            }
                            case 3: {
                                v15 = 118;
                                break;
                            }
                            case 4: {
                                v15 = 44;
                                break;
                            }
                            case 5: {
                                v15 = 110;
                                break;
                            }
                            default: {
                                v15 = 3;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x7F51) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 200;
                    case 1 -> 109;
                    case 2 -> 120;
                    case 3 -> 189;
                    case 4 -> 80;
                    case 5 -> 247;
                    case 6 -> 27;
                    case 7 -> 99;
                    case 8 -> 190;
                    case 9 -> 123;
                    case 10 -> 140;
                    case 11 -> 172;
                    case 12 -> 158;
                    case 13 -> 144;
                    case 14 -> 222;
                    case 15 -> 103;
                    case 16 -> 91;
                    case 17 -> 151;
                    case 18 -> 108;
                    case 19 -> 242;
                    case 20 -> 142;
                    case 21 -> 225;
                    case 22 -> 22;
                    case 23 -> 12;
                    case 24 -> 76;
                    case 25 -> 168;
                    case 26 -> 116;
                    case 27 -> 137;
                    case 28 -> 130;
                    case 29 -> 45;
                    case 30 -> 81;
                    case 31 -> 131;
                    case 32 -> 154;
                    case 33 -> 49;
                    case 34 -> 239;
                    case 35 -> 58;
                    case 36 -> 194;
                    case 37 -> 67;
                    case 38 -> 61;
                    case 39 -> 38;
                    case 40 -> 179;
                    case 41 -> 129;
                    case 42 -> 87;
                    case 43 -> 153;
                    case 44 -> 39;
                    case 45 -> 47;
                    case 46 -> 41;
                    case 47 -> 106;
                    case 48 -> 191;
                    case 49 -> 215;
                    case 50 -> 44;
                    case 51 -> 250;
                    case 52 -> 141;
                    case 53 -> 111;
                    case 54 -> 203;
                    case 55 -> 42;
                    case 56 -> 226;
                    case 57 -> 13;
                    case 58 -> 64;
                    case 59 -> 255;
                    case 60 -> 98;
                    case 61 -> 110;
                    case 62 -> 102;
                    case 63 -> 21;
                    case 64 -> 251;
                    case 65 -> 249;
                    case 66 -> 174;
                    case 67 -> 213;
                    case 68 -> 234;
                    case 69 -> 104;
                    case 70 -> 237;
                    case 71 -> 135;
                    case 72 -> 69;
                    case 73 -> 186;
                    case 74 -> 228;
                    case 75 -> 100;
                    case 76 -> 211;
                    case 77 -> 150;
                    case 78 -> 146;
                    case 79 -> 74;
                    case 80 -> 252;
                    case 81 -> 92;
                    case 82 -> 208;
                    case 83 -> 52;
                    case 84 -> 206;
                    case 85 -> 188;
                    case 86 -> 152;
                    case 87 -> 94;
                    case 88 -> 185;
                    case 89 -> 75;
                    case 90 -> 107;
                    case 91 -> 125;
                    case 92 -> 232;
                    case 93 -> 164;
                    case 94 -> 95;
                    case 95 -> 230;
                    case 96 -> 84;
                    case 97 -> 31;
                    case 98 -> 82;
                    case 99 -> 77;
                    case 100 -> 176;
                    case 101 -> 66;
                    case 102 -> 134;
                    case 103 -> 132;
                    case 104 -> 0;
                    case 105 -> 23;
                    case 106 -> 184;
                    case 107 -> 7;
                    case 108 -> 217;
                    case 109 -> 201;
                    case 110 -> 37;
                    case 111 -> 18;
                    case 112 -> 178;
                    case 113 -> 79;
                    case 114 -> 197;
                    case 115 -> 20;
                    case 116 -> 157;
                    case 117 -> 248;
                    case 118 -> 15;
                    case 119 -> 210;
                    case 120 -> 218;
                    case 121 -> 71;
                    case 122 -> 32;
                    case 123 -> 57;
                    case 124 -> 138;
                    case 125 -> 223;
                    case 126 -> 198;
                    case 127 -> 6;
                    case 128 -> 90;
                    case 129 -> 231;
                    case 130 -> 238;
                    case 131 -> 33;
                    case 132 -> 139;
                    case 133 -> 235;
                    case 134 -> 212;
                    case 135 -> 11;
                    case 136 -> 46;
                    case 137 -> 59;
                    case 138 -> 170;
                    case 139 -> 97;
                    case 140 -> 88;
                    case 141 -> 254;
                    case 142 -> 148;
                    case 143 -> 48;
                    case 144 -> 182;
                    case 145 -> 136;
                    case 146 -> 195;
                    case 147 -> 93;
                    case 148 -> 10;
                    case 149 -> 128;
                    case 150 -> 73;
                    case 151 -> 25;
                    case 152 -> 196;
                    case 153 -> 16;
                    case 154 -> 227;
                    case 155 -> 1;
                    case 156 -> 160;
                    case 157 -> 163;
                    case 158 -> 165;
                    case 159 -> 253;
                    case 160 -> 112;
                    case 161 -> 19;
                    case 162 -> 40;
                    case 163 -> 187;
                    case 164 -> 216;
                    case 165 -> 207;
                    case 166 -> 145;
                    case 167 -> 181;
                    case 168 -> 126;
                    case 169 -> 50;
                    case 170 -> 30;
                    case 171 -> 9;
                    case 172 -> 202;
                    case 173 -> 220;
                    case 174 -> 162;
                    case 175 -> 114;
                    case 176 -> 121;
                    case 177 -> 241;
                    case 178 -> 204;
                    case 179 -> 240;
                    case 180 -> 159;
                    case 181 -> 85;
                    case 182 -> 124;
                    case 183 -> 143;
                    case 184 -> 229;
                    case 185 -> 60;
                    case 186 -> 28;
                    case 187 -> 68;
                    case 188 -> 193;
                    case 189 -> 62;
                    case 190 -> 89;
                    case 191 -> 122;
                    case 192 -> 43;
                    case 193 -> 244;
                    case 194 -> 53;
                    case 195 -> 233;
                    case 196 -> 70;
                    case 197 -> 236;
                    case 198 -> 169;
                    case 199 -> 83;
                    case 200 -> 55;
                    case 201 -> 24;
                    case 202 -> 173;
                    case 203 -> 127;
                    case 204 -> 26;
                    case 205 -> 133;
                    case 206 -> 35;
                    case 207 -> 147;
                    case 208 -> 86;
                    case 209 -> 72;
                    case 210 -> 245;
                    case 211 -> 4;
                    case 212 -> 17;
                    case 213 -> 219;
                    case 214 -> 214;
                    case 215 -> 8;
                    case 216 -> 205;
                    case 217 -> 118;
                    case 218 -> 65;
                    case 219 -> 51;
                    case 220 -> 2;
                    case 221 -> 224;
                    case 222 -> 221;
                    case 223 -> 167;
                    case 224 -> 199;
                    case 225 -> 36;
                    case 226 -> 183;
                    case 227 -> 115;
                    case 228 -> 149;
                    case 229 -> 14;
                    case 230 -> 117;
                    case 231 -> 177;
                    case 232 -> 113;
                    case 233 -> 166;
                    case 234 -> 209;
                    case 235 -> 243;
                    case 236 -> 96;
                    case 237 -> 119;
                    case 238 -> 54;
                    case 239 -> 192;
                    case 240 -> 78;
                    case 241 -> 56;
                    case 242 -> 3;
                    case 243 -> 34;
                    case 244 -> 246;
                    case 245 -> 155;
                    case 246 -> 156;
                    case 247 -> 63;
                    case 248 -> 101;
                    case 249 -> 105;
                    case 250 -> 29;
                    case 251 -> 161;
                    case 252 -> 171;
                    case 253 -> 175;
                    case 254 -> 180;
                    default -> 5;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 136930205266458L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "7\u0019P1\u001e\u001dOn\t0\u0013C;S_RrU";
                    var5_4 = "7\u0019P1\u001e\u001dOn\t0\u0013C;S_RrU".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 4;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 88;
                                    break;
                                }
                                case 1: {
                                    v11 = 120;
                                    break;
                                }
                                case 2: {
                                    v11 = 38;
                                    break;
                                }
                                case 3: {
                                    v11 = 91;
                                    break;
                                }
                                case 4: {
                                    v11 = 127;
                                    break;
                                }
                                case 5: {
                                    v11 = 117;
                                    break;
                                }
                                default: {
                                    v11 = 120;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 94709096199405L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "_rJ\u0016\u0001\u00071\u0004YlF\f\nUsM\f\r\u0005)\u007frD\tUsM\f\r\u0005)sx\rRuP\u0001\u0007\b3s\u007fW\u000b\u0006\u0001";
                    var5_4 = "_rJ\u0016\u0001\u00071\u0004YlF\f\nUsM\f\r\u0005)\u007frD\tUsM\f\r\u0005)sx\rRuP\u0001\u0007\b3s\u007fW\u000b\u0006\u0001".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 74;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "X}A\u001c\f\u00057\u0006X}A\u001c\u0000\u000f";
                        var5_4 = "X}A\u001c\f\u00057\u0006X}A\u001c\u0000\u000f".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 71;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 92;
                                break;
                            }
                            case 1: {
                                v15 = 86;
                                break;
                            }
                            case 2: {
                                v15 = 105;
                                break;
                            }
                            case 3: {
                                v15 = 40;
                                break;
                            }
                            case 4: {
                                v15 = 34;
                                break;
                            }
                            case 5: {
                                v15 = 44;
                                break;
                            }
                            default: {
                                v15 = 23;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 29147754139472L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(2106032760 + (char)-9552, 2106032760 + (char)-7677, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 133600689432142L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00f5\u00a6)A\u00f3\u0003\u00b3AU\u0005\u0096\u0012c\u0013Y\r\u00ae\u0012RY\u008a\r\u00e3\u0007R\u00f5\u001f\u00bfB\u0010g\u00bb\u00ac\u0087jC\u00d4\u00f3}\u00ef\u0019\u00b1d{\u00ae\u00de\u0005\u00b0\u0011\u00a7s\u00c13\u001c\u00c2#~N8`\u0088\u0096}\u00ef\u00ca|E\u0081\u0006\u00d9/\r\u00f8\u00cbl)\u00b1\u00b7\r2t\u00f6\u0090\b.\u00f5 \\\u00a9U\t]\b\u00a9\u0091\u009e\u00de)\u0011\u001e\u00ed\u0012\u0007\u0095";
                    var4_3 = "\u00f5\u00a6)A\u00f3\u0003\u00b3AU\u0005\u0096\u0012c\u0013Y\r\u00ae\u0012RY\u008a\r\u00e3\u0007R\u00f5\u001f\u00bfB\u0010g\u00bb\u00ac\u0087jC\u00d4\u00f3}\u00ef\u0019\u00b1d{\u00ae\u00de\u0005\u00b0\u0011\u00a7s\u00c13\u001c\u00c2#~N8`\u0088\u0096}\u00ef\u00ca|E\u0081\u0006\u00d9/\r\u00f8\u00cbl)\u00b1\u00b7\r2t\u00f6\u0090\b.\u00f5 \\\u00a9U\t]\b\u00a9\u0091\u009e\u00de)\u0011\u001e\u00ed\u0012\u0007\u0095".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 66;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00d8\u00bf\u0013O\u00d5\u0012k\u0091\u00c2\u00eb\u00a6y\u00db*\u0011\u00bcL\u0013\u001d\u009d\u00d1.\tz\u009ci\u00d9\u007f\u0086\u00ee[$\u00eb \u000b\u0085\u00c2\u00fa\u0007m6T^#\u0090f\r\u00bd\u00ba\u001b\u0014\u00b8{\u00b3\u00c5\u00f3\u00bf\u0002\u00d2l\u0083*,\u00fd:\u00d4\u0081\u00edX\u00c0\u008e\u00b2u'\u00d9\u008cF\bph>k\u00946Q\u00adZ\u001a\u001b\b*\u008dq";
                        var4_3 = "\u00d8\u00bf\u0013O\u00d5\u0012k\u0091\u00c2\u00eb\u00a6y\u00db*\u0011\u00bcL\u0013\u001d\u009d\u00d1.\tz\u009ci\u00d9\u007f\u0086\u00ee[$\u00eb \u000b\u0085\u00c2\u00fa\u0007m6T^#\u0090f\r\u00bd\u00ba\u001b\u0014\u00b8{\u00b3\u00c5\u00f3\u00bf\u0002\u00d2l\u0083*,\u00fd:\u00d4\u0081\u00edX\u00c0\u008e\u00b2u'\u00d9\u008cF\bph>k\u00946Q\u00adZ\u001a\u001b\b*\u008dq".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 2;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 109;
                                break;
                            }
                            case 1: {
                                v15 = 120;
                                break;
                            }
                            case 2: {
                                v15 = 24;
                                break;
                            }
                            case 3: {
                                v15 = 117;
                                break;
                            }
                            case 4: {
                                v15 = 98;
                                break;
                            }
                            case 5: {
                                v15 = 4;
                                break;
                            }
                            default: {
                                v15 = 8;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x5278) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 245;
                    case 1 -> 85;
                    case 2 -> 142;
                    case 3 -> 110;
                    case 4 -> 9;
                    case 5 -> 106;
                    case 6 -> 210;
                    case 7 -> 229;
                    case 8 -> 158;
                    case 9 -> 182;
                    case 10 -> 192;
                    case 11 -> 124;
                    case 12 -> 48;
                    case 13 -> 217;
                    case 14 -> 137;
                    case 15 -> 163;
                    case 16 -> 205;
                    case 17 -> 162;
                    case 18 -> 8;
                    case 19 -> 76;
                    case 20 -> 233;
                    case 21 -> 23;
                    case 22 -> 16;
                    case 23 -> 38;
                    case 24 -> 111;
                    case 25 -> 95;
                    case 26 -> 189;
                    case 27 -> 30;
                    case 28 -> 204;
                    case 29 -> 206;
                    case 30 -> 202;
                    case 31 -> 94;
                    case 32 -> 15;
                    case 33 -> 72;
                    case 34 -> 96;
                    case 35 -> 147;
                    case 36 -> 39;
                    case 37 -> 195;
                    case 38 -> 150;
                    case 39 -> 121;
                    case 40 -> 83;
                    case 41 -> 18;
                    case 42 -> 244;
                    case 43 -> 184;
                    case 44 -> 31;
                    case 45 -> 209;
                    case 46 -> 253;
                    case 47 -> 123;
                    case 48 -> 40;
                    case 49 -> 138;
                    case 50 -> 224;
                    case 51 -> 44;
                    case 52 -> 235;
                    case 53 -> 238;
                    case 54 -> 226;
                    case 55 -> 59;
                    case 56 -> 177;
                    case 57 -> 35;
                    case 58 -> 101;
                    case 59 -> 188;
                    case 60 -> 240;
                    case 61 -> 12;
                    case 62 -> 208;
                    case 63 -> 62;
                    case 64 -> 133;
                    case 65 -> 213;
                    case 66 -> 250;
                    case 67 -> 78;
                    case 68 -> 65;
                    case 69 -> 98;
                    case 70 -> 93;
                    case 71 -> 194;
                    case 72 -> 186;
                    case 73 -> 6;
                    case 74 -> 222;
                    case 75 -> 21;
                    case 76 -> 139;
                    case 77 -> 52;
                    case 78 -> 58;
                    case 79 -> 4;
                    case 80 -> 131;
                    case 81 -> 41;
                    case 82 -> 84;
                    case 83 -> 164;
                    case 84 -> 73;
                    case 85 -> 165;
                    case 86 -> 183;
                    case 87 -> 42;
                    case 88 -> 221;
                    case 89 -> 198;
                    case 90 -> 168;
                    case 91 -> 255;
                    case 92 -> 191;
                    case 93 -> 174;
                    case 94 -> 248;
                    case 95 -> 247;
                    case 96 -> 74;
                    case 97 -> 24;
                    case 98 -> 152;
                    case 99 -> 3;
                    case 100 -> 97;
                    case 101 -> 109;
                    case 102 -> 122;
                    case 103 -> 241;
                    case 104 -> 47;
                    case 105 -> 140;
                    case 106 -> 108;
                    case 107 -> 201;
                    case 108 -> 79;
                    case 109 -> 143;
                    case 110 -> 207;
                    case 111 -> 218;
                    case 112 -> 239;
                    case 113 -> 243;
                    case 114 -> 28;
                    case 115 -> 117;
                    case 116 -> 128;
                    case 117 -> 14;
                    case 118 -> 173;
                    case 119 -> 56;
                    case 120 -> 75;
                    case 121 -> 154;
                    case 122 -> 214;
                    case 123 -> 178;
                    case 124 -> 77;
                    case 125 -> 180;
                    case 126 -> 88;
                    case 127 -> 7;
                    case 128 -> 148;
                    case 129 -> 157;
                    case 130 -> 196;
                    case 131 -> 90;
                    case 132 -> 49;
                    case 133 -> 223;
                    case 134 -> 167;
                    case 135 -> 254;
                    case 136 -> 68;
                    case 137 -> 146;
                    case 138 -> 43;
                    case 139 -> 86;
                    case 140 -> 181;
                    case 141 -> 242;
                    case 142 -> 145;
                    case 143 -> 166;
                    case 144 -> 227;
                    case 145 -> 89;
                    case 146 -> 100;
                    case 147 -> 70;
                    case 148 -> 197;
                    case 149 -> 19;
                    case 150 -> 141;
                    case 151 -> 144;
                    case 152 -> 155;
                    case 153 -> 5;
                    case 154 -> 231;
                    case 155 -> 135;
                    case 156 -> 57;
                    case 157 -> 2;
                    case 158 -> 51;
                    case 159 -> 66;
                    case 160 -> 60;
                    case 161 -> 172;
                    case 162 -> 203;
                    case 163 -> 251;
                    case 164 -> 37;
                    case 165 -> 132;
                    case 166 -> 32;
                    case 167 -> 33;
                    case 168 -> 119;
                    case 169 -> 151;
                    case 170 -> 92;
                    case 171 -> 67;
                    case 172 -> 153;
                    case 173 -> 17;
                    case 174 -> 46;
                    case 175 -> 120;
                    case 176 -> 127;
                    case 177 -> 114;
                    case 178 -> 228;
                    case 179 -> 171;
                    case 180 -> 249;
                    case 181 -> 179;
                    case 182 -> 136;
                    case 183 -> 246;
                    case 184 -> 64;
                    case 185 -> 50;
                    case 186 -> 13;
                    case 187 -> 53;
                    case 188 -> 107;
                    case 189 -> 22;
                    case 190 -> 0;
                    case 191 -> 103;
                    case 192 -> 113;
                    case 193 -> 216;
                    case 194 -> 125;
                    case 195 -> 190;
                    case 196 -> 161;
                    case 197 -> 81;
                    case 198 -> 104;
                    case 199 -> 10;
                    case 200 -> 80;
                    case 201 -> 116;
                    case 202 -> 82;
                    case 203 -> 126;
                    case 204 -> 175;
                    case 205 -> 211;
                    case 206 -> 236;
                    case 207 -> 134;
                    case 208 -> 102;
                    case 209 -> 185;
                    case 210 -> 54;
                    case 211 -> 115;
                    case 212 -> 212;
                    case 213 -> 63;
                    case 214 -> 45;
                    case 215 -> 20;
                    case 216 -> 87;
                    case 217 -> 25;
                    case 218 -> 112;
                    case 219 -> 118;
                    case 220 -> 159;
                    case 221 -> 215;
                    case 222 -> 91;
                    case 223 -> 232;
                    case 224 -> 187;
                    case 225 -> 170;
                    case 226 -> 61;
                    case 227 -> 11;
                    case 228 -> 237;
                    case 229 -> 199;
                    case 230 -> 220;
                    case 231 -> 26;
                    case 232 -> 169;
                    case 233 -> 27;
                    case 234 -> 34;
                    case 235 -> 29;
                    case 236 -> 1;
                    case 237 -> 176;
                    case 238 -> 105;
                    case 239 -> 230;
                    case 240 -> 156;
                    case 241 -> 55;
                    case 242 -> 234;
                    case 243 -> 200;
                    case 244 -> 225;
                    case 245 -> 219;
                    case 246 -> 149;
                    case 247 -> 160;
                    case 248 -> 99;
                    case 249 -> 69;
                    case 250 -> 130;
                    case 251 -> 71;
                    case 252 -> 129;
                    case 253 -> 193;
                    case 254 -> 36;
                    default -> 252;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 130534420573599L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1774556730 - -((char)-22412), 1774556730 - (char)-24958, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 52248902844642L;
                    int[] nArray = SshAgentIpcService.b();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-625728180 - -((char)-26118), 625728180 - (char)-13871, (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 78148601327290L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = ";8\u009e3\u00a8\u0003\u008c\u00f6>";
                var4_3 = ";8\u009e3\u00a8\u0003\u008c\u00f6>".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 98;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 7;
                                break;
                            }
                            case 1: {
                                v11 = 15;
                                break;
                            }
                            case 2: {
                                v11 = 31;
                                break;
                            }
                            case 3: {
                                v11 = 30;
                                break;
                            }
                            case 4: {
                                v11 = 11;
                                break;
                            }
                            case 5: {
                                v11 = 119;
                                break;
                            }
                            default: {
                                v11 = 77;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFFFA5) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 80;
                    case 1 -> 73;
                    case 2 -> 240;
                    case 3 -> 77;
                    case 4 -> 111;
                    case 5 -> 40;
                    case 6 -> 67;
                    case 7 -> 94;
                    case 8 -> 54;
                    case 9 -> 83;
                    case 10 -> 88;
                    case 11 -> 156;
                    case 12 -> 45;
                    case 13 -> 39;
                    case 14 -> 11;
                    case 15 -> 42;
                    case 16 -> 44;
                    case 17 -> 108;
                    case 18 -> 233;
                    case 19 -> 179;
                    case 20 -> 86;
                    case 21 -> 244;
                    case 22 -> 6;
                    case 23 -> 160;
                    case 24 -> 248;
                    case 25 -> 37;
                    case 26 -> 190;
                    case 27 -> 0;
                    case 28 -> 188;
                    case 29 -> 221;
                    case 30 -> 114;
                    case 31 -> 102;
                    case 32 -> 120;
                    case 33 -> 43;
                    case 34 -> 85;
                    case 35 -> 122;
                    case 36 -> 180;
                    case 37 -> 51;
                    case 38 -> 205;
                    case 39 -> 137;
                    case 40 -> 223;
                    case 41 -> 228;
                    case 42 -> 23;
                    case 43 -> 208;
                    case 44 -> 146;
                    case 45 -> 159;
                    case 46 -> 128;
                    case 47 -> 247;
                    case 48 -> 60;
                    case 49 -> 218;
                    case 50 -> 230;
                    case 51 -> 229;
                    case 52 -> 195;
                    case 53 -> 70;
                    case 54 -> 104;
                    case 55 -> 234;
                    case 56 -> 58;
                    case 57 -> 62;
                    case 58 -> 124;
                    case 59 -> 249;
                    case 60 -> 99;
                    case 61 -> 252;
                    case 62 -> 15;
                    case 63 -> 22;
                    case 64 -> 178;
                    case 65 -> 253;
                    case 66 -> 151;
                    case 67 -> 255;
                    case 68 -> 31;
                    case 69 -> 50;
                    case 70 -> 92;
                    case 71 -> 138;
                    case 72 -> 181;
                    case 73 -> 90;
                    case 74 -> 89;
                    case 75 -> 110;
                    case 76 -> 100;
                    case 77 -> 215;
                    case 78 -> 206;
                    case 79 -> 17;
                    case 80 -> 191;
                    case 81 -> 207;
                    case 82 -> 176;
                    case 83 -> 173;
                    case 84 -> 91;
                    case 85 -> 26;
                    case 86 -> 145;
                    case 87 -> 97;
                    case 88 -> 172;
                    case 89 -> 219;
                    case 90 -> 222;
                    case 91 -> 41;
                    case 92 -> 148;
                    case 93 -> 171;
                    case 94 -> 232;
                    case 95 -> 59;
                    case 96 -> 21;
                    case 97 -> 47;
                    case 98 -> 109;
                    case 99 -> 115;
                    case 100 -> 69;
                    case 101 -> 72;
                    case 102 -> 126;
                    case 103 -> 254;
                    case 104 -> 202;
                    case 105 -> 175;
                    case 106 -> 16;
                    case 107 -> 157;
                    case 108 -> 96;
                    case 109 -> 32;
                    case 110 -> 217;
                    case 111 -> 163;
                    case 112 -> 204;
                    case 113 -> 132;
                    case 114 -> 79;
                    case 115 -> 66;
                    case 116 -> 125;
                    case 117 -> 209;
                    case 118 -> 224;
                    case 119 -> 192;
                    case 120 -> 133;
                    case 121 -> 136;
                    case 122 -> 140;
                    case 123 -> 2;
                    case 124 -> 197;
                    case 125 -> 236;
                    case 126 -> 53;
                    case 127 -> 24;
                    case 128 -> 68;
                    case 129 -> 5;
                    case 130 -> 186;
                    case 131 -> 93;
                    case 132 -> 250;
                    case 133 -> 245;
                    case 134 -> 13;
                    case 135 -> 198;
                    case 136 -> 142;
                    case 137 -> 81;
                    case 138 -> 170;
                    case 139 -> 127;
                    case 140 -> 82;
                    case 141 -> 10;
                    case 142 -> 153;
                    case 143 -> 33;
                    case 144 -> 29;
                    case 145 -> 196;
                    case 146 -> 55;
                    case 147 -> 212;
                    case 148 -> 201;
                    case 149 -> 243;
                    case 150 -> 119;
                    case 151 -> 189;
                    case 152 -> 28;
                    case 153 -> 64;
                    case 154 -> 251;
                    case 155 -> 87;
                    case 156 -> 116;
                    case 157 -> 200;
                    case 158 -> 76;
                    case 159 -> 18;
                    case 160 -> 214;
                    case 161 -> 12;
                    case 162 -> 155;
                    case 163 -> 19;
                    case 164 -> 84;
                    case 165 -> 182;
                    case 166 -> 98;
                    case 167 -> 78;
                    case 168 -> 135;
                    case 169 -> 34;
                    case 170 -> 165;
                    case 171 -> 149;
                    case 172 -> 139;
                    case 173 -> 231;
                    case 174 -> 112;
                    case 175 -> 166;
                    case 176 -> 61;
                    case 177 -> 134;
                    case 178 -> 242;
                    case 179 -> 193;
                    case 180 -> 246;
                    case 181 -> 56;
                    case 182 -> 237;
                    case 183 -> 168;
                    case 184 -> 123;
                    case 185 -> 213;
                    case 186 -> 167;
                    case 187 -> 1;
                    case 188 -> 118;
                    case 189 -> 184;
                    case 190 -> 74;
                    case 191 -> 27;
                    case 192 -> 169;
                    case 193 -> 129;
                    case 194 -> 36;
                    case 195 -> 177;
                    case 196 -> 65;
                    case 197 -> 154;
                    case 198 -> 105;
                    case 199 -> 117;
                    case 200 -> 35;
                    case 201 -> 194;
                    case 202 -> 14;
                    case 203 -> 9;
                    case 204 -> 25;
                    case 205 -> 210;
                    case 206 -> 162;
                    case 207 -> 63;
                    case 208 -> 3;
                    case 209 -> 101;
                    case 210 -> 71;
                    case 211 -> 143;
                    case 212 -> 49;
                    case 213 -> 226;
                    case 214 -> 7;
                    case 215 -> 203;
                    case 216 -> 227;
                    case 217 -> 141;
                    case 218 -> 144;
                    case 219 -> 147;
                    case 220 -> 38;
                    case 221 -> 220;
                    case 222 -> 106;
                    case 223 -> 95;
                    case 224 -> 131;
                    case 225 -> 183;
                    case 226 -> 48;
                    case 227 -> 238;
                    case 228 -> 52;
                    case 229 -> 161;
                    case 230 -> 75;
                    case 231 -> 8;
                    case 232 -> 241;
                    case 233 -> 103;
                    case 234 -> 185;
                    case 235 -> 20;
                    case 236 -> 164;
                    case 237 -> 187;
                    case 238 -> 30;
                    case 239 -> 121;
                    case 240 -> 211;
                    case 241 -> 130;
                    case 242 -> 199;
                    case 243 -> 107;
                    case 244 -> 174;
                    case 245 -> 152;
                    case 246 -> 235;
                    case 247 -> 225;
                    case 248 -> 113;
                    case 249 -> 4;
                    case 250 -> 57;
                    case 251 -> 158;
                    case 252 -> 216;
                    case 253 -> 150;
                    case 254 -> 239;
                    default -> 46;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

