/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.time.interval;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.datetime.Date;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.core.commons.time.interval.TimeZoneAwareInterval;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/commons/time/interval/MonthInterval;", "Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeZoneAwareInterval;", "count", "", "(I)V", "tickFormatPattern", "", "getTickFormatPattern", "()Ljava/lang/String;", "addInterval", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "dateTime", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "atOrBefore", "plot-base"})
public final class MonthInterval
extends TimeZoneAwareInterval {
    private final int count;
    @NotNull
    private final String tickFormatPattern;

    public MonthInterval(int count2) {
        this.count = count2;
        this.tickFormatPattern = "%b";
    }

    @Override
    @NotNull
    public String getTickFormatPattern() {
        return this.tickFormatPattern;
    }

    @Override
    @NotNull
    protected DateTime atOrBefore(@NotNull DateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        return new DateTime(new Date(1, dateTime.getMonth(), dateTime.getYear()), null, 2, null);
    }

    @Override
    @NotNull
    protected DateTime addInterval(@NotNull DateTime dateTime, @NotNull TimeZone tz) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)tz, (String)"tz");
        return new DateTime(dateTime.getDate().addMonths(this.count), null, 2, null);
    }
}

