"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tag = void 0;
var react_1 = __importDefault(require("react"));
var Href_1 = require("./Href");
var Tag = function (_a) {
    var _b;
    var tag = _a.tag;
    var name = "#".concat(tag.name());
    var description = (_b = tag.description()) !== null && _b !== void 0 ? _b : '';
    var externalDocs = tag.externalDocs();
    var element = (react_1.default.createElement("div", { title: description, className: "border border-solid border-blue-300 hover:bg-blue-300 hover:text-blue-600 text-blue-500 font-bold no-underline text-xs rounded px-3 py-1" },
        react_1.default.createElement("span", { className: externalDocs ? 'underline' : '' }, name)));
    if (externalDocs) {
        return (react_1.default.createElement(Href_1.Href, { href: externalDocs.url(), title: description }, element));
    }
    return element;
};
exports.Tag = Tag;
//# sourceMappingURL=Tag.js.map