/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.uk;

import ai.grazie.rules.common.CommaLicense;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.uk.UkrainianTreePatterns;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

class IntroductoryConstructions {
    private static final NodePattern afterConjOrParticle = NodePattern.N.directlyAfter(NodePattern.N.pos("conj.*|part").noForm("\u0446\u0435|\u0449\u043e|\u0442\u0430\u043c|\u0442\u043e|\u0431"));
    private static final NodePattern beforeZhe = NodePattern.N.directlyBefore(NodePattern.N.form("\u0436\u0435?"));
    private static final String adjDumku = "\u0439\u043e\u0433\u043e|\u043c\u043e\u044e|\u0457\u0457|\u0442\u0432\u043e\u044e|\u0457\u0445\u043d\u044e|\u0432\u0430\u0448\u0443|\u0441\u0432\u043e\u044e";
    private static final NodePattern zvyrnutyX = NodePattern.N.withHead("obl", NodePattern.N.lemma("\u0437\u0432\u0438\u0440\u043d\u0443\u0442\u0438|\u0437\u0432\u0438\u0440\u0442\u0430\u0442\u0438|\u043f\u0440\u0438\u0441\u0442\u0430\u0432\u0430\u0442\u0438|\u043f\u0440\u0438\u0441\u0442\u0430\u0442\u0438|\u0432\u043f\u043b\u0438\u043d\u0443\u0442\u0438|\u0432\u043f\u043b\u0438\u0432\u0430\u0442\u0438|\u043f\u043e\u043a\u043b\u0430\u0434\u0430\u0442\u0438\u0441\u044f|\u0437\u0434\u0430(\u0432\u0430)?\u0442\u0438\u0441\u044f|\u0441\u0445\u043e\u0436\u0438\u0439|(\u043d\u0435)?\u043e\u0447\u0435\u0432\u0438\u0434\u043d\u0438\u0439|\u0433\u0430\u0440\u0430\u0437\u0434|\u0437\u0434\u0430\u0442\u0438\u0441\u044f"));
    private static final Map<NodePattern, Function<NodeMatch, CommaLicense>> patterns = ImmutableMap.builder().put((Object)NodePattern.or(NodePattern.N.inFormSequence(2, "\u043d\u0430", "\u0439\u043e\u0433\u043e|\u043c\u043e\u044e|\u0457\u0457|\u0442\u0432\u043e\u044e|\u0457\u0445\u043d\u044e|\u0432\u0430\u0448\u0443|\u0441\u0432\u043e\u044e", "\u0434\u0443\u043c\u043a\u0443").andNot(zvyrnutyX), NodePattern.N.inFormSequence(2, "\u043d\u0430", ".*", "\u043f\u043e\u0433\u043b\u044f\u0434").andNot(NodePattern.N.withNeighbor(-3, NodePattern.N.form("\u0442\u0456\u043b\u044c\u043a\u0438"))).andNot(NodePattern.N.withHead("obl", NodePattern.or(NodePattern.N.withHeadRelation("root|[cx]comp").pos("verb.*"), NodePattern.N.withDependent("[cx]comp", NodePattern.N.pos("verb.*"))))).andNot(zvyrnutyX), NodePattern.N.inFormSequence(1, "\u0432\u043b\u0430\u0441\u043d\u0435|\u0456\u043d\u0430\u043a\u0448\u0435|\u043a\u043e\u0440\u043e\u0442\u043a\u043e|\u043f\u043e\u043f\u0440\u043e\u0441\u0442\u0443", "\u043a\u0430\u0436\u0443\u0447\u0438"), NodePattern.N.inFormSequence(1, "\u0433\u0440\u0456\u0448\u043d\u0438\u043c", "\u0434\u0456\u043b\u043e\u043c"), NodePattern.N.inFormSequence(0, "\u0433\u0440\u0456\u0445", "\u0441\u043a\u0430\u0437\u0430\u0442\u0438"), NodePattern.N.inFormSequence(1, "\u043d\u0430", "\u0436\u0430\u043b\u044c").andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("\u0434\u043b\u044f|\u0447\u0438"), NodePattern.N.form("\u0456").directlyBefore(NodePattern.N.form("\u0430\u0445"))))).andNot(NodePattern.N.inFormSequence(2, "\u0430\u043b\u0435", "\u043d\u0430", "\u0436\u0430\u043b\u044c")), NodePattern.N.inFormSequence(2, "\u043d\u0430", ".*", "\u0436\u0430\u043b\u044c").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("\u0434\u043b\u044f|\u0447\u0438"))).noHeadRelation("root"), NodePattern.N.inFormSequence(2, "\u0442\u0430\u043a", "\u0431\u0438", "\u043c\u043e\u0432\u0438\u0442\u0438"), NodePattern.N.inFormSequence(2, "\u043d\u0430", "\u043c\u0456\u0439", "\u043f\u043e\u0433\u043b\u044f\u0434"), NodePattern.N.inFormSequence(3, "\u044f\u043a\u0449\u043e", "\u043c\u043e\u0436\u043d\u0430", "\u0442\u0430\u043a", "\u0432\u0438\u0441\u043b\u043e\u0432\u0438\u0442\u0438\u0441\u044f"), NodePattern.N.inFormSequence(0, "\u0431\u0443\u0434\u044c", "\u043b\u0430\u0441\u043a\u0430"), NodePattern.N.inFormSequence(1, "\u0432\u0437\u0430\u0433\u0430\u043b\u0456", "\u043a\u0430\u0436\u0443\u0447\u0438"), NodePattern.N.lemma("\u0441\u0443\u043c\u043d\u0456\u0432").withDependent("case", NodePattern.N.form("\u043f\u043e\u0437\u0430")), NodePattern.N.inFormSequence(1, "\u0456?\u0437", "\u0434\u043e\u0437\u0432\u043e\u043b\u0443", "\u0441\u043a\u0430\u0437\u0430\u0442\u0438").andNot(NodePattern.N.withHead(NodePattern.N.form("\u0441\u043a\u0430\u0437\u0430\u0442\u0438"))), NodePattern.N.inFormSequence(1, "\u0447\u043e\u0440\u0442", "\u0437\u0430\u0431\u0438\u0440\u0430\u0439"), NodePattern.N.inFormSequence(2, "\u0434\u043e", "\u0440\u0435\u0447\u0456", "\u043a\u0430\u0436\u0443\u0447\u0438|\u0441\u043a\u0430\u0437\u0430\u0442\u0438|\u0441\u043a\u0430\u0436\u0443"), NodePattern.N.inFormSequence(1, "\u0434\u043e", "\u0440\u0435\u0447\u0456").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("\u043a\u0430\u0436\u0443\u0447\u0438|\u0441\u043a\u0430\u0437\u0430\u0442\u0438|\u0441\u043a\u0430\u0436\u0443"))).andNot(NodePattern.N.withHead("obl", NodePattern.N.withHeadRelation("root|[cx]comp").lemma("\u043f\u0440\u0438\u043f\u0430\u0441\u0442\u0438|\u043f\u0440\u0438\u0439\u0442\u0438\u0441[\u044c\u044f]|\u0431\u0443\u0442\u0438|\u0432\u0438\u044f\u0432\u0438\u0442\u0438\u0441\u044f"))), NodePattern.N.inFormSequence(0, "\u043a\u0440\u0438\u0439", "\u0431\u043e\u0436\u0435"), NodePattern.N.inFormSequence(1, "\u043c\u0456\u0436", "\u0456\u043d\u0448\u0438\u043c"), NodePattern.N.inFormSequence(1, "\u044f\u0441\u043d\u0430", "\u0440\u0456\u0447"), NodePattern.N.inFormSequence(1, "\u044f\u0441\u043d\u0435|\u0437\u0432\u0456\u0441\u043d\u0435", "\u0434\u0456\u043b\u043e")).noDependents("punct", UkrainianTreePatterns.anyQuotation), IntroductoryConstructions.commasAround(CommaLicense::forPhrase, NodePattern.N)).build();
    private static final NodePattern afterCommaEquivalent = NodePattern.or(CommonPatterns.firstWord, NodePattern.N.directlyAfter(UkrainianTreePatterns.commaOrStronger));

    IntroductoryConstructions() {
    }

    private static Function<NodeMatch, CommaLicense> commasAround(BiFunction<Node, CommaLicense.NeedCommas, CommaLicense> constructor, NodePattern obligatoryPattern) {
        return match -> {
            Node node = match.anchor();
            CommaLicense commas = (CommaLicense)constructor.apply(node, CommaLicense.NeedCommas.around);
            return commas.markObligatoryIf(obligatoryPattern.matches(node) && !beforeZhe.matches(node));
        };
    }

    static List<CommaLicense> analyze(Node node) {
        for (Map.Entry<NodePattern, Function<NodeMatch, CommaLicense>> entry : patterns.entrySet()) {
            NodeMatch match = entry.getKey().match(node);
            if (match == null) continue;
            CommaLicense license = entry.getValue().apply(match);
            Node start = license.start.skipBack(afterConjOrParticle::matches);
            if (start != license.start) {
                boolean needCommaBefore = afterCommaEquivalent.matches(start);
                return List.of(CommaLicense.forRange(license.start, license.end, CommaLicense.NeedCommas.around).markObligatoryIf(license.obligatory && !needCommaBefore), CommaLicense.forRange(start, license.end, CommaLicense.NeedCommas.around).markObligatoryIf(license.obligatory && needCommaBefore));
            }
            return List.of(license);
        }
        return List.of();
    }
}

