/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.ide.util.scopeChooser.ScopeEditorPanel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSourceConfigurable;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.StatusText;
import icons.DatabaseIcons;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SqlDataSourceRootsList {
    private final SqlDataSourceConfigurable myConfigurable;
    private JBList<Root> myRootsList;

    SqlDataSourceRootsList(SqlDataSourceConfigurable configurable) {
        this.myConfigurable = configurable;
    }

    @NotNull
    private CollectionListModel<Root> getRootsListModel() {
        CollectionListModel collectionListModel = (CollectionListModel)this.myRootsList.getModel();
        if (collectionListModel == null) {
            SqlDataSourceRootsList.$$$reportNull$$$0(0);
        }
        return collectionListModel;
    }

    public JComponent createPanel() {
        this.myRootsList = new JBList((ListModel)new CollectionListModel((Object[])new Root[0]));
        StatusText text = this.myRootsList.getEmptyText();
        text.clear();
        text.appendText(DatabaseBundle.message((String)"status.text.no.ddl.files.folders.added", (Object[])new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, e -> this.doChooseFiles());
        this.myRootsList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                e.consume();
                Root sel = (Root)SqlDataSourceRootsList.this.myRootsList.getSelectedValue();
                if (sel == null) {
                    return;
                }
                if (sel.myType == Root.Type.NAMED_SCOPE) {
                    SqlDataSourceRootsList.this.editNamedScope(sel.myRoot);
                } else if (sel.myType == Root.Type.ANONYMOUS_SCOPE) {
                    SqlDataSourceRootsList.editAnonymousScope(SqlDataSourceRootsList.this.myConfigurable.getProject(), SqlDataSourceRootsList.compile(sel.myRoot));
                }
            }
        });
        this.myRootsList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<Root>(){

            protected void customizeCellRenderer(@NotNull JList list, Root value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value.myType == Root.Type.DATA_SOURCE) {
                    DasDataSource dataSource = value.getDataSource(SqlDataSourceRootsList.this.myConfigurable.getController());
                    this.customizeRenderer(dataSource);
                } else if (value.myType == Root.Type.NAMED_SCOPE) {
                    NamedScope scope = NamedScopeManager.getInstance((Project)SqlDataSourceRootsList.this.myConfigurable.getProject()).getScope(value.myRoot);
                    this.customizeRenderer(scope);
                } else if (value.myType == Root.Type.ANONYMOUS_SCOPE) {
                    this.customizeAnonymousScopeRenderer(value.myRoot);
                } else {
                    this.customizeRenderer(value.myRoot);
                }
            }

            private void customizeRenderer(DasDataSource dataSource) {
                if (dataSource == null) {
                    this.setIcon(DatabaseIcons.Dbms);
                    this.append(DatabaseBundle.message((String)"non.existing.data.source", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else {
                    this.setIcon(dataSource.getIcon(0));
                    this.append(dataSource.getName());
                }
            }

            private void customizeRenderer(NamedScope scope) {
                if (scope == null) {
                    this.setIcon(AllIcons.Ide.LocalScope);
                    this.append(DatabaseBundle.message((String)"non.existing.scope", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else {
                    this.setIcon(scope.getIcon());
                    this.append(scope.getPresentableName());
                }
            }

            private void customizeAnonymousScopeRenderer(@NlsSafe String scope) {
                this.setIcon(AllIcons.Ide.LocalScope);
                this.append(DatabaseBundle.message((String)"separator.scope", (Object[])new Object[0]));
                this.append(" ");
                this.append(scope, SimpleTextAttributes.GRAY_ATTRIBUTES);
            }

            private void customizeRenderer(String url) {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file != null) {
                    this.append(file.getPresentableUrl(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.setIcon(file.isDirectory() ? PlatformIcons.FOLDER_ICON : IconUtil.getIcon((VirtualFile)file, (int)0, (Project)SqlDataSourceRootsList.this.myConfigurable.getProject()));
                } else {
                    this.append(VfsUtilCore.urlToPath((String)url), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.setIcon(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/sql/database/SqlDataSourceRootsList$2", "customizeCellRenderer"));
            }
        });
        return ToolbarDecorator.createDecorator(this.myRootsList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(new AnAction[]{new DumbAwareAction(SqlBundle.message((String)"action.add.ddl.files.text", (Object[])new Object[0]), null, DatabaseIcons.DdlDbms){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        SqlDataSourceRootsList.this.doChooseFiles();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/database/SqlDataSourceRootsList$4$1", "actionPerformed"));
                    }
                }, new FileScopeGroup(), new ExtendDataSourceGroup()}), button.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).show(button.getPreferredPopupPoint());
            }
        }).addExtraAction((AnAction)new DumbAwareAction(SqlBundle.message((String)"button.configure.sql.dialect", (Object[])new Object[0]), null, AllIcons.Actions.Edit){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                Root supported = (Root)ContainerUtil.find((Iterable)SqlDataSourceRootsList.this.myRootsList.getSelectedValuesList(), r -> r.myType != Root.Type.NAMED_SCOPE);
                e.getPresentation().setEnabled(supported != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                String dsId;
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((dsId = (String)JBIterable.from((Iterable)SqlDataSourceRootsList.this.myRootsList.getSelectedValuesList()).map(Root::getDataSourceId).single()) != null) {
                    DatabaseConfigEditor controller = SqlDataSourceRootsList.this.myConfigurable.getController();
                    DbDataSource tgt = (DbDataSource)ContainerUtil.find((Iterable)controller.getDataSources(), ds -> ds.getUniqueId().equals(dsId));
                    if (tgt != null) {
                        controller.navigateTo((Object)tgt, true);
                    }
                    return;
                }
                List files = JBIterable.from((Iterable)SqlDataSourceRootsList.this.myRootsList.getSelectedValuesList()).filterMap(Root::getRootPath).filterMap(url -> VirtualFileManager.getInstance().findFileByUrl(url)).toList();
                SqlDialectsConfigurable.openDialectsConfigurable(SqlDataSourceRootsList.this.myConfigurable.getProject(), files);
                SqlDataSourceRootsList.this.myConfigurable.fireChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/database/SqlDataSourceRootsList$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/database/SqlDataSourceRootsList$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        }).createPanel();
    }

    private void editNamedScope(String scopeId) {
        ShowSettingsUtil.getInstance().showSettingsDialog(this.myConfigurable.getProject(), c -> ConfigurableWrapper.cast(ScopeChooserConfigurable.class, (UnnamedConfigurable)c) != null, c -> {
            ScopeChooserConfigurable configurable = (ScopeChooserConfigurable)ConfigurableWrapper.cast(ScopeChooserConfigurable.class, (UnnamedConfigurable)c);
            if (configurable != null) {
                configurable.selectNodeInTree(scopeId);
            }
        });
    }

    void saveData(@NotNull SqlDataSourceImpl dataSource) {
        if (dataSource == null) {
            SqlDataSourceRootsList.$$$reportNull$$$0(1);
        }
        ListModel model = this.myRootsList.getModel();
        ArrayList<String> urls = new ArrayList<String>();
        String parentId = null;
        String filterId = null;
        String filter = null;
        int len = model.getSize();
        block6: for (int i = 0; i < len; ++i) {
            Root root = (Root)model.getElementAt(i);
            switch (root.myType.ordinal()) {
                case 1: {
                    parentId = root.myRoot;
                    continue block6;
                }
                case 2: {
                    filterId = root.myRoot;
                    continue block6;
                }
                case 3: {
                    filter = root.myRoot;
                    continue block6;
                }
                case 0: {
                    urls.add(root.myRoot);
                }
            }
        }
        dataSource.setUrls(urls);
        dataSource.setParentUniqueId(parentId);
        dataSource.setFilterId(filterId);
        dataSource.setInlineFilter(filter);
    }

    void reset(@NotNull SqlDataSourceImpl o) {
        if (o == null) {
            SqlDataSourceRootsList.$$$reportNull$$$0(2);
        }
        ArrayList<Root> items = new ArrayList<Root>();
        if (o.getParentUniqueId() != null) {
            items.add(new Root(o.getParentUniqueId(), Root.Type.DATA_SOURCE));
        }
        if (o.getFilterId() != null) {
            items.add(new Root(o.getFilterId(), Root.Type.NAMED_SCOPE));
        }
        if (o.getInlineFilter() != null) {
            items.add(new Root(o.getInlineFilter(), Root.Type.ANONYMOUS_SCOPE));
        }
        for (String url : o.getUrls()) {
            items.add(new Root(url, Root.Type.ROOT));
        }
        this.setItems(items);
    }

    private void doChooseFiles() {
        VirtualFile tgt;
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor((FileType)SqlFileType.INSTANCE).withTitle(SqlBundle.message((String)"dialog.title.choose.ddl.files", (Object[])new Object[0]));
        Project project = this.myConfigurable.getProject();
        Object[] roots = ProjectRootManager.getInstance((Project)project).getContentRoots();
        if (!PlatformUtils.isDataGrip()) {
            descriptor.setRoots((VirtualFile[])roots);
            descriptor.withTreeRootVisible(true);
        }
        if ((tgt = (VirtualFile)ContainerUtil.getFirstItem(((SqlDataSourceImpl)this.myConfigurable.getDataSource()).getRoots())) == null) {
            tgt = (VirtualFile)ArrayUtil.getLastElement((Object[])roots);
        }
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)tgt, files -> {
            CollectionListModel<Root> model = this.getRootsListModel();
            LinkedHashSet<Root> set = new LinkedHashSet<Root>(model.toList());
            Root.Type type = Root.Type.ROOT;
            for (VirtualFile f : files) {
                set.add(new Root(f.getUrl(), type));
            }
            this.setItems(set);
        });
    }

    private void setItems(Iterable<Root> set) {
        CollectionListModel<Root> model = this.getRootsListModel();
        SqlDataSourceRootsList.setItemsImpl(model, set);
        this.myConfigurable.updateDefaultTexts(ContainerUtil.mapNotNull((Collection)model.getItems(), Root::getRootPath));
    }

    private static void setItemsImpl(@NotNull CollectionListModel<Root> model, Iterable<Root> items) {
        if (model == null) {
            SqlDataSourceRootsList.$$$reportNull$$$0(3);
        }
        int len = model.getSize();
        int i = 0;
        for (Root s : items) {
            if (i < len) {
                model.setElementAt((Object)s, i++);
                continue;
            }
            model.add((Object)s);
        }
        while (i < len) {
            model.removeRow(i++);
        }
    }

    private void replaceScope(Root element) {
        CollectionListModel<Root> model = this.getRootsListModel();
        int existing = ContainerUtil.indexOf((List)model.getItems(), r -> r.myType == Root.Type.NAMED_SCOPE || r.myType == Root.Type.ANONYMOUS_SCOPE);
        if (existing == -1) {
            Root root = model.getSize() > 0 ? (Root)model.getElementAt(0) : null;
            model.add(root == null || root.myType != Root.Type.DATA_SOURCE ? 0 : 1, (Object)element);
        } else {
            model.setElementAt((Object)element, existing);
        }
    }

    @Nullable
    private static PackageSet editAnonymousScope(Project project, PackageSet scope) {
        ScopeEditorPanel panel = new ScopeEditorPanel(project, (NamedScopesHolder)NamedScopeManager.getInstance((Project)project));
        if (scope == null) {
            panel.rebuild(true);
        } else {
            panel.reset(scope, null);
        }
        DialogBuilder builder = new DialogBuilder(project);
        builder.setCenterPanel((JComponent)panel.getPanel());
        return builder.showAndGet() ? panel.getCurrentScope() : null;
    }

    @Nullable
    public static PackageSet compile(@Nullable String filter) {
        PackageSet compiled;
        try {
            compiled = filter == null ? null : PackageSetFactory.getInstance().compile(filter);
        }
        catch (ParsingException e) {
            compiled = new InvalidPackageSet(filter);
        }
        return compiled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceRootsList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsListModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceRootsList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setItemsImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class Root {
        private final String myRoot;
        private final Type myType;

        Root(@NotNull String root, @NotNull Type type) {
            if (root == null) {
                Root.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Root.$$$reportNull$$$0(1);
            }
            this.myRoot = root;
            this.myType = type;
        }

        Root(@NotNull DasDataSource ds) {
            if (ds == null) {
                Root.$$$reportNull$$$0(2);
            }
            this(ds.getUniqueId(), Type.DATA_SOURCE);
        }

        @Nullable
        DasDataSource getDataSource(DatabaseConfigEditor controller) {
            if (this.myType != Type.DATA_SOURCE) {
                return null;
            }
            DbDataSource dataSource = (DbDataSource)ContainerUtil.find((Iterable)controller.getDataSources(), ds -> ds.getUniqueId().equals(this.myRoot));
            return dataSource == null ? null : (DasDataSource)controller.getTempTargetOrTarget((Object)dataSource.getDelegate());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Root)) {
                return false;
            }
            Root source = (Root)o;
            return this.myRoot.equals(source.myRoot) && this.myType == source.myType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myRoot, this.myType});
        }

        public String getDataSourceId() {
            return this.myType == Type.DATA_SOURCE ? this.myRoot : null;
        }

        public String getRootPath() {
            return this.myType == Type.ROOT ? this.myRoot : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ds";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/database/SqlDataSourceRootsList$Root";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum Type {
            ROOT,
            DATA_SOURCE,
            NAMED_SCOPE,
            ANONYMOUS_SCOPE;

        }
    }

    private class FileScopeGroup
    extends ActionGroup {
        FileScopeGroup() {
            super(SqlBundle.message((String)"action.ddl.files.scope.text", (Object[])new Object[0]), null, AllIcons.Ide.LocalScopeAction);
            this.setPopup(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            NamedScopeManager scopeManager = NamedScopeManager.getInstance((Project)SqlDataSourceRootsList.this.myConfigurable.getProject());
            NamedScope[] scopes = scopeManager.getScopes();
            int len = scopes.length;
            AnAction editScopes = ActionManager.getInstance().getAction("ScopeView.EditScopes");
            AnAction[] res = new AnAction[editScopes == null ? len + 2 : len + 3];
            for (int i = 0; i < len; ++i) {
                final NamedScope scope = scopes[i];
                res[i] = new DumbAwareAction(scope.getPresentableName(), null, scope.getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Root element = new Root(scope.getScopeId(), Root.Type.NAMED_SCOPE);
                        SqlDataSourceRootsList.this.replaceScope(element);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/database/SqlDataSourceRootsList$FileScopeGroup$1", "actionPerformed"));
                    }
                };
            }
            res[len] = Separator.getInstance();
            res[len + 1] = new DumbAwareAction(SqlBundle.message((String)"action.anonymous.scope.text", (Object[])new Object[0]), null, AllIcons.Ide.LocalScopeAction){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Project project;
                    PackageSet scope;
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((scope = SqlDataSourceRootsList.editAnonymousScope(project = SqlDataSourceRootsList.this.myConfigurable.getProject(), null)) == null) {
                        return;
                    }
                    SqlDataSourceRootsList.this.replaceScope(new Root(scope.getText(), Root.Type.ANONYMOUS_SCOPE));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/database/SqlDataSourceRootsList$FileScopeGroup$2", "actionPerformed"));
                }
            };
            if (editScopes != null) {
                res[len + 2] = editScopes;
            }
            if (res == null) {
                FileScopeGroup.$$$reportNull$$$0(0);
            }
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceRootsList$FileScopeGroup", "getChildren"));
        }
    }

    private class ExtendDataSourceGroup
    extends ActionGroup {
        ExtendDataSourceGroup() {
            super(SqlBundle.message((String)"action.extend.data.source.text", (Object[])new Object[0]), null, DatabaseIcons.Dbms);
            this.setPopup(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            SqlDataSourceImpl me = SqlDataSourceRootsList.this.myConfigurable.getTempDataSource();
            String id = ((SqlDataSourceImpl)SqlDataSourceRootsList.this.myConfigurable.getDataSource()).getUniqueId();
            DatabaseDialectEx dialect = me.getDatabaseDialect();
            DatabaseConfigEditor controller = SqlDataSourceRootsList.this.myConfigurable.getController();
            List parents = (List)JBIterable.from((Iterable)controller.getDataSources()).filter(ds -> !ds.getUniqueId().equals(id)).map(ds -> (DasDataSource)controller.getTempTargetOrTarget((Object)ds.getDelegate())).filter(ds -> DbImplUtil.getDatabaseDialect((Dbms)ds.getDbms()) == dialect).addAllTo(new ArrayList());
            parents.sort(Comparator.comparing(DasDataSource::getName, DbPresentation.NAMES_COMPARATOR));
            AnAction[] res = new AnAction[parents.size()];
            int size = parents.size();
            for (int i = 0; i < size; ++i) {
                final DasDataSource ds2 = (DasDataSource)parents.get(i);
                res[i] = new DumbAwareAction(ds2.getName(), null, ds2.getIcon(0)){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        CollectionListModel<Root> model = SqlDataSourceRootsList.this.getRootsListModel();
                        Root element = new Root(ds2);
                        int existing = ContainerUtil.indexOf((List)model.getItems(), r -> r.myType == Root.Type.DATA_SOURCE);
                        if (existing == -1) {
                            model.add(0, (Object)element);
                        } else {
                            model.setElementAt((Object)element, existing);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/database/SqlDataSourceRootsList$ExtendDataSourceGroup$1", "actionPerformed"));
                    }
                };
            }
            if (res == null) {
                ExtendDataSourceGroup.$$$reportNull$$$0(0);
            }
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceRootsList$ExtendDataSourceGroup", "getChildren"));
        }
    }
}

