/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.jupyter.core.jupyter.structure.elements.JupyterStructureViewCellElement;
import com.intellij.jupyter.core.jupyter.structure.model.JupyterStructureElementState;
import com.intellij.navigation.ItemPresentation;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002JB\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureTreeCellRenderer;", "Ljavax/swing/tree/TreeCellRenderer;", "<init>", "()V", "defaultRenderer", "Lcom/intellij/ide/util/treeView/NodeRenderer;", "panel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "centerComponent", "Lcom/intellij/ui/SimpleColoredComponent;", "rightComponent", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "getElement", "Lcom/intellij/jupyter/core/jupyter/structure/elements/JupyterStructureViewCellElement;", "getDefaultRenderer", "intellij.jupyter.core"})
public final class JupyterStructureTreeCellRenderer
implements TreeCellRenderer {
    @NotNull
    private final NodeRenderer defaultRenderer = new NodeRenderer();
    @NotNull
    private final BorderLayoutPanel panel = new BorderLayoutPanel();
    @NotNull
    private final SimpleColoredComponent centerComponent = new SimpleColoredComponent();
    @NotNull
    private final SimpleColoredComponent rightComponent = new SimpleColoredComponent();

    public JupyterStructureTreeCellRenderer() {
        BorderLayoutPanel borderLayoutPanel;
        BorderLayoutPanel $this$_init__u24lambda_u240 = borderLayoutPanel = this.panel;
        boolean bl = false;
        $this$_init__u24lambda_u240.addToCenter((Component)this.centerComponent);
        $this$_init__u24lambda_u240.addToRight((Component)this.rightComponent);
        $this$_init__u24lambda_u240.setOpaque(true);
    }

    @Override
    @NotNull
    public Component getTreeCellRendererComponent(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon executionStateIcon;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        JupyterStructureViewCellElement jupyterStructureViewCellElement = this.getElement(value);
        if (jupyterStructureViewCellElement == null) {
            return this.getDefaultRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        JupyterStructureViewCellElement element = jupyterStructureViewCellElement;
        ItemPresentation itemPresentation = element.getPresentation();
        PresentationData presentationData = itemPresentation instanceof PresentationData ? (PresentationData)itemPresentation : null;
        if (presentationData == null) {
            return this.getDefaultRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        PresentationData presentation = presentationData;
        Component cellRenderer = this.defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.panel.setBackground(cellRenderer.getBackground());
        this.centerComponent.setForeground(cellRenderer.getForeground());
        this.rightComponent.setForeground(cellRenderer.getForeground());
        this.centerComponent.clear();
        this.rightComponent.clear();
        this.centerComponent.setIcon(presentation.getIcon(false));
        SimpleTextAttributes titleAttributes = element.getLevel() == 1 ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        String string = presentation.getPresentableText();
        if (string == null) {
            string = "";
        }
        this.centerComponent.append(string, titleAttributes);
        JupyterStructureElementState executionState = element.getExecutionState$intellij_jupyter_core();
        String executionCountString = element.getExecutionCountString$intellij_jupyter_core();
        Icon icon = executionState.isRunning() ? AllIcons.RunConfigurations.TestState.Run_run : (executionState.isQueued() ? AllIcons.General.History : (executionStateIcon = executionState.isCancelled() ? AllIcons.Actions.Cancel : null));
        if (executionStateIcon != null) {
            Icon it = executionStateIcon;
            boolean bl = false;
            this.rightComponent.setIcon(it);
            return (Component)this.panel;
        }
        if (executionCountString == null || executionState == JupyterStructureElementState.NOT_RUNNING) {
            return (Component)this.panel;
        }
        SimpleTextAttributes textAttributes = executionState.isError() ? SimpleTextAttributes.ERROR_ATTRIBUTES : (executionState.isCompleted() ? new SimpleTextAttributes(0, UIUtil.getLabelSuccessForeground()) : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.rightComponent.append(executionCountString, textAttributes);
        return (Component)this.panel;
    }

    private final JupyterStructureViewCellElement getElement(Object value) {
        DefaultMutableTreeNode defaultMutableTreeNode = value instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)value : null;
        Object object = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
        AbstractTreeNode abstractTreeNode = object instanceof AbstractTreeNode ? (AbstractTreeNode)object : null;
        Object object2 = abstractTreeNode != null ? abstractTreeNode.getValue() : null;
        return object2 instanceof JupyterStructureViewCellElement ? (JupyterStructureViewCellElement)object2 : null;
    }

    private final Component getDefaultRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component component2 = this.defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getTreeCellRendererComponent(...)");
        return component2;
    }
}

