/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss.psi;

import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssMediaFeature;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.postcss.PostCssLanguage;
import org.intellij.plugins.postcss.psi.PostCssCustomSelectorAtRule;
import org.intellij.plugins.postcss.psi.PostCssNest;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PostCssPsiUtil {
    private PostCssPsiUtil() {
    }

    @Contract(value="null -> false")
    public static boolean isInsidePostCss(@Nullable PsiElement element) {
        return CssPsiUtilCore.getStylesheetLanguage((PsiElement)element) == PostCssLanguage.INSTANCE;
    }

    @Contract(value="null -> true")
    public static boolean isEmptyElement(@Nullable PsiElement element) {
        return element == null || element.getTextLength() == 0;
    }

    @Contract(value="null -> false")
    public static boolean isInsideNestedRuleset(@Nullable PsiElement element) {
        CssRuleset parent = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)element, CssRuleset.class);
        return PsiTreeUtil.getParentOfType((PsiElement)parent, CssRuleset.class) != null;
    }

    @Contract(value="null -> false")
    public static boolean isInsideRulesetWithNestedRulesets(@Nullable PsiElement element) {
        CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)element, CssRuleset.class);
        return ruleset != null && PsiTreeUtil.findChildOfAnyType((PsiElement)ruleset.getBlock(), (boolean)false, (Class[])new Class[]{CssRuleset.class}) != null;
    }

    @Contract(value="null -> false")
    public static boolean isInsideCustomSelector(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, PostCssCustomSelectorAtRule.class) != null;
    }

    @Contract(value="null -> false")
    public static boolean containsAmpersand(@Nullable PsiElement element) {
        return element != null && element.textContains('&');
    }

    @NotNull
    public static List<TextRange> findAllAmpersands(@Nullable PsiElement element) {
        int index;
        if (element == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                PostCssPsiUtil.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        int offset = 0;
        String text = element.getText();
        do {
            if ((index = text.indexOf(38, offset)) < 0) continue;
            offset = index + 1;
            result.add(TextRange.create((int)(offset - 1), (int)offset));
        } while (index >= 0);
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            PostCssPsiUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<? extends PsiElement> findAllComparisonOperators(@Nullable CssMediaFeature mediaFeature) {
        List list = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)mediaFeature).filter(PostCssPsiUtil::isComparisonOperator)).toList();
        if (list == null) {
            PostCssPsiUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    public static boolean startsWithAmpersand(@NotNull PsiElement element) {
        if (element == null) {
            PostCssPsiUtil.$$$reportNull$$$0(3);
        }
        return StringUtil.startsWithChar((CharSequence)element.getText(), (char)'&');
    }

    @Contract(value="null -> false")
    public static boolean isInsideNest(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PostCssNest.class, CssRuleset.class, CssAtRule.class}) instanceof PostCssNest;
    }

    @Contract(value="null -> false")
    public static boolean isComparisonOperator(@Nullable PsiElement element) {
        return element != null && CssElementTypes.COMPARISON_OPERATORS.contains(element.getNode().getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/postcss/psi/PostCssPsiUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAmpersands";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllComparisonOperators";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/postcss/psi/PostCssPsiUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startsWithAmpersand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

