/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.actions.cwm;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.ActionTimestampSetModel;
import com.jetbrains.rd.ide.model.InputEventModel;
import com.jetbrains.rd.ide.model.PresentationModel;
import com.jetbrains.rd.ide.model.RdCallActionRequest;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdRequest;
import com.jetbrains.rdclient.actions.cwm.ActionTimestampModelProvider;
import com.jetbrains.rdclient.actions.cwm.FrontendActionTimestampValidator;
import com.jetbrains.rdclient.actions.cwm.FrontendCallActionRequestKt;
import com.jetbrains.rdclient.actions.cwm.InputEventDataModel;
import com.jetbrains.rdclient.diagnostics.ActionRequestFusData;
import com.jetbrains.rdclient.diagnostics.ActionRequestFusDataProvider;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.services.RdActionsSupport;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002BU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u0006H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u001dR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001e\u0010'\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00065"}, d2={"Lcom/jetbrains/rdclient/actions/cwm/FrontendCallActionRequest;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusDataProvider;", "initialTimestampSet", "Lcom/jetbrains/rd/ide/model/ActionTimestampSetModel;", "frontendActionId", "", "actionPlace", "presentationModel", "Lcom/jetbrains/rd/ide/model/PresentationModel;", "inputEventDataModel", "Lcom/jetbrains/rdclient/actions/cwm/InputEventDataModel;", "isInsideCommand", "", "project", "Lcom/intellij/openapi/project/Project;", "contextComponent", "Ljava/awt/Component;", "actionFusData", "Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusData;", "<init>", "(Lcom/jetbrains/rd/ide/model/ActionTimestampSetModel;Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/rd/ide/model/PresentationModel;Lcom/jetbrains/rdclient/actions/cwm/InputEventDataModel;ZLcom/intellij/openapi/project/Project;Ljava/awt/Component;Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusData;)V", "getFrontendActionId", "()Ljava/lang/String;", "getActionPlace", "getPresentationModel", "()Lcom/jetbrains/rd/ide/model/PresentationModel;", "getInputEventDataModel", "()Lcom/jetbrains/rdclient/actions/cwm/InputEventDataModel;", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "getActionFusData", "()Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusData;", "contextComponentRef", "Ljava/lang/ref/WeakReference;", "getContextComponent", "()Ljava/awt/Component;", "value", "timestampSetModel", "getTimestampSetModel", "()Lcom/jetbrains/rd/ide/model/ActionTimestampSetModel;", "conflictWith", "other", "Lcom/jetbrains/rd/ide/model/RdPatch;", "undo", "", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "redo", "createModel", "Lcom/jetbrains/rd/ide/model/RdRequest;", "debugDescription", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendCallActionRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCallActionRequest.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendCallActionRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,134:1\n1#2:135\n60#3,5:136\n*S KotlinDebug\n*F\n+ 1 FrontendCallActionRequest.kt\ncom/jetbrains/rdclient/actions/cwm/FrontendCallActionRequest\n*L\n56#1:136,5\n*E\n"})
public class FrontendCallActionRequest
extends FrontendAsyncRequest
implements ActionRequestFusDataProvider {
    @NotNull
    private final String frontendActionId;
    @NotNull
    private final String actionPlace;
    @NotNull
    private final PresentationModel presentationModel;
    @Nullable
    private final InputEventDataModel inputEventDataModel;
    private final boolean isInsideCommand;
    @Nullable
    private final Project project;
    @NotNull
    private final ActionRequestFusData actionFusData;
    @Nullable
    private final WeakReference<Component> contextComponentRef;
    @NotNull
    private ActionTimestampSetModel timestampSetModel;

    /*
     * WARNING - void declaration
     */
    public FrontendCallActionRequest(@NotNull ActionTimestampSetModel initialTimestampSet, @NotNull String frontendActionId, @NotNull String actionPlace, @NotNull PresentationModel presentationModel, @Nullable InputEventDataModel inputEventDataModel, boolean isInsideCommand, @Nullable Project project, @Nullable Component contextComponent, @NotNull ActionRequestFusData actionFusData) {
        WeakReference<void> weakReference;
        Intrinsics.checkNotNullParameter((Object)initialTimestampSet, (String)"initialTimestampSet");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Intrinsics.checkNotNullParameter((Object)actionPlace, (String)"actionPlace");
        Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
        Intrinsics.checkNotNullParameter((Object)actionFusData, (String)"actionFusData");
        this.frontendActionId = frontendActionId;
        this.actionPlace = actionPlace;
        this.presentationModel = presentationModel;
        this.inputEventDataModel = inputEventDataModel;
        this.isInsideCommand = isInsideCommand;
        this.project = project;
        this.actionFusData = actionFusData;
        FrontendCallActionRequest frontendCallActionRequest = this;
        Component component = contextComponent;
        if (component != null) {
            void it;
            Component component2 = component;
            FrontendCallActionRequest frontendCallActionRequest2 = frontendCallActionRequest;
            boolean bl = false;
            weakReference = new WeakReference<void>(it);
            frontendCallActionRequest = frontendCallActionRequest2;
        } else {
            weakReference = null;
        }
        frontendCallActionRequest.contextComponentRef = weakReference;
        this.timestampSetModel = initialTimestampSet;
    }

    @NotNull
    public final String getFrontendActionId() {
        return this.frontendActionId;
    }

    @NotNull
    public final String getActionPlace() {
        return this.actionPlace;
    }

    @NotNull
    public final PresentationModel getPresentationModel() {
        return this.presentationModel;
    }

    @Nullable
    public final InputEventDataModel getInputEventDataModel() {
        return this.inputEventDataModel;
    }

    protected final boolean isInsideCommand() {
        return this.isInsideCommand;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public ActionRequestFusData getActionFusData() {
        return this.actionFusData;
    }

    @Nullable
    public final Component getContextComponent() {
        WeakReference<Component> weakReference = this.contextComponentRef;
        return weakReference != null ? (Component)weakReference.get() : null;
    }

    @NotNull
    public final ActionTimestampSetModel getTimestampSetModel() {
        return this.timestampSetModel;
    }

    @Override
    public boolean conflictWith(@NotNull RdPatch other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return !((Collection)CollectionsKt.intersect((Iterable)FrontendCallActionRequestKt.patchItemIds(this.timestampSetModel), (Iterable)FrontendCallActionRequestKt.patchItemIds(other))).isEmpty();
    }

    @Override
    public void undo(@NotNull FrontendRebaseSession rebaseSession) {
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
    }

    @Override
    public void redo(@NotNull FrontendRebaseSession rebaseSession) {
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        DataContext dataContext = DataManager.getInstance().getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        ActionTimestampSetModel actualSetModel = ActionTimestampModelProvider.Companion.createTimestampModelSet(this.frontendActionId, dataContext2, false);
        if (!FrontendActionTimestampValidator.Companion.validateActualTimestampSetModel(this.frontendActionId, this.timestampSetModel, actualSetModel)) {
            Logger $this$debug_u24default$iv = FrontendCallActionRequestKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Cannot execute `" + this.frontendActionId + "` queued action. Context changed", e$iv);
            }
            return;
        }
        this.timestampSetModel = ActionTimestampModelProvider.Companion.preserveFragileTimestamps(actualSetModel, this.timestampSetModel);
    }

    @Override
    @NotNull
    public RdRequest createModel() {
        ActionTimestampSetModel timestampSetModel = ActionTimestampModelProvider.Companion.filterOutTransientTimestamps(this.timestampSetModel);
        String backendActionId = RdActionsSupport.Companion.getInstance().getBackendActionId(this.frontendActionId);
        InputEventDataModel inputEventDataModel = this.inputEventDataModel;
        return (RdRequest)new RdCallActionRequest(timestampSetModel, backendActionId, this.actionPlace, this.presentationModel, (InputEventModel)(inputEventDataModel != null ? inputEventDataModel.getProtocolModel() : null), this.isInsideCommand);
    }

    @Override
    @NotNull
    protected String debugDescription() {
        return "Call action=" + this.frontendActionId;
    }
}

