/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class RestClientSerializer {
    public static final String REST_CLIENT_REQUEST_TAG = "RestClientRequest";

    private RestClientSerializer() {
    }

    public static void saveToFile(@NotNull RestClientRequest request, @NotNull File file) throws RestClientSerializationException {
        if (request == null) {
            RestClientSerializer.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RestClientSerializer.$$$reportNull$$$0(1);
        }
        Element requestXml = XmlSerializer.serialize((Object)request);
        try {
            JDOMUtil.write((Element)requestXml, (Path)file.toPath());
        }
        catch (IOException e1) {
            throw new RestClientSerializationException(e1.getMessage());
        }
    }

    @NotNull
    public static RestClientRequest loadFromFile(@NotNull VirtualFile file) throws RestClientSerializationException {
        Element element;
        if (file == null) {
            RestClientSerializer.$$$reportNull$$$0(2);
        }
        try {
            element = JDOMUtil.load((InputStream)file.getInputStream());
        }
        catch (JDOMException e) {
            throw new RestClientSerializationException(RestClientBundle.message("the.selected.file.is.not.a.valid.xml.file.error", e.getMessage()));
        }
        catch (IOException e) {
            throw new RestClientSerializationException(RestClientBundle.message("error.loading.error", file.getPath(), e.getMessage()));
        }
        if (!element.getName().equals(REST_CLIENT_REQUEST_TAG)) {
            throw new RestClientSerializationException(RestClientBundle.message("the.selected.file.is.not.a.rest.client.request.error", new Object[0]));
        }
        RestClientRequest restClientRequest = (RestClientRequest)XmlSerializer.deserialize((Element)element, RestClientRequest.class);
        if (restClientRequest == null) {
            RestClientSerializer.$$$reportNull$$$0(3);
        }
        return restClientRequest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/execution/RestClientSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/execution/RestClientSerializer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static class RestClientSerializationException
    extends Exception {
        public RestClientSerializationException(@NotNull @Nls String s) {
            if (s == null) {
                RestClientSerializationException.$$$reportNull$$$0(0);
            }
            super(s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/httpClient/execution/RestClientSerializer$RestClientSerializationException", "<init>"));
        }
    }
}

