/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.settings;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.http.request.run.HttpClientSettings;
import com.intellij.httpClient.settings.HttpClientConfigurable;
import com.intellij.httpClient.settings.HttpClientSettingsImpl;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/settings/HttpClientConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "methodRegex", "Lkotlin/text/Regex;", "customMethodsTextField", "Lcom/intellij/ui/RawCommandLineEditor;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "validate", "Lcom/intellij/openapi/ui/ValidationInfo;", "text", "", "apply", "", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientConfigurable.kt\ncom/intellij/httpClient/settings/HttpClientConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1563#2:67\n1634#2,3:68\n774#2:71\n865#2,2:72\n774#2:74\n865#2,2:75\n*S KotlinDebug\n*F\n+ 1 HttpClientConfigurable.kt\ncom/intellij/httpClient/settings/HttpClientConfigurable\n*L\n47#1:67\n47#1:68,3\n47#1:71\n47#1:72,2\n49#1:74\n49#1:75,2\n*E\n"})
public final class HttpClientConfigurable
extends BoundConfigurable
implements UnnamedConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final Regex methodRegex;
    @NotNull
    private final RawCommandLineEditor customMethodsTextField;

    public HttpClientConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(HttpClientExecutorBundle.message("http.client.configurable.display.name", new Object[0]), "reference.settings.tools.http.client");
        this.project = project;
        this.methodRegex = new Regex("([A-Z]+)");
        this.customMethodsTextField = new RawCommandLineEditor(arg_0 -> HttpClientConfigurable.customMethodsTextField$lambda$1(HttpClientConfigurable::customMethodsTextField$lambda$0, arg_0), arg_0 -> HttpClientConfigurable.customMethodsTextField$lambda$3(HttpClientConfigurable::customMethodsTextField$lambda$2, arg_0));
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel(arg_0 -> HttpClientConfigurable.createPanel$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final ValidationInfo validate(String text2) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        String it;
        Iterable $this$mapTo$iv$iv;
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List methods = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = methods;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it2 = (String)element$iv$iv;
            boolean bl = false;
            if (!(!this.methodRegex.matches((CharSequence)it2))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List invalid = (List)destination$iv$iv2;
        if (invalid.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)invalid, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)};
        String message = HttpClientExecutorBundle.message("http.client.configurable.validation.failed", objectArray);
        return new ValidationInfo(message);
    }

    public void apply() {
        String text2 = this.customMethodsTextField.getText();
        Intrinsics.checkNotNull((Object)text2);
        ValidationInfo info = this.validate(text2);
        if (info == null) {
            HttpClientSettings.Companion.getInstance(this.project).setCustomMethodsText(text2);
            return;
        }
        throw new ConfigurationException(info.message);
    }

    private static final List customMethodsTextField$lambda$0(String it) {
        Intrinsics.checkNotNull((Object)it);
        String[] stringArray = new String[]{",", " "};
        return StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    private static final List customMethodsTextField$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final String customMethodsTextField$lambda$2(List it) {
        Intrinsics.checkNotNull((Object)it);
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)it, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))).toString();
    }

    private static final String customMethodsTextField$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit createPanel$lambda$0(HttpClientConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(HttpClientExecutorBundle.message("http.client.configurable.command.line.editor.row.name", new Object[0]), arg_0 -> HttpClientConfigurable.createPanel$lambda$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(HttpClientConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.customMethodsTextField), (String)HttpClientExecutorBundle.message("http.client.configurable.custom.methods.row.comment", new Object[0]), (int)0, null, (int)6, null).resizableColumn().align(Align.FILL).gap(RightGap.SMALL);
        Function1 function1 = HttpClientConfigurable::createPanel$lambda$0$0$0;
        Function2 function2 = createPanel.1.1.2.INSTANCE;
        HttpClientSettings httpClientSettings = HttpClientSettings.Companion.getInstance(this$0.project);
        Intrinsics.checkNotNull((Object)httpClientSettings, (String)"null cannot be cast to non-null type com.intellij.httpClient.settings.HttpClientSettingsImpl");
        cell.bind(function1, function2, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((HttpClientSettingsImpl)httpClientSettings){

            public Object get() {
                return ((HttpClientSettingsImpl)this.receiver).getOptions$intellij_restClient();
            }

            public void set(Object value2) {
                ((HttpClientSettingsImpl)this.receiver).setOptions$intellij_restClient((String)value2);
            }
        }))).validationOnInput((arg_0, arg_1) -> HttpClientConfigurable.createPanel$lambda$0$0$1(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$0$0$0(RawCommandLineEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (char)' ', (char)',', (boolean)false, (int)4, null);
    }

    private static final ValidationInfo createPanel$lambda$0$0$1(HttpClientConfigurable this$0, ValidationInfoBuilder $this$validationOnInput, RawCommandLineEditor input) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return this$0.validate(string);
    }
}

