/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.rules.en.UnitConversionRule;
import tech.units.indriya.unit.Units;

public class UnitConversionRuleImperial
extends UnitConversionRule {
    public UnitConversionRuleImperial(ResourceBundle messages) {
        super(messages);
        this.format = NumberFormat.getNumberInstance(Locale.UK);
        this.format.setMaximumFractionDigits(2);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
        this.addUnit("(kilometre|kilometer)s? per hour", Units.KILOMETRE_PER_HOUR, "kilometres per hour", 1.0, true);
        this.addUnit("kilomet(re|er)s?", Units.METRE, "kilometres", 1000.0, true);
        this.addUnit("met(re|er)s?", Units.METRE, "metres", 1.0, true);
        this.addUnit("decimet(re|er)s?", Units.METRE, "decimetres", 0.1, false);
        this.addUnit("centimet(re|er)s?", Units.METRE, "centimetres", 0.01, true);
        this.addUnit("millimet(re|er)s?", Units.METRE, "micrometres", 0.001, true);
        this.addUnit("micromet(re|er)s?", Units.METRE, "micrometres", 1.0E-6, true);
        this.addUnit("nanomet(re|er)s?", Units.METRE, "nanometres", 1.0E-9, true);
        this.addUnit("square met(re|er)s?", Units.SQUARE_METRE, "square metres", 1.0, true);
        this.addUnit("square kilomet(re|er)s?", Units.SQUARE_METRE, "square kilometres", 1000000.0, true);
        this.addUnit("square decimet(re|er)s?", Units.SQUARE_METRE, "square decimetres", 0.01, false);
        this.addUnit("square centimet(re|er)s?", Units.SQUARE_METRE, "square centimetres", 1.0E-4, true);
        this.addUnit("square millimet(re|er)s?", Units.SQUARE_METRE, "square millimetres", 1.0E-6, true);
        this.addUnit("square micromet(re|er)s?", Units.SQUARE_METRE, "square micrometres", 1.0E-12, true);
        this.addUnit("square nanomet(re|er)s?", Units.SQUARE_METRE, "square nanometres", 1.0E-18, true);
        this.addUnit("cubic met(re|er)s?", Units.CUBIC_METRE, "cubic metres", 1.0, true);
        this.addUnit("cubic kilomet(re|er)s?", Units.CUBIC_METRE, "cubic kilometres", 1.0E9, true);
        this.addUnit("cubic decimet(re|er)s?", Units.CUBIC_METRE, "cubic decimetres", 0.001, false);
        this.addUnit("cubic centimet(re|er)s?", Units.CUBIC_METRE, "cubic centimetres", 1.0E-6, true);
        this.addUnit("cubic millimet(re|er)s?", Units.CUBIC_METRE, "cubic millimetres", 1.0E-9, true);
        this.addUnit("cubic micromet(re|er)s?", Units.CUBIC_METRE, "cubic micrometres", 1.0E-18, true);
        this.addUnit("cubic nanomet(re|er)s?", Units.CUBIC_METRE, "cubic nanometres", 1.0E-27, true);
        this.addUnit("lit(re|er)s?", Units.LITRE, "litres", 1.0, true);
        this.addUnit("millilit(re|er)s?", Units.LITRE, "millilitres", 0.001, true);
        this.addUnit("qt\\.", IMP_QUART, "qt.", 1.0, false);
        this.addUnit("gal", IMP_GALLON, "gal", 1.0, false);
        this.addUnit("pt", IMP_PINT, "pt", 1.0, false);
        this.addUnit("(?:fl.? oz.?|oz. fl.)", IMP_FL_OUNCE, "fl oz", 1.0, false);
        this.addUnit("quarts?", IMP_QUART, "quarts", 1.0, false);
        this.addUnit("gallons?", IMP_GALLON, "gallons", 1.0, false);
        this.addUnit("pints?", IMP_PINT, "pints", 1.0, false);
        this.addUnit("(fluid )?ounces?", IMP_FL_OUNCE, "fluid ounces", 1.0, false);
    }

    @Override
    public String getId() {
        return "METRIC_UNITS_EN_IMPERIAL";
    }
}

