/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class PatternBasedNodeJsFilter
implements Filter,
DumbAware {
    private static final Pattern[] BASIC_PATTERNS = new Pattern[]{Pattern.compile("^\\s*at\\s+(.*):(\\d*):(\\d*)$"), Pattern.compile("^\\s*at.*\\((.*):(\\d*):(\\d*)\\)$")};
    protected static final Pattern[] ALL_PATTERNS = (Pattern[])ArrayUtil.mergeArrays((Object[])BASIC_PATTERNS, (Object[])new Pattern[]{Pattern.compile("^\\s*at.+?\\(.+?\\((.*):(\\d*):(\\d*)\\)\\)$"), Pattern.compile("^(.*):(\\d+):(\\d+)(?:\\s.*)?$"), Pattern.compile("^(.*):(\\d+)(?:\\s.*)?$")});
    private final Project myProject;
    private final boolean myUseOnlyBasicPatterns;

    public PatternBasedNodeJsFilter(@NotNull Project project) {
        if (project == null) {
            PatternBasedNodeJsFilter.$$$reportNull$$$0(0);
        }
        this(project, false);
    }

    public PatternBasedNodeJsFilter(@NotNull Project project, boolean useOnlyBasicPatterns) {
        if (project == null) {
            PatternBasedNodeJsFilter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myUseOnlyBasicPatterns = useOnlyBasicPatterns;
    }

    protected Pattern[] getPatterns() {
        return this.myUseOnlyBasicPatterns ? BASIC_PATTERNS : ALL_PATTERNS;
    }

    @Nullable
    private Matcher findMatcher(String line) {
        Pattern[] patterns;
        for (Pattern pattern : patterns = this.getPatterns()) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            return matcher;
        }
        return null;
    }

    public Filter.Result applyFilter(@NotNull String outLine, int entireLength) {
        Matcher matcher;
        if (outLine == null) {
            PatternBasedNodeJsFilter.$$$reportNull$$$0(2);
        }
        if ((matcher = this.findMatcher(outLine)) != null) {
            String fileName = matcher.group(1);
            VirtualFile file = LocalFileFinder.findFile((String)fileName);
            if (file == null) {
                file = this.findVirtualFile(fileName);
            }
            if (file != null) {
                int line = Integer.parseInt(matcher.group(2)) - 1;
                boolean hasColumnInfo = matcher.groupCount() >= 3;
                int column = hasColumnInfo ? Integer.parseInt(matcher.group(3)) - 1 : 0;
                int start = matcher.start(1);
                int end = matcher.end(matcher.groupCount());
                return new Filter.Result(entireLength - outLine.length() + start, entireLength - outLine.length() + end, (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, file, line, column));
            }
        }
        return null;
    }

    protected VirtualFile findVirtualFile(@NotNull String fileName) {
        if (fileName == null) {
            PatternBasedNodeJsFilter.$$$reportNull$$$0(3);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outLine";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/PatternBasedNodeJsFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findVirtualFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

