/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 133823267668929L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(676714410 - (char)-16982, 676714410 - 24192, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(676714410 - (char)-16983, -676714410 - -((char)-16538), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 133563366419659L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.v();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1526572290 - -23050, 1526572290 - 27526, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1526572290 - -23051, -1526572290 - -29899, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1526572290 - -23056, -1526572290 - -13372, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 116015315986306L;
                            Object object = this.lock;
                            synchronized (object) {
                                boolean bl3;
                                bl2 = SshAgentIpcService.A();
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-340650930 - -((char)-22024), 340650930 - (char)-15575, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-340650930 - -((char)-22025), 340650930 - (char)-8191, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-340650930 - -((char)-22026), 340650930 - (char)-17590, (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (!bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-340650930 - -((char)-22019), 340650930 - (char)-27676, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-340650930 - -((char)-22020), -340650930 - -((char)-8647), (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-340650930 - -((char)-22021), 340650930 - (char)-31757, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-340650930 - -((char)-22019), 340650930 - (char)-27676, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-340650930 - -((char)-22022), 340650930 - (char)-10759, (int)l2));
                            if (ActionTimestamp.v() != null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.v(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 22412250007070L;
                    bl = SshAgentIpcService.v();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 44765093487576L;
                boolean bl2 = SshAgentIpcService.v();
                this.assertConnectionThread();
                bl = bl2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl4 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22125), -1350676350 - -14585, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22129), 1350676350 - (char)-25622, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22126), -1350676350 - -22954, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22129), 1350676350 - (char)-25622, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22123), -1350676350 - -27734, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22125), -1350676350 - -14585, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22129), 1350676350 - (char)-25622, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22124), -1350676350 - -30537, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl8 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22125), -1350676350 - -14585, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22129), 1350676350 - (char)-25622, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22137), -1350676350 - -((char)-27490), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22129), 1350676350 - (char)-25622, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22138), -1350676350 - -13006, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl9;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl10 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl9 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl9) {
                boolean bl11 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22129), 1350676350 - (char)-25622, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22123), -1350676350 - -27734, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl12 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22125), -1350676350 - -14585, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22129), 1350676350 - (char)-25622, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1350676350 - -((char)-22135), 1350676350 - (char)-32763, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 69923627095779L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1559470860 + (char)-20394, -1559470860 + -((char)-26554), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 96836982784965L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1644797430 + -((char)-25659), 1644797430 + (char)-9238, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "K=\u008c\u00b5\u001bj\u00e4\u008cG.1'\u00b7\u0011X\u009f9\u00a4\u0098\u0014\u008b-\u0094\u00b1\u0003(\u009aA\n\u0091]\u0004\u00f8\u008cp\u00a7\u00d1e\u0082\u00a2";
                        var4_3 = "K=\u008c\u00b5\u001bj\u00e4\u008cG.1'\u00b7\u0011X\u009f9\u00a4\u0098\u0014\u008b-\u0094\u00b1\u0003(\u009aA\n\u0091]\u0004\u00f8\u008cp\u00a7\u00d1e\u0082\u00a2".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 110;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 108;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 90;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 31;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 122;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 61;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 32;
                                        break;
                                    }
                                    default: {
                                        v11 = 85;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x581) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 67;
                            case 1 -> 31;
                            case 2 -> 2;
                            case 3 -> 109;
                            case 4 -> 211;
                            case 5 -> 214;
                            case 6 -> 216;
                            case 7 -> 153;
                            case 8 -> 4;
                            case 9 -> 154;
                            case 10 -> 42;
                            case 11 -> 64;
                            case 12 -> 71;
                            case 13 -> 18;
                            case 14 -> 162;
                            case 15 -> 212;
                            case 16 -> 52;
                            case 17 -> 218;
                            case 18 -> 188;
                            case 19 -> 99;
                            case 20 -> 143;
                            case 21 -> 164;
                            case 22 -> 173;
                            case 23 -> 254;
                            case 24 -> 246;
                            case 25 -> 157;
                            case 26 -> 85;
                            case 27 -> 14;
                            case 28 -> 86;
                            case 29 -> 201;
                            case 30 -> 190;
                            case 31 -> 172;
                            case 32 -> 106;
                            case 33 -> 74;
                            case 34 -> 80;
                            case 35 -> 96;
                            case 36 -> 36;
                            case 37 -> 23;
                            case 38 -> 127;
                            case 39 -> 231;
                            case 40 -> 145;
                            case 41 -> 7;
                            case 42 -> 163;
                            case 43 -> 107;
                            case 44 -> 183;
                            case 45 -> 0;
                            case 46 -> 91;
                            case 47 -> 12;
                            case 48 -> 205;
                            case 49 -> 1;
                            case 50 -> 24;
                            case 51 -> 213;
                            case 52 -> 19;
                            case 53 -> 83;
                            case 54 -> 6;
                            case 55 -> 110;
                            case 56 -> 51;
                            case 57 -> 87;
                            case 58 -> 129;
                            case 59 -> 113;
                            case 60 -> 142;
                            case 61 -> 191;
                            case 62 -> 39;
                            case 63 -> 152;
                            case 64 -> 242;
                            case 65 -> 72;
                            case 66 -> 194;
                            case 67 -> 73;
                            case 68 -> 79;
                            case 69 -> 234;
                            case 70 -> 177;
                            case 71 -> 244;
                            case 72 -> 21;
                            case 73 -> 38;
                            case 74 -> 126;
                            case 75 -> 49;
                            case 76 -> 200;
                            case 77 -> 149;
                            case 78 -> 103;
                            case 79 -> 28;
                            case 80 -> 104;
                            case 81 -> 45;
                            case 82 -> 43;
                            case 83 -> 48;
                            case 84 -> 210;
                            case 85 -> 179;
                            case 86 -> 208;
                            case 87 -> 128;
                            case 88 -> 189;
                            case 89 -> 165;
                            case 90 -> 10;
                            case 91 -> 116;
                            case 92 -> 168;
                            case 93 -> 198;
                            case 94 -> 232;
                            case 95 -> 209;
                            case 96 -> 186;
                            case 97 -> 161;
                            case 98 -> 90;
                            case 99 -> 221;
                            case 100 -> 34;
                            case 101 -> 66;
                            case 102 -> 141;
                            case 103 -> 134;
                            case 104 -> 16;
                            case 105 -> 59;
                            case 106 -> 124;
                            case 107 -> 176;
                            case 108 -> 120;
                            case 109 -> 47;
                            case 110 -> 75;
                            case 111 -> 50;
                            case 112 -> 217;
                            case 113 -> 238;
                            case 114 -> 130;
                            case 115 -> 27;
                            case 116 -> 248;
                            case 117 -> 140;
                            case 118 -> 112;
                            case 119 -> 147;
                            case 120 -> 22;
                            case 121 -> 236;
                            case 122 -> 15;
                            case 123 -> 243;
                            case 124 -> 125;
                            case 125 -> 192;
                            case 126 -> 76;
                            case 127 -> 30;
                            case 128 -> 58;
                            case 129 -> 233;
                            case 130 -> 250;
                            case 131 -> 160;
                            case 132 -> 55;
                            case 133 -> 225;
                            case 134 -> 224;
                            case 135 -> 70;
                            case 136 -> 253;
                            case 137 -> 62;
                            case 138 -> 94;
                            case 139 -> 223;
                            case 140 -> 139;
                            case 141 -> 46;
                            case 142 -> 95;
                            case 143 -> 26;
                            case 144 -> 115;
                            case 145 -> 156;
                            case 146 -> 170;
                            case 147 -> 53;
                            case 148 -> 65;
                            case 149 -> 199;
                            case 150 -> 237;
                            case 151 -> 77;
                            case 152 -> 206;
                            case 153 -> 193;
                            case 154 -> 239;
                            case 155 -> 101;
                            case 156 -> 118;
                            case 157 -> 171;
                            case 158 -> 148;
                            case 159 -> 33;
                            case 160 -> 135;
                            case 161 -> 93;
                            case 162 -> 196;
                            case 163 -> 146;
                            case 164 -> 181;
                            case 165 -> 144;
                            case 166 -> 155;
                            case 167 -> 117;
                            case 168 -> 123;
                            case 169 -> 122;
                            case 170 -> 174;
                            case 171 -> 84;
                            case 172 -> 230;
                            case 173 -> 68;
                            case 174 -> 60;
                            case 175 -> 81;
                            case 176 -> 203;
                            case 177 -> 102;
                            case 178 -> 169;
                            case 179 -> 175;
                            case 180 -> 222;
                            case 181 -> 241;
                            case 182 -> 220;
                            case 183 -> 166;
                            case 184 -> 184;
                            case 185 -> 137;
                            case 186 -> 119;
                            case 187 -> 207;
                            case 188 -> 202;
                            case 189 -> 89;
                            case 190 -> 41;
                            case 191 -> 32;
                            case 192 -> 40;
                            case 193 -> 249;
                            case 194 -> 92;
                            case 195 -> 105;
                            case 196 -> 187;
                            case 197 -> 251;
                            case 198 -> 5;
                            case 199 -> 228;
                            case 200 -> 44;
                            case 201 -> 11;
                            case 202 -> 108;
                            case 203 -> 159;
                            case 204 -> 57;
                            case 205 -> 195;
                            case 206 -> 133;
                            case 207 -> 82;
                            case 208 -> 3;
                            case 209 -> 37;
                            case 210 -> 25;
                            case 211 -> 227;
                            case 212 -> 182;
                            case 213 -> 100;
                            case 214 -> 131;
                            case 215 -> 29;
                            case 216 -> 9;
                            case 217 -> 136;
                            case 218 -> 56;
                            case 219 -> 178;
                            case 220 -> 215;
                            case 221 -> 235;
                            case 222 -> 8;
                            case 223 -> 245;
                            case 224 -> 98;
                            case 225 -> 151;
                            case 226 -> 35;
                            case 227 -> 197;
                            case 228 -> 180;
                            case 229 -> 61;
                            case 230 -> 114;
                            case 231 -> 158;
                            case 232 -> 247;
                            case 233 -> 13;
                            case 234 -> 63;
                            case 235 -> 219;
                            case 236 -> 17;
                            case 237 -> 132;
                            case 238 -> 88;
                            case 239 -> 138;
                            case 240 -> 240;
                            case 241 -> 255;
                            case 242 -> 204;
                            case 243 -> 111;
                            case 244 -> 54;
                            case 245 -> 78;
                            case 246 -> 150;
                            case 247 -> 229;
                            case 248 -> 252;
                            case 249 -> 69;
                            case 250 -> 97;
                            case 251 -> 121;
                            case 252 -> 226;
                            case 253 -> 167;
                            case 254 -> 185;
                            default -> 20;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (bl) {
                ActionTimestamp.v(new int[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 22653413223978L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.v();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1755682650 + 24717, 1755682650 - 4817, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1755682650 + 24713, -1755682650 + -19008, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1755682650 + 24734, 1755682650 - 5557, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1755682650 + 24717, 1755682650 - 4817, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1755682650 + 24713, -1755682650 + -19008, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1755682650 + 24741, 1755682650 + 19891, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 82851963143054L;
                        boolean bl3 = SshAgentIpcService.v();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(2044036650 - 27600, 2044036650 - 18314, (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(2044036650 - 27601, 2044036650 - 4359, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 124130554563414L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                bl = SshAgentIpcService.v();
                synchronized (object2) {
                    boolean bl2;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl3 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl4 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18377, 1704696420 + (char)-30831, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18373, -1704696420 + -((char)-21886), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18404, -1704696420 + -((char)-24534), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl2 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18373, -1704696420 + -((char)-21886), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18379, 1704696420 + 31218, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl6 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18377, 1704696420 + (char)-30831, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18373, -1704696420 + -((char)-21886), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18389, -1704696420 + -((char)-23161), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl6 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18377, 1704696420 + (char)-30831, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18373, -1704696420 + -((char)-21886), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18390, 1704696420 + (char)-30470, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl7 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl8 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18377, 1704696420 + (char)-30831, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18373, -1704696420 + -((char)-21886), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1704696420 + (char)-18391, 1704696420 + (char)-19138, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 81867851550442L;
                    Object object = this.lock;
                    bl2 = SshAgentIpcService.v();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1479911370 + 12125, 1479911370 - 897, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1479911370 + 12121, -1479911370 + -6544, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1479911370 + 12134, -1479911370 + -13291, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1479911370 + 12141, -1479911370 + -20639, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1479911370 + 12125, 1479911370 - 897, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1479911370 + 12121, -1479911370 + -6544, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1479911370 + 12140, 1479911370 - 3704, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1479911370 + 12125, 1479911370 - 897, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1479911370 + 12121, -1479911370 + -6544, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1479911370 + 12139, -1479911370 + -13202, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1479911370 + 12125, 1479911370 - 897, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1479911370 + 12121, -1479911370 + -6544, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1479911370 + 12138, 1479911370 + 107, (int)l2));
                    if (bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1479911370 + 12125, 1479911370 - 897, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1479911370 + 12121, -1479911370 + -6544, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1479911370 + 12097, 1479911370 + 18550, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1479911370 + 12096, -1479911370 + -6118, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "`\u00b4\u00ef\u00c4r\u00f1D8\u0014T\u00c4Q-[D\u00ce\u0094n\u008a\u00b1\u00dd<\u0016>J\u00df\u00eaf\u001c\u0006\u000fT\u0002\u00d8\u00a53\u0018\u00d9S\u0080\u00ef\u00e3\u00d9\u00db\u00e7\u0004\u0099\u00f3\u00cf\u0012\u00ab\u00a9\u007f\u0084%#x\u00fdF\u0012\u00d1\t\u00920w2v\u00fdq+m\u0005\u0087f\u0013\u009e\u009d\bK\u00a4\u008a\u00b7\u008c\u00b9\u009d\u00d3\u0014\u00fe\u00de|\u00f5\u0093W\u00e2a\u0085\u00e9g\u0005\u00ac\u00ae\u0097\u00b0\u00f8f{\u00cf\u0005z\u00b3\u00ac$j\u001e\u009d+ES\u00ca\u008a\\\u00f7Q\u008f\u0012\u008ab#\u0005\n\u00f0\u001a\u007fk\u00da\u000b\u00fa\u00b5t\u009f\u00d0\u0084w\u001c\u0010[\u00a0y\u00e7\u001a.\u00b0\u009a\u00b1\u0090\u0083\u0094V\u00b5,G\t\u00a4[gN'U}\u00a1\u0002\u0010:\u008fU\u0002\u009f\u0092\u0000\r\u00a7bA\u00ca\u000e~'>?\u00e2\u00ff\u00a2\u00c9;\u00d0\u00e7\u00d0W\u00ba\u0097\u00d7m~\u00d9\u0098\u00ae-\u00c9H\u0082=\u008a\u0015jc\u001e\u00af\u0099/Y\u00c0(\u0086i\u0093\u008ct\u0091\f|\u000ef\u00b7@\u00a6e\u00c2*\u00e01\u00df?%\u009b\u00d0\u008a\u00b1\u00ec9\u00b2\u00ce\u00b5\b\u00c7\u0002\u001bc\u00be#\u00db\u0080\f\u00fa\u00b3\u00acNU\u00e4H\u007f\u0087d\u0017\u000eF[/\u0098\u00dd\u00d3\u0096\u00981\u009d\u00a1^r\u00c2\u00c23)\u000f|\u00fd\u00cd\u0016\u00df\u001b{n\u0085mxH\u00fcY\u0086\u0014\u00f8,}\u00fe\u00e4t\u00daS\u00c1\b\u00b5ScS\u0007\u000b\u00a0s}\u0098\u00e7y\u0093I\u00ad\u0002\u0006\\@4\u00c1\u009dqY\u000e\u00c0\u00c4\u001f\u00bb\u00b5\u0081\u0080R\u00f0O\u00b83f^\u00b7\u00eb\u0099?\u00ec\u00cc.\u0085'N\u0002\u00bf?\u00bd\u001e\u00fex\u00afr\u00a7\u000b`S\u00ffR?g\u0005\u000f.f(\u0015\u0099\u00df\u00c0\u00c0\u00df]\u00f55\u000e\u00c1\u00e4\u0088\u0002\u00d2\u001f\u00d33]\u00a70<)\u009b\u00c1\u0085\u000e\u00d2!_\u00821!\u001e_\u00e7\u008e \u000bpZ\u00c9\u000e7_V\u008c\u00ef!c\u00e73u\u00b6\u0089\u0017\u00bc*x Y$\u00c4\u00fa\u0007\u00ef\u009e\u0001\u00fffBR\u0007Rw\u00d2\u00ae\u00fb\u0087\u00f7(\u00d1r\u0080Y\u00c2\u00a1\u00ab\u00b5\u00df\u0010\u00e9O:\r\u00d9\u00f8H\u0089`7cF\u00b3d\u00c3\u0080P\u00a8b\u00fcG\u00a1\u00d2\u00d2\f\u0018^(x\u0019\u000fYg\u00df\u00d2\u00c1\u00bcn\u00d5\u0012\u0091\u00f1.\u0099u3\"\u00d8\u001e\u00ed\u00f5\u00df^\u00fem\u0005\u00dc\u0098\u00e04u>\u00baXEF\u00af,k\u0095Z\u0004\u00af\u00d3\u00e8\u0001\u00a6R\u00f4\u00a5\u00e0\u000e\u00e2\u00b4\u00a8\u00a8/\u00f3\u00b3<\u00a9\u00ac\u0086\u0089{\u008b\u001b\u00d6\u00ff)\u00c4\u00e4\u00cb_gc@R\u0015\u00b1.\u00a8\u00c7\"@\u00b4\u0093I\u00d8J\u008a\u00b4\u00d8\u0090\n\u0097S\u00c5Vm}\u00bd\u009b\u0094\u00bd\u0018\u00c9H\u00ca?\u0099\b\u00d1A\u00acMi+o\u00ba\u008ft\u00b17\u0011\u0004\u0085a\u0088\u00ee)8\u00fa\u00f1i\\\u00cd\u008e\u001f\u000b\u0092Y)\u000bI\"\u0088N_\u00d1k\u000e\u00e38\u0017W\u00c0\u00e9713M\u00d0MI\u00b4R-8\u0085\u00e8\u00ce\t\u00d2=\u00a9\u009c\u00f4\u00c0QH:";
                var4_3 = "`\u00b4\u00ef\u00c4r\u00f1D8\u0014T\u00c4Q-[D\u00ce\u0094n\u008a\u00b1\u00dd<\u0016>J\u00df\u00eaf\u001c\u0006\u000fT\u0002\u00d8\u00a53\u0018\u00d9S\u0080\u00ef\u00e3\u00d9\u00db\u00e7\u0004\u0099\u00f3\u00cf\u0012\u00ab\u00a9\u007f\u0084%#x\u00fdF\u0012\u00d1\t\u00920w2v\u00fdq+m\u0005\u0087f\u0013\u009e\u009d\bK\u00a4\u008a\u00b7\u008c\u00b9\u009d\u00d3\u0014\u00fe\u00de|\u00f5\u0093W\u00e2a\u0085\u00e9g\u0005\u00ac\u00ae\u0097\u00b0\u00f8f{\u00cf\u0005z\u00b3\u00ac$j\u001e\u009d+ES\u00ca\u008a\\\u00f7Q\u008f\u0012\u008ab#\u0005\n\u00f0\u001a\u007fk\u00da\u000b\u00fa\u00b5t\u009f\u00d0\u0084w\u001c\u0010[\u00a0y\u00e7\u001a.\u00b0\u009a\u00b1\u0090\u0083\u0094V\u00b5,G\t\u00a4[gN'U}\u00a1\u0002\u0010:\u008fU\u0002\u009f\u0092\u0000\r\u00a7bA\u00ca\u000e~'>?\u00e2\u00ff\u00a2\u00c9;\u00d0\u00e7\u00d0W\u00ba\u0097\u00d7m~\u00d9\u0098\u00ae-\u00c9H\u0082=\u008a\u0015jc\u001e\u00af\u0099/Y\u00c0(\u0086i\u0093\u008ct\u0091\f|\u000ef\u00b7@\u00a6e\u00c2*\u00e01\u00df?%\u009b\u00d0\u008a\u00b1\u00ec9\u00b2\u00ce\u00b5\b\u00c7\u0002\u001bc\u00be#\u00db\u0080\f\u00fa\u00b3\u00acNU\u00e4H\u007f\u0087d\u0017\u000eF[/\u0098\u00dd\u00d3\u0096\u00981\u009d\u00a1^r\u00c2\u00c23)\u000f|\u00fd\u00cd\u0016\u00df\u001b{n\u0085mxH\u00fcY\u0086\u0014\u00f8,}\u00fe\u00e4t\u00daS\u00c1\b\u00b5ScS\u0007\u000b\u00a0s}\u0098\u00e7y\u0093I\u00ad\u0002\u0006\\@4\u00c1\u009dqY\u000e\u00c0\u00c4\u001f\u00bb\u00b5\u0081\u0080R\u00f0O\u00b83f^\u00b7\u00eb\u0099?\u00ec\u00cc.\u0085'N\u0002\u00bf?\u00bd\u001e\u00fex\u00afr\u00a7\u000b`S\u00ffR?g\u0005\u000f.f(\u0015\u0099\u00df\u00c0\u00c0\u00df]\u00f55\u000e\u00c1\u00e4\u0088\u0002\u00d2\u001f\u00d33]\u00a70<)\u009b\u00c1\u0085\u000e\u00d2!_\u00821!\u001e_\u00e7\u008e \u000bpZ\u00c9\u000e7_V\u008c\u00ef!c\u00e73u\u00b6\u0089\u0017\u00bc*x Y$\u00c4\u00fa\u0007\u00ef\u009e\u0001\u00fffBR\u0007Rw\u00d2\u00ae\u00fb\u0087\u00f7(\u00d1r\u0080Y\u00c2\u00a1\u00ab\u00b5\u00df\u0010\u00e9O:\r\u00d9\u00f8H\u0089`7cF\u00b3d\u00c3\u0080P\u00a8b\u00fcG\u00a1\u00d2\u00d2\f\u0018^(x\u0019\u000fYg\u00df\u00d2\u00c1\u00bcn\u00d5\u0012\u0091\u00f1.\u0099u3\"\u00d8\u001e\u00ed\u00f5\u00df^\u00fem\u0005\u00dc\u0098\u00e04u>\u00baXEF\u00af,k\u0095Z\u0004\u00af\u00d3\u00e8\u0001\u00a6R\u00f4\u00a5\u00e0\u000e\u00e2\u00b4\u00a8\u00a8/\u00f3\u00b3<\u00a9\u00ac\u0086\u0089{\u008b\u001b\u00d6\u00ff)\u00c4\u00e4\u00cb_gc@R\u0015\u00b1.\u00a8\u00c7\"@\u00b4\u0093I\u00d8J\u008a\u00b4\u00d8\u0090\n\u0097S\u00c5Vm}\u00bd\u009b\u0094\u00bd\u0018\u00c9H\u00ca?\u0099\b\u00d1A\u00acMi+o\u00ba\u008ft\u00b17\u0011\u0004\u0085a\u0088\u00ee)8\u00fa\u00f1i\\\u00cd\u008e\u001f\u000b\u0092Y)\u000bI\"\u0088N_\u00d1k\u000e\u00e38\u0017W\u00c0\u00e9713M\u00d0MI\u00b4R-8\u0085\u00e8\u00ce\t\u00d2=\u00a9\u009c\u00f4\u00c0QH:".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 108;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00bdo9\u00a3=\u00ec\u00daC\u00f9a\u007f/\u00b7\u00f1\u00cd\u00e7\u00cb\u00c6I\u00a40]tf\r\u008aKC\u008d\u0014\u00ef\u00a0^\u00d9\u00c2\u00a2\u00850\u007ff\u00eb8\u000f\u00d2 \u00aad\u008ei\u00e8";
                    var4_3 = "\u00bdo9\u00a3=\u00ec\u00daC\u00f9a\u007f/\u00b7\u00f1\u00cd\u00e7\u00cb\u00c6I\u00a40]tf\r\u008aKC\u008d\u0014\u00ef\u00a0^\u00d9\u00c2\u00a2\u00850\u007ff\u00eb8\u000f\u00d2 \u00aad\u008ei\u00e8".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 119;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 35;
                            break;
                        }
                        case 1: {
                            v15 = 95;
                            break;
                        }
                        case 2: {
                            v15 = 104;
                            break;
                        }
                        case 3: {
                            v15 = 121;
                            break;
                        }
                        case 4: {
                            v15 = 77;
                            break;
                        }
                        case 5: {
                            v15 = 15;
                            break;
                        }
                        default: {
                            v15 = 108;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x19C1) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 30;
                case 1 -> 158;
                case 2 -> 28;
                case 3 -> 176;
                case 4 -> 245;
                case 5 -> 125;
                case 6 -> 221;
                case 7 -> 169;
                case 8 -> 61;
                case 9 -> 138;
                case 10 -> 181;
                case 11 -> 134;
                case 12 -> 177;
                case 13 -> 161;
                case 14 -> 237;
                case 15 -> 100;
                case 16 -> 184;
                case 17 -> 131;
                case 18 -> 120;
                case 19 -> 35;
                case 20 -> 202;
                case 21 -> 220;
                case 22 -> 23;
                case 23 -> 204;
                case 24 -> 185;
                case 25 -> 70;
                case 26 -> 240;
                case 27 -> 43;
                case 28 -> 116;
                case 29 -> 63;
                case 30 -> 46;
                case 31 -> 233;
                case 32 -> 142;
                case 33 -> 162;
                case 34 -> 108;
                case 35 -> 103;
                case 36 -> 110;
                case 37 -> 92;
                case 38 -> 41;
                case 39 -> 119;
                case 40 -> 67;
                case 41 -> 234;
                case 42 -> 113;
                case 43 -> 12;
                case 44 -> 13;
                case 45 -> 127;
                case 46 -> 167;
                case 47 -> 140;
                case 48 -> 130;
                case 49 -> 38;
                case 50 -> 36;
                case 51 -> 21;
                case 52 -> 40;
                case 53 -> 7;
                case 54 -> 2;
                case 55 -> 34;
                case 56 -> 74;
                case 57 -> 209;
                case 58 -> 235;
                case 59 -> 17;
                case 60 -> 107;
                case 61 -> 206;
                case 62 -> 114;
                case 63 -> 189;
                case 64 -> 135;
                case 65 -> 117;
                case 66 -> 199;
                case 67 -> 18;
                case 68 -> 44;
                case 69 -> 123;
                case 70 -> 197;
                case 71 -> 101;
                case 72 -> 210;
                case 73 -> 45;
                case 74 -> 244;
                case 75 -> 62;
                case 76 -> 126;
                case 77 -> 128;
                case 78 -> 124;
                case 79 -> 139;
                case 80 -> 156;
                case 81 -> 173;
                case 82 -> 152;
                case 83 -> 37;
                case 84 -> 122;
                case 85 -> 172;
                case 86 -> 27;
                case 87 -> 168;
                case 88 -> 143;
                case 89 -> 136;
                case 90 -> 195;
                case 91 -> 164;
                case 92 -> 42;
                case 93 -> 79;
                case 94 -> 183;
                case 95 -> 71;
                case 96 -> 24;
                case 97 -> 121;
                case 98 -> 238;
                case 99 -> 179;
                case 100 -> 225;
                case 101 -> 98;
                case 102 -> 239;
                case 103 -> 231;
                case 104 -> 115;
                case 105 -> 203;
                case 106 -> 52;
                case 107 -> 22;
                case 108 -> 153;
                case 109 -> 4;
                case 110 -> 31;
                case 111 -> 223;
                case 112 -> 97;
                case 113 -> 160;
                case 114 -> 159;
                case 115 -> 99;
                case 116 -> 213;
                case 117 -> 145;
                case 118 -> 118;
                case 119 -> 1;
                case 120 -> 243;
                case 121 -> 80;
                case 122 -> 129;
                case 123 -> 72;
                case 124 -> 8;
                case 125 -> 249;
                case 126 -> 246;
                case 127 -> 166;
                case 128 -> 105;
                case 129 -> 16;
                case 130 -> 194;
                case 131 -> 141;
                case 132 -> 81;
                case 133 -> 193;
                case 134 -> 252;
                case 135 -> 64;
                case 136 -> 78;
                case 137 -> 55;
                case 138 -> 146;
                case 139 -> 201;
                case 140 -> 242;
                case 141 -> 212;
                case 142 -> 25;
                case 143 -> 180;
                case 144 -> 19;
                case 145 -> 49;
                case 146 -> 77;
                case 147 -> 58;
                case 148 -> 236;
                case 149 -> 50;
                case 150 -> 76;
                case 151 -> 91;
                case 152 -> 11;
                case 153 -> 254;
                case 154 -> 150;
                case 155 -> 6;
                case 156 -> 66;
                case 157 -> 56;
                case 158 -> 102;
                case 159 -> 84;
                case 160 -> 94;
                case 161 -> 171;
                case 162 -> 227;
                case 163 -> 232;
                case 164 -> 111;
                case 165 -> 9;
                case 166 -> 228;
                case 167 -> 224;
                case 168 -> 47;
                case 169 -> 230;
                case 170 -> 32;
                case 171 -> 48;
                case 172 -> 170;
                case 173 -> 93;
                case 174 -> 165;
                case 175 -> 151;
                case 176 -> 191;
                case 177 -> 248;
                case 178 -> 26;
                case 179 -> 14;
                case 180 -> 192;
                case 181 -> 132;
                case 182 -> 59;
                case 183 -> 65;
                case 184 -> 247;
                case 185 -> 133;
                case 186 -> 190;
                case 187 -> 200;
                case 188 -> 5;
                case 189 -> 251;
                case 190 -> 73;
                case 191 -> 222;
                case 192 -> 95;
                case 193 -> 178;
                case 194 -> 216;
                case 195 -> 148;
                case 196 -> 207;
                case 197 -> 175;
                case 198 -> 144;
                case 199 -> 188;
                case 200 -> 83;
                case 201 -> 253;
                case 202 -> 241;
                case 203 -> 54;
                case 204 -> 104;
                case 205 -> 68;
                case 206 -> 149;
                case 207 -> 226;
                case 208 -> 182;
                case 209 -> 250;
                case 210 -> 29;
                case 211 -> 155;
                case 212 -> 57;
                case 213 -> 229;
                case 214 -> 163;
                case 215 -> 218;
                case 216 -> 137;
                case 217 -> 86;
                case 218 -> 96;
                case 219 -> 69;
                case 220 -> 154;
                case 221 -> 0;
                case 222 -> 187;
                case 223 -> 208;
                case 224 -> 219;
                case 225 -> 15;
                case 226 -> 82;
                case 227 -> 20;
                case 228 -> 87;
                case 229 -> 198;
                case 230 -> 214;
                case 231 -> 90;
                case 232 -> 147;
                case 233 -> 215;
                case 234 -> 33;
                case 235 -> 106;
                case 236 -> 174;
                case 237 -> 109;
                case 238 -> 75;
                case 239 -> 89;
                case 240 -> 217;
                case 241 -> 157;
                case 242 -> 51;
                case 243 -> 255;
                case 244 -> 186;
                case 245 -> 10;
                case 246 -> 88;
                case 247 -> 196;
                case 248 -> 85;
                case 249 -> 211;
                case 250 -> 3;
                case 251 -> 39;
                case 252 -> 205;
                case 253 -> 112;
                case 254 -> 60;
                default -> 53;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 5192289562890L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(325840020 + (char)-22266, -325840020 + -((char)-16049), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 128741921084679L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.A();
                            try {
                                hANDLE2 = hANDLE;
                                if (!bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (!bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-276426630 - -((char)-7908), -276426630 - -((char)-11481), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-276426630 - -((char)-7909), 276426630 - (char)-22461, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-276426630 - -((char)-7910), -276426630 - -((char)-5476), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "l\u00d5\u00a2\u000e\f[\u00ae\u0010\u00107Q8?\u00e5\u00c6j\u00fa\u0019Pp[\u00dbi\u00e0/";
                    var4_3 = "l\u00d5\u00a2\u000e\f[\u00ae\u0010\u00107Q8?\u00e5\u00c6j\u00fa\u0019Pp[\u00dbi\u00e0/".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 75;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00ab\u00946J\u00825\u00ad \u00e1\u00b0\u00aab\u00f7\u00a9\u00b1\u00ed\u009b@=\u008cUu\u0081\u00d3\u0000\u0099\u00ee\u009344VS\u0019\u00ca\u00f8,\u0004m\u00c4\u0010\u00b9\u0011\u00cc\u00aeW\u0087\u008b\u0019\u001e\"\u00baus\u00b5\u0015\u00e9Z{\u009d";
                        var4_3 = "\u00ab\u00946J\u00825\u00ad \u00e1\u00b0\u00aab\u00f7\u00a9\u00b1\u00ed\u009b@=\u008cUu\u0081\u00d3\u0000\u0099\u00ee\u009344VS\u0019\u00ca\u00f8,\u0004m\u00c4\u0010\u00b9\u0011\u00cc\u00aeW\u0087\u008b\u0019\u001e\"\u00baus\u00b5\u0015\u00e9Z{\u009d".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 43;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 19;
                                break;
                            }
                            case 1: {
                                v15 = 103;
                                break;
                            }
                            case 2: {
                                v15 = 97;
                                break;
                            }
                            case 3: {
                                v15 = 91;
                                break;
                            }
                            case 4: {
                                v15 = 120;
                                break;
                            }
                            case 5: {
                                v15 = 123;
                                break;
                            }
                            default: {
                                v15 = 44;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFA490) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 224;
                    case 1 -> 234;
                    case 2 -> 5;
                    case 3 -> 122;
                    case 4 -> 30;
                    case 5 -> 17;
                    case 6 -> 248;
                    case 7 -> 21;
                    case 8 -> 49;
                    case 9 -> 176;
                    case 10 -> 85;
                    case 11 -> 103;
                    case 12 -> 79;
                    case 13 -> 101;
                    case 14 -> 87;
                    case 15 -> 133;
                    case 16 -> 131;
                    case 17 -> 192;
                    case 18 -> 42;
                    case 19 -> 197;
                    case 20 -> 1;
                    case 21 -> 217;
                    case 22 -> 149;
                    case 23 -> 243;
                    case 24 -> 69;
                    case 25 -> 143;
                    case 26 -> 110;
                    case 27 -> 126;
                    case 28 -> 165;
                    case 29 -> 141;
                    case 30 -> 255;
                    case 31 -> 129;
                    case 32 -> 15;
                    case 33 -> 252;
                    case 34 -> 216;
                    case 35 -> 105;
                    case 36 -> 213;
                    case 37 -> 48;
                    case 38 -> 32;
                    case 39 -> 173;
                    case 40 -> 190;
                    case 41 -> 142;
                    case 42 -> 67;
                    case 43 -> 50;
                    case 44 -> 100;
                    case 45 -> 47;
                    case 46 -> 241;
                    case 47 -> 134;
                    case 48 -> 102;
                    case 49 -> 46;
                    case 50 -> 73;
                    case 51 -> 23;
                    case 52 -> 211;
                    case 53 -> 225;
                    case 54 -> 195;
                    case 55 -> 96;
                    case 56 -> 16;
                    case 57 -> 215;
                    case 58 -> 107;
                    case 59 -> 7;
                    case 60 -> 152;
                    case 61 -> 171;
                    case 62 -> 86;
                    case 63 -> 182;
                    case 64 -> 22;
                    case 65 -> 130;
                    case 66 -> 222;
                    case 67 -> 135;
                    case 68 -> 65;
                    case 69 -> 36;
                    case 70 -> 198;
                    case 71 -> 4;
                    case 72 -> 242;
                    case 73 -> 115;
                    case 74 -> 231;
                    case 75 -> 146;
                    case 76 -> 66;
                    case 77 -> 166;
                    case 78 -> 148;
                    case 79 -> 159;
                    case 80 -> 92;
                    case 81 -> 168;
                    case 82 -> 2;
                    case 83 -> 237;
                    case 84 -> 56;
                    case 85 -> 19;
                    case 86 -> 91;
                    case 87 -> 29;
                    case 88 -> 83;
                    case 89 -> 205;
                    case 90 -> 55;
                    case 91 -> 189;
                    case 92 -> 238;
                    case 93 -> 228;
                    case 94 -> 20;
                    case 95 -> 162;
                    case 96 -> 212;
                    case 97 -> 118;
                    case 98 -> 28;
                    case 99 -> 177;
                    case 100 -> 108;
                    case 101 -> 201;
                    case 102 -> 164;
                    case 103 -> 119;
                    case 104 -> 227;
                    case 105 -> 221;
                    case 106 -> 193;
                    case 107 -> 196;
                    case 108 -> 106;
                    case 109 -> 84;
                    case 110 -> 181;
                    case 111 -> 158;
                    case 112 -> 154;
                    case 113 -> 90;
                    case 114 -> 104;
                    case 115 -> 247;
                    case 116 -> 206;
                    case 117 -> 137;
                    case 118 -> 62;
                    case 119 -> 223;
                    case 120 -> 170;
                    case 121 -> 64;
                    case 122 -> 253;
                    case 123 -> 112;
                    case 124 -> 81;
                    case 125 -> 111;
                    case 126 -> 82;
                    case 127 -> 11;
                    case 128 -> 199;
                    case 129 -> 74;
                    case 130 -> 34;
                    case 131 -> 93;
                    case 132 -> 80;
                    case 133 -> 77;
                    case 134 -> 178;
                    case 135 -> 251;
                    case 136 -> 95;
                    case 137 -> 39;
                    case 138 -> 51;
                    case 139 -> 132;
                    case 140 -> 109;
                    case 141 -> 232;
                    case 142 -> 26;
                    case 143 -> 236;
                    case 144 -> 63;
                    case 145 -> 151;
                    case 146 -> 180;
                    case 147 -> 97;
                    case 148 -> 188;
                    case 149 -> 98;
                    case 150 -> 172;
                    case 151 -> 179;
                    case 152 -> 61;
                    case 153 -> 0;
                    case 154 -> 41;
                    case 155 -> 78;
                    case 156 -> 239;
                    case 157 -> 33;
                    case 158 -> 45;
                    case 159 -> 124;
                    case 160 -> 174;
                    case 161 -> 191;
                    case 162 -> 254;
                    case 163 -> 3;
                    case 164 -> 44;
                    case 165 -> 35;
                    case 166 -> 139;
                    case 167 -> 155;
                    case 168 -> 24;
                    case 169 -> 140;
                    case 170 -> 88;
                    case 171 -> 194;
                    case 172 -> 12;
                    case 173 -> 71;
                    case 174 -> 10;
                    case 175 -> 161;
                    case 176 -> 121;
                    case 177 -> 250;
                    case 178 -> 209;
                    case 179 -> 150;
                    case 180 -> 245;
                    case 181 -> 147;
                    case 182 -> 210;
                    case 183 -> 40;
                    case 184 -> 207;
                    case 185 -> 53;
                    case 186 -> 59;
                    case 187 -> 31;
                    case 188 -> 220;
                    case 189 -> 136;
                    case 190 -> 169;
                    case 191 -> 203;
                    case 192 -> 52;
                    case 193 -> 94;
                    case 194 -> 58;
                    case 195 -> 144;
                    case 196 -> 235;
                    case 197 -> 14;
                    case 198 -> 6;
                    case 199 -> 37;
                    case 200 -> 113;
                    case 201 -> 13;
                    case 202 -> 70;
                    case 203 -> 233;
                    case 204 -> 183;
                    case 205 -> 240;
                    case 206 -> 25;
                    case 207 -> 72;
                    case 208 -> 89;
                    case 209 -> 153;
                    case 210 -> 219;
                    case 211 -> 57;
                    case 212 -> 54;
                    case 213 -> 184;
                    case 214 -> 123;
                    case 215 -> 114;
                    case 216 -> 160;
                    case 217 -> 230;
                    case 218 -> 208;
                    case 219 -> 157;
                    case 220 -> 185;
                    case 221 -> 117;
                    case 222 -> 246;
                    case 223 -> 229;
                    case 224 -> 202;
                    case 225 -> 68;
                    case 226 -> 145;
                    case 227 -> 156;
                    case 228 -> 120;
                    case 229 -> 200;
                    case 230 -> 175;
                    case 231 -> 127;
                    case 232 -> 204;
                    case 233 -> 186;
                    case 234 -> 116;
                    case 235 -> 8;
                    case 236 -> 244;
                    case 237 -> 9;
                    case 238 -> 125;
                    case 239 -> 76;
                    case 240 -> 249;
                    case 241 -> 138;
                    case 242 -> 167;
                    case 243 -> 38;
                    case 244 -> 60;
                    case 245 -> 99;
                    case 246 -> 18;
                    case 247 -> 226;
                    case 248 -> 128;
                    case 249 -> 43;
                    case 250 -> 75;
                    case 251 -> 27;
                    case 252 -> 214;
                    case 253 -> 218;
                    case 254 -> 187;
                    default -> 163;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 49056268411799L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\n]mW8!\u0005S\t\rW~]uc\u0018O\u0011";
                    var5_4 = "\n]mW8!\u0005S\t\rW~]uc\u0018O\u0011".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 74;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 43;
                                    break;
                                }
                                case 1: {
                                    v11 = 114;
                                    break;
                                }
                                case 2: {
                                    v11 = 85;
                                    break;
                                }
                                case 3: {
                                    v11 = 115;
                                    break;
                                }
                                case 4: {
                                    v11 = 23;
                                    break;
                                }
                                case 5: {
                                    v11 = 7;
                                    break;
                                }
                                default: {
                                    v11 = 124;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 102861725125415L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\fA\b]\u00034b\u0004\n_\u0004G\n\u0006@\u000fG\u000f6z,A\u0006\t\u0006@\u000fG\u000f6z K\r\u0001F\u0012J\u0005;` L\u0015@\u00042";
                    var5_4 = "\fA\b]\u00034b\u0004\n_\u0004G\n\u0006@\u000fG\u000f6z,A\u0006\t\u0006@\u000fG\u000f6z K\r\u0001F\u0012J\u0005;` L\u0015@\u00042".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 7;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "_\u001aW\u0003Zb0\u0006_\u001aW\u0003Vh";
                        var5_4 = "_\u001aW\u0003Zb0\u0006_\u001aW\u0003Vh".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 94;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 66;
                                break;
                            }
                            case 1: {
                                v15 = 40;
                                break;
                            }
                            case 2: {
                                v15 = 102;
                                break;
                            }
                            case 3: {
                                v15 = 46;
                                break;
                            }
                            case 4: {
                                v15 = 109;
                                break;
                            }
                            case 5: {
                                v15 = 82;
                                break;
                            }
                            default: {
                                v15 = 9;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 136258547153556L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-709612980 + -((char)-15369), 709612980 + (char)-13567, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 44224030164951L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00c166hu\u0003\u00ff\u0091E\u0005\u00c8\u000f1\u008bv\r\u001c4\u009d\u00a6\u0016\u001e\u0014y\u00cc\u00a3\u00f7\u0010\u00b3\u0010\u00cd\u00a1`\u00ff\u0096\u00a0/\u0093bz\u00c1f\u0093\u00e5Lm\u0005K\u00fcA\u00f5x3\u00e7\u00e1\u00c5!\u00f7?3t\u009c{\u0095o\u00df\u0095\u00e9|M[\u00fa\u009aQ<\u001a\"\u00ea\u001au\u00f2\u0002 \u000f\u0003pi\u0088\u009c\u00af69\u008a\u00c9\u00a5\u008e8\u00b2\u00f6\b\u00fd\u00b4\u0019!";
                    var4_3 = "\u00c166hu\u0003\u00ff\u0091E\u0005\u00c8\u000f1\u008bv\r\u001c4\u009d\u00a6\u0016\u001e\u0014y\u00cc\u00a3\u00f7\u0010\u00b3\u0010\u00cd\u00a1`\u00ff\u0096\u00a0/\u0093bz\u00c1f\u0093\u00e5Lm\u0005K\u00fcA\u00f5x3\u00e7\u00e1\u00c5!\u00f7?3t\u009c{\u0095o\u00df\u0095\u00e9|M[\u00fa\u009aQ<\u001a\"\u00ea\u001au\u00f2\u0002 \u000f\u0003pi\u0088\u009c\u00af69\u008a\u00c9\u00a5\u008e8\u00b2\u00f6\b\u00fd\u00b4\u0019!".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 50;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00a8\u001bx\u001c!hm>\u009e{\u00ea\u00f2B\u00c3\u00c2\u001dL\u00f3\f\u00e44\u0098\u00a54\u00e9<\u0012\u0012fS\u00dfs\u00e7\u00afM\u00ed\u001ao\u00fcC,V\u0084sS\u008c\u00e9\u0085\u00e1\u0085o\u00f3\u00f4FQ\u008a\u00b4=+k \u00af\u009f\u00d4\\i\u00ad\u00c6\u00b8b\u000b\u00f6]O@\u00e4\u00b2\u009c\u00feb\u000f\u00b6\u00d7J\u00a02\u00fc\tS\u000f\u00e4\u00f4\u00b8";
                        var4_3 = "\u00a8\u001bx\u001c!hm>\u009e{\u00ea\u00f2B\u00c3\u00c2\u001dL\u00f3\f\u00e44\u0098\u00a54\u00e9<\u0012\u0012fS\u00dfs\u00e7\u00afM\u00ed\u001ao\u00fcC,V\u0084sS\u008c\u00e9\u0085\u00e1\u0085o\u00f3\u00f4FQ\u008a\u00b4=+k \u00af\u009f\u00d4\\i\u00ad\u00c6\u00b8b\u000b\u00f6]O@\u00e4\u00b2\u009c\u00feb\u000f\u00b6\u00d7J\u00a02\u00fc\tS\u000f\u00e4\u00f4\u00b8".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 109;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 64;
                                break;
                            }
                            case 1: {
                                v15 = 104;
                                break;
                            }
                            case 2: {
                                v15 = 90;
                                break;
                            }
                            case 3: {
                                v15 = 50;
                                break;
                            }
                            case 4: {
                                v15 = 49;
                                break;
                            }
                            case 5: {
                                v15 = 126;
                                break;
                            }
                            default: {
                                v15 = 120;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF9CC1) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 230;
                    case 1 -> 93;
                    case 2 -> 146;
                    case 3 -> 19;
                    case 4 -> 84;
                    case 5 -> 213;
                    case 6 -> 244;
                    case 7 -> 65;
                    case 8 -> 193;
                    case 9 -> 178;
                    case 10 -> 46;
                    case 11 -> 105;
                    case 12 -> 240;
                    case 13 -> 117;
                    case 14 -> 122;
                    case 15 -> 214;
                    case 16 -> 10;
                    case 17 -> 41;
                    case 18 -> 175;
                    case 19 -> 218;
                    case 20 -> 126;
                    case 21 -> 154;
                    case 22 -> 194;
                    case 23 -> 116;
                    case 24 -> 121;
                    case 25 -> 80;
                    case 26 -> 147;
                    case 27 -> 111;
                    case 28 -> 99;
                    case 29 -> 109;
                    case 30 -> 28;
                    case 31 -> 225;
                    case 32 -> 182;
                    case 33 -> 247;
                    case 34 -> 205;
                    case 35 -> 55;
                    case 36 -> 59;
                    case 37 -> 188;
                    case 38 -> 171;
                    case 39 -> 128;
                    case 40 -> 143;
                    case 41 -> 88;
                    case 42 -> 209;
                    case 43 -> 27;
                    case 44 -> 129;
                    case 45 -> 66;
                    case 46 -> 216;
                    case 47 -> 142;
                    case 48 -> 158;
                    case 49 -> 17;
                    case 50 -> 174;
                    case 51 -> 9;
                    case 52 -> 242;
                    case 53 -> 92;
                    case 54 -> 190;
                    case 55 -> 223;
                    case 56 -> 49;
                    case 57 -> 101;
                    case 58 -> 26;
                    case 59 -> 239;
                    case 60 -> 85;
                    case 61 -> 3;
                    case 62 -> 235;
                    case 63 -> 224;
                    case 64 -> 124;
                    case 65 -> 72;
                    case 66 -> 203;
                    case 67 -> 22;
                    case 68 -> 40;
                    case 69 -> 42;
                    case 70 -> 211;
                    case 71 -> 103;
                    case 72 -> 167;
                    case 73 -> 183;
                    case 74 -> 199;
                    case 75 -> 2;
                    case 76 -> 11;
                    case 77 -> 71;
                    case 78 -> 96;
                    case 79 -> 4;
                    case 80 -> 151;
                    case 81 -> 234;
                    case 82 -> 36;
                    case 83 -> 130;
                    case 84 -> 100;
                    case 85 -> 141;
                    case 86 -> 241;
                    case 87 -> 98;
                    case 88 -> 204;
                    case 89 -> 120;
                    case 90 -> 219;
                    case 91 -> 106;
                    case 92 -> 94;
                    case 93 -> 229;
                    case 94 -> 208;
                    case 95 -> 78;
                    case 96 -> 69;
                    case 97 -> 14;
                    case 98 -> 172;
                    case 99 -> 104;
                    case 100 -> 52;
                    case 101 -> 125;
                    case 102 -> 31;
                    case 103 -> 114;
                    case 104 -> 232;
                    case 105 -> 165;
                    case 106 -> 74;
                    case 107 -> 60;
                    case 108 -> 197;
                    case 109 -> 212;
                    case 110 -> 198;
                    case 111 -> 254;
                    case 112 -> 20;
                    case 113 -> 210;
                    case 114 -> 248;
                    case 115 -> 13;
                    case 116 -> 16;
                    case 117 -> 70;
                    case 118 -> 177;
                    case 119 -> 189;
                    case 120 -> 119;
                    case 121 -> 1;
                    case 122 -> 58;
                    case 123 -> 44;
                    case 124 -> 37;
                    case 125 -> 166;
                    case 126 -> 30;
                    case 127 -> 77;
                    case 128 -> 64;
                    case 129 -> 132;
                    case 130 -> 113;
                    case 131 -> 200;
                    case 132 -> 185;
                    case 133 -> 207;
                    case 134 -> 176;
                    case 135 -> 246;
                    case 136 -> 163;
                    case 137 -> 139;
                    case 138 -> 7;
                    case 139 -> 108;
                    case 140 -> 181;
                    case 141 -> 34;
                    case 142 -> 180;
                    case 143 -> 107;
                    case 144 -> 81;
                    case 145 -> 184;
                    case 146 -> 233;
                    case 147 -> 68;
                    case 148 -> 110;
                    case 149 -> 145;
                    case 150 -> 51;
                    case 151 -> 196;
                    case 152 -> 24;
                    case 153 -> 236;
                    case 154 -> 179;
                    case 155 -> 217;
                    case 156 -> 21;
                    case 157 -> 160;
                    case 158 -> 228;
                    case 159 -> 237;
                    case 160 -> 215;
                    case 161 -> 192;
                    case 162 -> 137;
                    case 163 -> 255;
                    case 164 -> 82;
                    case 165 -> 159;
                    case 166 -> 54;
                    case 167 -> 57;
                    case 168 -> 23;
                    case 169 -> 220;
                    case 170 -> 95;
                    case 171 -> 63;
                    case 172 -> 32;
                    case 173 -> 102;
                    case 174 -> 201;
                    case 175 -> 227;
                    case 176 -> 155;
                    case 177 -> 73;
                    case 178 -> 250;
                    case 179 -> 79;
                    case 180 -> 33;
                    case 181 -> 252;
                    case 182 -> 195;
                    case 183 -> 149;
                    case 184 -> 56;
                    case 185 -> 221;
                    case 186 -> 45;
                    case 187 -> 8;
                    case 188 -> 89;
                    case 189 -> 131;
                    case 190 -> 157;
                    case 191 -> 191;
                    case 192 -> 115;
                    case 193 -> 226;
                    case 194 -> 15;
                    case 195 -> 206;
                    case 196 -> 153;
                    case 197 -> 38;
                    case 198 -> 253;
                    case 199 -> 5;
                    case 200 -> 161;
                    case 201 -> 134;
                    case 202 -> 123;
                    case 203 -> 53;
                    case 204 -> 169;
                    case 205 -> 90;
                    case 206 -> 62;
                    case 207 -> 187;
                    case 208 -> 238;
                    case 209 -> 202;
                    case 210 -> 133;
                    case 211 -> 29;
                    case 212 -> 87;
                    case 213 -> 222;
                    case 214 -> 48;
                    case 215 -> 76;
                    case 216 -> 249;
                    case 217 -> 150;
                    case 218 -> 231;
                    case 219 -> 112;
                    case 220 -> 251;
                    case 221 -> 50;
                    case 222 -> 47;
                    case 223 -> 135;
                    case 224 -> 6;
                    case 225 -> 97;
                    case 226 -> 245;
                    case 227 -> 152;
                    case 228 -> 12;
                    case 229 -> 138;
                    case 230 -> 162;
                    case 231 -> 61;
                    case 232 -> 173;
                    case 233 -> 243;
                    case 234 -> 186;
                    case 235 -> 25;
                    case 236 -> 148;
                    case 237 -> 75;
                    case 238 -> 168;
                    case 239 -> 127;
                    case 240 -> 136;
                    case 241 -> 164;
                    case 242 -> 39;
                    case 243 -> 0;
                    case 244 -> 86;
                    case 245 -> 170;
                    case 246 -> 91;
                    case 247 -> 83;
                    case 248 -> 144;
                    case 249 -> 140;
                    case 250 -> 67;
                    case 251 -> 43;
                    case 252 -> 18;
                    case 253 -> 156;
                    case 254 -> 118;
                    default -> 35;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 133095981638600L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-759943860 - -((char)-16570), 759943860 - (char)-21141, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 128059787711359L;
                    boolean bl = SshAgentIpcService.A();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1042792920 + 23116, 1042792920 + (char)-32683, (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (!bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 88009412077584L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00e0S\u0002\u00d3n\u0003v\u0004\u0086";
                var4_3 = "\u00e0S\u0002\u00d3n\u0003v\u0004\u0086".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 11;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 75;
                                break;
                            }
                            case 1: {
                                v11 = 57;
                                break;
                            }
                            case 2: {
                                v11 = 53;
                                break;
                            }
                            case 3: {
                                v11 = 17;
                                break;
                            }
                            case 4: {
                                v11 = 95;
                                break;
                            }
                            case 5: {
                                v11 = 31;
                                break;
                            }
                            default: {
                                v11 = 1;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xF5A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 179;
                    case 1 -> 217;
                    case 2 -> 221;
                    case 3 -> 20;
                    case 4 -> 67;
                    case 5 -> 229;
                    case 6 -> 72;
                    case 7 -> 33;
                    case 8 -> 155;
                    case 9 -> 88;
                    case 10 -> 56;
                    case 11 -> 90;
                    case 12 -> 175;
                    case 13 -> 7;
                    case 14 -> 251;
                    case 15 -> 207;
                    case 16 -> 125;
                    case 17 -> 114;
                    case 18 -> 132;
                    case 19 -> 46;
                    case 20 -> 199;
                    case 21 -> 157;
                    case 22 -> 244;
                    case 23 -> 118;
                    case 24 -> 106;
                    case 25 -> 243;
                    case 26 -> 54;
                    case 27 -> 105;
                    case 28 -> 4;
                    case 29 -> 165;
                    case 30 -> 222;
                    case 31 -> 160;
                    case 32 -> 69;
                    case 33 -> 127;
                    case 34 -> 41;
                    case 35 -> 1;
                    case 36 -> 21;
                    case 37 -> 143;
                    case 38 -> 120;
                    case 39 -> 57;
                    case 40 -> 228;
                    case 41 -> 214;
                    case 42 -> 52;
                    case 43 -> 130;
                    case 44 -> 11;
                    case 45 -> 98;
                    case 46 -> 81;
                    case 47 -> 117;
                    case 48 -> 15;
                    case 49 -> 169;
                    case 50 -> 134;
                    case 51 -> 50;
                    case 52 -> 64;
                    case 53 -> 121;
                    case 54 -> 13;
                    case 55 -> 166;
                    case 56 -> 115;
                    case 57 -> 238;
                    case 58 -> 87;
                    case 59 -> 59;
                    case 60 -> 150;
                    case 61 -> 79;
                    case 62 -> 39;
                    case 63 -> 12;
                    case 64 -> 37;
                    case 65 -> 82;
                    case 66 -> 14;
                    case 67 -> 254;
                    case 68 -> 247;
                    case 69 -> 188;
                    case 70 -> 107;
                    case 71 -> 194;
                    case 72 -> 62;
                    case 73 -> 31;
                    case 74 -> 220;
                    case 75 -> 205;
                    case 76 -> 38;
                    case 77 -> 218;
                    case 78 -> 110;
                    case 79 -> 233;
                    case 80 -> 200;
                    case 81 -> 74;
                    case 82 -> 91;
                    case 83 -> 92;
                    case 84 -> 197;
                    case 85 -> 55;
                    case 86 -> 3;
                    case 87 -> 209;
                    case 88 -> 159;
                    case 89 -> 208;
                    case 90 -> 97;
                    case 91 -> 223;
                    case 92 -> 144;
                    case 93 -> 190;
                    case 94 -> 65;
                    case 95 -> 248;
                    case 96 -> 226;
                    case 97 -> 102;
                    case 98 -> 219;
                    case 99 -> 211;
                    case 100 -> 182;
                    case 101 -> 131;
                    case 102 -> 129;
                    case 103 -> 51;
                    case 104 -> 16;
                    case 105 -> 60;
                    case 106 -> 184;
                    case 107 -> 189;
                    case 108 -> 96;
                    case 109 -> 45;
                    case 110 -> 153;
                    case 111 -> 49;
                    case 112 -> 44;
                    case 113 -> 136;
                    case 114 -> 103;
                    case 115 -> 133;
                    case 116 -> 142;
                    case 117 -> 104;
                    case 118 -> 24;
                    case 119 -> 77;
                    case 120 -> 122;
                    case 121 -> 30;
                    case 122 -> 123;
                    case 123 -> 83;
                    case 124 -> 128;
                    case 125 -> 108;
                    case 126 -> 241;
                    case 127 -> 250;
                    case 128 -> 111;
                    case 129 -> 174;
                    case 130 -> 216;
                    case 131 -> 224;
                    case 132 -> 0;
                    case 133 -> 167;
                    case 134 -> 204;
                    case 135 -> 28;
                    case 136 -> 78;
                    case 137 -> 137;
                    case 138 -> 140;
                    case 139 -> 93;
                    case 140 -> 252;
                    case 141 -> 236;
                    case 142 -> 8;
                    case 143 -> 86;
                    case 144 -> 227;
                    case 145 -> 186;
                    case 146 -> 171;
                    case 147 -> 68;
                    case 148 -> 232;
                    case 149 -> 32;
                    case 150 -> 237;
                    case 151 -> 70;
                    case 152 -> 183;
                    case 153 -> 255;
                    case 154 -> 177;
                    case 155 -> 215;
                    case 156 -> 25;
                    case 157 -> 191;
                    case 158 -> 34;
                    case 159 -> 101;
                    case 160 -> 192;
                    case 161 -> 27;
                    case 162 -> 202;
                    case 163 -> 170;
                    case 164 -> 75;
                    case 165 -> 201;
                    case 166 -> 40;
                    case 167 -> 249;
                    case 168 -> 17;
                    case 169 -> 94;
                    case 170 -> 156;
                    case 171 -> 35;
                    case 172 -> 145;
                    case 173 -> 113;
                    case 174 -> 187;
                    case 175 -> 231;
                    case 176 -> 47;
                    case 177 -> 206;
                    case 178 -> 85;
                    case 179 -> 76;
                    case 180 -> 203;
                    case 181 -> 58;
                    case 182 -> 71;
                    case 183 -> 100;
                    case 184 -> 210;
                    case 185 -> 172;
                    case 186 -> 148;
                    case 187 -> 235;
                    case 188 -> 124;
                    case 189 -> 80;
                    case 190 -> 176;
                    case 191 -> 48;
                    case 192 -> 26;
                    case 193 -> 146;
                    case 194 -> 135;
                    case 195 -> 185;
                    case 196 -> 141;
                    case 197 -> 84;
                    case 198 -> 178;
                    case 199 -> 95;
                    case 200 -> 180;
                    case 201 -> 6;
                    case 202 -> 149;
                    case 203 -> 151;
                    case 204 -> 139;
                    case 205 -> 246;
                    case 206 -> 29;
                    case 207 -> 163;
                    case 208 -> 5;
                    case 209 -> 112;
                    case 210 -> 158;
                    case 211 -> 66;
                    case 212 -> 73;
                    case 213 -> 164;
                    case 214 -> 63;
                    case 215 -> 2;
                    case 216 -> 147;
                    case 217 -> 162;
                    case 218 -> 10;
                    case 219 -> 138;
                    case 220 -> 230;
                    case 221 -> 22;
                    case 222 -> 9;
                    case 223 -> 225;
                    case 224 -> 126;
                    case 225 -> 195;
                    case 226 -> 239;
                    case 227 -> 161;
                    case 228 -> 193;
                    case 229 -> 109;
                    case 230 -> 242;
                    case 231 -> 152;
                    case 232 -> 43;
                    case 233 -> 173;
                    case 234 -> 42;
                    case 235 -> 253;
                    case 236 -> 89;
                    case 237 -> 19;
                    case 238 -> 198;
                    case 239 -> 212;
                    case 240 -> 99;
                    case 241 -> 181;
                    case 242 -> 61;
                    case 243 -> 116;
                    case 244 -> 240;
                    case 245 -> 18;
                    case 246 -> 119;
                    case 247 -> 213;
                    case 248 -> 53;
                    case 249 -> 196;
                    case 250 -> 36;
                    case 251 -> 154;
                    case 252 -> 23;
                    case 253 -> 234;
                    case 254 -> 245;
                    default -> 168;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

