/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.celery.ref;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/pro/celery/ref/CeleryScheduleClassTaskQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "classToFix", "Lcom/jetbrains/python/psi/PyClass;", "<init>", "(Lcom/jetbrains/python/psi/PyClass;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "intellij.python"})
@ApiStatus.Internal
public final class CeleryScheduleClassTaskQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final PyClass classToFix;

    public CeleryScheduleClassTaskQuickFix(@NotNull PyClass classToFix) {
        Intrinsics.checkNotNullParameter((Object)classToFix, (String)"classToFix");
        this.classToFix = classToFix;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (!Registry.Companion.is("django.celery.enabled")) {
            return;
        }
        PyClass classToFixWritable = (PyClass)updater.getWritable((PsiElement)this.classToFix);
        PyPsiRefactoringUtil.addSuperClassExpressions((Project)project, (PyClass)classToFixWritable, (Collection)CollectionsKt.listOf((Object)"Task"), null);
        AddImportHelper.addOrUpdateFromImportStatement((PsiFile)classToFixWritable.getContainingFile(), (String)"celery", (String)"Task", null, (AddImportHelper.ImportPriority)AddImportHelper.ImportPriority.THIRD_PARTY, null);
        updater.moveCaretTo((PsiElement)classToFixWritable);
    }

    @NotNull
    public String getFamilyName() {
        String string = PythonProBundle.message((String)"celery.unregistered-task-class.quickfix");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

