/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.template.lang.core.templateLanguages;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.template.lang.core.templateLanguages.TemplateFileReference;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateFileReferenceSet
extends FileReferenceSet {
    private final String mySeparatorString;

    public TemplateFileReferenceSet(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(0);
        }
        this(TemplateFileReferenceSet.str(element), element, provider);
    }

    public TemplateFileReferenceSet(String text, @NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(1);
        }
        super(text, element, TemplateFileReferenceSet.detectShift(element, text), provider, element.getContainingFile().getViewProvider().getVirtualFile().isCaseSensitive());
        this.mySeparatorString = TemplateFileReferenceSet.detectSeparator(element);
        this.reparse();
    }

    private static String str(@NotNull PsiElement element) {
        if (element == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(2);
        }
        return PyStringLiteralCoreUtil.stripQuotesAroundValue((String)element.getText());
    }

    public static int detectShift(PsiElement element, String text) {
        String elementText = element.getText();
        int from = 0;
        Pair quotes = PyStringLiteralCoreUtil.getQuotes((String)elementText);
        if (quotes != null) {
            from = ((String)quotes.first).length();
        }
        return elementText.indexOf(text, from);
    }

    public static String detectSeparator(PsiElement element) {
        String winSeparator = TemplateFileReferenceSet.isRawString(element.getText()) ? "\\" : "\\\\";
        return TemplateFileReferenceSet.str(element).contains(winSeparator) ? winSeparator : "/";
    }

    public String getSeparatorString() {
        if (this.mySeparatorString == null) {
            return super.getSeparatorString();
        }
        return this.mySeparatorString;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        ArrayList<PsiFileSystemItem> contexts = new ArrayList<PsiFileSystemItem>();
        if (this.getPathString().startsWith("/") || this.getPathString().startsWith("\\")) {
            ArrayList<PsiFileSystemItem> arrayList = contexts;
            if (arrayList == null) {
                TemplateFileReferenceSet.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module != null) {
            List<VirtualFile> templatesFolders = this.getRoots(module);
            for (VirtualFile folder : templatesFolders) {
                PsiFileSystemItem directory = this.getPsiDirectory(module, folder);
                if (directory == null) continue;
                contexts.add(directory);
            }
        }
        ArrayList<PsiFileSystemItem> arrayList = contexts;
        if (arrayList == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    protected PsiFileSystemItem getPsiDirectory(@NotNull Module module, @NotNull VirtualFile folder) {
        if (module == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(5);
        }
        if (folder == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(6);
        }
        return PsiManager.getInstance((Project)module.getProject()).findDirectory(folder);
    }

    protected List<VirtualFile> getRoots(Module module) {
        return TemplatesService.getInstance(module).getTemplateFolders();
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new TemplateFileReference(this, range, index, text);
    }

    private static boolean isRawString(String text) {
        text = StringUtil.toLowerCase((String)text);
        String text1 = StringUtil.toLowerCase((String)(text = StringUtil.trimStart((String)text, (String)"u")));
        return StringUtil.startsWith((CharSequence)text1, (CharSequence)"r\"") && StringUtil.endsWith((CharSequence)text1, (CharSequence)"\"") || StringUtil.startsWith((CharSequence)text1, (CharSequence)"r'") && StringUtil.endsWith((CharSequence)text1, (CharSequence)"'");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/template/lang/core/templateLanguages/TemplateFileReferenceSet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/template/lang/core/templateLanguages/TemplateFileReferenceSet";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "str";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPsiDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

