/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\u0012\u0010\n\u001a\u00020\t*\u00020\t2\u0006\u0010\u000b\u001a\u00020\b\u001a\u0012\u0010\f\u001a\u00020\t*\u00020\t2\u0006\u0010\u000b\u001a\u00020\r\u001a\u0012\u0010\n\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u0012\u0010\f\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0003\u001a(\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0002\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"generateRSAKeypair", "Ljava/security/KeyPair;", "generateAESKey", "Ljavax/crypto/SecretKey;", "AES_TRANSFORMATION", "", "RSA_TRANSFORMATION", "decodeRSAKey", "Ljava/security/PublicKey;", "", "encrypt", "key", "decrypt", "Ljava/security/PrivateKey;", "Lcom/intellij/credentialStore/Credentials;", "transform", "mode", "", "transformation", "Ljava/security/Key;", "data", "intellij.platform.credentialStore.common"})
@SourceDebugExtension(value={"SMAP\ncrypto.kt\nKotlin\n*S Kotlin\n*F\n+ 1 crypto.kt\ncom/intellij/credentialStore/CryptoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class CryptoKt {
    @NotNull
    private static final String AES_TRANSFORMATION = "AES/ECB/PKCS5Padding";
    @NotNull
    private static final String RSA_TRANSFORMATION = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

    @NotNull
    public static final KeyPair generateRSAKeypair() {
        KeyPairGenerator keyPairGenerator;
        KeyPairGenerator $this$generateRSAKeypair_u24lambda_u240 = keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        boolean bl = false;
        $this$generateRSAKeypair_u24lambda_u240.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"generateKeyPair(...)");
        return keyPair;
    }

    @NotNull
    public static final SecretKey generateAESKey() {
        KeyGenerator keyGenerator;
        KeyGenerator $this$generateAESKey_u24lambda_u240 = keyGenerator = KeyGenerator.getInstance("AES");
        boolean bl = false;
        $this$generateAESKey_u24lambda_u240.init(256);
        SecretKey secretKey = keyGenerator.generateKey();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"generateKey(...)");
        return secretKey;
    }

    @NotNull
    public static final PublicKey decodeRSAKey(@NotNull byte[] $this$decodeRSAKey) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeRSAKey, (String)"<this>");
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec($this$decodeRSAKey));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
        return publicKey;
    }

    @NotNull
    public static final byte[] encrypt(@NotNull byte[] $this$encrypt, @NotNull PublicKey key) {
        Intrinsics.checkNotNullParameter((Object)$this$encrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return CryptoKt.transform(1, RSA_TRANSFORMATION, key, $this$encrypt);
    }

    @NotNull
    public static final byte[] decrypt(@NotNull byte[] $this$decrypt, @NotNull PrivateKey key) {
        Intrinsics.checkNotNullParameter((Object)$this$decrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return CryptoKt.transform(2, RSA_TRANSFORMATION, key, $this$decrypt);
    }

    @NotNull
    public static final Credentials encrypt(@NotNull Credentials $this$encrypt, @NotNull SecretKey key) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$encrypt, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                object = $this$encrypt.getPassword();
                if (object == null) break block2;
                byte[] byArray = OneTimeString.toByteArray$default((OneTimeString)object, (boolean)false, (int)1, null);
                object = byArray;
                if (byArray != null) break block3;
            }
            return $this$encrypt;
        }
        Object data = object;
        byte[] encrypted = CryptoKt.transform(1, AES_TRANSFORMATION, key, (byte[])data);
        return new Credentials($this$encrypt.getUserName(), Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])encrypted, (int)0, (int)0, (int)6, null));
    }

    @NotNull
    public static final Credentials decrypt(@NotNull Credentials $this$decrypt, @NotNull SecretKey key) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$decrypt, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                object = $this$decrypt.getPassword();
                if (object == null || (object = object.toString()) == null) break block2;
                Object object2 = object;
                Base64.Default default_ = Base64.Default;
                CharSequence p0 = (CharSequence)object2;
                boolean bl = false;
                byte[] byArray = Base64.decode$default((Base64)((Base64)default_), (CharSequence)p0, (int)0, (int)0, (int)6, null);
                object = byArray;
                if (byArray != null) break block3;
            }
            return $this$decrypt;
        }
        Object data = object;
        byte[] decrypted = CryptoKt.transform(2, AES_TRANSFORMATION, key, (byte[])data);
        return new Credentials($this$decrypt.getUserName(), decrypted);
    }

    private static final byte[] transform(int mode, String transformation, Key key, byte[] data) {
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(mode, key);
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }
}

