/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.dtrace;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.LineByLineParser;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.ProfilerProcessBase;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.AttachCanceledException;
import com.intellij.profiler.api.AttachFailedException;
import com.intellij.profiler.api.AttachProfilerUtilsKt;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.NewCallTreeOnlyProfilerData;
import com.intellij.profiler.api.ParsingData;
import com.intellij.profiler.api.ProfilerDumpWriter;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.dtrace.DTraceProfilerProcessBase;
import com.intellij.profiler.dtrace.DTraceProfilerProcessBaseKt;
import com.intellij.profiler.dtrace.DTraceScript;
import com.intellij.profiler.dtrace.DTraceScriptKt;
import com.intellij.profiler.dtrace.FullDumpParser;
import com.intellij.profiler.sudo.SudoProcessHandler;
import com.intellij.util.concurrency.Semaphore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B)\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H$J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aH$J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u001a2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aH\u0014J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u001fH\u0014J\b\u0010$\u001a\u00020\u001fH\u0014J\b\u0010%\u001a\u00020\u001fH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/profiler/dtrace/DTraceProfilerProcessBase;", "Lcom/intellij/profiler/ProfilerProcessBase;", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "project", "Lcom/intellij/openapi/project/Project;", "targetProcess", "attachedTimestamp", "", "dtraceProcessHandler", "Lcom/intellij/profiler/sudo/SudoProcessHandler;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/AttachableTargetProcess;JLcom/intellij/profiler/sudo/SudoProcessHandler;)V", "getAttachedTimestamp", "()J", "profilerConfiguration", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "getProfilerConfiguration", "()Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "dumpParser", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/profiler/dtrace/FullDumpParser;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "createDumpParser", "createProfilerData", "Lcom/intellij/profiler/api/NewCallTreeOnlyProfilerData;", "builder", "Lcom/intellij/profiler/DummyCallTreeBuilder;", "createDumpWriter", "Lcom/intellij/profiler/api/ProfilerDumpWriter;", "data", "onDTraceStopped", "", "postProcessData", "doStop", "", "onTargetProcessTerminated", "onTerminateCalled", "dispose", "Companion", "intellij.profiler.common"})
public abstract class DTraceProfilerProcessBase
extends ProfilerProcessBase<AttachableTargetProcess> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long attachedTimestamp;
    @NotNull
    private final SudoProcessHandler dtraceProcessHandler;
    @NotNull
    private final ProfilerConfigurationState profilerConfiguration;
    @NotNull
    private final AtomicReference<FullDumpParser<BaseCallStackElement>> dumpParser;

    protected DTraceProfilerProcessBase(@NotNull Project project, final @NotNull AttachableTargetProcess targetProcess, long attachedTimestamp, @NotNull SudoProcessHandler dtraceProcessHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)dtraceProcessHandler), (String)"dtraceProcessHandler");
        super(project, (ProfilerTargetProcess)targetProcess);
        this.attachedTimestamp = attachedTimestamp;
        this.dtraceProcessHandler = dtraceProcessHandler;
        this.dtraceProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private BufferedWriter currentProcessRawDumpFileWriter;

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    this.getDumpReadIndicator().checkCanceled();
                    if (this.getState() == Attached.INSTANCE && ProcessOutputType.isStdout(outputType)) {
                        String string = event.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"DTrace stopped", (boolean)false, (int)2, null)) {
                            this.onDTraceStopped();
                            if (UtilsKt.keepTempProfilerFiles()) {
                                File file = UtilsKt.dtraceOutputFile(targetProcess.getPid());
                                1 $this$thisLogger$iv = this;
                                boolean $i$f$thisLogger = false;
                                Logger logger = Logger.getInstance(1.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                logger.info("DTrace dump will be written to " + file.getAbsolutePath());
                                this.currentProcessRawDumpFileWriter = new BufferedWriter(new FileWriter(file));
                            }
                            dumpParser.set(this.createDumpParser());
                            this.changeStateAndNotifyAsync(ReadingData.INSTANCE);
                        }
                    }
                    if (this.getState() != ReadingData.INSTANCE) break block5;
                    FullDumpParser fullDumpParser = (FullDumpParser)dumpParser.get();
                    if (fullDumpParser != null) {
                        LineByLineParser lineByLineParser = fullDumpParser;
                        String string = event.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        LineByLineParser.consumeText$default(lineByLineParser, string, null, 2, null);
                    }
                    BufferedWriter bufferedWriter = this.currentProcessRawDumpFileWriter;
                    if (bufferedWriter != null) {
                        bufferedWriter.append(event.getText());
                    }
                }
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                BufferedWriter bufferedWriter = this.currentProcessRawDumpFileWriter;
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                FullDumpParser fullDumpParser = (FullDumpParser)dumpParser.get();
                if (fullDumpParser == null) {
                    return;
                }
                FullDumpParser parser = fullDumpParser;
                1 $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(1.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Dtrace process terminated with code: " + event.getExitCode());
                this.changeStateAndNotifyAsync(ParsingData.INSTANCE);
                DummyCallTreeBuilder dummyCallTreeBuilder = parser.getChartBuilders().get("CPU Samples");
                if (dummyCallTreeBuilder == null) {
                    dummyCallTreeBuilder = new DummyCallTreeBuilder(null, null, 3, null);
                }
                DummyCallTreeBuilder<BaseCallStackElement> cpuAnalyzedTree = this.postProcessData(dummyCallTreeBuilder);
                NewCallTreeOnlyProfilerData data = this.createProfilerData(cpuAnalyzedTree);
                this.getDumpReadIndicator().checkCanceled();
                this.changeStateAndNotifyAsync(new DataReady(data, this.createDumpWriter(data)));
            }
        });
        this.profilerConfiguration = DTraceProfilerProcessBaseKt.getLegacyDTraceProfilerConfiguration();
        this.dumpParser = new AtomicReference<Object>(null);
    }

    @Override
    public long getAttachedTimestamp() {
        return this.attachedTimestamp;
    }

    @Override
    @NotNull
    public ProfilerConfigurationState getProfilerConfiguration() {
        return this.profilerConfiguration;
    }

    @NotNull
    protected abstract FullDumpParser<BaseCallStackElement> createDumpParser();

    @NotNull
    protected abstract NewCallTreeOnlyProfilerData createProfilerData(@NotNull DummyCallTreeBuilder<BaseCallStackElement> var1);

    @Nullable
    protected ProfilerDumpWriter createDumpWriter(@NotNull NewCallTreeOnlyProfilerData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    protected void onDTraceStopped() {
    }

    @NotNull
    protected DummyCallTreeBuilder<BaseCallStackElement> postProcessData(@NotNull DummyCallTreeBuilder<BaseCallStackElement> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        return builder;
    }

    @Override
    protected boolean doStop() {
        this.dtraceProcessHandler.sendSIGINT();
        return true;
    }

    @Override
    protected void onTargetProcessTerminated() {
    }

    @Override
    protected void onTerminateCalled() {
        this.dtraceProcessHandler.destroyProcess();
    }

    @Override
    public void dispose() {
        this.dtraceProcessHandler.destroyProcess();
        this.dumpParser.set(null);
        super.dispose();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0090\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\b\u0002\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u001326\u0010\u0016\u001a2\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u0002H\u00060\u0017\u00a8\u0006\u001d"}, d2={"Lcom/intellij/profiler/dtrace/DTraceProfilerProcessBase$Companion;", "", "<init>", "()V", "attachBase", "Lorg/jetbrains/concurrency/Promise;", "ProfilerProcess", "Lcom/intellij/profiler/dtrace/DTraceProfilerProcessBase;", "targetProcess", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "backgroundOption", "Lcom/intellij/openapi/progress/PerformInBackgroundOption;", "dTraceScript", "Lcom/intellij/profiler/dtrace/DTraceScript;", "timeoutInMilliseconds", "", "project", "Lcom/intellij/openapi/project/Project;", "sudoPasswordSupplier", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "", "onDTraceAttached", "Lkotlin/Function2;", "Lcom/intellij/profiler/sudo/SudoProcessHandler;", "Lkotlin/ParameterName;", "name", "dtraceProcessHandler", "indicator", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <ProfilerProcess extends DTraceProfilerProcessBase> Promise<ProfilerProcess> attachBase(@NotNull AttachableTargetProcess targetProcess, @NotNull PerformInBackgroundOption backgroundOption, @NotNull DTraceScript dTraceScript, int timeoutInMilliseconds, @NotNull Project project, @NotNull Function1<? super ProgressIndicator, String> sudoPasswordSupplier, @NotNull Function2<? super SudoProcessHandler, ? super ProgressIndicator, ? extends ProfilerProcess> onDTraceAttached) {
            Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
            Intrinsics.checkNotNullParameter((Object)backgroundOption, (String)"backgroundOption");
            Intrinsics.checkNotNullParameter((Object)dTraceScript, (String)"dTraceScript");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(sudoPasswordSupplier, (String)"sudoPasswordSupplier");
            Intrinsics.checkNotNullParameter(onDTraceAttached, (String)"onDTraceAttached");
            AsyncPromise result2 = new AsyncPromise();
            String string = CommonProfilerBundleKt.commonProfilerMessage("attach.task.title", new Object[0]);
            new Task.Backgroundable(project, backgroundOption, targetProcess, sudoPasswordSupplier, dTraceScript, timeoutInMilliseconds, result2, onDTraceAttached, string){
                final /* synthetic */ AttachableTargetProcess $targetProcess;
                final /* synthetic */ Function1<ProgressIndicator, String> $sudoPasswordSupplier;
                final /* synthetic */ DTraceScript $dTraceScript;
                final /* synthetic */ int $timeoutInMilliseconds;
                final /* synthetic */ AsyncPromise<ProfilerProcess> $result;
                final /* synthetic */ Function2<SudoProcessHandler, ProgressIndicator, ProfilerProcess> $onDTraceAttached;
                {
                    this.$targetProcess = $targetProcess;
                    this.$sudoPasswordSupplier = $sudoPasswordSupplier;
                    this.$dTraceScript = $dTraceScript;
                    this.$timeoutInMilliseconds = $timeoutInMilliseconds;
                    this.$result = $result;
                    this.$onDTraceAttached = $onDTraceAttached;
                    super($project, $super_call_param$1, true, $backgroundOption);
                }

                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    Object[] objectArray = new Object[]{this.$targetProcess.getFullName()};
                    indicator.setText(CommonProfilerBundleKt.commonProfilerMessage("attach.task.text", objectArray));
                    String password = (String)this.$sudoPasswordSupplier.invoke((Object)indicator);
                    if (password == null) {
                        com.intellij.profiler.dtrace.DTraceProfilerProcessBase$Companion.access$attachBase$setWrongPasswordResult(this.$result);
                        return;
                    }
                    Semaphore semaphore = new Semaphore(1);
                    AtomicBoolean terminated = new AtomicBoolean(false);
                    SudoProcessHandler handler = DTraceScriptKt.startDTraceProcessNew(this.$targetProcess.getPid(), this.$dTraceScript, (Function0<String>)((Function0)() -> attachBase.2.run$lambda$0(password)), (Function0<Unit>)((Function0)() -> attachBase.2.run$lambda$1(semaphore, this.$result)), (Function1<? super Integer, Unit>)((Function1)arg_0 -> attachBase.2.run$lambda$2(this, arg_0)));
                    ProcessAdapter adapter2 = new ProcessAdapter(terminated, this.$result, this.$onDTraceAttached, handler, indicator, semaphore, this.$targetProcess){
                        final /* synthetic */ AtomicBoolean $terminated;
                        final /* synthetic */ AsyncPromise<ProfilerProcess> $result;
                        final /* synthetic */ Function2<SudoProcessHandler, ProgressIndicator, ProfilerProcess> $onDTraceAttached;
                        final /* synthetic */ SudoProcessHandler $handler;
                        final /* synthetic */ ProgressIndicator $indicator;
                        final /* synthetic */ Semaphore $semaphore;
                        final /* synthetic */ AttachableTargetProcess $targetProcess;
                        {
                            this.$terminated = $terminated;
                            this.$result = $result;
                            this.$onDTraceAttached = $onDTraceAttached;
                            this.$handler = $handler;
                            this.$indicator = $indicator;
                            this.$semaphore = $semaphore;
                            this.$targetProcess = $targetProcess;
                        }

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                            if (this.$terminated.get()) {
                                return;
                            }
                            if (ProcessOutputType.isStdout(outputType)) {
                                String string = event.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"DTrace attached", (boolean)false, (int)2, null)) {
                                    try {
                                        this.$result.setResult(this.$onDTraceAttached.invoke((Object)((Object)this.$handler), (Object)this.$indicator));
                                    }
                                    catch (Throwable e) {
                                        this.$result.setError(e);
                                        this.$handler.destroyProcess();
                                    }
                                    this.$semaphore.up();
                                    return;
                                }
                            }
                            if (ProcessOutputType.isStderr(outputType)) {
                                String string = event.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"DTrace cannot instrument translated processes", (boolean)false, (int)2, null)) {
                                    this.$result.setError((Throwable)AttachProfilerUtilsKt.cannotInstrumentTranslatedProcess());
                                    this.$handler.destroyProcess();
                                    this.$semaphore.up();
                                    return;
                                }
                            }
                            if (!ProcessOutputType.isStderr(outputType)) return;
                            String string = event.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"dtrace: failed to grab pid", (boolean)false, (int)2, null)) return;
                            this.$result.setError((Throwable)AttachProfilerUtilsKt.attachFailedCantGrubPid(this.$targetProcess));
                            this.$handler.destroyProcess();
                            this.$semaphore.up();
                        }
                    };
                    handler.addProcessListener((ProcessListener)adapter2);
                    handler.startNotify();
                    long start = System.currentTimeMillis();
                    while (!semaphore.waitFor(100L)) {
                        boolean canceled = indicator.isCanceled();
                        if (!canceled && System.currentTimeMillis() - start <= (long)this.$timeoutInMilliseconds) continue;
                        terminated.set(true);
                        handler.destroyProcess();
                        this.$result.setError((Throwable)(canceled ? (Exception)AttachCanceledException.INSTANCE : (Exception)AttachProfilerUtilsKt.attachFailedTimeout(this.$targetProcess)));
                        break;
                    }
                    handler.removeProcessListener((ProcessListener)adapter2);
                }

                private static final String run$lambda$0(String $password) {
                    return $password;
                }

                private static final Unit run$lambda$1(Semaphore $semaphore, AsyncPromise $result) {
                    $semaphore.up();
                    com.intellij.profiler.dtrace.DTraceProfilerProcessBase$Companion.access$attachBase$setWrongPasswordResult($result);
                    return Unit.INSTANCE;
                }

                private static final Unit run$lambda$2(attachBase.2 this$0, int it) {
                    attachBase.2 $this$thisLogger$iv = this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(attachBase.2.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("can't send signal " + it);
                    return Unit.INSTANCE;
                }
            }.queue();
            return (Promise)result2;
        }

        public static /* synthetic */ Promise attachBase$default(Companion companion, AttachableTargetProcess attachableTargetProcess, PerformInBackgroundOption performInBackgroundOption, DTraceScript dTraceScript, int n, Project project, Function1 function1, Function2 function2, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                function1 = arg_0 -> Companion.attachBase$lambda$0(project, arg_0);
            }
            return companion.attachBase(attachableTargetProcess, performInBackgroundOption, dTraceScript, n, project, (Function1<? super ProgressIndicator, String>)function1, function2);
        }

        private static final String attachBase$lambda$0(Project $project, ProgressIndicator it) {
            return ProfilerManager.INSTANCE.getSudoPassword($project, it);
        }

        private static final <ProfilerProcess extends DTraceProfilerProcessBase> boolean attachBase$setWrongPasswordResult(AsyncPromise<ProfilerProcess> result2) {
            return result2.setError((Throwable)new AttachFailedException(CommonProfilerBundleKt.commonProfilerMessage("profiler.valid.password.required", new Object[0])));
        }

        public static final /* synthetic */ boolean access$attachBase$setWrongPasswordResult(AsyncPromise result2) {
            return com.intellij.profiler.dtrace.DTraceProfilerProcessBase$Companion.attachBase$setWrongPasswordResult(result2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

