/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ImportDataSourceAction;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceIdentifier;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\n"}, d2={"scanForNewConfigurations", "", "project", "Lcom/intellij/openapi/project/Project;", "getNewAndModifiedDataSources", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/autoconfig/DataSourceRegistry;", "notifyNewDataSourcesDetected", "", "intellij.database.impl"})
public final class DatabaseConfigStartupActivityKt {
    private static final boolean scanForNewConfigurations(Project project) {
        Module[] modules = project.isDisposed() ? Module.EMPTY_ARRAY : ModuleManager.Companion.getInstance(project).getModules();
        Intrinsics.checkNotNull((Object)modules);
        if (modules.length == 0) {
            return false;
        }
        DataSourceRegistry registry = new DataSourceRegistry(project);
        for (DataSourceDetector detector : DataSourceDetector.EP_NAME.getExtensionList()) {
            if (!detector.isApplicable(project)) continue;
            for (Module module : modules) {
                ProgressManager.checkCanceled();
                detector.collectDataSources(module, registry.getBuilder(), false);
                if (registry.getDataSources().isEmpty() || !(!DatabaseConfigStartupActivityKt.getNewAndModifiedDataSources(registry, project).isEmpty())) continue;
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    @NotNull
    public static final Collection<LocalDataSource> getNewAndModifiedDataSources(@NotNull DataSourceRegistry $this$getNewAndModifiedDataSources, @NotNull Project project) {
        DataSourceIdentifier identifier;
        Intrinsics.checkNotNullParameter((Object)$this$getNewAndModifiedDataSources, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if ($this$getNewAndModifiedDataSources.getDataSources().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        MultiMap multiMap = MultiMap.createLinked();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createLinked(...)");
        MultiMap uniqueIds = multiMap;
        for (LocalDataSource dataSource : $this$getNewAndModifiedDataSources.getDataSources()) {
            Intrinsics.checkNotNull((Object)dataSource);
            if (DataSourceIdentifier.Companion.of(dataSource) == null) continue;
            uniqueIds.putValue((Object)identifier, (Object)dataSource);
        }
        for (LocalDataSource storageDataSource : DataSourceStorage.getProjectStorage((Project)project).getDataSources()) {
            Intrinsics.checkNotNull((Object)storageDataSource);
            if (DataSourceIdentifier.Companion.of(storageDataSource) == null) continue;
            uniqueIds.remove((Object)identifier);
        }
        Collection collection = uniqueIds.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        return collection;
    }

    private static final void notifyNewDataSourcesDetected(Project project) {
        if (!project.isOpen()) {
            return;
        }
        NotificationGroup notificationGroup = ConnDatabaseNotifications.DATABASE_DETECTION_GROUP();
        String string = DatabaseBundle.message((String)"data.sources.detected", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = DatabaseBundle.message((String)"data.sources.detected.content", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        notificationGroup.createNotification(string, string2, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.create((String)DatabaseBundle.message((String)"data.sources.detected.configure", (Object[])new Object[0]), (String)"data.sources.detected.configure", (arg_0, arg_1) -> DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected$lambda$1((arg_0, arg_1) -> DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected$lambda$0(project, arg_0, arg_1), arg_0, arg_1))).addAction((AnAction)NotificationAction.create((String)DatabaseBundle.message((String)"data.sources.detected.do.not.suggest.again", (Object[])new Object[0]), (String)"data.sources.detected.do.not.suggest.again", (arg_0, arg_1) -> DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected$lambda$3((arg_0, arg_1) -> DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected$lambda$2(project, arg_0, arg_1), arg_0, arg_1))).setSuggestionType(true).setDisplayId("DatabaseConfigFileWatcher.found").notify(project);
    }

    private static final Unit notifyNewDataSourcesDetected$lambda$0(Project $project, AnActionEvent anActionEvent, Notification notification) {
        if (ImportDataSourceAction.doImportAction($project)) {
            notification.expire();
        }
        return Unit.INSTANCE;
    }

    private static final void notifyNewDataSourcesDetected$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit notifyNewDataSourcesDetected$lambda$2(Project $project, AnActionEvent anActionEvent, Notification notification) {
        notification.setDoNotAskFor($project);
        notification.expire();
        return Unit.INSTANCE;
    }

    private static final void notifyNewDataSourcesDetected$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$notifyNewDataSourcesDetected(Project project) {
        DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected(project);
    }

    public static final /* synthetic */ boolean access$scanForNewConfigurations(Project project) {
        return DatabaseConfigStartupActivityKt.scanForNewConfigurations(project);
    }
}

