/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.SshUIUtil;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ssh.ui.unified.SshConfigsMasterComponent;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.messages.MessageBus;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SshConfigConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NonNls
    public static final String SSH_CONFIGURABLE_ID = "ssh.settings";
    @NotNull
    final Project myProject;
    @Nullable
    private final SshUiData mySelect;
    protected SshConfigsMasterComponent myComponent;
    @Nullable
    private SshUiData myLastSelectedItem;

    private SshConfigConfigurable(@Nullable Project project, @Nullable SshUiData select) {
        this.myProject = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        this.mySelect = select;
    }

    @NotNull
    public String getId() {
        return SSH_CONFIGURABLE_ID;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return SshBundle.message("ssh.configurable.title", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = this.doCreateComponent(this.myProject);
            this.myComponent.selectItem(this.mySelect);
        }
        return this.myComponent.createComponent();
    }

    @NotNull
    protected abstract SshConfigsMasterComponent doCreateComponent(@NotNull Project var1);

    public boolean isModified() {
        return this.myComponent.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myComponent.apply();
    }

    public void reset() {
        this.myComponent.reset();
    }

    protected void resetFromData(@NotNull SshConfigManager.ConfigsData lastSavedAndCurrentData) {
        if (lastSavedAndCurrentData == null) {
            SshConfigConfigurable.v(0);
        }
        this.myComponent.resetFromData(lastSavedAndCurrentData);
    }

    public void select(@Nullable SshUiData data) {
        this.myComponent.selectItem(data);
    }

    public void add(SshUiData newItem) {
        this.myComponent.onItemCreated(newItem);
    }

    public void disposeUIResources() {
        if (this.myComponent != null) {
            this.myLastSelectedItem = this.myComponent.getSelectedItem();
            this.myComponent.disposeUIResources();
            this.myComponent = null;
        }
    }

    @Nullable
    public String getHelpTopic() {
        return "Settings_Tools_SSH_Configurations";
    }

    @Nullable
    public SshUiData getLastSelectedData() {
        return this.myComponent == null ? this.myLastSelectedItem : this.myComponent.getSelectedItem();
    }

    private static /* synthetic */ void v(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastSavedAndCurrentData", "com/intellij/ssh/ui/unified/SshConfigConfigurable", "resetFromData"));
    }

    public static class ComboBoxConfigurable
    extends SshConfigConfigurable {
        @NotNull
        private final SshConfigManager.ConfigsData myData;
        private final SshConfigVisibility myDefaultVisibility;

        public ComboBoxConfigurable(@Nullable Project project, @Nullable SshUiData select, @NotNull SshConfigManager.ConfigsData data, @NotNull SshConfigVisibility defaultVisibility) {
            if (defaultVisibility == null) {
                ComboBoxConfigurable.A(0);
            }
            if (data == null) {
                ComboBoxConfigurable.A(1);
            }
            super(project, select);
            this.myData = data;
            this.myDefaultVisibility = defaultVisibility;
        }

        @Override
        @NotNull
        protected SshConfigsMasterComponent doCreateComponent(@NotNull Project project) {
            if (project == null) {
                ComboBoxConfigurable.A(2);
            }
            SshConfigsMasterComponent sshConfigsMasterComponent = new SshConfigsMasterComponent(project, this.myDefaultVisibility);
            sshConfigsMasterComponent.resetFromData(this.myData);
            SshConfigsMasterComponent sshConfigsMasterComponent2 = sshConfigsMasterComponent;
            if (sshConfigsMasterComponent2 == null) {
                ComboBoxConfigurable.A(3);
            }
            return sshConfigsMasterComponent2;
        }

        private static /* synthetic */ void A(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultVisibility";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigConfigurable$ComboBoxConfigurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigConfigurable$ComboBoxConfigurable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doCreateComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doCreateComponent";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Main
    extends SshConfigConfigurable {
        private final Disposable myDisposable;

        public Main(@NotNull Project project) {
            if (project == null) {
                Main.A(0);
            }
            super(project, null);
            this.myDisposable = Disposer.newDisposable((String)Main.class.getName());
        }

        @Override
        @NotNull
        protected SshConfigsMasterComponent doCreateComponent(@NotNull Project project) {
            if (project == null) {
                Main.A(1);
            }
            SshConfigsMasterComponent.MainSshConfigsMasterComponent mainSshConfigsMasterComponent = new SshConfigsMasterComponent.MainSshConfigsMasterComponent(project);
            mainSshConfigsMasterComponent.resetFromData(SshConfigManager.getInstance(this.myProject).getLastSavedAndCurrentData());
            MessageBus messageBus = project.isDefault() ? ApplicationManager.getApplication().getMessageBus() : project.getMessageBus();
            messageBus.connect(this.myDisposable).subscribe(SshConfigManager.SSH_CONFIGS, (Object)mainSshConfigsMasterComponent);
            SshConfigsMasterComponent.MainSshConfigsMasterComponent mainSshConfigsMasterComponent2 = mainSshConfigsMasterComponent;
            if (mainSshConfigsMasterComponent2 == null) {
                Main.A(2);
            }
            return mainSshConfigsMasterComponent2;
        }

        @Override
        public void disposeUIResources() {
            Disposer.dispose((Disposable)this.myDisposable);
            super.disposeUIResources();
        }

        private static /* synthetic */ void A(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigConfigurable$Main";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigConfigurable$Main";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doCreateComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doCreateComponent";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        public static final class Provider
        extends ConfigurableProvider {
            private final Project myProject;

            public Provider(Project project) {
                this.myProject = project;
            }

            @NotNull
            public Configurable createConfigurable() {
                return new Main(this.myProject);
            }

            public boolean canCreateConfigurable() {
                return SshUIUtil.isSshLegallyAvailable();
            }
        }
    }
}

