/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation.diff;

import com.intellij.openapi.util.Pair;
import com.intellij.util.BeforeAfter;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.AggregatesViewDiff;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.SnapshotObjectsComparator;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8DiffCachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.Aggregate;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public final class V8HeapDiffCalculator {
    @NotNull
    private final V8CachingReader myBaseReader;
    @NotNull
    private final V8CachingReader myChangedReader;
    private AggregatesViewDiff myAggregatesViewDiff;
    private LongList myBaseSnapshotIds;
    private LongList myChangedSnapshotIds;
    private LongList myBaseSnapshotSizes;
    private LongList myChangedSnapshotSizes;
    private final List<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> myBiggestObjectsDiff;

    public V8HeapDiffCalculator(@NotNull V8CachingReader baseReader, @NotNull V8CachingReader changedReader) {
        if (baseReader == null) {
            V8HeapDiffCalculator.$$$reportNull$$$0(0);
        }
        if (changedReader == null) {
            V8HeapDiffCalculator.$$$reportNull$$$0(1);
        }
        this.myBaseReader = baseReader;
        this.myChangedReader = changedReader;
        this.myBiggestObjectsDiff = new ArrayList<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>>();
    }

    public void execute() throws IOException {
        this.myAggregatesViewDiff = this.calculate();
        this.myBaseSnapshotIds = new LongArrayList(this.myBaseReader.getNodeCount());
        this.myBaseSnapshotSizes = new LongArrayList(this.myBaseReader.getNodeCount());
        this.myChangedSnapshotIds = new LongArrayList(this.myChangedReader.getNodeCount());
        this.myChangedSnapshotSizes = new LongArrayList(this.myChangedReader.getNodeCount());
        V8HeapDiffCalculator.calculateSelfIndexes(this.myBaseReader, this.myBaseSnapshotIds, this.myBaseSnapshotSizes);
        V8HeapDiffCalculator.calculateSelfIndexes(this.myChangedReader, this.myChangedSnapshotIds, this.myChangedSnapshotSizes);
        this.calculateBiggestObjectsDiff();
    }

    private void calculateBiggestObjectsDiff() {
        List<Integer> list = this.myBaseReader.getBiggestObjects();
        ArrayList<Long> biggestObjectIds = new ArrayList<Long>(list.size());
        for (Integer integer : list) {
            biggestObjectIds.add(integer.longValue());
        }
        SnapshotObjectsComparator comparator = new SnapshotObjectsComparator(this.myBaseReader, this.myChangedReader, this.myBaseSnapshotIds, this.myChangedSnapshotIds, biggestObjectIds, false);
        List<Integer> changedList = this.myChangedReader.getBiggestObjects();
        ArrayList<Long> changedBiggestObjectIds = new ArrayList<Long>(changedList.size());
        for (Integer integer : changedList) {
            changedBiggestObjectIds.add(integer.longValue());
        }
        changedBiggestObjectIds.sort(V8DiffCachingReader.createByRetainedSizesComparator(this.myChangedReader));
        biggestObjectIds.sort(V8DiffCachingReader.createByRetainedSizesComparator(this.myBaseReader));
        for (Long id : changedBiggestObjectIds) {
            Long idInBase = comparator.getBaseForChanged(id);
            V8HeapContainmentTreeTableModel.NamedEntry changedEntry = V8HeapContainmentTreeTableModel.NamedEntry.createWithoutLink(id, this.myChangedReader);
            V8HeapContainmentTreeTableModel.NamedEntry baseEntry = idInBase == null ? null : V8HeapContainmentTreeTableModel.NamedEntry.createWithoutLink(idInBase, this.myBaseReader);
            this.myBiggestObjectsDiff.add((BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>)new BeforeAfter((Object)baseEntry, (Object)changedEntry));
        }
        for (Long id : biggestObjectIds) {
            if (comparator.haveEquivalent(id)) continue;
            V8HeapContainmentTreeTableModel.NamedEntry entry = V8HeapContainmentTreeTableModel.NamedEntry.createWithoutLink(id, this.myBaseReader);
            this.myBiggestObjectsDiff.add((BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>)new BeforeAfter((Object)entry, null));
        }
    }

    public List<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> getBiggestObjectsDiff() {
        return this.myBiggestObjectsDiff;
    }

    public AggregatesViewDiff getAggregatesViewDiff() {
        return this.myAggregatesViewDiff;
    }

    public LongList getBaseSnapshotIds() {
        return this.myBaseSnapshotIds;
    }

    public LongList getChangedSnapshotIds() {
        return this.myChangedSnapshotIds;
    }

    public LongList getBaseSnapshotSizes() {
        return this.myBaseSnapshotSizes;
    }

    public LongList getChangedSnapshotSizes() {
        return this.myChangedSnapshotSizes;
    }

    private static void calculateSelfIndexes(V8CachingReader reader, final LongList snapshotIds, final LongList sizes) throws IOException {
        for (int i = 0; i < reader.getNodeCount(); ++i) {
            snapshotIds.add(0L);
            sizes.add(0L);
        }
        SequentialRawReader<V8HeapEntry> indexReader = new SequentialRawReader<V8HeapEntry>(reader.getNodeIndexFile(), V8HeapEntry.MyRawSerializer.getInstance(), reader.getNodeCount());
        indexReader.iterate(new CloseableThrowableConsumer<V8HeapEntry, IOException>(){

            @Override
            public void close() {
            }

            public void consume(V8HeapEntry entry) {
                snapshotIds.set((int)entry.getId(), entry.getSnapshotObjectId());
                sizes.set((int)entry.getId(), entry.getSize());
            }
        });
    }

    private AggregatesViewDiff calculate() {
        Pair<Aggregate, String> baseAggregate;
        List<Pair<Aggregate, String>> baseList = V8HeapDiffCalculator.processAggregates(this.myBaseReader);
        List<Pair<Aggregate, String>> changedList = V8HeapDiffCalculator.processAggregates(this.myChangedReader);
        AggregatesViewDiff diff = new AggregatesViewDiff();
        int base = 0;
        int changed = 0;
        while (base < baseList.size() && changed < changedList.size()) {
            baseAggregate = baseList.get(base);
            Pair<Aggregate, String> changedAggregate = changedList.get(changed);
            int compare = ((String)baseAggregate.getSecond()).compareTo((String)changedAggregate.getSecond());
            if (compare < 0) {
                diff.addAggregate(new AggregatesViewDiff.AggregateDifference((String)baseAggregate.getSecond(), ((Aggregate)baseAggregate.getFirst()).getType(), (Aggregate)baseAggregate.getFirst(), null));
                ++base;
                continue;
            }
            if (compare > 0) {
                diff.addAggregate(new AggregatesViewDiff.AggregateDifference((String)changedAggregate.getSecond(), ((Aggregate)changedAggregate.getFirst()).getType(), null, (Aggregate)changedAggregate.getFirst()));
                ++changed;
                continue;
            }
            AggregatesViewDiff.AggregateDifference difference = new AggregatesViewDiff.AggregateDifference((String)baseAggregate.getSecond(), ((Aggregate)baseAggregate.getFirst()).getType(), (Aggregate)baseAggregate.getFirst(), (Aggregate)changedAggregate.getFirst());
            diff.addAggregate(difference);
            ++base;
            ++changed;
        }
        while (base < baseList.size()) {
            baseAggregate = baseList.get(base);
            diff.addAggregate(new AggregatesViewDiff.AggregateDifference((String)baseAggregate.getSecond(), ((Aggregate)baseAggregate.getFirst()).getType(), (Aggregate)baseAggregate.getFirst(), null));
            ++base;
        }
        while (changed < changedList.size()) {
            Pair<Aggregate, String> changedAggregate = changedList.get(changed);
            diff.addAggregate(new AggregatesViewDiff.AggregateDifference((String)changedAggregate.getSecond(), ((Aggregate)changedAggregate.getFirst()).getType(), null, (Aggregate)changedAggregate.getFirst()));
            ++changed;
        }
        return diff;
    }

    private static List<Pair<Aggregate, String>> processAggregates(V8CachingReader reader) {
        TreeMap<Long, Aggregate> map = reader.getAggregatesMap();
        ArrayList<Pair<Aggregate, String>> list = new ArrayList<Pair<Aggregate, String>>();
        for (Aggregate aggregate : map.values()) {
            list.add((Pair<Aggregate, String>)Pair.create((Object)aggregate, (Object)aggregate.getPresentation(reader)));
        }
        list.sort(Pair.comparingBySecond());
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "baseReader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "changedReader";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/diff/V8HeapDiffCalculator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

